/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.repository;

import com.bizunited.empower.business.policy.entity.SalePolicy;
import com.bizunited.empower.business.policy.repository.internal.SalePolicyRepositoryCustom;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_SalePolicyEntityRepository")
public interface SalePolicyRepository
extends JpaRepository<SalePolicy, String>,
JpaSpecificationExecutor<SalePolicy>,
SalePolicyRepositoryCustom {
    @Query(value="select distinct salePolicyEntity from SalePolicy salePolicyEntity  left join fetch salePolicyEntity.policyType salePolicyEntity_policyType  where salePolicyEntity_policyType.id = :id and salePolicyEntity.tenantCode = :tenantCode ")
    public Set<SalePolicy> findDetailsByPolicyType(@Param(value="id") String var1, @Param(value="tenantCode") String var2);

    @Query(value="from SalePolicy sp  left join fetch sp.products spp left join fetch sp.gifts spg  left join fetch sp.excludeProducts spe  left join fetch sp.policyType pt  left join fetch sp.salePolicyExecutorLadders pel  left join fetch pel.salePolicyExecutorVars pelv  left join fetch sp.customers spc  left join fetch pt.policyExecutor pe  left join fetch pe.policyExecutorVars pev  where sp.salePolicyCode = :salePolicyCode and sp.tenantCode = :tenantCode")
    public SalePolicy findDetailsBySalePolicyCodeAndTenantCode(@Param(value="salePolicyCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value=" from SalePolicy f where f.salePolicyCode = :salePolicyCode and f.tenantCode = :tenantCode ")
    public SalePolicy findBySalePolicyCodeAndTenantCode(@Param(value="salePolicyCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select distinct f  from SalePolicy f  inner join fetch f.products p  inner join fetch f.policyType  where f.salePolicyCode = :salePolicyCode and p.productSpecificationCode = :productSpecificationCode and f.tenantCode = :tenantCode and f.tenantCode = :tenantCode ")
    public SalePolicy findBySalePolicyCodeAndProductCode(@Param(value="salePolicyCode") String var1, @Param(value="productSpecificationCode") String var2, @Param(value="tenantCode") String var3);

    @Query(value="select distinct f  from SalePolicy f  inner join fetch f.products p  inner join fetch f.policyType  where f.salePolicyCode in (:salePolicyCodes) and p.productSpecificationCode = :productSpecificationCode and f.tenantCode = :tenantCode ")
    public List<SalePolicy> findBySalePolicyCodesAndProductCode(@Param(value="salePolicyCodes") String[] var1, @Param(value="productSpecificationCode") String var2, @Param(value="tenantCode") String var3);

    @Query(value=" from SalePolicy sp  where sp.tenantCode = :tenantCode and sp.effective = true and sp.validEndTime > :startTime ")
    public Set<SalePolicy> findByValidTimeAndPolicyEffective(@Param(value="tenantCode") String var1, @Param(value="startTime") Date var2);
}

