/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.repository;

import com.bizunited.empower.business.policy.entity.SalePolicyResult;
import java.math.BigDecimal;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_SalePolicyResultRepository")
public interface SalePolicyResultRepository
extends JpaRepository<SalePolicyResult, String>,
JpaSpecificationExecutor<SalePolicyResult> {
    @Modifying
    @Query(value="update sale_policy_result set relevance_code = :targetRelevanceCode where relevance_code = :sourceRelevanceCode", nativeQuery=true)
    public void updateRelevanceCode(@Param(value="sourceRelevanceCode") String var1, @Param(value="targetRelevanceCode") String var2);

    @Modifying
    @Query(value="update sale_policy_result set state = 0 where relevance_code = :relevanceCode ", nativeQuery=true)
    public void disableByRelevanceCode(@Param(value="relevanceCode") String var1);

    @Query(value="select count(*) from SalePolicyResult sp where sp.tenantCode = :tenantCode and sp.salePolicyCode = :salePolicyCode AND sp.state = 1 ")
    public long countByTenantCodeAndSalePolicyCode(@Param(value="tenantCode") String var1, @Param(value="salePolicyCode") String var2);

    @Query(value="select sum(sp.subtotalProductAmount) from SalePolicyResult sp where sp.tenantCode = :tenantCode and sp.salePolicyCode = :salePolicyCode AND sp.state = 1 ")
    public BigDecimal sumProductAmountByTenantCodeAndSalePolicyCode(@Param(value="tenantCode") String var1, @Param(value="salePolicyCode") String var2);

    @Query(value="select sum(sp.subtotalDiscountAmount + sp.giftValue) from SalePolicyResult sp where sp.tenantCode = :tenantCode and sp.salePolicyCode = :salePolicyCode AND sp.state = 1 ")
    public BigDecimal sumCostByTenantCodeAndSalePolicyCode(@Param(value="tenantCode") String var1, @Param(value="salePolicyCode") String var2);
}

