/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.repository.internal;

import com.bizunited.empower.business.policy.dto.SalePolicyDto;
import com.bizunited.empower.business.policy.entity.SalePolicy;
import com.bizunited.empower.business.policy.repository.internal.SalePolicyRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class SalePolicyRepositoryImpl
implements SalePolicyRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<SalePolicy> findByCondition(Pageable pageable, SalePolicyDto conditions) {
        StringBuilder hql = new StringBuilder(" from SalePolicy sp inner join fetch sp.policyType pt where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(sp) from SalePolicy sp inner join sp.policyType pt where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            this.buildConditionsAndParameter(conditions, condition, parameters);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u67e5\u8be2\u6761\u4ef6\u4e2d\uff0c\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!!");
        }
        hql.append((CharSequence)condition).append(" order by sp.createTime desc ");
        countHql.append((CharSequence)condition);
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        parameters.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        Number count = (Number)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count == null ? 0L : count.longValue());
    }

    private void buildConditionsAndParameter(SalePolicyDto conditions, StringBuilder condition, Map<String, Object> parameter) throws ParseException {
        if (conditions == null) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (conditions.getTenantCode() != null) {
            condition.append(" AND sp.tenantCode = :tenantCode ");
            parameter.put("tenantCode", conditions.getTenantCode());
        }
        if (conditions.getValidStartTime() != null) {
            condition.append(" AND sp.validStartTime >= :validStartTime ");
            parameter.put("validStartTime", simpleDateFormat.parseObject(conditions.getValidStartTime()));
        }
        if (conditions.getValidEndTime() != null) {
            condition.append(" AND sp.validEndTime <= :validEndTime ");
            parameter.put("validEndTime", simpleDateFormat.parseObject(conditions.getValidEndTime()));
        }
        if (conditions.getEffective() != null) {
            condition.append(" AND sp.effective = :effective ");
            parameter.put("effective", conditions.getEffective());
        }
        if (conditions.getValidBetweenTime() != null) {
            condition.append(" AND sp.validStartTime <= :validBetweenTime AND sp.validEndTime >= :validBetweenTime ");
            parameter.put("validBetweenTime", simpleDateFormat.parseObject(conditions.getValidBetweenTime()));
        }
        if (conditions.getSaleType() != null) {
            condition.append(" AND pt.saleType = :saleType ");
            parameter.put("saleType", conditions.getSaleType());
        }
        if (StringUtils.isNotBlank((CharSequence)conditions.getSalePolicyName())) {
            condition.append(" AND sp.salePolicyName like CONCAT('%',:salePolicyName,'%') ");
            parameter.put("salePolicyName", conditions.getSalePolicyName());
        }
    }
}

