/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.service.PolicyExecuteService;
import com.bizunited.empower.business.policy.service.SalePolicyResultService;
import com.bizunited.empower.business.policy.service.SalePolicyVoService;
import com.bizunited.empower.business.policy.service.salepolicy.PolicyExecuteContext;
import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConMatched;
import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConProduct;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.ExeInfo;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.GiftInfo;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeInfo;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeInfoForCompose;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeInfoForComposeResult;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeResult;
import com.bizunited.empower.business.policy.vo.PolicyExecutorVarVo;
import com.bizunited.empower.business.policy.vo.PolicyExecutorVo;
import com.bizunited.empower.business.policy.vo.PolicyTypeVo;
import com.bizunited.empower.business.policy.vo.SalePolicyExecutorLadderVo;
import com.bizunited.empower.business.policy.vo.SalePolicyExecutorVarsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyGiftsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyProductsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyVo;
import com.bizunited.empower.business.product.dto.ProductSpecificationAndUnitPriceDto;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.service.ProductUnitAndPriceService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PolicyExecuteServiceImpl
implements PolicyExecuteService {
    @Autowired
    private SalePolicyVoService salePolicyVoService;
    @Autowired
    private ProductUnitAndPriceService productUnitAndPriceService;
    @Autowired
    private ProductSpecificationVoService productSpecificationService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private SalePolicyResultService salePolicyResultService;
    @Autowired
    private ScriptService scriptService;
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyExecuteServiceImpl.class);

    @Override
    public PolicyExecuteContext preExecutePolicy(Set<PolicyConProduct> initPolicyProducts, String tenantCode, String customerCode) {
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u7ecf\u9500\u5546\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u5ba2\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(initPolicyProducts) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u53c2\u4e0e\u4f18\u60e0\u7684\u603b\u4f53\u672c\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        long initPolicyProductSpecificationCodeSize = initPolicyProducts.stream().map(PolicyConProduct::getProductSpecificationCode).distinct().count();
        Validate.isTrue((initPolicyProductSpecificationCodeSize == (long)initPolicyProducts.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u53c2\u4e0e\u4f18\u60e0\u7684\u603b\u4f53\u672c\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u5fc5\u987b\u4f20\u5165\u4e14\u4e0d\u80fd\u91cd\u590d!!", (Object[])new Object[0]);
        for (PolicyConProduct initPolicyProductItem : initPolicyProducts) {
            BigDecimal quantity = initPolicyProductItem.getQuantity();
            BigDecimal unitPrice = initPolicyProductItem.getUnitPrice();
            BigDecimal subtotalAmount = initPolicyProductItem.getSubtotalAmount();
            String initUnitCode = initPolicyProductItem.getUnitCode();
            Validate.notBlank((CharSequence)initUnitCode, (String)"\u5546\u54c1\u5355\u4f4d\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((quantity != null && quantity.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7b56\u7565\u8ba1\u7b97\u65f6\uff0c\u5546\u54c1\u521d\u59cb\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((unitPrice != null && unitPrice.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7b56\u7565\u8ba1\u7b97\u65f6\uff0c\u5546\u54c1\u521d\u59cb\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((subtotalAmount != null && subtotalAmount.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7b56\u7565\u8ba1\u7b97\u65f6\uff0c\u5546\u54c1\u521d\u59cb\u5c0f\u8ba1\u603b\u4ef7\u5fc5\u987b\u5927\u4e8e0\uff01\uff01", (Object[])new Object[0]);
        }
        long mappingCount = initPolicyProducts.stream().collect(Collectors.groupingBy(PolicyConProduct::getProductSpecificationCode)).values().stream().filter(item -> item.size() > 1).count();
        Validate.isTrue((mappingCount == 0L ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u4f20\u5165\u76f8\u540c\u5546\u54c1\u89c4\u683c\u7f16\u7801\u7684\u91cd\u590d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<SalePolicyVo> salePolicies = this.salePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, true, customerCode);
        if (CollectionUtils.isEmpty(salePolicies)) {
            return null;
        }
        PolicyExecuteContext context = this.validate(salePolicies, initPolicyProducts, tenantCode, customerCode);
        Map<String, PolicyConProduct> initPolicyProductMapping = initPolicyProducts.stream().collect(Collectors.toMap(PolicyConProduct::getProductSpecificationCode, item -> item));
        ArrayList policyConMatcheds = Lists.newArrayList(context.getMatchedPolicyMapping().values());
        if (CollectionUtils.isEmpty((Collection)policyConMatcheds)) {
            context.streamlining();
            return context;
        }
        for (PolicyConMatched policyConMatchedItem : policyConMatcheds) {
            Object policyExeInfo;
            List<PolicyConProduct> policyConProducts = policyConMatchedItem.getMatchedPolicyProducts();
            SalePolicyVo salePolicy = policyConMatchedItem.getSalePolicy();
            boolean compose = salePolicy.getCompose();
            if (!compose) {
                Iterator iterator = policyConProducts.iterator();
                while (iterator.hasNext()) {
                    PolicyConProduct policyConProductItem = (PolicyConProduct)iterator.next();
                    PolicyExeInfo policyExeInfo2 = new PolicyExeInfo();
                    policyExeInfo2.setProductSpecificationCode(policyConProductItem.getProductSpecificationCode());
                    policyExeInfo2.setUnitCode(policyConProductItem.getUnitCode());
                    policyExeInfo2.setPolicyExeResults(this.execute(salePolicy, policyConProductItem));
                    policyConMatchedItem.addExeInfo(policyConProductItem.getProductSpecificationCode(), policyExeInfo2);
                }
                iterator = policyConProducts.iterator();
                while (iterator.hasNext()) {
                    PolicyExeResult policyExeResult;
                    PolicyConProduct policyConProduct = (PolicyConProduct)iterator.next();
                    String productSpecificationCode = policyConProduct.getProductSpecificationCode();
                    PolicyConProduct initPolicyConProduct = initPolicyProductMapping.get(productSpecificationCode);
                    policyExeInfo = (PolicyExeInfo)policyConMatchedItem.getExeInfo(productSpecificationCode);
                    List<PolicyExeResult> policyExeResults = ((PolicyExeInfo)policyExeInfo).getPolicyExeResults();
                    if (CollectionUtils.isEmpty(policyExeResults) || (policyExeResult = policyExeResults.get(policyExeResults.size() - 1)) == null) continue;
                    float lastNumber = policyExeResult.getLastNumber();
                    float lastPrice = policyExeResult.getLastPrice();
                    float lastSubtotal = lastNumber * lastPrice;
                    initPolicyConProduct.setQuantity(new BigDecimal(lastNumber));
                    initPolicyConProduct.setUnitPrice(new BigDecimal(lastPrice));
                    initPolicyConProduct.setSubtotalAmount(new BigDecimal(lastSubtotal));
                }
                continue;
            }
            List<PolicyExeInfoForComposeResult> policyExeResults = this.execute(salePolicy, policyConProducts);
            String[] productSpecificationCodes = new String[policyConProducts.size()];
            String[] unitCodes = new String[policyConProducts.size()];
            int index = 0;
            policyExeInfo = policyConProducts.iterator();
            while (policyExeInfo.hasNext()) {
                PolicyConProduct policyConProduct = (PolicyConProduct)policyExeInfo.next();
                productSpecificationCodes[index] = policyConProduct.getProductSpecificationCode();
                unitCodes[index] = policyConProduct.getUnitCode();
                ++index;
            }
            policyExeInfo = new PolicyExeInfoForCompose();
            ((PolicyExeInfoForCompose)policyExeInfo).setPolicyExeResults(policyExeResults);
            ((PolicyExeInfoForCompose)policyExeInfo).setProductSpecificationCodes(productSpecificationCodes);
            ((PolicyExeInfoForCompose)policyExeInfo).setUnitCodes(unitCodes);
            policyConMatchedItem.addExeInfo(salePolicy.getSalePolicyCode(), (ExeInfo)policyExeInfo);
        }
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        ArrayList allGifts = Lists.newArrayList();
        for (PolicyConMatched policyConMatchedItem : policyConMatcheds) {
            PolicyExeInfoForCompose policyExeInfoForCompose;
            List<PolicyExeInfoForComposeResult> policyExeInfoForComposeResults;
            SalePolicyVo salePolicy = policyConMatchedItem.getSalePolicy();
            boolean compose = salePolicy.getCompose();
            if (!compose) {
                List<PolicyConProduct> policyConProducts = policyConMatchedItem.getMatchedPolicyProducts();
                BigDecimal subtotalDiscountAmount = BigDecimal.ZERO;
                Integer subtotalGiftNumber = 0;
                BigDecimal subtotalGiftAmount = BigDecimal.ZERO;
                BigDecimal subtotalEnjoyAmount = BigDecimal.ZERO;
                BigDecimal subtotalEnjoyNumber = BigDecimal.ZERO;
                BigDecimal subtotalProductAmount = BigDecimal.ZERO;
                for (PolicyConProduct policyConProductItem : policyConProducts) {
                    List<PolicyExeResult> policyExeResults;
                    String productSpecificationCode = policyConProductItem.getProductSpecificationCode();
                    PolicyExeInfo policyExeInfo = (PolicyExeInfo)policyConMatchedItem.getExeInfo(productSpecificationCode);
                    if (policyExeInfo == null || CollectionUtils.isEmpty(policyExeResults = policyExeInfo.getPolicyExeResults())) continue;
                    PolicyExeResult policyExeResult = policyExeResults.get(policyExeResults.size() - 1);
                    float initSubtotal = policyExeResult.getInitSubtotal();
                    float lastSubtotal = policyExeResult.getLastSubtotal();
                    float initNumber = policyExeResult.getInitNumber();
                    float lastSurplusNumber = policyExeResult.getLastSurplusNumber();
                    float lastSurplusTotal = policyExeResult.getLastSurplusTotal();
                    subtotalDiscountAmount = new BigDecimal(initSubtotal).subtract(new BigDecimal(lastSubtotal));
                    totalDiscountAmount = totalDiscountAmount.add(subtotalDiscountAmount);
                    subtotalEnjoyAmount = subtotalEnjoyAmount.add(new BigDecimal(initSubtotal).subtract(new BigDecimal(lastSurplusTotal)));
                    subtotalEnjoyNumber = subtotalEnjoyNumber.add(new BigDecimal(initNumber)).subtract(new BigDecimal(lastSurplusNumber));
                    subtotalProductAmount = subtotalProductAmount.add(new BigDecimal(initSubtotal));
                    List<GiftInfo> giftInfos = policyExeResult.getLastGifts();
                    if (CollectionUtils.isEmpty(giftInfos)) continue;
                    Pair<Integer, BigDecimal> perfectGiftResult = this.perfectGiftInfos(giftInfos);
                    subtotalGiftNumber = subtotalGiftNumber + (Integer)perfectGiftResult.getLeft();
                    subtotalGiftAmount = subtotalGiftAmount.add((BigDecimal)perfectGiftResult.getRight());
                    allGifts.addAll(giftInfos);
                }
                subtotalDiscountAmount.setScale(4, RoundingMode.HALF_UP);
                policyConMatchedItem.setSubtotalDiscountAmount(subtotalDiscountAmount);
                subtotalEnjoyAmount.setScale(4, RoundingMode.HALF_UP);
                policyConMatchedItem.setSubtotalEnjoyAmount(subtotalEnjoyAmount);
                subtotalEnjoyNumber.setScale(4, RoundingMode.HALF_UP);
                policyConMatchedItem.setSubtotalEnjoyNumber(subtotalEnjoyNumber);
                subtotalGiftAmount.setScale(4, RoundingMode.HALF_UP);
                policyConMatchedItem.setSubtotalGiftAmount(subtotalGiftAmount);
                policyConMatchedItem.setSubtotalGiftNumber(subtotalGiftNumber);
                subtotalProductAmount.setScale(4, RoundingMode.HALF_UP);
                policyConMatchedItem.setSubtotalProductAmount(subtotalProductAmount);
                continue;
            }
            SalePolicyVo salePolicyVo = policyConMatchedItem.getSalePolicy();
            ExeInfo exeInfo = policyConMatchedItem.getExeInfo(salePolicyVo.getSalePolicyCode());
            if (exeInfo == null || CollectionUtils.isEmpty(policyExeInfoForComposeResults = (policyExeInfoForCompose = (PolicyExeInfoForCompose)exeInfo).getPolicyExeResults())) continue;
            PolicyExeInfoForComposeResult policyExeInfoForComposeResult = policyExeInfoForComposeResults.get(policyExeInfoForComposeResults.size() - 1);
            float initSubtotal = policyExeInfoForComposeResult.getInitTotalAmount();
            float initTotalNumbers = policyExeInfoForComposeResult.getInitTotalNumbers();
            float lastSubtotal = policyExeInfoForComposeResult.getLastTotalAmount();
            float lastSurplusTotalAmount = policyExeInfoForComposeResult.getLastSurplusTotalAmount();
            float lastSurplusTotalNumber = policyExeInfoForComposeResult.getLastSurplusTotalNumber();
            BigDecimal subtotalDiscountAmount = new BigDecimal(initSubtotal).subtract(new BigDecimal(lastSubtotal));
            subtotalDiscountAmount.setScale(4, RoundingMode.HALF_UP);
            policyConMatchedItem.setSubtotalDiscountAmount(subtotalDiscountAmount);
            BigDecimal subtotalEnjoyAmount = new BigDecimal(initSubtotal).subtract(new BigDecimal(lastSurplusTotalAmount));
            subtotalEnjoyAmount.setScale(4, RoundingMode.HALF_UP);
            policyConMatchedItem.setSubtotalEnjoyAmount(subtotalEnjoyAmount);
            BigDecimal subtotalEnjoyNumber = new BigDecimal(initTotalNumbers).subtract(new BigDecimal(lastSurplusTotalNumber));
            subtotalEnjoyNumber.setScale(4, RoundingMode.HALF_UP);
            policyConMatchedItem.setSubtotalEnjoyNumber(subtotalEnjoyNumber);
            policyConMatchedItem.setSubtotalProductAmount(new BigDecimal(initSubtotal).setScale(4, RoundingMode.HALF_UP));
            totalDiscountAmount = totalDiscountAmount.add(subtotalDiscountAmount);
            List<GiftInfo> giftInfos = policyExeInfoForComposeResult.getLastGifts();
            if (!CollectionUtils.isEmpty(giftInfos)) {
                Pair<Integer, BigDecimal> perfectGiftResult = this.perfectGiftInfos(giftInfos);
                policyConMatchedItem.setSubtotalGiftNumber((Integer)perfectGiftResult.getLeft());
                policyConMatchedItem.setSubtotalGiftAmount((BigDecimal)perfectGiftResult.getRight());
                allGifts.addAll(giftInfos);
                continue;
            }
            policyConMatchedItem.setSubtotalGiftNumber(0);
            policyConMatchedItem.setSubtotalGiftAmount(BigDecimal.ZERO);
        }
        totalDiscountAmount.setScale(2, RoundingMode.UP);
        context.setTotalDiscountAmount(totalDiscountAmount);
        if (!CollectionUtils.isEmpty((Collection)allGifts)) {
            List giftInfos = allGifts.stream().sorted((target, source) -> {
                String targetSpecificationCode = target.getSpecificationCode();
                String targetUnitCode = target.getUnitCode();
                String sourceSpecificationCode = source.getSpecificationCode();
                String sourceUnitCode = source.getUnitCode();
                return StringUtils.compare((String)(targetSpecificationCode + "_" + targetUnitCode), (String)(sourceSpecificationCode + "_" + sourceUnitCode));
            }).collect(Collectors.toList());
            LinkedHashMap giftInfoMapping = Maps.newLinkedHashMap();
            for (GiftInfo giftInfo : giftInfos) {
                String code = giftInfo.getSpecificationCode();
                String unitCode = giftInfo.getUnitCode();
                String key = StringUtils.join((Object[])new String[]{code, "_", unitCode});
                Integer quantity = giftInfo.getQuantity();
                GiftInfo currentGiftInfo = null;
                currentGiftInfo = (GiftInfo)giftInfoMapping.get(key);
                if (currentGiftInfo == null) {
                    currentGiftInfo = (GiftInfo)this.nebulaToolkitService.copyObjectByWhiteList((Object)giftInfo, GiftInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    giftInfoMapping.put(key, currentGiftInfo);
                    continue;
                }
                Integer cquantity = currentGiftInfo.getQuantity() + quantity;
                currentGiftInfo.setQuantity(cquantity);
                BigDecimal subtotalAmount = currentGiftInfo.getSubtotalAmount().add(giftInfo.getSubtotalAmount());
                BigDecimal unitPrice = BigDecimal.ZERO;
                if (cquantity > 0) {
                    unitPrice = subtotalAmount.multiply(new BigDecimal(cquantity)).setScale(4, RoundingMode.HALF_UP);
                }
                currentGiftInfo.setSubtotalAmount(subtotalAmount);
                currentGiftInfo.setUnitPrice(unitPrice);
            }
            context.setTotalGiftInfos(Lists.newArrayList(giftInfoMapping.values()));
        }
        context.streamlining();
        return context;
    }

    private List<PolicyExeResult> execute(SalePolicyVo salePolicy, PolicyConProduct policyConProduct) {
        PolicyTypeVo policyType = salePolicy.getPolicyType();
        PolicyExecutorVo policyExecutor = policyType.getPolicyExecutor();
        Map<String, SalePolicyGiftsVo> salePolicyGiftMapping = this.validateGiftsBeforeSalePolicy(salePolicy, Lists.newArrayList((Object[])new PolicyConProduct[]{policyConProduct}));
        Pair<Set<SalePolicyExecutorLadderVo>, Set<PolicyExecutorVarVo>> ladderMapping = this.validateLaddersBeforeSalePolicy(salePolicy, policyExecutor);
        Set salePolicyExecutorLadders = (Set)ladderMapping.getLeft();
        Set vars = (Set)ladderMapping.getRight();
        String unitCode = policyConProduct.getUnitCode();
        String productCode = policyConProduct.getProductSpecificationCode();
        float initPrice = policyConProduct.getUnitPrice().floatValue();
        float initNumber = policyConProduct.getQuantity().floatValue();
        float initSubtotal = policyConProduct.getSubtotalAmount().floatValue();
        float initSpecificPrice = policyConProduct.getSpecificPrice() == null ? 0.0f : policyConProduct.getSpecificPrice().floatValue();
        ArrayList<PolicyExeResult> results = new ArrayList<PolicyExeResult>();
        Iterator salePolicyExecutorLadderIterator = salePolicyExecutorLadders.iterator();
        int index = 0;
        int resultIndex = 0;
        while (index < salePolicyExecutorLadders.size()) {
            List lastGifts;
            Object lastSurplusTotalObject;
            Object lastSurplusNumberObject;
            Object lastSurplusPriceObject;
            Object lastTotalObject;
            Object lastNumberObject;
            SalePolicyExecutorLadderVo salePolicyExecutorLadderItem = (SalePolicyExecutorLadderVo)((Object)salePolicyExecutorLadderIterator.next());
            PolicyExeResult policyExeResult = new PolicyExeResult();
            policyExeResult.setInitNumber(initNumber);
            policyExeResult.setInitPrice(initPrice);
            policyExeResult.setInitSubtotal(initSubtotal);
            policyExeResult.setInitSpecificPrice(initSpecificPrice);
            List<GiftInfo> preGiftInfos = this.analysisPreGift(salePolicyGiftMapping, index, results);
            policyExeResult.setPreGifts(preGiftInfos);
            if (index == 0) {
                policyExeResult.setPreNumber(initNumber);
                policyExeResult.setPrePrice(initPrice);
                policyExeResult.setPreSubtotal(initSubtotal);
                policyExeResult.setPreSurplusNumber(initNumber);
                policyExeResult.setPreSurplusPrice(initPrice);
                policyExeResult.setPreSurplusTotal(initSubtotal);
            } else {
                PolicyExeResult prePolicyExeInfo = (PolicyExeResult)results.get(resultIndex - 1);
                policyExeResult.setPreNumber(prePolicyExeInfo.getLastNumber());
                policyExeResult.setPrePrice(prePolicyExeInfo.getLastPrice());
                policyExeResult.setPreSubtotal(prePolicyExeInfo.getLastSubtotal());
                policyExeResult.setPreSurplusNumber(prePolicyExeInfo.getLastSurplusNumber());
                policyExeResult.setPreSurplusPrice(prePolicyExeInfo.getLastSurplusPrice());
                policyExeResult.setPreSurplusTotal(prePolicyExeInfo.getLastSurplusTotal());
            }
            HashMap params = Maps.newHashMap();
            params.put("_init_number", Float.valueOf(policyExeResult.getInitNumber()));
            params.put("_init_price", Float.valueOf(policyExeResult.getInitPrice()));
            params.put("_init_subtotal", Float.valueOf(policyExeResult.getInitSubtotal()));
            params.put("_init_specific_price", Float.valueOf(policyExeResult.getInitSpecificPrice()));
            params.put("_pre_number", Float.valueOf(policyExeResult.getPreNumber()));
            params.put("_pre_price", Float.valueOf(policyExeResult.getPrePrice()));
            params.put("_pre_subtotal", Float.valueOf(policyExeResult.getPreSubtotal()));
            params.put("_pre_surplus_number", Float.valueOf(policyExeResult.getPreSurplusNumber()));
            params.put("_pre_surplus_price", Float.valueOf(policyExeResult.getPreSurplusPrice()));
            params.put("_pre_surplus_total", Float.valueOf(policyExeResult.getPreSurplusTotal()));
            params.put("_pre_gifts", policyExeResult.getPreGifts());
            params.put("unitCode", unitCode);
            params.put("productCode", productCode);
            params.put("productSpecificationService", this.productSpecificationService);
            policyExeResult.setLastNumber(policyExeResult.getPreNumber());
            policyExeResult.setLastPrice(policyExeResult.getPrePrice());
            policyExeResult.setLastSubtotal(policyExeResult.getPreSubtotal());
            policyExeResult.setLastSurplusNumber(policyExeResult.getPreSurplusNumber());
            policyExeResult.setLastSurplusPrice(policyExeResult.getPreSurplusPrice());
            policyExeResult.setLastSurplusTotal(policyExeResult.getPreSurplusTotal());
            if (!CollectionUtils.isEmpty(preGiftInfos)) {
                ArrayList<GiftInfo> lastGifts2 = new ArrayList<GiftInfo>(this.nebulaToolkitService.copyCollectionByWhiteList(preGiftInfos, GiftInfo.class, GiftInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                policyExeResult.setLastGifts(lastGifts2);
                params.put("_last_gifts", lastGifts2);
                params.put("gifts", salePolicyGiftMapping);
            }
            Set<SalePolicyExecutorVarsVo> salePolicyExecutorVars = salePolicyExecutorLadderItem.getSalePolicyExecutorVars();
            Map<String, String> salePolicyExecutorVarMapping = salePolicyExecutorVars.stream().collect(Collectors.toMap(SalePolicyExecutorVarsVo::getVariableName, SalePolicyExecutorVarsVo::getVariableValue));
            this.mappingVariableValues(salePolicyExecutorVarMapping, vars, index, params);
            String tenantCode = TenantUtils.getTenantCode();
            Map currentScriptParams = null;
            String scriptId = policyExecutor.getScript();
            try {
                currentScriptParams = this.scriptService.invoke(tenantCode, new String[]{scriptId}, (Map)params);
            }
            catch (InvokeProxyException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            Object lastPriceObject = currentScriptParams.get("_last_price");
            if (lastPriceObject != null) {
                policyExeResult.setLastPrice(Float.parseFloat(lastPriceObject.toString()));
            }
            if ((lastNumberObject = currentScriptParams.get("_last_number")) != null) {
                policyExeResult.setLastNumber(Float.parseFloat(lastNumberObject.toString()));
            }
            if ((lastTotalObject = currentScriptParams.get("_last_subtotal")) != null) {
                policyExeResult.setLastSubtotal(Float.parseFloat(lastTotalObject.toString()));
            }
            if ((lastSurplusPriceObject = currentScriptParams.get("_last_surplus_price")) != null) {
                policyExeResult.setLastSurplusPrice(Float.parseFloat(lastSurplusPriceObject.toString()));
            }
            if ((lastSurplusNumberObject = currentScriptParams.get("_last_surplus_number")) != null) {
                policyExeResult.setLastSurplusNumber(Float.parseFloat(lastSurplusNumberObject.toString()));
            }
            if ((lastSurplusTotalObject = currentScriptParams.get("_last_surplus_total")) != null) {
                policyExeResult.setLastSurplusTotal(Float.parseFloat(lastSurplusTotalObject.toString()));
            }
            if (!CollectionUtils.isEmpty((Collection)(lastGifts = (List)currentScriptParams.get("_last_gifts")))) {
                Validate.isTrue((lastGifts != null && lastGifts.size() == salePolicyGiftMapping.size() ? 1 : 0) != 0, (String)"\u8ba1\u7b97\u7ed3\u679c\u4e2d\u5b58\u5728\u8d60\u54c1\uff0c\u4f46\u8d60\u54c1\u6761\u76ee\u548c\u8ba1\u7b97\u524d\u7684\u8d60\u54c1\u6761\u76ee\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            boolean isChange = false;
            if (policyExeResult.getInitNumber() != ((Float)currentScriptParams.get("_init_number")).floatValue() && policyExeResult.getInitPrice() != ((Float)currentScriptParams.get("_init_price")).floatValue() && policyExeResult.getInitSubtotal() != ((Float)currentScriptParams.get("_init_subtotal")).floatValue() && policyExeResult.getInitSpecificPrice() != ((Float)currentScriptParams.get("_init_specific_price")).floatValue()) {
                throw new IllegalArgumentException("\u5728\u8ba1\u7b97\u811a\u672c\u4e2d\uff0c\u4e0d\u80fd\u5bf9\u4ea7\u54c1\u7684\u521d\u59cb\u503c\u8fdb\u884c\u4fee\u6539\uff08_init_number\u3001_init_price\u3001_init_subtotal\u3001_init_specific_price");
            }
            if (policyExeResult.getPreNumber() != policyExeResult.getLastNumber() || policyExeResult.getPrePrice() != policyExeResult.getLastPrice() || policyExeResult.getPreSubtotal() != policyExeResult.getLastSubtotal() || policyExeResult.getPreSurplusNumber() != policyExeResult.getLastSurplusNumber() || policyExeResult.getPreSurplusPrice() != policyExeResult.getLastSurplusPrice() || policyExeResult.getPreSurplusTotal() != policyExeResult.getLastSurplusTotal()) {
                isChange = true;
            }
            List<GiftInfo> preGifts = policyExeResult.getPreGifts();
            for (int cindex = 0; !CollectionUtils.isEmpty(salePolicyGiftMapping) && cindex < salePolicyGiftMapping.size(); ++cindex) {
                GiftInfo preGift = preGifts.get(cindex);
                GiftInfo lastGift = (GiftInfo)lastGifts.get(cindex);
                if (preGift.getQuantity().intValue() == lastGift.getQuantity().intValue()) continue;
                isChange = true;
                break;
            }
            results.add(policyExeResult);
            if (isChange && !policyType.getAllowableSteps().booleanValue()) break;
            ++index;
            ++resultIndex;
        }
        return results;
    }

    private PolicyExecuteContext validate(Set<SalePolicyVo> initSalePolicys, Set<PolicyConProduct> initPolicyProducts, String tenantCode, String customerCode) {
        initSalePolicys = this.initSalePolicyOrders(initSalePolicys);
        PolicyExecuteContext executreContext = new PolicyExecuteContext(initSalePolicys, tenantCode, customerCode, this.nebulaToolkitService);
        Map<String, PolicyConProduct> remainingPolicyProducts = initPolicyProducts.stream().collect(Collectors.toMap(PolicyConProduct::getProductSpecificationCode, item -> item));
        LinkedHashMap realRemainingPolicyProducts = Maps.newLinkedHashMap(remainingPolicyProducts);
        for (SalePolicyVo salePolicyItem : initSalePolicys) {
            String message;
            Set thresholdZoreCodes;
            boolean compose = salePolicyItem.getCompose();
            Set<SalePolicyProductsVo> salePolicyProducts = salePolicyItem.getProducts();
            Set salePolicyProductCodes = salePolicyProducts.stream().map(SalePolicyProductsVo::getProductSpecificationCode).collect(Collectors.toSet());
            boolean isSubset = false;
            boolean isIntersectionSet = false;
            Set remainingPolicyProductSpecificationCodes = remainingPolicyProducts.values().stream().map(PolicyConProduct::getProductSpecificationCode).collect(Collectors.toSet());
            if (compose && !CollectionUtils.isEmpty(thresholdZoreCodes = salePolicyProducts.stream().filter(item -> item.getThreshold().floatValue() == 0.0f).map(SalePolicyProductsVo::getProductSpecificationCode).collect(Collectors.toSet()))) {
                remainingPolicyProductSpecificationCodes.addAll(thresholdZoreCodes);
            }
            Sets.SetView intersectionCodeValues = Sets.intersection(remainingPolicyProductSpecificationCodes, salePolicyProductCodes);
            LinkedHashSet intersectionCodes = Sets.newLinkedHashSet();
            if (!CollectionUtils.isEmpty((Collection)intersectionCodeValues)) {
                intersectionCodes.addAll(intersectionCodeValues);
            }
            if (!CollectionUtils.isEmpty((Collection)intersectionCodes) && intersectionCodes.size() == salePolicyProductCodes.size()) {
                isSubset = true;
                isIntersectionSet = true;
            } else if (!CollectionUtils.isEmpty((Collection)intersectionCodes)) {
                isIntersectionSet = true;
            }
            if (!compose && !isIntersectionSet) {
                message = "\u672a\u6db5\u76d6\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f.";
                executreContext.addExcludedPolicy(salePolicyItem, message);
                continue;
            }
            if (compose && !isSubset) {
                message = "\u672a\u6db5\u76d6/\u672a\u5b8c\u5168\u6db5\u76d6\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f.";
                executreContext.addExcludedPolicy(salePolicyItem, message);
                continue;
            }
            Map<String, PolicyConProduct> thisTimeSourcePolicyProducts = remainingPolicyProducts.values().stream().filter(item -> intersectionCodes.contains(item.getProductSpecificationCode())).collect(Collectors.toMap(PolicyConProduct::getProductSpecificationCode, item -> item));
            Map<String, SalePolicyProductsVo> thisTimeTargetPolicyProducts = salePolicyProducts.stream().filter(item -> intersectionCodes.contains(item.getProductSpecificationCode())).collect(Collectors.toMap(SalePolicyProductsVo::getProductSpecificationCode, item -> item));
            BigDecimal totalQuantity = BigDecimal.ZERO;
            BigDecimal totalAmount = BigDecimal.ZERO;
            List realIncludePolicyProducts = null;
            try {
                Triple<List<PolicyConProduct>, BigDecimal, BigDecimal> triple = this.validateEachSalePolicy(salePolicyItem, thisTimeSourcePolicyProducts, thisTimeTargetPolicyProducts, intersectionCodes, totalQuantity, totalAmount);
                realIncludePolicyProducts = (List)triple.getLeft();
                totalQuantity = (BigDecimal)triple.getMiddle();
                totalAmount = (BigDecimal)triple.getRight();
            }
            catch (RuntimeException e) {
                executreContext.addExcludedPolicy(salePolicyItem, e.getMessage());
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)realIncludePolicyProducts)) {
                String message2 = "\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f\u5747\u6ca1\u6709\u8fbe\u5230\u5355\u54c1\u6700\u4f4e\u53c2\u4e0e\u8981\u6c42";
                executreContext.addExcludedPolicy(salePolicyItem, message2);
                continue;
            }
            if (compose) {
                Integer composeType = salePolicyItem.getComposeType();
                BigDecimal composeNumber = salePolicyItem.getComposeNumber();
                if (composeType != null && composeNumber != null && composeNumber.floatValue() > 0.0f) {
                    String message3;
                    if (composeType == 1 && composeNumber.floatValue() > totalAmount.floatValue()) {
                        message3 = "\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f\u6574\u4f53\u603b\u4ef7\u6ca1\u6709\u8fbe\u5230\u53c2\u4e0e\u9650\u989d";
                        executreContext.addExcludedPolicy(salePolicyItem, message3);
                        continue;
                    }
                    if (composeType == 2 && composeNumber.floatValue() > totalQuantity.floatValue()) {
                        message3 = "\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f\u6574\u4f53\u6570\u91cf\u6ca1\u6709\u8fbe\u5230\u53c2\u4e0e\u9650\u989d";
                        executreContext.addExcludedPolicy(salePolicyItem, message3);
                        continue;
                    }
                }
            }
            for (String intersectionCode : intersectionCodes) {
                realRemainingPolicyProducts.remove(intersectionCode);
            }
            PolicyConMatched policyConMatched = new PolicyConMatched(realIncludePolicyProducts, salePolicyItem);
            executreContext.addMatchedPolicy(salePolicyItem.getSalePolicyCode(), policyConMatched);
        }
        if (!realRemainingPolicyProducts.isEmpty()) {
            Collection realRemainingPolicyConProducts = realRemainingPolicyProducts.values();
            realRemainingPolicyConProducts = this.nebulaToolkitService.copyCollectionByBlankList(realRemainingPolicyConProducts, PolicyConProduct.class, PolicyConProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            executreContext.setExcludedPolicyProducts(new ArrayList<PolicyConProduct>(realRemainingPolicyConProducts));
        }
        return executreContext;
    }

    private Triple<List<PolicyConProduct>, BigDecimal, BigDecimal> validateEachSalePolicy(SalePolicyVo salePolicyItem, Map<String, PolicyConProduct> thisTimeSourcePolicyProducts, Map<String, SalePolicyProductsVo> thisTimeTargetPolicyProducts, Set<String> intersectionCodes, BigDecimal totalQuantity, BigDecimal totalAmount) {
        boolean compose = salePolicyItem.getCompose();
        ArrayList realIncludePolicyProducts = Lists.newArrayList();
        for (PolicyConProduct policyConProductItem : thisTimeSourcePolicyProducts.values()) {
            String message;
            String productSpecificationCode = policyConProductItem.getProductSpecificationCode();
            BigDecimal orderQuantity = policyConProductItem.getQuantity();
            BigDecimal subtotalAmount = policyConProductItem.getSubtotalAmount();
            BigDecimal unitPrice = policyConProductItem.getUnitPrice();
            String unitCode = policyConProductItem.getUnitCode();
            BigDecimal orderQuantityForTargetUnit = null;
            BigDecimal orderUnitPriceForTargetUnit = null;
            float unitRate = 1.0f;
            SalePolicyProductsVo currentSalePolicyProduct = thisTimeTargetPolicyProducts.get(productSpecificationCode);
            if (currentSalePolicyProduct == null) {
                String message2 = "\u7279\u4ef7\u4f18\u60e0\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u5546\u54c1(\u5546\u54c1\u8bbe\u5b9a\u5b58\u5728\u95ee\u9898)!!";
                throw new IllegalArgumentException(message2);
            }
            String targetUnitCode = currentSalePolicyProduct.getUnitCode();
            try {
                unitRate = this.transformationUnitRate(productSpecificationCode, unitCode, targetUnitCode);
                orderQuantityForTargetUnit = orderQuantity.multiply(new BigDecimal(unitRate)).setScale(2, RoundingMode.HALF_UP);
                orderUnitPriceForTargetUnit = unitPrice.divide(new BigDecimal(unitRate), 2, RoundingMode.HALF_UP);
            }
            catch (RuntimeException e) {
                intersectionCodes.remove(productSpecificationCode);
                if (!compose) continue;
                String message3 = "\u672a\u5b8c\u5168\u6db5\u76d6\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f(\u5546\u54c1\u5355\u4f4d\u5b58\u5728\u95ee\u9898)";
                throw new IllegalArgumentException(message3);
            }
            BigDecimal orderSpecificPriceForTargetUnit = BigDecimal.ZERO;
            PolicyTypeVo policyTypeItem = salePolicyItem.getPolicyType();
            if (policyTypeItem.getSaleType() == 1) {
                String message4;
                BigDecimal specificPrice = currentSalePolicyProduct.getSpecificPrice();
                if (specificPrice == null) {
                    message4 = "\u7279\u4ef7\u4f18\u60e0\u65f6\uff0c\u672a\u53d1\u73b0\u5546\u54c1\u8bbe\u5b9a\u7684\u7279\u4ef7\u4fe1\u606f(\u5546\u54c1\u8bbe\u5b9a\u5b58\u5728\u95ee\u9898)!!";
                    throw new IllegalArgumentException(message4);
                }
                if (specificPrice.floatValue() < 0.0f) {
                    message4 = "\u7279\u4ef7\u4f18\u60e0\u65f6\uff0c\u5546\u54c1\u8bbe\u5b9a\u7684\u7279\u4ef7\u503c\u5c0f\u4e8e0(\u5546\u54c1\u8bbe\u5b9a\u5b58\u5728\u95ee\u9898)!!";
                    throw new IllegalArgumentException(message4);
                }
                orderSpecificPriceForTargetUnit = specificPrice.divide(new BigDecimal(unitRate), 4, RoundingMode.HALF_UP);
            }
            BigDecimal targetThreshold = currentSalePolicyProduct.getThreshold();
            Integer targetThresholdType = currentSalePolicyProduct.getThresholdType();
            if (targetThreshold == null || targetThresholdType == null || StringUtils.isBlank((CharSequence)targetUnitCode)) {
                totalQuantity = totalQuantity.add(orderQuantityForTargetUnit);
                totalAmount = totalAmount.add(subtotalAmount);
                continue;
            }
            if (targetThresholdType == 1) {
                if (targetThreshold.floatValue() > orderUnitPriceForTargetUnit.floatValue()) {
                    intersectionCodes.remove(productSpecificationCode);
                    if (!compose) continue;
                    message = "\u672a\u5b8c\u5168\u6db5\u76d6\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f(\u81f3\u5c11\u4e00\u7c7b\u5546\u54c1\u5355\u4ef7\u91d1\u989d\u672a\u8fbe\u5230\u8981\u6c42)";
                    throw new IllegalArgumentException(message);
                }
            } else if (targetThresholdType == 2) {
                if (targetThreshold.floatValue() > subtotalAmount.floatValue()) {
                    intersectionCodes.remove(productSpecificationCode);
                    if (!compose) continue;
                    message = "\u672a\u5b8c\u5168\u6db5\u76d6\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f(\u81f3\u5c11\u4e00\u7c7b\u5546\u54c1\u5c0f\u8ba1\u603b\u4ef7\u91d1\u989d\u672a\u8fbe\u5230\u8981\u6c42)";
                    throw new IllegalArgumentException(message);
                }
            } else if (targetThresholdType == 3 && targetThreshold.floatValue() > orderUnitPriceForTargetUnit.floatValue()) {
                intersectionCodes.remove(productSpecificationCode);
                if (!compose) continue;
                message = "\u672a\u5b8c\u5168\u6db5\u76d6\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f(\u81f3\u5c11\u4e00\u7c7b\u5546\u54c1\u6570\u91cf\u672a\u8fbe\u5230\u8981\u6c42)";
                throw new IllegalArgumentException(message);
            }
            totalQuantity = totalQuantity.add(orderQuantityForTargetUnit);
            totalAmount = totalAmount.add(subtotalAmount);
            PolicyConProduct realIncludePolicyProduct = (PolicyConProduct)this.nebulaToolkitService.copyObjectByWhiteList((Object)policyConProductItem, PolicyConProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            realIncludePolicyProduct.setUnitRate(Float.valueOf(unitRate));
            realIncludePolicyProduct.setQuantity(orderQuantityForTargetUnit);
            realIncludePolicyProduct.setUnitPrice(orderUnitPriceForTargetUnit);
            realIncludePolicyProduct.setSpecificPrice(orderSpecificPriceForTargetUnit);
            realIncludePolicyProducts.add(realIncludePolicyProduct);
        }
        return Triple.of((Object)realIncludePolicyProducts, (Object)totalQuantity, (Object)totalAmount);
    }

    private Set<SalePolicyVo> initSalePolicyOrders(Set<SalePolicyVo> initSalePolicys) {
        List salePoliciesForType1NoCompose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 1 && item.getPolicyType().getCompose() == false).collect(Collectors.toList());
        List salePoliciesForType2NoCompose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 2 && item.getPolicyType().getCompose() == false).collect(Collectors.toList());
        List salePoliciesForType3NoCompose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 3 && item.getPolicyType().getCompose() == false).collect(Collectors.toList());
        List salePoliciesForType4NoCompose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 4 && item.getPolicyType().getCompose() == false).collect(Collectors.toList());
        List salePoliciesForType5NoCompose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 5 && item.getPolicyType().getCompose() == false).collect(Collectors.toList());
        List salePoliciesForType1Compose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 1 && item.getPolicyType().getCompose() != false).collect(Collectors.toList());
        List salePoliciesForType2Compose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 2 && item.getPolicyType().getCompose() != false).collect(Collectors.toList());
        List salePoliciesForType3Compose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 3 && item.getPolicyType().getCompose() != false).collect(Collectors.toList());
        List salePoliciesForType4Compose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 4 && item.getPolicyType().getCompose() != false).collect(Collectors.toList());
        List salePoliciesForType5Compose = initSalePolicys.stream().filter(item -> item.getPolicyType().getSaleType() == 5 && item.getPolicyType().getCompose() != false).collect(Collectors.toList());
        LinkedHashSet salePolicys = Sets.newLinkedHashSet();
        if (!CollectionUtils.isEmpty(salePoliciesForType1NoCompose)) {
            salePolicys.addAll(salePoliciesForType1NoCompose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType2NoCompose)) {
            salePolicys.addAll(salePoliciesForType2NoCompose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType3NoCompose)) {
            salePolicys.addAll(salePoliciesForType3NoCompose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType4NoCompose)) {
            salePolicys.addAll(salePoliciesForType4NoCompose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType5NoCompose)) {
            salePolicys.addAll(salePoliciesForType5NoCompose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType1Compose)) {
            salePolicys.addAll(salePoliciesForType1Compose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType2Compose)) {
            salePolicys.addAll(salePoliciesForType2Compose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType3Compose)) {
            salePolicys.addAll(salePoliciesForType3Compose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType4Compose)) {
            salePolicys.addAll(salePoliciesForType4Compose);
        }
        if (!CollectionUtils.isEmpty(salePoliciesForType5Compose)) {
            salePolicys.addAll(salePoliciesForType5Compose);
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicys) ? 1 : 0) != 0, (String)"\u8425\u9500\u653f\u7b56\u7c7b\u578b\u5b58\u5728\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6b63!!", (Object[])new Object[0]);
        return salePolicys;
    }

    private Map<String, SalePolicyGiftsVo> validateGiftsBeforeSalePolicy(SalePolicyVo salePolicy, List<PolicyConProduct> policyConProducts) {
        PolicyTypeVo policyType = salePolicy.getPolicyType();
        boolean displayGifts = policyType.getDisplayGifts();
        boolean giftsMapping = policyType.getGiftsMapping();
        Map<Object, Object> salePolicyGiftMapping = Maps.newLinkedHashMap();
        if (displayGifts && giftsMapping) {
            for (PolicyConProduct policyConProductItem : policyConProducts) {
                Integer giftQuantity = policyConProductItem.getGiftQuantity();
                String giftSpecificationCode = policyConProductItem.getGiftSpecificationCode();
                String giftUnitCode = policyConProductItem.getGiftUnitCode();
                if (salePolicyGiftMapping.get(giftSpecificationCode) != null) {
                    SalePolicyGiftsVo salePolicyGift = (SalePolicyGiftsVo)((Object)salePolicyGiftMapping.get(giftSpecificationCode));
                    Integer exsitQuantity = salePolicyGift.getGiftQuantity();
                    String exsitUnitCode = salePolicyGift.getGiftUnitCode();
                    Validate.isTrue((boolean)StringUtils.equals((CharSequence)exsitUnitCode, (CharSequence)giftUnitCode), (String)"\u7ec4\u5408\u5546\u54c1\u8d60\u54c1\u4e00\u5bf9\u4e00\u7684\u573a\u666f\u4e0b\uff0c\u53d1\u73b0\u5355\u4f4d\u89c4\u683c\u4e0d\u4e00\u81f4\u7684\u8d60\u54c1\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
                    salePolicyGift.setGiftQuantity(exsitQuantity + giftQuantity);
                    continue;
                }
                SalePolicyGiftsVo gift = new SalePolicyGiftsVo();
                gift.setGiftSpecificationCode(giftSpecificationCode);
                gift.setGiftQuantity(giftQuantity);
                gift.setGiftUnitCode(giftUnitCode);
                salePolicyGiftMapping.put(giftSpecificationCode, (Object)gift);
            }
        } else if (displayGifts) {
            Set<SalePolicyGiftsVo> salePolicyGifts = salePolicy.getGifts();
            Validate.isTrue((salePolicyGifts.stream().map(SalePolicyGiftsVo::getGiftSpecificationCode).distinct().count() == (long)salePolicyGifts.size() ? 1 : 0) != 0, (String)"\u5f53\u524d\u7b56\u7565\u8ba1\u7b97\u4f20\u5165\u4e86\u8d60\u54c1\u4fe1\u606f\uff0c\u4f46\u8d60\u54c1\u7f16\u7801\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            salePolicyGiftMapping = salePolicyGifts.stream().collect(Collectors.toMap(SalePolicyGiftsVo::getGiftSpecificationCode, item -> item));
        }
        return salePolicyGiftMapping;
    }

    private Pair<Set<SalePolicyExecutorLadderVo>, Set<PolicyExecutorVarVo>> validateLaddersBeforeSalePolicy(SalePolicyVo salePolicy, PolicyExecutorVo policyExecutor) {
        Set<SalePolicyExecutorLadderVo> salePolicyExecutorLadders = salePolicy.getSalePolicyExecutorLadders();
        Set<PolicyExecutorVarVo> vars = policyExecutor.getPolicyExecutorVars();
        if (!CollectionUtils.isEmpty(vars)) {
            int index;
            LinkedHashSet variableNames = Sets.newLinkedHashSet();
            Iterator<PolicyExecutorVarVo> varItor = vars.iterator();
            for (index = 0; index < vars.size(); ++index) {
                PolicyExecutorVarVo varItem = varItor.next();
                String variableName = varItem.getVariableName();
                Validate.notBlank((CharSequence)variableName, (String)"\u9519\u8bef\u7684\u5165\u53c2\u53d8\u91cf\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5b9a\u503c\uff01\uff01", (Object[])new Object[0]);
                variableNames.add(variableName);
            }
            index = 1;
            for (SalePolicyExecutorLadderVo salePolicyExecutorLadderItem : salePolicyExecutorLadders) {
                Set<SalePolicyExecutorVarsVo> salePolicyExecutorVars = salePolicyExecutorLadderItem.getSalePolicyExecutorVars();
                Set saleVariableNames = salePolicyExecutorVars.stream().map(SalePolicyExecutorVarsVo::getVariableName).collect(Collectors.toSet());
                Validate.isTrue((Sets.intersection((Set)variableNames, saleVariableNames).size() == variableNames.size() ? 1 : 0) != 0, (String)"\u672a\u5728\u7b2c%d\u7ec4\u5916\u53c2\u4e2d\u53d1\u73b0\u5fc5\u8981\u7684\u53d8\u91cf\u503c\uff0c\u8bf7\u68c0\u67e5", (long)(index + 1));
                ++index;
            }
        }
        return Pair.of(salePolicyExecutorLadders, vars);
    }

    private List<GiftInfo> analysisPreGift(Map<String, SalePolicyGiftsVo> salePolicyGiftMapping, int index, List<?> results) {
        ArrayList preGiftInfos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(salePolicyGiftMapping)) {
            return preGiftInfos;
        }
        if (index == 0) {
            Collection<SalePolicyGiftsVo> salePolicyGiftValues = salePolicyGiftMapping.values();
            for (SalePolicyGiftsVo item : salePolicyGiftValues) {
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.setUnitCode(item.getGiftUnitCode());
                giftInfo.setName(item.getGiftUnitName());
                giftInfo.setSpecificationCode(item.getGiftSpecificationCode());
                giftInfo.setSpecificationName(item.getGiftSpecificationName());
                giftInfo.setUnitCode(item.getGiftUnitCode());
                giftInfo.setUnitName(item.getGiftUnitName());
                giftInfo.setQuantity(0);
                giftInfo.setSubtotalAmount(BigDecimal.ZERO);
                giftInfo.setUnitPrice(BigDecimal.ZERO);
                preGiftInfos.add(giftInfo);
            }
        } else {
            Object result = results.get(index - 1);
            if (result instanceof PolicyExeResult) {
                PolicyExeResult prePolicyExeInfo = (PolicyExeResult)result;
                List<GiftInfo> lastGifts = prePolicyExeInfo.getLastGifts();
                preGiftInfos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(lastGifts, GiftInfo.class, GiftInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            } else if (result instanceof PolicyExeInfoForComposeResult) {
                PolicyExeInfoForComposeResult prePolicyExeInfo = (PolicyExeInfoForComposeResult)result;
                List<GiftInfo> lastGifts = prePolicyExeInfo.getLastGifts();
                preGiftInfos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(lastGifts, GiftInfo.class, GiftInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            }
        }
        return preGiftInfos;
    }

    private void mappingVariableValues(Map<String, String> salePolicyExecutorVarMapping, Set<PolicyExecutorVarVo> vars, int index, Map<String, Object> params) {
        Iterator<PolicyExecutorVarVo> varItor = vars.iterator();
        block6: for (int cindex = 0; vars != null && cindex < vars.size(); ++cindex) {
            PolicyExecutorVarVo policyExecutorVars = varItor.next();
            String variableName = policyExecutorVars.getVariableName();
            Integer variableType = policyExecutorVars.getVariableType();
            String value = salePolicyExecutorVarMapping.get(variableName);
            Validate.notBlank((CharSequence)value, (String)"\u5728\u8fdb\u884c\u7b2c%d\u6b21\u7b56\u7565\u8ba1\u7b97\u65f6\uff0c\u672a\u53d1\u73b0%s\u53d8\u91cf\u503c", (Object[])new Object[]{index - 1, variableName});
            switch (variableType) {
                case 1: {
                    Boolean valueBoolean = Boolean.valueOf(value);
                    params.put(variableName, valueBoolean);
                    continue block6;
                }
                case 2: {
                    Float valueString = Float.valueOf(value);
                    params.put(variableName, valueString);
                    continue block6;
                }
                case 3: {
                    Integer valueInteger = Integer.valueOf(value);
                    params.put(variableName, valueInteger);
                    continue block6;
                }
                case 4: {
                    params.put(variableName, value);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("\u7b56\u7565\u6267\u884c\u8fc7\u7a0b\u4e2d\uff0c\u53d1\u73b0\u672a\u77e5\u7c7b\u578b\u7684\u53c2\u6570\uff01\uff01");
                }
            }
        }
    }

    private List<PolicyExeInfoForComposeResult> execute(SalePolicyVo salePolicy, List<PolicyConProduct> policyConProducts) {
        PolicyTypeVo policyType = salePolicy.getPolicyType();
        PolicyExecutorVo policyExecutor = policyType.getPolicyExecutor();
        Map<String, SalePolicyGiftsVo> salePolicyGiftMapping = this.validateGiftsBeforeSalePolicy(salePolicy, policyConProducts);
        Pair<Set<SalePolicyExecutorLadderVo>, Set<PolicyExecutorVarVo>> ladderMapping = this.validateLaddersBeforeSalePolicy(salePolicy, policyExecutor);
        Set salePolicyExecutorLadders = (Set)ladderMapping.getLeft();
        Set vars = (Set)ladderMapping.getRight();
        int productSize = policyConProducts.size();
        String[] unitCodes = new String[productSize];
        String[] productCodes = new String[productSize];
        float[] initPrices = new float[productSize];
        float[] initNumbers = new float[productSize];
        float[] initSubtotals = new float[productSize];
        float[] initSpecificPrices = new float[productSize];
        int productIndex = 0;
        float initTotalAmount = 0.0f;
        float initTotalNumbers = 0.0f;
        for (PolicyConProduct policyConProductItem : policyConProducts) {
            unitCodes[productIndex] = policyConProductItem.getUnitCode();
            productCodes[productIndex] = policyConProductItem.getProductSpecificationCode();
            initPrices[productIndex] = policyConProductItem.getUnitPrice().floatValue();
            initNumbers[productIndex] = policyConProductItem.getQuantity().floatValue();
            initSubtotals[productIndex] = policyConProductItem.getSubtotalAmount().floatValue();
            initSpecificPrices[productIndex] = policyConProductItem.getSpecificPrice() == null ? 0.0f : policyConProductItem.getSpecificPrice().floatValue();
            initTotalAmount += initSubtotals[productIndex];
            initTotalNumbers += initNumbers[productIndex];
            ++productIndex;
        }
        ArrayList<PolicyExeInfoForComposeResult> results = new ArrayList<PolicyExeInfoForComposeResult>();
        Iterator salePolicyExecutorLadderIterator = salePolicyExecutorLadders.iterator();
        for (int index = 0; index < salePolicyExecutorLadders.size(); ++index) {
            List lastGifts;
            Object lastSurplusTotalAmount;
            Object lastSurplusTotalNumber;
            Object lastTotalNumber;
            SalePolicyExecutorLadderVo salePolicyExecutorLadderItem = (SalePolicyExecutorLadderVo)((Object)salePolicyExecutorLadderIterator.next());
            PolicyExeInfoForComposeResult policyExeResult = new PolicyExeInfoForComposeResult();
            policyExeResult.setInitNumbers(initNumbers);
            policyExeResult.setInitPrices(initPrices);
            policyExeResult.setInitSubtotals(initSubtotals);
            policyExeResult.setInitTotalAmount(initTotalAmount);
            policyExeResult.setInitTotalNumbers(initTotalNumbers);
            policyExeResult.setInitSpecificPrices(initSpecificPrices);
            List<GiftInfo> preGiftInfos = this.analysisPreGift(salePolicyGiftMapping, index, results);
            policyExeResult.setPreGifts(preGiftInfos);
            if (index == 0) {
                policyExeResult.setPreTotalAmount(initTotalAmount);
                policyExeResult.setPreTotalNumber(initTotalNumbers);
                policyExeResult.setPreSurplusTotalAmount(initTotalAmount);
                policyExeResult.setPreSurplusTotalNumber(initTotalNumbers);
            } else {
                PolicyExeInfoForComposeResult prePolicyExeInfo = (PolicyExeInfoForComposeResult)results.get(index - 1);
                policyExeResult.setPreTotalAmount(prePolicyExeInfo.getLastTotalAmount());
                policyExeResult.setPreTotalNumber(prePolicyExeInfo.getLastTotalNumber());
                policyExeResult.setPreSurplusTotalAmount(prePolicyExeInfo.getLastSurplusTotalAmount());
                policyExeResult.setPreSurplusTotalNumber(prePolicyExeInfo.getLastSurplusTotalNumber());
            }
            HashMap params = Maps.newHashMap();
            params.put("_init_numbers", policyExeResult.getInitNumbers());
            params.put("_init_prices", policyExeResult.getInitPrices());
            params.put("_init_subtotals", policyExeResult.getInitSubtotals());
            params.put("_init_specific_prices", policyExeResult.getInitSpecificPrices());
            params.put("_pre_total_amount", Float.valueOf(policyExeResult.getPreTotalAmount()));
            params.put("_pre_total_number", Float.valueOf(policyExeResult.getPreTotalNumber()));
            params.put("_pre_surplus_total_number", Float.valueOf(policyExeResult.getPreSurplusTotalNumber()));
            params.put("_pre_surplus_total_amount", Float.valueOf(policyExeResult.getPreSurplusTotalAmount()));
            params.put("_pre_gifts", policyExeResult.getPreGifts());
            params.put("unitCodes", unitCodes);
            params.put("productCodes", productCodes);
            params.put("productSpecificationService", this.productSpecificationService);
            policyExeResult.setLastTotalAmount(policyExeResult.getPreTotalAmount());
            policyExeResult.setLastTotalNumber(policyExeResult.getPreTotalNumber());
            policyExeResult.setLastSurplusTotalAmount(policyExeResult.getLastSurplusTotalAmount());
            policyExeResult.setLastSurplusTotalNumber(policyExeResult.getLastSurplusTotalNumber());
            if (!CollectionUtils.isEmpty(preGiftInfos)) {
                ArrayList<GiftInfo> lastGifts2 = new ArrayList<GiftInfo>(this.nebulaToolkitService.copyCollectionByWhiteList(preGiftInfos, GiftInfo.class, GiftInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                policyExeResult.setLastGifts(lastGifts2);
                params.put("_last_gifts", lastGifts2);
                params.put("gifts", salePolicyGiftMapping);
            }
            Set<SalePolicyExecutorVarsVo> salePolicyExecutorVars = salePolicyExecutorLadderItem.getSalePolicyExecutorVars();
            Map<String, String> salePolicyExecutorVarMapping = salePolicyExecutorVars.stream().collect(Collectors.toMap(SalePolicyExecutorVarsVo::getVariableName, SalePolicyExecutorVarsVo::getVariableValue));
            this.mappingVariableValues(salePolicyExecutorVarMapping, vars, index, params);
            String tenantCode = TenantUtils.getTenantCode();
            Map currentScriptParams = null;
            String scriptId = policyExecutor.getScript();
            try {
                currentScriptParams = this.scriptService.invoke(tenantCode, new String[]{scriptId}, (Map)params);
            }
            catch (InvokeProxyException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            Object lastTotalAmount = currentScriptParams.get("_last_total_amount");
            if (lastTotalAmount != null) {
                policyExeResult.setLastTotalAmount(Float.parseFloat(lastTotalAmount.toString()));
            }
            if ((lastTotalNumber = currentScriptParams.get("_last_total_number")) != null) {
                policyExeResult.setLastTotalNumber(Float.parseFloat(lastTotalNumber.toString()));
            }
            if ((lastSurplusTotalNumber = currentScriptParams.get("_last_surplus_total_number")) != null) {
                policyExeResult.setLastSurplusTotalNumber(Float.parseFloat(lastSurplusTotalNumber.toString()));
            }
            if ((lastSurplusTotalAmount = currentScriptParams.get("_last_surplus_total_amount")) != null) {
                policyExeResult.setLastSurplusTotalAmount(Float.parseFloat(lastSurplusTotalAmount.toString()));
            }
            if (!CollectionUtils.isEmpty((Collection)(lastGifts = (List)currentScriptParams.get("_last_gifts")))) {
                Validate.isTrue((lastGifts != null && lastGifts.size() == salePolicyGiftMapping.size() ? 1 : 0) != 0, (String)"\u8ba1\u7b97\u7ed3\u679c\u4e2d\u5b58\u5728\u8d60\u54c1\uff0c\u4f46\u8d60\u54c1\u6761\u76ee\u548c\u8ba1\u7b97\u524d\u7684\u8d60\u54c1\u6761\u76ee\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            boolean isChange = false;
            if (policyExeResult.getPreTotalAmount() != policyExeResult.getLastTotalAmount() || policyExeResult.getPreTotalNumber() != policyExeResult.getLastTotalNumber() || policyExeResult.getPreSurplusTotalAmount() != policyExeResult.getLastSurplusTotalAmount() || policyExeResult.getPreSurplusTotalNumber() != policyExeResult.getLastSurplusTotalNumber()) {
                isChange = true;
            }
            List<GiftInfo> preGifts = policyExeResult.getPreGifts();
            for (int cindex = 0; !CollectionUtils.isEmpty(salePolicyGiftMapping) && cindex < salePolicyGiftMapping.size(); ++cindex) {
                GiftInfo preGift = preGifts.get(cindex);
                GiftInfo lastGift = (GiftInfo)lastGifts.get(cindex);
                if (preGift.getQuantity().intValue() == lastGift.getQuantity().intValue()) continue;
                isChange = true;
                break;
            }
            results.add(policyExeResult);
            if (isChange && !policyType.getAllowableSteps().booleanValue()) break;
        }
        return results;
    }

    private Pair<Integer, BigDecimal> perfectGiftInfos(List<GiftInfo> giftInfos) {
        String unitCode;
        String specificationCode;
        Integer giftNumber = 0;
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList conditionPairs = Lists.newArrayList();
        ProductSpecificationAndUnitPriceDto conditionQueryResult = null;
        for (GiftInfo giftInfo : giftInfos) {
            specificationCode = giftInfo.getSpecificationCode();
            unitCode = giftInfo.getUnitCode();
            Integer quantity = giftInfo.getQuantity();
            giftNumber = giftNumber + quantity;
            Pair pair = Pair.of((Object)specificationCode, (Object)unitCode);
            conditionPairs.add(pair);
            conditionQueryResult = this.productUnitAndPriceService.findPriceBySpecUnitPairList((List)conditionPairs);
        }
        if (conditionQueryResult == null) {
            return Pair.of((Object)giftNumber, (Object)totalAmount);
        }
        for (GiftInfo giftInfo : giftInfos) {
            specificationCode = giftInfo.getSpecificationCode();
            ProductSpecificationAndUnitPriceDto codeAndUnitPrice = conditionQueryResult.getProductSpecificationAndUnitPriceDto(specificationCode, unitCode = giftInfo.getUnitCode());
            if (codeAndUnitPrice == null) continue;
            giftInfo.setSpecificationName(codeAndUnitPrice.getProductSpecificationName());
            giftInfo.setUnitName(codeAndUnitPrice.getUnitName());
            BigDecimal unitPrice = codeAndUnitPrice.getSellingPrice();
            Integer quantity = giftInfo.getQuantity();
            giftInfo.setUnitPrice(unitPrice);
            BigDecimal giftSubtotalAmount = unitPrice.multiply(new BigDecimal(quantity).setScale(4, RoundingMode.HALF_UP));
            totalAmount = totalAmount.add(giftSubtotalAmount);
            giftInfo.setSubtotalAmount(giftSubtotalAmount);
        }
        return Pair.of((Object)giftNumber, (Object)totalAmount);
    }

    @Override
    @Transactional
    public PolicyExecuteContext executePolicy(String relevanceCode, Set<PolicyConProduct> initPolicyProducts, List<GiftInfo> sourceGiftInfos, String tenantCode, String customerCode) {
        Map<String, PolicyConMatched> policyConMatching;
        PolicyExecuteContext context;
        Validate.notBlank((CharSequence)relevanceCode, (String)"\u5916\u90e8\u5355\u636e\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashMap sourceGiftInfoMapping = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(sourceGiftInfos)) {
            for (GiftInfo sourceGiftInfo : sourceGiftInfos) {
                String code = sourceGiftInfo.getSpecificationCode();
                String unitCode = sourceGiftInfo.getUnitCode();
                Integer quantity = sourceGiftInfo.getQuantity();
                Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, unitCode}) && quantity != null ? 1 : 0) != 0, (String)"\u5728\u6b63\u5f0f\u6267\u884c\u65f6\uff0c\u8c03\u7528\u8005\u4f20\u5165\u4e86\u9519\u8bef\u7684\u53c2\u8003\u8d60\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            for (GiftInfo item : sourceGiftInfos) {
                String key = StringUtils.join((Object[])new String[]{item.getSpecificationCode(), "_", item.getUnitCode()});
                if (!sourceGiftInfoMapping.containsKey(key)) {
                    sourceGiftInfoMapping.put(key, item);
                    continue;
                }
                GiftInfo target = (GiftInfo)sourceGiftInfoMapping.get(key);
                if (target.getQuantity() != null && item.getQuantity() != null) {
                    target.setQuantity(target.getQuantity() + item.getQuantity());
                }
                if (target.getSubtotalAmount() != null && item.getSubtotalAmount() != null) {
                    target.setSubtotalAmount(target.getSubtotalAmount().add(item.getSubtotalAmount()));
                }
                sourceGiftInfoMapping.put(key, target);
            }
        }
        if ((context = this.preExecutePolicy(initPolicyProducts, tenantCode, customerCode)) == null) {
            return null;
        }
        List<GiftInfo> allGiftInfos = context.getTotalGiftInfos();
        if (!CollectionUtils.isEmpty(allGiftInfos)) {
            for (GiftInfo targetGiftInfo : allGiftInfos) {
                String targetCode = targetGiftInfo.getSpecificationCode();
                String targetUnitCode = targetGiftInfo.getUnitCode();
                Integer tarQuantity = targetGiftInfo.getQuantity();
                if (tarQuantity == 0) continue;
                String key = StringUtils.join((Object[])new String[]{targetCode, "_", targetUnitCode});
                GiftInfo sourceGift = (GiftInfo)sourceGiftInfoMapping.get(key);
                Validate.notNull((Object)sourceGift, (String)"\u5728\u6b63\u5f0f\u6267\u884c\u8425\u9500\u6d3b\u52a8\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e00\u4e2a\u8425\u9500\u6d3b\u52a8\u7684\u8d60\u54c1\u4fe1\u606f\u88ab\u51cf\u5c11\u5230\u4e860\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Validate.isTrue((tarQuantity <= sourceGift.getQuantity() ? 1 : 0) != 0, (String)"\u5728\u6b63\u5f0f\u6267\u884c\u8425\u9500\u6d3b\u52a8\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u8d60\u54c1\u6570\u91cf\u548c\u5355\u636e\u6700\u7ec8\u6807\u5b9a\u7684\u8d60\u54c1\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
        }
        if (CollectionUtils.isEmpty(policyConMatching = context.getMatchedPolicyMapping())) {
            return null;
        }
        Collection<PolicyConMatched> policyConMatcheds = policyConMatching.values();
        for (PolicyConMatched policyConMatchedItem : policyConMatcheds) {
            boolean compose = policyConMatchedItem.getSalePolicy().getCompose();
            this.salePolicyResultService.create(policyConMatchedItem, customerCode, relevanceCode, compose);
        }
        return context;
    }

    private float transformationUnitRate(String productSpecificationCode, String sourceUnitCode, String targetUnitCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{productSpecificationCode, sourceUnitCode, targetUnitCode})) {
            return 1.0f;
        }
        if (StringUtils.equals((CharSequence)sourceUnitCode, (CharSequence)targetUnitCode)) {
            return 1.0f;
        }
        BigDecimal sourceUnitRate = this.productSpecificationService.findConvertRate(productSpecificationCode, sourceUnitCode);
        BigDecimal targetUnitRate = this.productSpecificationService.findConvertRate(productSpecificationCode, targetUnitCode);
        if (targetUnitRate.floatValue() == 0.0f) {
            return 1.0f;
        }
        return sourceUnitRate.divide(targetUnitRate, 6, RoundingMode.HALF_UP).floatValue();
    }
}

