/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.entity.PolicyExecutorVar;
import com.bizunited.empower.business.policy.repository.PolicyExecutorVarsRepository;
import com.bizunited.empower.business.policy.service.PolicyExecutorVarService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PolicyExecutorVarsServiceImpl")
public class PolicyExecutorVarServiceImpl
implements PolicyExecutorVarService {
    @Autowired
    private PolicyExecutorVarsRepository policyExecutorVarRepository;

    @Override
    @Transactional
    public PolicyExecutorVar create(PolicyExecutorVar policyExecutorVars) {
        PolicyExecutorVar current = this.createForm(policyExecutorVars);
        return current;
    }

    @Override
    @Transactional
    public PolicyExecutorVar createForm(PolicyExecutorVar policyExecutorVars) {
        this.createValidation(policyExecutorVars);
        this.policyExecutorVarRepository.save((Object)policyExecutorVars);
        return policyExecutorVars;
    }

    private void createValidation(PolicyExecutorVar policyExecutorVars) {
        Validate.notNull((Object)((Object)policyExecutorVars), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)policyExecutorVars.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        policyExecutorVars.setId(null);
        Validate.notBlank((CharSequence)policyExecutorVars.getVariableName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyExecutorVars.getVariableType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d8\u91cf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((policyExecutorVars.getVariableName() == null || policyExecutorVars.getVariableName().length() < 255 ? 1 : 0) != 0, (String)"\u53d8\u91cf\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public PolicyExecutorVar update(PolicyExecutorVar policyExecutorVars) {
        PolicyExecutorVar current = this.updateForm(policyExecutorVars);
        return current;
    }

    @Override
    @Transactional
    public PolicyExecutorVar updateForm(PolicyExecutorVar policyExecutorVars) {
        this.updateValidation(policyExecutorVars);
        String currentId = policyExecutorVars.getId();
        Optional op_currentPolicyExecutorVars = this.policyExecutorVarRepository.findById(currentId);
        PolicyExecutorVar currentPolicyExecutorVars = op_currentPolicyExecutorVars.orElse(null);
        currentPolicyExecutorVars = (PolicyExecutorVar)((Object)Validate.notNull((Object)((Object)currentPolicyExecutorVars), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentPolicyExecutorVars.setVariableName(policyExecutorVars.getVariableName());
        currentPolicyExecutorVars.setVariableType(policyExecutorVars.getVariableType());
        currentPolicyExecutorVars.setPolicyExecutor(policyExecutorVars.getPolicyExecutor());
        this.policyExecutorVarRepository.saveAndFlush((Object)currentPolicyExecutorVars);
        return currentPolicyExecutorVars;
    }

    private void updateValidation(PolicyExecutorVar policyExecutorVars) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)policyExecutorVars.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutorVars.getVariableName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyExecutorVars.getVariableType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53d8\u91cf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((policyExecutorVars.getVariableName() == null || policyExecutorVars.getVariableName().length() < 255 ? 1 : 0) != 0, (String)"\u53d8\u91cf\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<PolicyExecutorVar> findDetailsByPolicyExecutor(String policyExecutor) {
        if (StringUtils.isBlank((CharSequence)policyExecutor)) {
            return Lists.newArrayList();
        }
        return this.policyExecutorVarRepository.findDetailsByPolicyExecutor(policyExecutor);
    }

    @Override
    public PolicyExecutorVar findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.policyExecutorVarRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        PolicyExecutorVar current = this.findById(id);
        if (current != null) {
            this.policyExecutorVarRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void deleteByExecutor(String executorId) {
        Validate.notBlank((CharSequence)executorId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u7b56\u7565\u7c7b\u578b\u6267\u884c\u5668\u7684\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        this.policyExecutorVarRepository.deleteByExecutor(executorId);
    }
}

