/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountBrandDetails;
import com.bizunited.empower.business.policy.repository.RebateAccountBrandDetailsRepository;
import com.bizunited.empower.business.policy.repository.RebateAccountRepository;
import com.bizunited.empower.business.policy.service.RebateAccountBrandDetailsService;
import com.bizunited.empower.business.product.service.ProductBrandService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RebateAccountBrandDetailsServiceImpl")
public class RebateAccountBrandDetailsServiceImpl
implements RebateAccountBrandDetailsService {
    @Autowired
    private RebateAccountBrandDetailsRepository rebateAccountBrandDetailsRepository;
    @Autowired
    private RebateAccountRepository rebateAccountRepository;
    @Autowired
    private ProductBrandService productBrandService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String REBATE_CODE_PREFIX = "RPB";

    @Override
    @Transactional
    public void init(RebateAccount rebateAccount, String[] brandCodes) {
        Validate.isTrue((brandCodes != null && brandCodes.length > 0 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u81f3\u5c11\u4e00\u4e2a\u54c1\u724c\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String brandCode : brandCodes) {
            this.init(rebateAccount, brandCode);
        }
    }

    private void init(RebateAccount rebateAccount, String brandCode) {
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8fd4\u5229\u8d26\u6237\u4fe1\u606f", (Object[])new Object[0]);
        RebateAccount currentRebateAccount = this.rebateAccountRepository.findById(rebateAccount.getId()).orElse(null);
        Validate.notNull((Object)((Object)currentRebateAccount), (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u8d26\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String customerCode = currentRebateAccount.getCustomerCode();
        BigDecimal detailAmount = BigDecimal.ZERO;
        Integer detailType = 1;
        String opAccount = SecurityUtils.getUserAccount();
        String remark = "\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1[\u5546\u54c1\u54c1\u724c" + brandCode + "]\u521d\u59cb\u5316";
        Date now = new Date();
        RebateAccountBrandDetails rebateAccountBrandDetail = new RebateAccountBrandDetails();
        rebateAccountBrandDetail.setCreateAccount(opAccount);
        rebateAccountBrandDetail.setCreateTime(now);
        rebateAccountBrandDetail.setModifyAccount(opAccount);
        rebateAccountBrandDetail.setModifyTime(now);
        rebateAccountBrandDetail.setAvailableAmount(BigDecimal.ZERO);
        rebateAccountBrandDetail.setDetailAmount(detailAmount);
        rebateAccountBrandDetail.setDetailType(detailType);
        rebateAccountBrandDetail.setRebateAccount(rebateAccount);
        rebateAccountBrandDetail.setRelevanceCode(null);
        rebateAccountBrandDetail.setRemark(remark);
        rebateAccountBrandDetail.setId(null);
        rebateAccountBrandDetail.setBrandCode(brandCode);
        this.createValidation(rebateAccountBrandDetail, customerCode, now, true);
        this.rebateAccountBrandDetailsRepository.save((Object)rebateAccountBrandDetail);
    }

    @Override
    @Transactional
    public RebateAccountBrandDetails create(RebateAccountBrandDetails rebateAccountBrandDetails) {
        RebateAccountBrandDetails current = this.createForm(rebateAccountBrandDetails);
        return current;
    }

    private RebateAccountBrandDetails createForm(RebateAccountBrandDetails rebateAccountBrandDetail) {
        Validate.notNull((Object)((Object)rebateAccountBrandDetail), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        RebateAccount rebateAccount = rebateAccountBrandDetail.getRebateAccount();
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u672a\u6307\u5b9a\u8fd4\u5229\u660e\u7ec6\u5173\u8054\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String rebateAccountId = rebateAccount.getId();
        RebateAccount existRebateAccount = this.rebateAccountRepository.findById(rebateAccountId).orElse(null);
        Validate.notNull((Object)((Object)existRebateAccount), (String)"\u521b\u5efa\u901a\u7528\u8d26\u6237\u660e\u7ec6\u65f6\uff0c\u672a\u6307\u5b9a\u8fd4\u5229\u660e\u7ec6\u5173\u8054\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((existRebateAccount.getRebateAccountStatus() == 1 ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u8fd4\u5229\u8d26\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u4efb\u4f55\u8fd4\u5229\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String customerCode = existRebateAccount.getCustomerCode();
        Date now = new Date();
        rebateAccountBrandDetail.setCreateAccount(SecurityUtils.getUserAccount());
        rebateAccountBrandDetail.setCreateTime(now);
        rebateAccountBrandDetail.setModifyAccount(SecurityUtils.getUserAccount());
        rebateAccountBrandDetail.setModifyTime(now);
        this.createValidation(rebateAccountBrandDetail, customerCode, now, false);
        BigDecimal detailAmount = rebateAccountBrandDetail.getDetailAmount();
        Integer detailType = rebateAccountBrandDetail.getDetailType();
        String relevanceCode = rebateAccountBrandDetail.getRelevanceCode();
        String opAccount = SecurityUtils.getUserAccount();
        String remark = rebateAccountBrandDetail.getRemark() == null ? "" : rebateAccountBrandDetail.getRemark();
        String id = rebateAccountBrandDetail.getId();
        String brandCode = rebateAccountBrandDetail.getBrandCode();
        String rebateAccountBrandCode = rebateAccountBrandDetail.getRebateAccountBrandCode();
        if (detailType > 0) {
            this.rebateAccountBrandDetailsRepository.createForIncrement(id, brandCode, rebateAccountBrandCode, detailAmount, detailType, relevanceCode, rebateAccountId, opAccount, now, opAccount, now, remark);
        } else if (detailType < 0) {
            this.rebateAccountBrandDetailsRepository.createForDecrement(id, brandCode, rebateAccountBrandCode, detailAmount, detailType, relevanceCode, rebateAccountId, opAccount, now, opAccount, now, remark);
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u8fd4\u5229\u660e\u7ec6\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        rebateAccountBrandDetail.setRebateAccountBrandCode(rebateAccountBrandCode);
        rebateAccountBrandDetail.setId(id);
        return rebateAccountBrandDetail;
    }

    private void createValidation(RebateAccountBrandDetails rebateAccountBrandDetail, String customerCode, Date now, boolean init) {
        Long count;
        RebateAccount rebateAccount = rebateAccountBrandDetail.getRebateAccount();
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\u5fc5\u987b\u9996\u5148\u8fdb\u884c\u521b\u5efa!!", (Object[])new Object[0]);
        String rebateAccountId = rebateAccount.getId();
        Validate.notBlank((CharSequence)rebateAccountId, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u8d26\u6237\u6280\u672f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RebateAccount cRebateAccount = this.rebateAccountRepository.findById(rebateAccountId).orElse(null);
        Validate.notNull((Object)((Object)cRebateAccount), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u6307\u5b9a\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String brandCode = rebateAccountBrandDetail.getBrandCode();
        Validate.notBlank((CharSequence)brandCode, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u5546\u54c1\u54c1\u724c\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        List productBrands = this.productBrandService.findByCodeList((List)Lists.newArrayList((Object[])new String[]{brandCode}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)productBrands) && productBrands.size() == 1 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5546\u54c1\u54c1\u724c\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (init) {
            count = this.rebateAccountBrandDetailsRepository.countByRebateAccountIdAndBrandCode(rebateAccountId, brandCode);
            Validate.isTrue((count == null || count.intValue() == 0 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u5546\u54c1\u54c1\u724c\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316!!", (Object[])new Object[0]);
            Validate.notNull((Object)rebateAccountBrandDetail.getDetailType(), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountBrandDetail.getDetailType() == 1 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u8bf7\u4f20\u51651\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)rebateAccountBrandDetail.getDetailAmount(), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u53d8\u66f4\u91d1\u989d\uff0c\u90fd\u4e3a\u56db\u4f4d\uff0c\u65e0\u8bba\u652f\u51fa\u8fd8\u662f\u6536\u5165\uff0c\u90fd\u4e3a\u6b63\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountBrandDetail.getDetailAmount().intValue() == 0 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u91d1\u989d\u53d8\u66f4\u660e\u7ec6\u5fc5\u987b\u4e3a0\uff01", (Object[])new Object[0]);
        } else {
            count = this.rebateAccountBrandDetailsRepository.countByRebateAccountIdAndBrandCode(rebateAccountId, brandCode);
            Validate.isTrue((count != null && count.intValue() > 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u54c1\u724c\u5fc5\u987b\u4ee5\u9996\u5148\u521d\u59cb\u5316!!", (Object[])new Object[0]);
            Validate.notNull((Object)rebateAccountBrandDetail.getDetailType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountBrandDetail.getDetailType() != 0 && rebateAccountBrandDetail.getDetailType() != 1 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u503c\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)rebateAccountBrandDetail.getDetailAmount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d8\u66f4\u91d1\u989d\uff0c\u90fd\u4e3a\u56db\u4f4d\uff0c\u65e0\u8bba\u652f\u51fa\u8fd8\u662f\u6536\u5165\uff0c\u90fd\u4e3a\u6b63\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountBrandDetail.getDetailAmount().floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u91d1\u989d\u53d8\u66f4\u660e\u7ec6\u5fc5\u987b\u5927\u4e8e0\uff08\u65e0\u8bba\u662f\u91d1\u989d\u589e\u52a0\u8fd8\u662f\u51cf\u5c11\uff09\uff01", (Object[])new Object[0]);
        }
        Validate.isTrue((rebateAccountBrandDetail.getBrandCode() == null || rebateAccountBrandDetail.getBrandCode().length() < 255 ? 1 : 0) != 0, (String)"\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebateAccountBrandDetail.getRelevanceCode() == null || rebateAccountBrandDetail.getRelevanceCode().length() < 64 ? 1 : 0) != 0, (String)"\u5173\u8054\u5355\u636e,\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebateAccountBrandDetail.getRemark() == null || rebateAccountBrandDetail.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (rebateAccountBrandDetail.getDetailType() < 0) {
            BigDecimal currentAvailableAmount = this.rebateAccountBrandDetailsRepository.findAvailableAmountByRebateAccountId(rebateAccountId, brandCode);
            Validate.notNull((Object)currentAvailableAmount, (String)"\u6dfb\u52a0\u660e\u7ec6\u65f6\uff0c\u672a\u53d1\u73b0\u5f53\u524d\u8d26\u6237\u7684\u53ef\u7528\u8d44\u91d1\uff0c\u8bf7\u89c1\u67e5\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u4e13\u7528\u8d44\u91d1\u8fd4\u5229", (Object[])new Object[0]);
            Validate.isTrue((currentAvailableAmount.subtract(rebateAccountBrandDetail.getDetailAmount()).floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u5f53\u524d\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u4e13\u7528\u8d44\u91d1\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        String tenantCode = TenantUtils.getTenantCode();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String datecode = dateFormat.format(now);
        String codeUnKey = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, "_", tenantCode, "_", customerCode});
        String atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
        String rebateAccountBrandCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, atomicNumberValue});
        rebateAccountBrandDetail.setRebateAccountBrandCode(rebateAccountBrandCode);
        if (!init) {
            String id = StringUtils.join((Object[])new String[]{tenantCode, "_", customerCode, "_", brandCode, "_", atomicNumberValue});
            while (this.rebateAccountBrandDetailsRepository.findById(id).orElse(null) != null) {
                atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
                rebateAccountBrandCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, atomicNumberValue});
                id = StringUtils.join((Object[])new String[]{tenantCode, "_", customerCode, "_", brandCode, "_", atomicNumberValue});
            }
            rebateAccountBrandDetail.setId(id);
        }
    }

    @Override
    @Transactional
    public void diffectiveByRelevanceCode(String relevanceCode) {
        if (StringUtils.isBlank((CharSequence)relevanceCode)) {
            return;
        }
        Set<RebateAccountBrandDetails> rebateAccountBrandDetails = this.rebateAccountBrandDetailsRepository.findByRelevanceCode(relevanceCode);
        if (CollectionUtils.isEmpty(rebateAccountBrandDetails)) {
            return;
        }
        for (RebateAccountBrandDetails rebateAccountBrandDetail : rebateAccountBrandDetails) {
            Validate.isTrue((rebateAccountBrandDetail.getDetailType() <= -1 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4e1a\u52a1\u5355\u636e\u8fd4\u5229\u6d41\u6c34\u51b2\u62b5\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u6d41\u6c34\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
            RebateAccountBrandDetails newBrandDetail = new RebateAccountBrandDetails();
            newBrandDetail.setId(null);
            newBrandDetail.setRebateAccount(rebateAccountBrandDetail.getRebateAccount());
            newBrandDetail.setDetailType(3);
            newBrandDetail.setBrandCode(rebateAccountBrandDetail.getBrandCode());
            newBrandDetail.setDetailAmount(rebateAccountBrandDetail.getDetailAmount());
            newBrandDetail.setAvailableAmount(null);
            newBrandDetail.setRelevanceCode(relevanceCode);
            newBrandDetail.setRemark("\u4e1a\u52a1\u5355\u636e\u54c1\u724c\u4e13\u7528\u6d88\u8d39\u6d41\u6c34\u51b2\u62b5");
            this.createForm(newBrandDetail);
        }
    }

    @Override
    @Transactional
    public void updateRelevanceCode(String sourceRelevanceCode, String targetRelevanceCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sourceRelevanceCode, targetRelevanceCode})) {
            return;
        }
        this.rebateAccountBrandDetailsRepository.updateRelevanceCode(sourceRelevanceCode, targetRelevanceCode);
    }
}

