/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.repository.RebateAccountBrandDetailsRepository;
import com.bizunited.empower.business.policy.service.RebateAccountBrandGroupDetailsVoService;
import com.bizunited.empower.business.policy.vo.RebateAccountBrandGroupDetailsVo;
import com.bizunited.empower.business.product.entity.ProductBrand;
import com.bizunited.empower.business.product.service.ProductBrandService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_RebateAccountBrandGroupDetailsVoServiceImpl")
public class RebateAccountBrandGroupDetailsVoServiceImpl
implements RebateAccountBrandGroupDetailsVoService {
    @Autowired
    private RebateAccountBrandDetailsRepository rebateAccountBrandDetailsRepository;
    @Autowired
    private ProductBrandService productBrandService;

    @Override
    public Set<RebateAccountBrandGroupDetailsVo> findByRebateAccountId(String rebateAccountId) {
        if (StringUtils.isBlank((CharSequence)rebateAccountId)) {
            return null;
        }
        Object[][] results = this.rebateAccountBrandDetailsRepository.findByGroupRebateAccountId(rebateAccountId);
        if (results == null || results.length == 0) {
            return null;
        }
        HashSet brandCodes = Sets.newHashSet();
        LinkedHashSet rebateAccountBrandGroupDetails = Sets.newLinkedHashSet();
        for (Object[] items : results) {
            String cRebateAccountId = items[0].toString();
            String brandCode = items[1].toString();
            BigDecimal availableAmount = items[2] == null ? BigDecimal.ZERO : (BigDecimal)items[2];
            BigDecimal usedAmount = items[3] == null ? BigDecimal.ZERO : (BigDecimal)items[3];
            BigDecimal totalAmount = availableAmount.add(usedAmount);
            RebateAccountBrandGroupDetailsVo rebateAccountBrandGroupDetail = new RebateAccountBrandGroupDetailsVo();
            rebateAccountBrandGroupDetail.setRebateAccountId(cRebateAccountId);
            rebateAccountBrandGroupDetail.setBrandCode(brandCode);
            brandCodes.add(brandCode);
            rebateAccountBrandGroupDetail.setAvailableAmount(availableAmount);
            rebateAccountBrandGroupDetail.setUsedAmount(usedAmount);
            rebateAccountBrandGroupDetail.setTotalAmount(totalAmount);
            rebateAccountBrandGroupDetails.add(rebateAccountBrandGroupDetail);
        }
        List productBrands = this.productBrandService.findByCodeList((List)Lists.newArrayList((Iterable)brandCodes));
        if (CollectionUtils.isEmpty((Collection)productBrands)) {
            return rebateAccountBrandGroupDetails;
        }
        Map<String, ProductBrand> productBrandMapping = productBrands.stream().collect(Collectors.toMap(ProductBrand::getBrandCode, item -> item));
        for (RebateAccountBrandGroupDetailsVo rebateAccountBrandGroupDetail : rebateAccountBrandGroupDetails) {
            String brandCode = rebateAccountBrandGroupDetail.getBrandCode();
            ProductBrand brand = productBrandMapping.get(brandCode);
            if (brand == null) continue;
            rebateAccountBrandGroupDetail.setBrandName(brand.getBrandName());
        }
        return rebateAccountBrandGroupDetails;
    }
}

