/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountCommonDetails;
import com.bizunited.empower.business.policy.repository.RebateAccountCommonDetailsRepository;
import com.bizunited.empower.business.policy.service.RebateAccountCommonDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountCommonDetailsVoService;
import com.bizunited.empower.business.policy.vo.RebateAccountCommonDetailsVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="RebateAccountCommonDetailsVoServiceImpl")
public class RebateAccountCommonDetailsVoServiceImpl
implements RebateAccountCommonDetailsVoService {
    @Autowired
    private RebateAccountCommonDetailsService rebateAccountCommonDetailsService;
    @Autowired
    private RebateAccountCommonDetailsRepository rebateAccountCommonDetailsRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    private static final String REBATE_POLICY_COMMON_GEN_PREFIX = "REBATE_POLICY_COMMON_GEN_PREFIX";

    @Override
    public String preCreate() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(REBATE_POLICY_COMMON_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebateAccountCommonDetailsVo create(RebateAccountCommonDetailsVo rebateAccountCommonDetail) {
        block5: {
            Validate.notNull((Object)((Object)rebateAccountCommonDetail), (String)"\u6dfb\u52a0\u8fd4\u5229\u8d26\u6237-\u901a\u7528\u660e\u7ec6\u65f6\uff0c\u6dfb\u52a0\u7684\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            String prefix = rebateAccountCommonDetail.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u8fd4\u5229\u8d26\u6237-\u901a\u7528\u8d26\u6237\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(REBATE_POLICY_COMMON_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u8fd4\u5229\u8d26\u6237-\u901a\u7528\u8d26\u6237\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(REBATE_POLICY_COMMON_GEN_PREFIX, prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u8fd4\u5229\u653f\u7b56\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
        RebateAccountCommonDetails cRebateAccountCommonDetail = (RebateAccountCommonDetails)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rebateAccountCommonDetail, RebateAccountCommonDetails.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        RebateAccount rebateAccount = new RebateAccount();
        rebateAccount.setId(rebateAccountCommonDetail.getRebateAccountId());
        cRebateAccountCommonDetail.setRebateAccount(rebateAccount);
        cRebateAccountCommonDetail = this.rebateAccountCommonDetailsService.create(cRebateAccountCommonDetail);
        rebateAccountCommonDetail.setId(cRebateAccountCommonDetail.getId());
        return rebateAccountCommonDetail;
    }

    @Override
    public Page<RebateAccountCommonDetailsVo> findByConditions(Pageable pageable, String rebateAccountId) {
        Page<RebateAccountCommonDetails> resutls;
        if (StringUtils.isBlank((CharSequence)rebateAccountId)) {
            return null;
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if ((resutls = this.rebateAccountCommonDetailsRepository.findByCondition(pageable, rebateAccountId)) == null || resutls.isEmpty()) {
            return null;
        }
        Collection rebateAccountCommonDetails = this.nebulaToolkitService.copyCollectionByWhiteList(resutls, RebateAccountCommonDetails.class, RebateAccountCommonDetailsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new PageImpl((List)Lists.newArrayList((Iterable)rebateAccountCommonDetails), pageable, resutls.getTotalElements());
    }
}

