/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountProductDetails;
import com.bizunited.empower.business.policy.repository.RebateAccountProductDetailsRepository;
import com.bizunited.empower.business.policy.repository.RebateAccountRepository;
import com.bizunited.empower.business.policy.service.RebateAccountProductDetailsService;
import com.bizunited.empower.business.product.entity.Product;
import com.bizunited.empower.business.product.entity.ProductSpecification;
import com.bizunited.empower.business.product.service.ProductActionService;
import com.bizunited.empower.business.product.service.ProductService;
import com.bizunited.empower.business.product.service.ProductSpecificationService;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RebateAccountProductDetailsServiceImpl")
public class RebateAccountProductDetailsServiceImpl
implements RebateAccountProductDetailsService {
    @Autowired
    private RebateAccountProductDetailsRepository rebateAccountProductDetailsRepository;
    @Autowired
    private RebateAccountRepository rebateAccountRepository;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductSpecificationService productSpecificationService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private ProductActionService productActionService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String REBATE_CODE_PREFIX = "RPP";

    @Override
    @Transactional
    public void init(RebateAccount rebateAccount, String[] productCodes, String[] productSpecificationCodes, String[] unitCodes) {
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8fd4\u5229\u8d26\u6237\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((productCodes != null && productCodes.length > 0 && productSpecificationCodes != null && productSpecificationCodes.length > 0 && unitCodes != null && unitCodes.length > 0 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u5546\u54c1\u7f16\u53f7\uff0c\u5546\u54c1\u89c4\u683c\u7f16\u53f7\uff0c\u5355\u4f4d\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((productCodes.length == productSpecificationCodes.length ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u5546\u54c1\u7f16\u53f7\u6570\u91cf\u548c\u5546\u54c1\u89c4\u683c\u6570\u91cf\u5fc5\u987b\u4e00\u81f4", (Object[])new Object[0]);
        Validate.isTrue((productSpecificationCodes.length == unitCodes.length ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u5546\u54c1\u89c4\u683c\u548c\u5546\u54c1\u5355\u4f4d\u6570\u91cf\u5fc5\u987b\u4e00\u81f4", (Object[])new Object[0]);
        for (int index = 0; index < productSpecificationCodes.length; ++index) {
            this.init(rebateAccount, productCodes[index], productSpecificationCodes[index], unitCodes[index]);
        }
    }

    private void init(RebateAccount rebateAccount, String productCode, String productSpecificationCode, String unitCode) {
        RebateAccount currentRebateAccount = this.rebateAccountRepository.findById(rebateAccount.getId()).orElse(null);
        Validate.notNull((Object)((Object)currentRebateAccount), (String)"\u521d\u59cb\u5316\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u8d26\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String customerCode = currentRebateAccount.getCustomerCode();
        Date now = new Date();
        String opAccount = SecurityUtils.getUserAccount();
        Integer detailType = 1;
        String remark = "\u8fd4\u5229\u8d26\u6237-\u5b9e\u7269\u8fd4\u5229\u8d26\u6237[\u5546\u54c1\u89c4\u683c" + productSpecificationCode + "]\u521d\u59cb\u5316";
        RebateAccountProductDetails rebateAccountProductDetail = new RebateAccountProductDetails();
        rebateAccountProductDetail.setCreateAccount(opAccount);
        rebateAccountProductDetail.setCreateTime(now);
        rebateAccountProductDetail.setModifyAccount(opAccount);
        rebateAccountProductDetail.setModifyTime(now);
        rebateAccountProductDetail.setRebateAccount(rebateAccount);
        rebateAccountProductDetail.setAvailableNumber(0);
        rebateAccountProductDetail.setDetailNumber(0);
        rebateAccountProductDetail.setDetailType(detailType);
        rebateAccountProductDetail.setProductCode(productCode);
        rebateAccountProductDetail.setProductSpecificationCode(productSpecificationCode);
        rebateAccountProductDetail.setUnitCode(unitCode);
        rebateAccountProductDetail.setRelevanceCode(null);
        rebateAccountProductDetail.setRemark(remark);
        rebateAccountProductDetail.setId(null);
        this.createValidation(rebateAccountProductDetail, customerCode, now, true);
        this.rebateAccountProductDetailsRepository.save((Object)rebateAccountProductDetail);
    }

    @Override
    @Transactional
    public RebateAccountProductDetails create(RebateAccountProductDetails rebateAccountProductDetails) {
        RebateAccountProductDetails current = this.createForm(rebateAccountProductDetails);
        return current;
    }

    private RebateAccountProductDetails createForm(RebateAccountProductDetails rebateAccountProductDetail) {
        Validate.notNull((Object)((Object)rebateAccountProductDetail), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        RebateAccount rebateAccount = rebateAccountProductDetail.getRebateAccount();
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u672a\u6307\u5b9a\u8fd4\u5229\u660e\u7ec6\u5173\u8054\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String rebateAccountId = rebateAccount.getId();
        RebateAccount existRebateAccount = this.rebateAccountRepository.findById(rebateAccountId).orElse(null);
        Validate.notNull((Object)((Object)existRebateAccount), (String)"\u521b\u5efa\u5b9e\u7269\u8fd4\u5229\u8d26\u6237\u660e\u7ec6\u65f6\uff0c\u672a\u6307\u5b9a\u8fd4\u5229\u660e\u7ec6\u5173\u8054\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((existRebateAccount.getRebateAccountStatus() == 1 ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u8fd4\u5229\u8d26\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u4efb\u4f55\u8fd4\u5229\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String customerCode = existRebateAccount.getCustomerCode();
        Date now = new Date();
        rebateAccountProductDetail.setCreateAccount(SecurityUtils.getUserAccount());
        rebateAccountProductDetail.setCreateTime(now);
        rebateAccountProductDetail.setModifyAccount(SecurityUtils.getUserAccount());
        rebateAccountProductDetail.setModifyTime(now);
        this.createValidation(rebateAccountProductDetail, customerCode, now, false);
        Integer detailNumber = rebateAccountProductDetail.getDetailNumber();
        Integer detailType = rebateAccountProductDetail.getDetailType();
        String relevanceCode = rebateAccountProductDetail.getRelevanceCode();
        String productCode = rebateAccountProductDetail.getProductCode();
        String unitCode = rebateAccountProductDetail.getUnitCode();
        String opAccount = SecurityUtils.getUserAccount();
        String remark = rebateAccountProductDetail.getRemark() == null ? "" : rebateAccountProductDetail.getRemark();
        String productSpecificationCode = rebateAccountProductDetail.getProductSpecificationCode();
        String rebateAccountProductCode = rebateAccountProductDetail.getRebateAccountProductCode();
        String id = rebateAccountProductDetail.getId();
        if (detailType > 0) {
            this.rebateAccountProductDetailsRepository.createForIncrement(id, productCode, productSpecificationCode, unitCode, rebateAccountProductCode, detailNumber, detailType, relevanceCode, rebateAccountId, opAccount, now, opAccount, now, remark);
        } else if (detailType < 0) {
            this.rebateAccountProductDetailsRepository.createForDecrement(id, productCode, productSpecificationCode, unitCode, rebateAccountProductCode, detailNumber, detailType, relevanceCode, rebateAccountId, opAccount, now, opAccount, now, remark);
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u8fd4\u5229\u660e\u7ec6\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        rebateAccountProductDetail.setRebateAccountProductCode(rebateAccountProductCode);
        rebateAccountProductDetail.setId(id);
        return rebateAccountProductDetail;
    }

    private void createValidation(RebateAccountProductDetails rebateAccountProductDetail, String customerCode, Date now, boolean init) {
        Long count;
        String productCode = rebateAccountProductDetail.getProductCode();
        String productSpecificationCode = rebateAccountProductDetail.getProductSpecificationCode();
        String unitCode = rebateAccountProductDetail.getUnitCode();
        Validate.notBlank((CharSequence)productCode, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rebateAccountProductDetail.getProductSpecificationCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rebateAccountProductDetail.getUnitCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Product product = this.productService.findByProductCode(productCode);
        Validate.notNull((Object)product, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ProductSpecification productSpecification = this.productSpecificationService.findByTenantCodeAndProductSpecificationCode(productSpecificationCode);
        Validate.notNull((Object)productSpecification, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RebateAccount rebateAccount = rebateAccountProductDetail.getRebateAccount();
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\u5fc5\u987b\u9996\u5148\u8fdb\u884c\u521b\u5efa!!", (Object[])new Object[0]);
        String rebateAccountId = rebateAccount.getId();
        Validate.notBlank((CharSequence)rebateAccountId, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u8d26\u6237\u6280\u672f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RebateAccount cRebateAccount = this.rebateAccountRepository.findById(rebateAccountId).orElse(null);
        Validate.notNull((Object)((Object)cRebateAccount), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u6307\u5b9a\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (!init) {
            RebateAccountProductDetails sourceRebateAccountProductDetail = this.rebateAccountProductDetailsRepository.findByRebateAccountIdAndProductSpecificationCode(rebateAccountId, productSpecificationCode);
            Validate.notNull((Object)((Object)sourceRebateAccountProductDetail), (String)"\u6dfb\u52a0\u6d41\u6c34\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u8fd4\u5229\u7269\u8d44\u5e76\u6ca1\u6709\u8fdb\u884c\u4f59\u91cf\u5e93\u5b58\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            float unitRate = this.productSpecificationVoService.transformationUnitRate(productSpecificationCode, unitCode, sourceRebateAccountProductDetail.getUnitCode());
            unitCode = sourceRebateAccountProductDetail.getUnitCode();
            Integer detailNumber = rebateAccountProductDetail.getDetailNumber();
            Validate.notNull((Object)rebateAccountProductDetail.getDetailNumber(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c \u53d8\u66f4\u6570\u91cf\uff0c\u6574\u6570\uff0c\u65e0\u8bba\u652f\u51fa\u8fd8\u662f\u6536\u5165\uff0c\u90fd\u4e3a\u6b63\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountProductDetail.getDetailNumber() > 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6570\u91cf\u53d8\u66f4\u660e\u7ec6\u5fc5\u987b\u5927\u4e8e0\uff08\u65e0\u8bba\u662f\u6570\u91cf\u589e\u52a0\u8fd8\u662f\u51cf\u5c11\uff09\uff01", (Object[])new Object[0]);
            detailNumber = new BigDecimal(detailNumber).multiply(new BigDecimal(unitRate)).setScale(0, RoundingMode.DOWN).intValue();
            Validate.isTrue((detailNumber > 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7531\u4e8e\u8fd4\u5229\u653f\u7b56\u7269\u8d44\u5355\u4f4d\u8bbe\u5b9a\u7684\u539f\u56e0\uff0c\u5bfc\u81f4\u672c\u6b21\u5b9e\u7269\u8fd4\u5229\u7684\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            rebateAccountProductDetail.setDetailNumber(detailNumber);
            rebateAccountProductDetail.setUnitCode(unitCode);
        }
        Validate.isTrue((boolean)this.productActionService.validityUnitCode(productCode, unitCode), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5546\u54c1\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{productCode, productSpecificationCode, unitCode}) ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u5546\u54c1\u89c4\u683c\u3001\u5546\u54c1\u5355\u4f4d\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        if (init) {
            count = this.rebateAccountProductDetailsRepository.countByRebateAccountIdAndProductSpecificationCode(rebateAccountId, productSpecificationCode);
            Validate.isTrue((count == null || count.intValue() == 0 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u5546\u54c1\u89c4\u683c\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316!!", (Object[])new Object[0]);
            Validate.notNull((Object)rebateAccountProductDetail.getDetailType(), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountProductDetail.getDetailType() == 1 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u5fc5\u987b\u4f20\u51651\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)rebateAccountProductDetail.getDetailNumber(), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u53d8\u66f4\u6570\u91cf\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountProductDetail.getDetailNumber() == 0 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u6570\u91cf\u53d8\u66f4\u660e\u7ec6\u5fc5\u987b\u4f20\u51650\uff01", (Object[])new Object[0]);
        } else {
            count = this.rebateAccountProductDetailsRepository.countByRebateAccountIdAndProductSpecificationCode(rebateAccountId, productSpecificationCode);
            Validate.isTrue((count != null && count.intValue() > 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u89c4\u683c\u5fc5\u987b\u5df2\u7ecf\u5b8c\u6210\u4e86\u521d\u59cb\u5316!!", (Object[])new Object[0]);
            Validate.notNull((Object)rebateAccountProductDetail.getDetailType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((rebateAccountProductDetail.getDetailType() != 0 && rebateAccountProductDetail.getDetailType() != 1 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u503c\uff01", (Object[])new Object[0]);
        }
        Validate.isTrue((rebateAccountProductDetail.getProductCode() == null || rebateAccountProductDetail.getProductCode().length() < 255 ? 1 : 0) != 0, (String)"\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebateAccountProductDetail.getProductSpecificationCode() == null || rebateAccountProductDetail.getProductSpecificationCode().length() < 255 ? 1 : 0) != 0, (String)"\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebateAccountProductDetail.getUnitCode() == null || rebateAccountProductDetail.getUnitCode().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebateAccountProductDetail.getRelevanceCode() == null || rebateAccountProductDetail.getRelevanceCode().length() < 64 ? 1 : 0) != 0, (String)"\u5173\u8054\u5355\u636e,\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebateAccountProductDetail.getRemark() == null || rebateAccountProductDetail.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (rebateAccountProductDetail.getDetailType() < 0) {
            Integer currentAvailableNumber = this.rebateAccountProductDetailsRepository.findAvailableNumberByRebateAccountId(rebateAccountId, productSpecificationCode);
            Validate.notNull((Object)currentAvailableNumber, (String)"\u6dfb\u52a0\u660e\u7ec6\u65f6\uff0c\u672a\u53d1\u73b0\u5f53\u524d\u8d26\u6237\u4e0b\u5546\u54c1\u89c4\u683c\u6570\u91cf\uff0c\u8bf7\u89c1\u67e5\u8fd4\u5229\u8d26\u6237-\u5b9e\u7269\u8fd4\u5229", (Object[])new Object[0]);
            Validate.isTrue((currentAvailableNumber - rebateAccountProductDetail.getDetailNumber() >= 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u5f53\u524d\u8fd4\u5229\u8d26\u6237-\u5b9e\u7269\u8fd4\u5229\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        String tenantCode = TenantUtils.getTenantCode();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String datecode = dateFormat.format(now);
        String codeUnKey = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, "_", tenantCode, "_", customerCode});
        String atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
        String rebateAccountProductCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, productSpecificationCode, atomicNumberValue});
        rebateAccountProductDetail.setRebateAccountProductCode(rebateAccountProductCode);
        if (!init) {
            String id = StringUtils.join((Object[])new String[]{tenantCode, "_", customerCode, "_", productSpecificationCode, "_", atomicNumberValue});
            while (this.rebateAccountProductDetailsRepository.findById(id).orElse(null) != null) {
                atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
                rebateAccountProductCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, productSpecificationCode, atomicNumberValue});
                id = StringUtils.join((Object[])new String[]{tenantCode, "_", customerCode, "_", productSpecificationCode, "_", atomicNumberValue});
            }
            rebateAccountProductDetail.setId(id);
        }
    }

    @Override
    @Transactional
    public void diffectiveByRelevanceCode(String relevanceCode) {
        if (StringUtils.isBlank((CharSequence)relevanceCode)) {
            return;
        }
        Set<RebateAccountProductDetails> rebateAccountProductDetails = this.rebateAccountProductDetailsRepository.findByRelevanceCode(relevanceCode);
        if (CollectionUtils.isEmpty(rebateAccountProductDetails)) {
            return;
        }
        for (RebateAccountProductDetails rebateAccountProductDetail : rebateAccountProductDetails) {
            Validate.isTrue((rebateAccountProductDetail.getDetailType() <= -1 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4e1a\u52a1\u5355\u636e\u5b9e\u7269\u8fd4\u5229\u6570\u91cf\u51b2\u62b5\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u6d41\u6c34\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
            RebateAccountProductDetails newProductDetail = new RebateAccountProductDetails();
            newProductDetail.setId(null);
            newProductDetail.setRebateAccount(rebateAccountProductDetail.getRebateAccount());
            newProductDetail.setDetailNumber(rebateAccountProductDetail.getDetailNumber());
            newProductDetail.setDetailType(3);
            newProductDetail.setProductCode(rebateAccountProductDetail.getProductCode());
            newProductDetail.setProductSpecificationCode(rebateAccountProductDetail.getProductSpecificationCode());
            newProductDetail.setUnitCode(rebateAccountProductDetail.getUnitCode());
            newProductDetail.setAvailableNumber(null);
            newProductDetail.setRelevanceCode(relevanceCode);
            newProductDetail.setRemark("\u4e1a\u52a1\u5355\u636e\u4e8b\u52a1\u8fd4\u5229\u6570\u91cf\u6d41\u6c34\u51b2\u62b5");
            this.createForm(newProductDetail);
        }
    }

    @Override
    @Transactional
    public void updateRelevanceCode(String sourceRelevanceCode, String targetRelevanceCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sourceRelevanceCode, targetRelevanceCode})) {
            return;
        }
        this.rebateAccountProductDetailsRepository.updateRelevanceCode(sourceRelevanceCode, targetRelevanceCode);
    }
}

