/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.repository.RebateAccountProductDetailsRepository;
import com.bizunited.empower.business.policy.service.RebateAccountProductGroupDetailsVoService;
import com.bizunited.empower.business.policy.vo.RebateAccountProductGroupDetailsVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.service.ProductVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import com.bizunited.empower.business.product.vo.ProductUnitVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_RebateAccountProductGroupDetailsVoServiceImpl")
public class RebateAccountProductGroupDetailsVoServiceImpl
implements RebateAccountProductGroupDetailsVoService {
    @Autowired
    private RebateAccountProductDetailsRepository rebateAccountProductDetailsRepository;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private ProductVoService productVoService;

    @Override
    public Set<RebateAccountProductGroupDetailsVo> findByRebateAccountId(String rebateAccountId) {
        if (StringUtils.isBlank((CharSequence)rebateAccountId)) {
            return null;
        }
        Object[][] results = this.rebateAccountProductDetailsRepository.findByGroupRebateAccountId(rebateAccountId);
        if (results == null || results.length == 0) {
            return null;
        }
        LinkedHashSet productSpecificationCodes = Sets.newLinkedHashSet();
        LinkedHashSet unitCodes = Sets.newLinkedHashSet();
        LinkedHashSet rebateAccountProductGroupDetails = Sets.newLinkedHashSet();
        for (Object[] items : results) {
            String cRebateAccountId = items[0].toString();
            String productCode = items[1].toString();
            String productSpecificationCode = items[2].toString();
            String unitCode = items[3].toString();
            Integer availableNumber = items[4] == null ? 0 : (Integer)items[4];
            BigDecimal usedNumber = items[5] == null ? BigDecimal.ZERO : (BigDecimal)items[5];
            BigDecimal totalNumber = new BigDecimal(availableNumber).add(usedNumber);
            RebateAccountProductGroupDetailsVo rebateAccountProductGroupDetail = new RebateAccountProductGroupDetailsVo();
            rebateAccountProductGroupDetail.setRebateAccountId(cRebateAccountId);
            rebateAccountProductGroupDetail.setProductSpecificationCode(productSpecificationCode);
            productSpecificationCodes.add(productSpecificationCode);
            rebateAccountProductGroupDetail.setProductCode(productCode);
            rebateAccountProductGroupDetail.setUnitCode(unitCode);
            unitCodes.add(unitCode);
            rebateAccountProductGroupDetail.setAvailableNumber(availableNumber);
            rebateAccountProductGroupDetail.setUsedNumber(usedNumber.intValue());
            rebateAccountProductGroupDetail.setTotalNumber(totalNumber);
            rebateAccountProductGroupDetails.add(rebateAccountProductGroupDetail);
        }
        if (CollectionUtils.isEmpty((Collection)rebateAccountProductGroupDetails)) {
            return rebateAccountProductGroupDetails;
        }
        Map<String, RebateAccountProductGroupDetailsVo> rebateAccountProductGroupDetailMapping = rebateAccountProductGroupDetails.stream().collect(Collectors.toMap(RebateAccountProductGroupDetailsVo::getProductSpecificationCode, item -> item));
        ArrayList specificationCodes = Lists.newArrayList(rebateAccountProductGroupDetailMapping.keySet());
        List productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList((List)specificationCodes);
        if (CollectionUtils.isEmpty((Collection)productSpecifications)) {
            return null;
        }
        for (ProductSpecificationVo productSpecification : productSpecifications) {
            String productSpecificationCode = productSpecification.getProductSpecificationCode();
            RebateAccountProductGroupDetailsVo rebateAccountProductGroupDetailItem = rebateAccountProductGroupDetailMapping.get(productSpecificationCode);
            if (rebateAccountProductGroupDetailItem == null) continue;
            rebateAccountProductGroupDetailItem.setProductName(productSpecification.getProduct().getProductName());
            rebateAccountProductGroupDetailItem.setProductSpecificationName(productSpecification.getProductSpecificationName());
            rebateAccountProductGroupDetailItem.setMainImageName(productSpecification.getMainImageName());
            rebateAccountProductGroupDetailItem.setMainImagePath(productSpecification.getMainImagePath());
            ProductVo productVo = this.productVoService.findDetailsById(productSpecification.getProduct().getId());
            Set productUnitAndPrices = productVo.getProductUnitSpecificationAndPrices();
            if (CollectionUtils.isEmpty((Collection)productUnitAndPrices)) continue;
            String unitCode = rebateAccountProductGroupDetailItem.getUnitCode();
            for (ProductUnitSpecificationAndPriceVo productUnitAndPriceVo : productUnitAndPrices) {
                ProductUnitVo productUnit = productUnitAndPriceVo.getProductUnit();
                if (productUnit == null || !StringUtils.equals((CharSequence)productUnit.getUnitCode(), (CharSequence)unitCode)) continue;
                rebateAccountProductGroupDetailItem.setUnitName(productUnit == null ? "" : productUnit.getUnitName());
            }
        }
        return rebateAccountProductGroupDetails;
    }
}

