/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.repository.RebateAccountRepository;
import com.bizunited.empower.business.policy.service.RebateAccountCommonDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RebateAccountServiceImpl")
public class RebateAccountServiceImpl
implements RebateAccountService {
    @Autowired
    private CustomerService customerService;
    @Autowired
    private RebateAccountCommonDetailsService rebateAccountCommonDetailsService;
    @Autowired
    private RebateAccountRepository rebateAccountRepository;

    @Override
    @Transactional
    public void create(List<RebateAccount> rebateAccounts) {
        Validate.isTrue((!CollectionUtils.isEmpty(rebateAccounts) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5ba2\u6237\u8d26\u6237\u521b\u5efa\u65f6\uff0c\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\u5ba2\u6237\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        for (RebateAccount rebateAccount : rebateAccounts) {
            this.create(rebateAccount);
        }
    }

    private RebateAccount create(RebateAccount rebateAccount) {
        RebateAccount current = this.createForm(rebateAccount);
        return current;
    }

    private RebateAccount createForm(RebateAccount rebateAccount) {
        Date now = new Date();
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = SecurityUtils.getUserAccount();
        rebateAccount.setId(null);
        rebateAccount.setCreateAccount(currentAccount);
        rebateAccount.setCreateTime(now);
        rebateAccount.setModifyAccount(currentAccount);
        rebateAccount.setModifyTime(now);
        rebateAccount.setTenantCode(tenantCode);
        rebateAccount.setRebateAccountStatus(1);
        this.createValidation(rebateAccount);
        this.rebateAccountRepository.saveAndFlush((Object)rebateAccount);
        this.rebateAccountCommonDetailsService.init(rebateAccount, rebateAccount.getCustomerCode());
        return rebateAccount;
    }

    private void createValidation(RebateAccount rebateAccount) {
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)rebateAccount.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        rebateAccount.setId(null);
        String customerCode = rebateAccount.getCustomerCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Customer cCustomer = this.customerService.findByTenantCodeAndCustomerCode(tenantCode, customerCode);
        Validate.notNull((Object)cCustomer, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u672a\u627e\u5230\u7ecf\u9500\u5546\u4e0b\u6307\u5b9a\u7684\u5ba2\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RebateAccount exsitRebateAccount = this.rebateAccountRepository.findByTenantCodeAndCustomerCode(tenantCode, customerCode);
        Validate.isTrue((exsitRebateAccount == null ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u5ba2\u6237\u5df2\u521b\u5efa\u8fd4\u5229\u8d26\u6237\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa!!", (Object[])new Object[0]);
        Validate.notNull((Object)rebateAccount.getRebateAccountStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8fd4\u5229\u8d26\u6237\u5de5\u4f5c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((rebateAccount.getCustomerCode() == null || rebateAccount.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void invalid(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4f5c\u5e9f\u8fd4\u5229\u8d26\u6237\u65f6\uff0c\u8fd4\u5229\u8d26\u6237\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        RebateAccount currentRebateAccount = this.rebateAccountRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentRebateAccount), (String)"\u4f5c\u5e9f\u8fd4\u5229\u8d26\u6237\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentRebateAccount.setRebateAccountStatus(0);
        this.rebateAccountRepository.save((Object)currentRebateAccount);
    }

    @Override
    @Transactional
    public void effective(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u542f\u7528\u8fd4\u5229\u8d26\u6237\u65f6\uff0c\u8fd4\u5229\u8d26\u6237\u6280\u672f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        RebateAccount currentRebateAccount = this.rebateAccountRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentRebateAccount), (String)"\u542f\u7528\u8fd4\u5229\u8d26\u6237\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentRebateAccount.setRebateAccountStatus(1);
        this.rebateAccountRepository.save((Object)currentRebateAccount);
    }

    @Override
    public RebateAccount findByTenantCodeAndCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.rebateAccountRepository.findByTenantCodeAndCustomerCode(tenantCode, customerCode);
    }
}

