/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.service.RebateAccountService;
import com.bizunited.empower.business.policy.service.RebatePolicyExecuteService;
import com.bizunited.empower.business.policy.service.RebatePolicyVoService;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyExecuteContext;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyStrategy;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillCon;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProduct;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProductResult;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConResult;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.empower.business.product.dto.ProductSpecificationAndUnitDto;
import com.bizunited.empower.business.product.service.ProductActionService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RebatePolicyExecuteServiceImpl")
public class RebatePolicyExecuteServiceImpl
implements RebatePolicyExecuteService {
    @Autowired
    private RebatePolicyVoService rebatePolicyVoService;
    @Autowired
    private RebateAccountService rebateAccountService;
    @Autowired(required=false)
    private List<RebatePolicyStrategy> rebatePolicyStrategys;
    @Autowired
    private ProductActionService productActionService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public RebatePolicyExecuteContext preExecutePolicy(BillCon bill, String tenantCode) {
        this.validateBillCon(bill, tenantCode);
        String customerCode = bill.getCustomerCode();
        return this.preExecute(bill, tenantCode, customerCode, true);
    }

    private RebatePolicyExecuteContext preExecute(BillCon bill, String tenantCode, String customerCode, boolean streamlining) {
        Set<RebatePolicyVo> initRebatePolicys = this.rebatePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, false, customerCode);
        if (CollectionUtils.isEmpty(initRebatePolicys)) {
            return null;
        }
        RebatePolicyExecuteContext rebatePolicyExecuteContext = new RebatePolicyExecuteContext(initRebatePolicys, bill, tenantCode, customerCode, this.nebulaToolkitService);
        LinkedHashMap matchedPolicyMapping = Maps.newLinkedHashMap();
        LinkedHashMap matchedRebatePolicyStrategy = Maps.newLinkedHashMap();
        Map<String, BillConProduct> realRemainingPolicyProducts = bill.getProducts().stream().collect(Collectors.toMap(BillConProduct::getProductSpecificationCode, item -> item));
        for (RebatePolicyVo rebatePolicy : initRebatePolicys) {
            for (RebatePolicyStrategy rebatePolicyStrategy : this.rebatePolicyStrategys) {
                if (!rebatePolicyStrategy.policyMatched(rebatePolicy)) continue;
                matchedRebatePolicyStrategy.put(rebatePolicy.getRebatePolicyCode(), rebatePolicyStrategy);
                try {
                    List<BillConProduct> billConProducts = rebatePolicyStrategy.preExecute(bill, rebatePolicy);
                    if (CollectionUtils.isEmpty(billConProducts)) continue;
                    billConProducts.stream().forEach(item -> realRemainingPolicyProducts.remove(item.getProductSpecificationCode()));
                    rebatePolicyExecuteContext.addMatchedPolicyProducts(rebatePolicy.getRebatePolicyCode(), billConProducts);
                    matchedPolicyMapping.put(rebatePolicy.getRebatePolicyCode(), rebatePolicy);
                }
                catch (RuntimeException e) {
                    rebatePolicyExecuteContext.addExcludedPolicy(rebatePolicy, e.getMessage());
                }
            }
        }
        rebatePolicyExecuteContext.setExcludedPolicyProducts(Lists.newArrayList(realRemainingPolicyProducts.values()));
        rebatePolicyExecuteContext.setMatchedPolicyMapping(matchedPolicyMapping);
        if (streamlining) {
            rebatePolicyExecuteContext.streamlining();
        }
        return rebatePolicyExecuteContext;
    }

    private void validateBillCon(BillCon bill, String tenantCode) {
        String onEvent = "\u8fdb\u884c\u8fd4\u5229\u653f\u7b56\u8ba1\u7b97\u65f6";
        Validate.notBlank((CharSequence)tenantCode, (String)(onEvent + "\uff0c\u7ecf\u9500\u5546\u7f16\u53f7\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        String customerCode = bill.getCustomerCode();
        RebateAccount rebateAccount = this.rebateAccountService.findByTenantCodeAndCustomerCode(customerCode);
        Validate.notNull((Object)((Object)rebateAccount), (String)(onEvent + "\uff0c\u672a\u627e\u5230\u6307\u5b9a\u5ba2\u6237\u7684\u8fd4\u5229\u8d26\u6237\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)(onEvent + "\uff0c\u5ba2\u6237\u7f16\u53f7\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        Validate.notNull((Object)bill, (String)(onEvent + "\uff0c\u5355\u636e\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        List<BillConProduct> billConProducts = bill.getProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(billConProducts) ? 1 : 0) != 0, (String)(onEvent + "\uff0c\u5355\u636e\u672c\u54c1\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        for (BillConProduct billConProduct : billConProducts) {
            String productSpecificationCode = billConProduct.getProductSpecificationCode();
            Validate.notBlank((CharSequence)productSpecificationCode, (String)(onEvent + "\uff0c\u5546\u54c1\u89c4\u683c\u7f16\u53f7\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
            String brandCode = billConProduct.getBrandCode();
            Validate.notBlank((CharSequence)brandCode, (String)(onEvent + "\uff0c\u5546\u54c1\u54c1\u724c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
            String unitCode = billConProduct.getUnitCode();
            Validate.notBlank((CharSequence)unitCode, (String)(onEvent + "\uff0c\u5546\u54c1\u5355\u4f4d\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
            BigDecimal quantity = billConProduct.getQuantity();
            Validate.notNull((Object)quantity, (String)(onEvent + "\uff0c\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
            BigDecimal subtotalAmount = billConProduct.getSubtotalAmount();
            Validate.notNull((Object)subtotalAmount, (String)(onEvent + "\uff0c\u5546\u54c1\u5c0f\u8ba1\u91d1\u989d\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
            Validate.isTrue((subtotalAmount.floatValue() >= 0.0f ? 1 : 0) != 0, (String)(onEvent + "\uff0c\u5546\u54c1\u5c0f\u8ba1\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0"), (Object[])new Object[0]);
        }
        long mappingCount = billConProducts.stream().collect(Collectors.groupingBy(BillConProduct::getProductSpecificationCode)).values().stream().filter(item -> item.size() > 1).count();
        Validate.isTrue((mappingCount == 0L ? 1 : 0) != 0, (String)(onEvent + "\uff0c\u4e0d\u80fd\u4f20\u5165\u76f8\u540c\u5546\u54c1\u89c4\u683c\u7f16\u7801\u7684\u91cd\u590d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RebatePolicyExecuteContext executePolicy(BillCon bill, String tenantCode) {
        this.validateBillCon(bill, tenantCode);
        String customerCode = bill.getCustomerCode();
        List<BillConResult> billConResults = bill.getBillResults();
        if (CollectionUtils.isEmpty(billConResults)) {
            return null;
        }
        String billCode = bill.getCode();
        Validate.notBlank((CharSequence)billCode, (String)"\u8fdb\u884c\u5355\u636e\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u672a\u627e\u5230\u5355\u636e\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        BigDecimal billTotalAmount = bill.getTotalAmount();
        Validate.notNull((Object)billTotalAmount, (String)"\u8fdb\u884c\u5355\u636e\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u672a\u4f20\u5165\u5355\u636e\u603b\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((billTotalAmount.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5355\u636e\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u4f20\u5165\u7684\u5355\u636e\u603b\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<RebatePolicyVo> processingRebatePolicys = this.rebatePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, true, customerCode);
        Validate.isTrue((!CollectionUtils.isEmpty(processingRebatePolicys) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5355\u636e\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u672a\u627e\u5230\u5f53\u524d\u5ba2\u6237\u4efb\u4f55\u6b63\u5728\u6267\u884c\u7684\u8fd4\u5229\u653f\u7b56\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5355\u636e!", (Object[])new Object[0]);
        Map<String, RebatePolicyVo> processingRebatePolicyMapping = processingRebatePolicys.stream().collect(Collectors.toMap(RebatePolicyVo::getRebatePolicyCode, item -> item));
        this.validateBillConResult(billConResults, processingRebatePolicyMapping);
        RebatePolicyExecuteContext executeContext = this.preExecute(bill, tenantCode, customerCode, false);
        Validate.notNull((Object)executeContext, (String)"\u8fd4\u5229\u653f\u7b56\u5df2\u5168\u90e8\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5355\u636e!", (Object[])new Object[0]);
        BigDecimal resultDiscountAmount = BigDecimal.ZERO;
        LinkedHashSet resultProducts = Sets.newLinkedHashSet();
        List<BillConResult> billResults = bill.getBillResults();
        if (CollectionUtils.isEmpty(billResults)) {
            return executeContext;
        }
        Map<String, RebatePolicyVo> matchedPolicyMapping = executeContext.getMatchedPolicyMapping();
        Map<String, List<BillConProduct>> matchedPolicyProductsMapping = executeContext.getMatchedPolicyProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(matchedPolicyMapping) || !CollectionUtils.isEmpty(matchedPolicyProductsMapping) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5355\u636e\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55\u5df2\u5339\u914d\u7684\u8fd4\u5229\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (BillConResult billConResult : billResults) {
            List<BillConProductResult> productResutls;
            String billResultRebatePolicyCode = billConResult.getRebatePolicyCode();
            RebatePolicyVo matchedRebatePolicy = matchedPolicyMapping.get(billResultRebatePolicyCode);
            Validate.notNull((Object)((Object)matchedRebatePolicy), (String)"\u8fdb\u884c\u5355\u636e\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u672a\u53d1\u73b0\u8bbe\u5b9a\u7684\u8fd4\u5229\u7f16\u53f7[%s]\u6709\u5bf9\u5e94\u5339\u914d\u7684\u8fd4\u5229\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{billResultRebatePolicyCode});
            for (RebatePolicyStrategy rebatePolicyStrategy : this.rebatePolicyStrategys) {
                if (!rebatePolicyStrategy.policyMatched(matchedRebatePolicy)) continue;
                rebatePolicyStrategy.execute(executeContext, bill, billConResult, matchedRebatePolicy);
            }
            if (matchedRebatePolicy.getRebatePolicyType() == 1 || matchedRebatePolicy.getRebatePolicyType() == 2) {
                resultDiscountAmount = resultDiscountAmount.add(billConResult.getDiscountAmount());
                continue;
            }
            if (matchedRebatePolicy.getRebatePolicyType() != 3 || CollectionUtils.isEmpty(productResutls = billConResult.getProductResutls())) continue;
            resultProducts.addAll(productResutls);
        }
        executeContext.setResultDiscountAmount(resultDiscountAmount);
        executeContext.setResultProducts(resultProducts);
        executeContext.streamlining();
        return executeContext;
    }

    private void validateBillConResult(List<BillConResult> billConResults, Map<String, RebatePolicyVo> processingRebatePolicyMapping) {
        for (BillConResult billConResultItem : billConResults) {
            String rebatePolicyCode = billConResultItem.getRebatePolicyCode();
            Validate.notBlank((CharSequence)rebatePolicyCode, (String)"\u8fdb\u884c\u5355\u636e\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            RebatePolicyVo cRebatePolicy = processingRebatePolicyMapping.get(rebatePolicyCode);
            Validate.notNull((Object)((Object)cRebatePolicy), (String)"\u8fd4\u5229\u653f\u7b56[%s]\u5df2\u8fc7\u671f\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5355\u636e!!", (Object[])new Object[]{rebatePolicyCode});
            Integer rebatePolicyType = cRebatePolicy.getRebatePolicyType();
            if (rebatePolicyType == 1 || rebatePolicyType == 2) {
                BigDecimal discountAmount = billConResultItem.getDiscountAmount();
                Validate.isTrue((discountAmount != null && discountAmount.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u8fd4\u5229\u91d1\u989d\u5fc5\u987b\u586b\u5199\u5927\u4e8e0\u7684\u503c!", (Object[])new Object[0]);
                continue;
            }
            if (rebatePolicyType != 3) continue;
            List<BillConProductResult> billConProducts = billConResultItem.getProductResutls();
            Validate.isTrue((!CollectionUtils.isEmpty(billConProducts) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u5b9e\u7269\u8fd4\u5229\u6570\u91cf\u5fc5\u987b\u586b\u5199\u5927\u4e8e0\u7684\u503c\uff01", (Object[])new Object[0]);
            ArrayList pairList = Lists.newArrayList();
            for (BillConProductResult billConProduct : billConProducts) {
                String poroductSpecificationCode = billConProduct.getProductSpecificationCode();
                Validate.notBlank((CharSequence)poroductSpecificationCode, (String)"\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u5b9e\u7269\u8fd4\u5229\u4fe1\u606f\u4e2d\u81f3\u5c11\u4e00\u9879\u7269\u8d44\u6ca1\u6709\u586b\u5199\u5546\u54c1\u89c4\u683c\u7f16\u53f7!", (Object[])new Object[0]);
                BigDecimal quantity = billConProduct.getQuantity();
                Validate.notNull((Object)quantity, (String)"\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u5b9e\u7269\u8fd4\u5229\u4fe1\u606f\u4e2d\u81f3\u5c11\u4e00\u9879\u7269\u8d44\u6ca1\u6709\u586b\u5199\u8fd4\u5229\u6570\u91cf!", (Object[])new Object[0]);
                Validate.isTrue((quantity.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u5b9e\u7269\u8fd4\u5229\u4fe1\u606f\u4e2d\u81f3\u5c11\u4e00\u9879\u7269\u8d44\u586b\u5199\u7684\u6570\u91cf\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u5927\u4e8e0!\uff09", (Object[])new Object[0]);
                String unitCode = billConProduct.getUnitCode();
                Validate.notBlank((CharSequence)unitCode, (String)"\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u5b9e\u7269\u8fd4\u5229\u4fe1\u606f\u4e2d\u81f3\u5c11\u4e00\u9879\u7269\u8d44\u5355\u4f4d\u4fe1\u606f\u6ca1\u6709\u4f20\u5165!", (Object[])new Object[0]);
                Pair pair = Pair.of((Object)poroductSpecificationCode, (Object)unitCode);
                pairList.add(pair);
            }
            ProductSpecificationAndUnitDto productSpecificationAndUnit = this.productActionService.findSpecNameAndUnitName((List)pairList);
            Validate.notNull((Object)productSpecificationAndUnit, (String)"\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u5b9e\u7269\u8fd4\u5229\u4fe1\u606f\u4e2d\u6ca1\u6709\u4efb\u4f55\u6b63\u786e\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)productSpecificationAndUnit.getHasContent(), (String)"\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u5b9e\u7269\u8fd4\u5229\u4fe1\u606f\u4e2d\u6ca1\u6709\u4efb\u4f55\u6b63\u786e\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f!!", (Object[])new Object[0]);
        }
    }
}

