/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.policy.entity.SalePolicyResult;
import com.bizunited.empower.business.policy.entity.SalePolicyResultGift;
import com.bizunited.empower.business.policy.repository.SalePolicyResultGiftRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyResultRepository;
import com.bizunited.empower.business.policy.service.SalePolicyResultService;
import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConMatched;
import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConProduct;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.ExeInfo;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.GiftInfo;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeInfo;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeInfoForCompose;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeInfoForComposeResult;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.PolicyExeResult;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyResultServiceImpl
implements SalePolicyResultService {
    @Autowired
    private SalePolicyResultRepository salePolicyResultRepository;
    @Autowired
    private SalePolicyResultGiftRepository salePolicyResultGiftRepository;

    @Override
    @Transactional
    public SalePolicyResult create(PolicyConMatched policyConMatchedItem, String customerCode, String relevanceCode, boolean compose) {
        String tenantCode = TenantUtils.getTenantCode();
        String account = SecurityUtils.getUserAccount();
        Validate.notBlank((CharSequence)account, (String)"\u9519\u8bef\u7684\u64cd\u4f5c\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Date now = new Date();
        String salePolicyCode = policyConMatchedItem.getSalePolicyCode();
        BigDecimal subtotalDiscountAmount = policyConMatchedItem.getSubtotalDiscountAmount();
        BigDecimal subtotalEnjoyAmount = policyConMatchedItem.getSubtotalEnjoyAmount();
        BigDecimal subtotalEnjoyNumber = policyConMatchedItem.getSubtotalEnjoyNumber();
        BigDecimal subtotalGiftAmount = policyConMatchedItem.getSubtotalGiftAmount();
        Integer subtotalGiftNumber = policyConMatchedItem.getSubtotalGiftNumber();
        BigDecimal subtotalProductAmount = policyConMatchedItem.getSubtotalProductAmount();
        SalePolicyResult salePolicyResult = new SalePolicyResult();
        salePolicyResult.setCustomerCode(customerCode);
        salePolicyResult.setTenantCode(tenantCode);
        salePolicyResult.setRelevanceCode(relevanceCode);
        salePolicyResult.setSalePolicyCode(salePolicyCode);
        salePolicyResult.setSubtotalEnjoyAmount(subtotalEnjoyAmount);
        salePolicyResult.setSubtotalEnjoyNumber(subtotalEnjoyNumber);
        salePolicyResult.setSubtotalDiscountAmount(subtotalDiscountAmount);
        salePolicyResult.setGiftNumber(subtotalGiftNumber);
        salePolicyResult.setGiftValue(subtotalGiftAmount);
        salePolicyResult.setCreateAccount(account);
        salePolicyResult.setCreateTime(now);
        salePolicyResult.setModifyAccount(account);
        salePolicyResult.setModifyTime(now);
        salePolicyResult.setState(1);
        salePolicyResult.setSubtotalProductAmount(subtotalProductAmount);
        this.salePolicyResultRepository.save((Object)salePolicyResult);
        if (!compose) {
            Map<String, ExeInfo> exeInfoMapping = policyConMatchedItem.getExeInfo();
            List<PolicyConProduct> policyConProducts = policyConMatchedItem.getMatchedPolicyProducts();
            for (PolicyConProduct policyConProductItem : policyConProducts) {
                PolicyExeInfo policyExeInfo;
                List<PolicyExeResult> policyExeResults;
                PolicyExeResult policyExeResult;
                List<GiftInfo> giftInfos;
                String productCode = policyConProductItem.getProductSpecificationCode();
                ExeInfo exeInfo = exeInfoMapping.get(productCode);
                if (exeInfo != null && !CollectionUtils.isEmpty(giftInfos = (policyExeResult = (policyExeResults = (policyExeInfo = (PolicyExeInfo)exeInfo).getPolicyExeResults()).get(policyExeResults.size() - 1)).getLastGifts())) continue;
            }
        } else {
            Map<String, ExeInfo> exeInfoMapping = policyConMatchedItem.getExeInfo();
            Collection<ExeInfo> exeInfos = exeInfoMapping.values();
            if (CollectionUtils.isEmpty(exeInfos)) {
                return salePolicyResult;
            }
            for (ExeInfo exeInfoItem : exeInfos) {
                PolicyExeInfoForCompose policyExeInfoForCompose = (PolicyExeInfoForCompose)exeInfoItem;
                List<PolicyExeInfoForComposeResult> policyExeInfoForComposeResults = policyExeInfoForCompose.getPolicyExeResults();
                PolicyExeInfoForComposeResult policyExeInfoForComposeResult = policyExeInfoForComposeResults.get(policyExeInfoForComposeResults.size() - 1);
                List<GiftInfo> lastGifts = policyExeInfoForComposeResult.getLastGifts();
                if (CollectionUtils.isEmpty(lastGifts)) continue;
                this.saveSalePolicyResultGift(lastGifts, salePolicyResult);
            }
        }
        return salePolicyResult;
    }

    private void saveSalePolicyResultGift(List<GiftInfo> giftInfos, SalePolicyResult salePolicyResult) {
        for (GiftInfo giftInfo : giftInfos) {
            String giftSpecificationCode = giftInfo.getSpecificationCode();
            String giftSpecificationName = giftInfo.getSpecificationName();
            String unitCode = giftInfo.getUnitCode();
            String unitName = giftInfo.getUnitName();
            Integer quantity = giftInfo.getQuantity();
            BigDecimal unitPrice = giftInfo.getUnitPrice();
            BigDecimal subtotalAmount = giftInfo.getSubtotalAmount();
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{giftSpecificationCode, giftSpecificationName, unitCode, unitName}) || quantity == null || unitPrice == null || subtotalAmount == null) continue;
            SalePolicyResultGift salePolicyResultGift = new SalePolicyResultGift();
            salePolicyResultGift.setSpecificationCode(giftSpecificationCode);
            salePolicyResultGift.setSpecificationName(giftSpecificationName);
            salePolicyResultGift.setQuantity(quantity);
            salePolicyResultGift.setSubtotalAmount(subtotalAmount);
            salePolicyResultGift.setUnitCode(unitCode);
            salePolicyResultGift.setUnitName(unitName);
            salePolicyResultGift.setUnitPrice(unitPrice);
            salePolicyResultGift.setSalePolicyResult(salePolicyResult);
            this.salePolicyResultGiftRepository.save((Object)salePolicyResultGift);
        }
    }

    @Override
    @Transactional
    public void disableByRelevanceCode(String relevanceCode) {
        Validate.notBlank((CharSequence)relevanceCode, (String)"\u9519\u8bef\u7684\u5916\u90e8\u5355\u636e\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.salePolicyResultRepository.disableByRelevanceCode(relevanceCode);
    }

    @Override
    @Transactional
    public void updateRelevanceCode(String sourceRelevanceCode, String targetRelevanceCode) {
        Validate.notBlank((CharSequence)sourceRelevanceCode, (String)"sourceRelevanceCode is blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)targetRelevanceCode, (String)"targetRelevanceCode is blank", (Object[])new Object[0]);
        this.salePolicyResultRepository.flush();
        this.salePolicyResultRepository.updateRelevanceCode(sourceRelevanceCode, targetRelevanceCode);
    }

    @Override
    public long countBySalePolicyCode(String salePolicyCode) {
        if (StringUtils.isBlank((CharSequence)salePolicyCode)) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.salePolicyResultRepository.countByTenantCodeAndSalePolicyCode(tenantCode, salePolicyCode);
    }

    @Override
    public BigDecimal sumProductAmountBySalePolicyCode(String salePolicyCode) {
        if (StringUtils.isBlank((CharSequence)salePolicyCode)) {
            return BigDecimal.ZERO;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.salePolicyResultRepository.sumProductAmountByTenantCodeAndSalePolicyCode(tenantCode, salePolicyCode);
    }

    @Override
    public BigDecimal sumCostBySalePolicyCode(String salePolicyCode) {
        if (StringUtils.isBlank((CharSequence)salePolicyCode)) {
            return BigDecimal.ZERO;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.salePolicyResultRepository.sumCostByTenantCodeAndSalePolicyCode(tenantCode, salePolicyCode);
    }
}

