/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.rebatepolicy.strategy;

import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountBrandDetails;
import com.bizunited.empower.business.policy.service.RebateAccountBrandDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountService;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyExecuteContext;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyStrategy;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillCon;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProduct;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConResult;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.empower.business.product.entity.ProductBrand;
import com.bizunited.empower.business.product.service.ProductBrandService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="BrandRebatePolicyStrategy")
public class BrandRebatePolicyStrategy
implements RebatePolicyStrategy {
    @Autowired
    private ProductBrandService productBrandService;
    @Autowired
    private RebateAccountService rebateAccountService;
    @Autowired
    private RebateAccountBrandDetailsService rebateAccountBrandDetailsService;

    @Override
    public boolean policyMatched(RebatePolicyVo rebatePolicy) {
        return rebatePolicy.getRebatePolicyType() == 2;
    }

    @Override
    public List<BillConProduct> preExecute(BillCon bill, RebatePolicyVo rebatePolicy) {
        String classifications = rebatePolicy.getClassifications();
        Validate.notBlank((CharSequence)classifications, (String)"\u8fd4\u5229\u653f\u7b56\u914d\u7f6e\u51fa\u73b0\u95ee\u9898", (Object[])new Object[0]);
        Object[] brandCodes = classifications.split(",");
        List productBrands = this.productBrandService.findByCodeList((List)Lists.newArrayList((Object[])brandCodes));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)productBrands) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u914d\u7f6e\u51fa\u73b0\u95ee\u9898", (Object[])new Object[0]);
        List<BillConProduct> billConProducts = bill.getProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(billConProducts) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u914d\u7f6e\u51fa\u73b0\u95ee\u9898", (Object[])new Object[0]);
        Map<String, List<BillConProduct>> billConProductMapping = billConProducts.stream().collect(Collectors.groupingBy(BillConProduct::getBrandCode));
        BigDecimal subTotalAmount = BigDecimal.ZERO;
        for (ProductBrand productBrandItem : productBrands) {
            List<BillConProduct> billConProductItems = billConProductMapping.get(productBrandItem.getBrandCode());
            if (CollectionUtils.isEmpty(billConProductItems)) continue;
            for (BillConProduct billConProduct : billConProductItems) {
                BigDecimal subtotalAmount = billConProduct.getSubtotalAmount();
                subTotalAmount = subTotalAmount.add(subtotalAmount);
            }
            if (!(rebatePolicy.getThresholdAmount().floatValue() <= subTotalAmount.floatValue())) continue;
            return billConProductItems;
        }
        throw new IllegalArgumentException("\u54c1\u724c\u5546\u54c1\u603b\u91d1\u989d\u672a\u8fbe\u5230\u8fd4\u5229\u95e8\u69db");
    }

    @Override
    public void execute(RebatePolicyExecuteContext executeContext, BillCon bill, BillConResult billConResult, RebatePolicyVo rebatePolicy) {
        String classifications = rebatePolicy.getClassifications();
        Object[] brandCodes = classifications.split(",");
        List productBrands = this.productBrandService.findByCodeList((List)Lists.newArrayList((Object[])brandCodes));
        String billCode = bill.getCode();
        String customerCode = bill.getCustomerCode();
        RebateAccount rebateAccount = this.rebateAccountService.findByTenantCodeAndCustomerCode(customerCode);
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u672a\u627e\u5230\u6307\u5b9a\u5ba2\u6237\u7684\u8fd4\u5229\u8d26\u6237\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String rebatePolicyName = rebatePolicy.getRebatePolicyName();
        String rebatePolicyCode = rebatePolicy.getRebatePolicyCode();
        BigDecimal discountAmount = billConResult.getDiscountAmount();
        Validate.isTrue((discountAmount != null && discountAmount.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u5355\u636e\u672a\u6b63\u786e\u8bbe\u5b9a\u54c1\u724c\u8fd4\u5229\u7684\u62b5\u6263\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        discountAmount = discountAmount.setScale(4, RoundingMode.UP);
        billConResult.setDiscountAmount(discountAmount);
        Map<String, List<BillConProduct>> matchedPolicyProducts = executeContext.getMatchedPolicyProducts();
        List<BillConProduct> billConProducts = matchedPolicyProducts.get(rebatePolicyCode);
        Validate.isTrue((!CollectionUtils.isEmpty(billConProducts) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8fd4\u5229\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (BillConProduct billConProduct : billConProducts) {
            BigDecimal subtotalAmount = billConProduct.getSubtotalAmount() == null ? BigDecimal.ZERO : billConProduct.getSubtotalAmount();
            totalAmount = totalAmount.add(subtotalAmount);
        }
        BigDecimal thresholdAmount = rebatePolicy.getThresholdAmount();
        Validate.isTrue((totalAmount.floatValue() >= thresholdAmount.floatValue() ? 1 : 0) != 0, (String)"\u54c1\u724c\u4e0b\u672c\u54c1\u603b\u91d1\u989d[%s]\u4e0d\u6ee1\u8db3\u8fd4\u5229\u653f\u7b56[%s]\u89c4\u5b9a\u7684\u54c1\u724c\u6700\u5c0f\u603b\u91d1\u989d\u8981\u6c42\uff0c\u4e0d\u80fd\u8fdb\u884c\u8fd4\u5229\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{Float.valueOf(totalAmount.floatValue()), rebatePolicyName});
        BigDecimal maxTotalAmountRatio = rebatePolicy.getMaxTotalAmountRatio();
        BigDecimal maxAmount = totalAmount.multiply(maxTotalAmountRatio).setScale(4, RoundingMode.UP);
        BigDecimal minAmount = rebatePolicy.getMinAmountRebate();
        Validate.isTrue((discountAmount.floatValue() <= maxAmount.floatValue() ? 1 : 0) != 0, (String)"\u5355\u636e\u62b5\u6263\u54c1\u724c\u91d1\u989d[%s]\uff0c\u5df2\u7ecf\u8d85\u51fa\u8fd4\u5229\u653f\u7b56[%s]\u89c4\u5b9a\u7684\u5355\u7b14\u5355\u636e\u4e2d\u54c1\u724c\u6700\u5927\u53ef\u62b5\u6263\u7684\u91d1\u989d[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{Float.valueOf(discountAmount.floatValue()), rebatePolicyName, Float.valueOf(maxAmount.floatValue())});
        Validate.isTrue((discountAmount.floatValue() >= minAmount.floatValue() ? 1 : 0) != 0, (String)"\u5355\u636e\u62b5\u6263\u54c1\u724c\u91d1\u989d[%s]\uff0c\u5df2\u7ecf\u4f4e\u4e8e\u8fd4\u5229\u653f\u7b56[%s]\u89c4\u5b9a\u7684\u5355\u7b14\u5355\u636e\u4e2d\u54c1\u724c\u6700\u5c0f\u53ef\u62b5\u6263\u7684\u91d1\u989d[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{Float.valueOf(discountAmount.floatValue()), rebatePolicyName, Float.valueOf(minAmount.floatValue())});
        ProductBrand productBrand = (ProductBrand)productBrands.get(0);
        String brandCode = productBrand.getBrandCode();
        RebateAccountBrandDetails rebateAccountBrandDetail = new RebateAccountBrandDetails();
        rebateAccountBrandDetail.setBrandCode(brandCode);
        rebateAccountBrandDetail.setDetailAmount(discountAmount);
        rebateAccountBrandDetail.setDetailType(-1);
        rebateAccountBrandDetail.setRebateAccount(rebateAccount);
        rebateAccountBrandDetail.setRelevanceCode(billCode);
        rebateAccountBrandDetail.setRemark(String.format("\u5355\u636e[%s]\u54c1\u724c\u4e13\u7528\u8fd4\u5229\u8d44\u91d1\u62b5\u6263[%s]", billCode, Float.valueOf(discountAmount.floatValue())));
        this.rebateAccountBrandDetailsService.create(rebateAccountBrandDetail);
    }
}

