/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.salepolicy.context;

import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConProduct;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.ExeInfo;
import com.bizunited.empower.business.policy.vo.SalePolicyVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class PolicyConMatched {
    private String salePolicyCode;
    private List<PolicyConProduct> matchedPolicyProducts;
    private SalePolicyVo salePolicy;
    private Map<String, ExeInfo> exeInfo = Maps.newHashMap();
    private BigDecimal subtotalProductAmount;
    private BigDecimal subtotalDiscountAmount;
    private BigDecimal subtotalEnjoyAmount;
    private BigDecimal subtotalEnjoyNumber;
    private Integer subtotalGiftNumber;
    private BigDecimal subtotalGiftAmount;

    public PolicyConMatched(List<PolicyConProduct> matchedPolicyProducts, SalePolicyVo salePolicy) {
        this.matchedPolicyProducts = matchedPolicyProducts;
        Validate.isTrue((!CollectionUtils.isEmpty(matchedPolicyProducts) ? 1 : 0) != 0, (String)"matchedPolicyProducts not be empty!!", (Object[])new Object[0]);
        this.salePolicy = salePolicy;
        Validate.notNull((Object)((Object)this.salePolicy), (String)"salePolicy not be empty!!", (Object[])new Object[0]);
        this.salePolicyCode = salePolicy.getSalePolicyCode();
    }

    public List<PolicyConProduct> getMatchedPolicyProducts() {
        return this.matchedPolicyProducts;
    }

    public ExeInfo getExeInfo(String code) {
        return this.exeInfo.get(code);
    }

    public void addExeInfo(String code, ExeInfo exeInfo) {
        this.exeInfo.put(code, exeInfo);
    }

    public Map<String, ExeInfo> getExeInfo() {
        return this.exeInfo;
    }

    public SalePolicyVo getSalePolicy() {
        return this.salePolicy;
    }

    public String getSalePolicyCode() {
        return this.salePolicyCode;
    }

    public void setSalePolicy(SalePolicyVo salePolicy) {
        this.salePolicy = salePolicy;
    }

    public BigDecimal getSubtotalProductAmount() {
        return this.subtotalProductAmount;
    }

    public void setSubtotalProductAmount(BigDecimal subtotalProductAmount) {
        this.subtotalProductAmount = subtotalProductAmount;
    }

    public BigDecimal getSubtotalDiscountAmount() {
        return this.subtotalDiscountAmount;
    }

    public void setSubtotalDiscountAmount(BigDecimal subtotalDiscountAmount) {
        this.subtotalDiscountAmount = subtotalDiscountAmount;
    }

    public Integer getSubtotalGiftNumber() {
        return this.subtotalGiftNumber;
    }

    public void setSubtotalGiftNumber(Integer subtotalGiftNumber) {
        this.subtotalGiftNumber = subtotalGiftNumber;
    }

    public BigDecimal getSubtotalGiftAmount() {
        return this.subtotalGiftAmount;
    }

    public void setSubtotalGiftAmount(BigDecimal subtotalGiftAmount) {
        this.subtotalGiftAmount = subtotalGiftAmount;
    }

    public BigDecimal getSubtotalEnjoyAmount() {
        return this.subtotalEnjoyAmount;
    }

    public void setSubtotalEnjoyAmount(BigDecimal subtotalEnjoyAmount) {
        this.subtotalEnjoyAmount = subtotalEnjoyAmount;
    }

    public BigDecimal getSubtotalEnjoyNumber() {
        return this.subtotalEnjoyNumber;
    }

    public void setSubtotalEnjoyNumber(BigDecimal subtotalEnjoyNumber) {
        this.subtotalEnjoyNumber = subtotalEnjoyNumber;
    }
}

