/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.aspect;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.service.SalePolicyVoService;
import com.bizunited.empower.business.policy.vo.PolicyTypeVo;
import com.bizunited.empower.business.policy.vo.SalePolicyProductsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyVo;
import com.bizunited.empower.business.product.common.aspect.LabelPreferentialItems;
import com.bizunited.empower.business.product.vo.ProductPreferentialItemVo;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class PreferentialAspect {
    @Autowired
    private CustomerService customerService;
    @Autowired
    private SalePolicyVoService salePolicyVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Pointcut(value="@annotation(com.bizunited.empower.business.product.common.aspect.LabelPreferentialItems)")
    private void cutMethod() {
    }

    @Around(value="cutMethod()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        block25: {
            ProductSpecificationVo targetItem;
            Map productCodeMapping;
            Map<Object, Object> specificationCodeMapping;
            String customerCode;
            Customer customer;
            String tenantCode;
            block26: {
                block24: {
                    Principal principal;
                    String account;
                    result = joinPoint.proceed();
                    if (result == null) {
                        return result;
                    }
                    tenantCode = TenantUtils.getTenantCode();
                    if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, account = (principal = SecurityUtils.getPrincipal()).getName()})) {
                        return result;
                    }
                    if (account.equals("anonymousUser")) {
                        return result;
                    }
                    customer = null;
                    customerCode = null;
                    Integer appType = TenantUtils.getAppType();
                    switch (appType) {
                        case 2: 
                        case 4: {
                            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                            LabelPreferentialItems labelPreferentialItems = methodSignature.getMethod().getAnnotation(LabelPreferentialItems.class);
                            Method method = methodSignature.getMethod();
                            String el = labelPreferentialItems.value();
                            if (!StringUtils.isNotBlank((CharSequence)el)) break;
                            Object[] args = joinPoint.getArgs();
                            SpelExpressionParser parser = new SpelExpressionParser();
                            Expression elExp = parser.parseExpression(el);
                            StandardEvaluationContext context = new StandardEvaluationContext();
                            DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
                            String[] parameterNames = discoverer.getParameterNames(method);
                            int index = 0;
                            for (String parameterName : parameterNames) {
                                context.setVariable(parameterName, args[index]);
                                ++index;
                            }
                            customerCode = (String)elExp.getValue((EvaluationContext)context);
                            if (!StringUtils.isNotBlank((CharSequence)customerCode)) break;
                            customer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), customerCode);
                            break;
                        }
                        case 3: {
                            customer = this.customerService.findByTenantCodeAndCustomerCode(tenantCode, account);
                            if (customer == null) break;
                            customerCode = customer.getCustomerCode();
                            break;
                        }
                        default: {
                            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5e94\u7528\u7c7b\u578b");
                        }
                    }
                    if (customer == null) {
                        customer = this.customerService.findByPhoneAndTenantCode(account);
                    }
                    specificationCodeMapping = Maps.newHashMap();
                    productCodeMapping = Maps.newHashMap();
                    if (!(result instanceof ProductSpecificationVo)) break block24;
                    ProductSpecificationVo productSpecification = (ProductSpecificationVo)result;
                    String productSpecificationCode = productSpecification.getProductSpecificationCode();
                    specificationCodeMapping = this.specificationCodeMapping(Lists.newArrayList((Object[])new String[]{productSpecificationCode}), StringUtils.isNotBlank((CharSequence)customerCode), tenantCode, customerCode);
                    productSpecification.setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                    break block25;
                }
                if (!(result instanceof ProductVo)) break block26;
                ProductVo product = (ProductVo)result;
                String productCode = product.getProductCode();
                Set productSpecifications = product.getProductSpecifications();
                Set productUnitSpecificationAndPrices = product.getProductUnitSpecificationAndPrices();
                List<String> productSpecificationCodes = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                    productSpecificationCodes = productSpecifications.stream().map(ProductSpecificationVo::getProductSpecificationCode).collect(Collectors.toList());
                }
                Pair<Map<String, Set<ProductPreferentialItemVo>>, Map<String, Set<ProductPreferentialItemVo>>> resutlsMapping = this.productCodeMapping(Lists.newArrayList((Object[])new String[]{productCode}), productSpecificationCodes, tenantCode, customerCode);
                productCodeMapping = (Map)resutlsMapping.getLeft();
                specificationCodeMapping = (Map)resutlsMapping.getRight();
                product.setPreferentialItems((Set)productCodeMapping.get(productCode));
                if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                    for (ProductSpecificationVo productSpecification : productSpecifications) {
                        String productSpecificationCode = productSpecification.getProductSpecificationCode();
                        productSpecification.setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                    }
                }
                for (ProductUnitSpecificationAndPriceVo productUnitSpecificationAndPriceVo : productUnitSpecificationAndPrices) {
                    String productSpecificationCode = productUnitSpecificationAndPriceVo.getProductSpecification().getProductSpecificationCode();
                    productUnitSpecificationAndPriceVo.getProductSpecification().setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                }
                break block25;
            }
            if (!(result instanceof Iterable)) break block25;
            Iterable results = (Iterable)result;
            LinkedHashSet exsitsProductCodes = Sets.newLinkedHashSet();
            LinkedHashSet exsitsProductSpecificationCodes = Sets.newLinkedHashSet();
            boolean isProduct = false;
            for (Object resultItem : results) {
                if (resultItem instanceof ProductSpecificationVo) {
                    targetItem = (ProductSpecificationVo)resultItem;
                    String productSpecificationCode = targetItem.getProductSpecificationCode();
                    exsitsProductSpecificationCodes.add(productSpecificationCode);
                    isProduct = false;
                    continue;
                }
                if (!(resultItem instanceof ProductVo)) continue;
                targetItem = (ProductVo)resultItem;
                String productCode = targetItem.getProductCode();
                exsitsProductCodes.add(productCode);
                Set productSpecifications = targetItem.getProductSpecifications();
                if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                    productSpecifications.stream().forEach(item -> exsitsProductSpecificationCodes.add(item.getProductSpecificationCode()));
                }
                isProduct = true;
            }
            if (!isProduct) {
                specificationCodeMapping = this.specificationCodeMapping(Lists.newArrayList((Iterable)exsitsProductSpecificationCodes), customer != null, tenantCode, customerCode);
                if (CollectionUtils.isEmpty(specificationCodeMapping)) {
                    return result;
                }
            } else {
                Pair<Map<String, Set<ProductPreferentialItemVo>>, Map<String, Set<ProductPreferentialItemVo>>> resutlsMapping = this.productCodeMapping(Lists.newArrayList((Iterable)exsitsProductCodes), Lists.newArrayList((Iterable)exsitsProductSpecificationCodes), tenantCode, customerCode);
                productCodeMapping = (Map)resutlsMapping.getLeft();
                specificationCodeMapping = (Map)resutlsMapping.getRight();
                if (CollectionUtils.isEmpty((Map)productCodeMapping)) {
                    return result;
                }
            }
            for (Object resultItem : results) {
                if (resultItem instanceof ProductSpecificationVo) {
                    targetItem = (ProductSpecificationVo)resultItem;
                    targetItem.setPreferentialItems((Set)specificationCodeMapping.get(targetItem.getProductSpecificationCode()));
                    continue;
                }
                if (!(resultItem instanceof ProductVo)) continue;
                targetItem = (ProductVo)resultItem;
                targetItem.setPreferentialItems((Set)productCodeMapping.get(targetItem.getProductCode()));
                Set productSpecifications = targetItem.getProductSpecifications();
                for (ProductSpecificationVo productSpecification : productSpecifications) {
                    String productSpecificationCode = productSpecification.getProductSpecificationCode();
                    productSpecification.setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                }
                Set productUnitSpecificationAndPriceVos = targetItem.getProductUnitSpecificationAndPrices();
                for (ProductUnitSpecificationAndPriceVo productUnitSpecificationAndPriceVo : productUnitSpecificationAndPriceVos) {
                    String productSpecificationCode = productUnitSpecificationAndPriceVo.getProductSpecification().getProductSpecificationCode();
                    productUnitSpecificationAndPriceVo.getProductSpecification().setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                }
            }
        }
        return result;
    }

    private Pair<Map<String, Set<ProductPreferentialItemVo>>, Map<String, Set<ProductPreferentialItemVo>>> productCodeMapping(List<String> productCodes, List<String> productSpecificationCodes, String tenantCode, String customerCode) {
        Set<Object> salePolicies = Sets.newHashSet();
        ConcurrentMap productCodeMapping = Maps.newConcurrentMap();
        ConcurrentMap specificationCodeMapping = Maps.newConcurrentMap();
        salePolicies = StringUtils.isNotBlank((CharSequence)customerCode) ? this.salePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, true, customerCode) : this.salePolicyVoService.findDetailsByEffective(tenantCode, true);
        if (CollectionUtils.isEmpty((Collection)salePolicies)) {
            return Pair.of((Object)Maps.newLinkedHashMap(), (Object)Maps.newLinkedHashMap());
        }
        for (SalePolicyVo salePolicy : salePolicies) {
            Integer saleType;
            String tagName;
            Set<SalePolicyProductsVo> salePolicyProducts = salePolicy.getProducts();
            ProductPreferentialItemVo preferentialItem = new ProductPreferentialItemVo();
            PolicyTypeVo policyType = salePolicy.getPolicyType();
            if (policyType == null || StringUtils.isBlank((CharSequence)(tagName = this.getTagName(saleType = policyType.getSaleType())))) continue;
            preferentialItem.setTag(tagName);
            preferentialItem.setCode(salePolicy.getSalePolicyCode());
            preferentialItem.setName(salePolicy.getSalePolicyName());
            preferentialItem.setValidStartTime(salePolicy.getValidStartTime());
            preferentialItem.setValidEndTime(salePolicy.getValidEndTime());
            preferentialItem.setDescription(salePolicy.getDescription());
            preferentialItem.setLabel(salePolicy.getLabel());
            salePolicyProducts.stream().filter(item -> productCodes.contains(item.getProductCode())).forEach(item -> {
                String itemProductCode = item.getProductCode();
                Set preferentialItems = (Set)productCodeMapping.get(itemProductCode);
                if (!CollectionUtils.isEmpty((Collection)preferentialItems)) {
                    preferentialItems.add(preferentialItem);
                } else {
                    preferentialItems = Sets.newHashSet();
                    preferentialItems.add(preferentialItem);
                }
                productCodeMapping.put(itemProductCode, preferentialItems);
            });
            salePolicyProducts.stream().filter(item -> productSpecificationCodes.contains(item.getProductSpecificationCode())).forEach(item -> {
                String productSpecificationCode = item.getProductSpecificationCode();
                Set preferentialItems = (Set)specificationCodeMapping.get(productSpecificationCode);
                BigDecimal specificPrice = this.getSpecificPrice(salePolicy, item.getProductSpecificationCode(), item.getUnitCode());
                ProductPreferentialItemVo currentPreferentialItem = (ProductPreferentialItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)preferentialItem, ProductPreferentialItemVo.class, HashSet.class, ArrayList.class, new String[]{""});
                currentPreferentialItem.setSpecificPrice(specificPrice);
                if (!CollectionUtils.isEmpty((Collection)preferentialItems)) {
                    preferentialItems.add(currentPreferentialItem);
                } else {
                    preferentialItems = Sets.newHashSet();
                    preferentialItems.add(currentPreferentialItem);
                }
                specificationCodeMapping.put(productSpecificationCode, preferentialItems);
            });
        }
        return Pair.of((Object)productCodeMapping, (Object)specificationCodeMapping);
    }

    private Map<String, Set<ProductPreferentialItemVo>> specificationCodeMapping(List<String> productSpecificationCodes, boolean isCustomer, String tenantCode, String customerCode) {
        Set<Object> salePolicies = Sets.newHashSet();
        ConcurrentMap specificationCodeMapping = Maps.newConcurrentMap();
        salePolicies = isCustomer ? this.salePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, true, customerCode) : this.salePolicyVoService.findDetailsByEffective(tenantCode, true);
        if (CollectionUtils.isEmpty((Collection)salePolicies)) {
            return Maps.newHashMap();
        }
        for (SalePolicyVo salePolicy : salePolicies) {
            Integer saleType;
            String tagName;
            Set<SalePolicyProductsVo> salePolicyProducts = salePolicy.getProducts();
            ProductPreferentialItemVo preferentialItem = new ProductPreferentialItemVo();
            PolicyTypeVo policyType = salePolicy.getPolicyType();
            if (policyType == null || StringUtils.isBlank((CharSequence)(tagName = this.getTagName(saleType = policyType.getSaleType())))) continue;
            preferentialItem.setTag(tagName);
            preferentialItem.setCode(salePolicy.getSalePolicyCode());
            preferentialItem.setName(salePolicy.getSalePolicyName());
            preferentialItem.setValidStartTime(salePolicy.getValidStartTime());
            preferentialItem.setValidEndTime(salePolicy.getValidEndTime());
            preferentialItem.setDescription(salePolicy.getDescription());
            preferentialItem.setLabel(salePolicy.getLabel());
            salePolicyProducts.stream().filter(item -> productSpecificationCodes.contains(item.getProductSpecificationCode())).forEach(item -> {
                String unitCode;
                String productSpecificationCode = item.getProductSpecificationCode();
                boolean isValid = this.isValid(salePolicy, productSpecificationCode, unitCode = item.getUnitCode());
                if (isValid) {
                    Set preferentialItems = (Set)specificationCodeMapping.get(productSpecificationCode);
                    BigDecimal specificPrice = this.getSpecificPrice(salePolicy, item.getProductSpecificationCode(), item.getUnitCode());
                    ProductPreferentialItemVo currentPreferentialItem = (ProductPreferentialItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)preferentialItem, ProductPreferentialItemVo.class, HashSet.class, ArrayList.class, new String[]{""});
                    currentPreferentialItem.setSpecificPrice(specificPrice);
                    if (!CollectionUtils.isEmpty((Collection)preferentialItems)) {
                        preferentialItems.add(currentPreferentialItem);
                    } else {
                        preferentialItems = Sets.newHashSet();
                        preferentialItems.add(currentPreferentialItem);
                    }
                    specificationCodeMapping.put(productSpecificationCode, preferentialItems);
                }
            });
        }
        return specificationCodeMapping;
    }

    private String getTagName(Integer targ) {
        switch (targ) {
            case 1: {
                return "\u7279\u4ef7";
            }
            case 2: {
                return "\u6ee1\u6298";
            }
            case 3: {
                return "\u6ee1\u51cf";
            }
            case 4: {
                return "\u6ee1\u8d60";
            }
            case 5: {
                return "\u4e70\u8d60";
            }
        }
        return "";
    }

    private boolean isValid(SalePolicyVo salePolicy, String productSpecificationCode, String unitCode) {
        if (salePolicy == null || salePolicy.getPolicyType() == null || salePolicy.getValidType() == null) {
            return false;
        }
        return salePolicy.getValidType() == 3;
    }

    private BigDecimal getSpecificPrice(SalePolicyVo salePolicy, String productSpecificationCode, String unitCode) {
        if (salePolicy == null || salePolicy.getPolicyType() == null || salePolicy.getValidType() == null) {
            return null;
        }
        if (salePolicy.getValidType() != 3) {
            return null;
        }
        Integer saleType = salePolicy.getPolicyType().getSaleType();
        if (saleType == null || saleType != 1) {
            return null;
        }
        Optional<SalePolicyProductsVo> op = salePolicy.getProducts().stream().filter(p -> p.getProductSpecificationCode().equals(productSpecificationCode) && p.getUnitCode().equals(unitCode)).findFirst();
        SalePolicyProductsVo salePolicyProductsVo = op.orElse(null);
        if (salePolicyProductsVo == null) {
            return null;
        }
        return salePolicyProductsVo.getSpecificPrice();
    }
}

