/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.controller;

import com.bizunited.empower.business.policy.service.SalePolicyResultService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/salePolicyResults"})
public class SalePolicyResultController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyResultController.class);
    @Autowired
    private SalePolicyResultService salePolicyResultService;

    @ApiOperation(value="\u6309\u7167\u7ecf\u9500\u5546\u548c\u8425\u9500\u6d3b\u52a8\u4e24\u4e2a\u7ef4\u5ea6\uff0c\u5bf9\u603b\u4f53\u9001\u51fa\u7684\u8d60\u54c1\u6570\u91cf\u8fdb\u884c\u7edf\u8ba1 (\u53ea\u7edf\u8ba1\u6709\u6548\u7684\u8425\u9500\u6d3b\u52a8)")
    @GetMapping(value={"countBySalePolicyCode"})
    public ResponseModel countBySalePolicyCode(@RequestParam(value="salePolicyCode") String salePolicyCode) {
        try {
            long current = this.salePolicyResultService.countBySalePolicyCode(salePolicyCode);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7ecf\u9500\u5546\u548c\u8425\u9500\u6d3b\u52a8\u4e24\u4e2a\u7ef4\u5ea6\uff0c\u5bf9\u8425\u9500\u6d3b\u52a8\u6d89\u53ca\u5546\u54c1\u7684\u539f\u59cb\u4ef7\u503c\u8fdb\u884c\u7d2f\u52a0\u7edf\u8ba1 (\u53ea\u7edf\u8ba1\u6709\u6548\u7684\u8425\u9500\u6d3b\u52a8)")
    @GetMapping(value={"sumProductAmountBySalePolicyCode"})
    public ResponseModel sumProductAmountBySalePolicyCode(@RequestParam(value="salePolicyCode") String salePolicyCode) {
        try {
            BigDecimal current = this.salePolicyResultService.sumProductAmountBySalePolicyCode(salePolicyCode);
            return this.buildHttpResultW(current == null ? BigDecimal.ZERO : Float.valueOf(current.floatValue()), new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7ecf\u9500\u5546\u548c\u8425\u9500\u6d3b\u52a8\u4e24\u4e2a\u7ef4\u5ea6\uff0c\u5bf9\u8425\u9500\u6d3b\u52a8\u7684\u4fc3\u9500\u6210\u672c\u8fdb\u884c\u7d2f\u52a0\u7edf\u8ba1\uff08\u53ea\u7edf\u8ba1\u6709\u6548\u7684\u8425\u9500\u6d3b\u52a8\uff09", notes="\u8425\u9500\u6d3b\u52a8\u6210\u672c = \u8425\u9500\u6d3b\u52a8\u4e2d\u51cf\u5c11\u7684\u672c\u54c1\u4ef7\u503c + \u8425\u9500\u6d3b\u52a8\u9001\u51fa\u8d60\u54c1\u7684\u539f\u59cb\u4ef7\u503c")
    @GetMapping(value={"sumCostBySalePolicyCode"})
    public ResponseModel sumCostBySalePolicyCode(String salePolicyCode) {
        try {
            BigDecimal current = this.salePolicyResultService.sumCostBySalePolicyCode(salePolicyCode);
            return this.buildHttpResultW(current == null ? BigDecimal.ZERO : Float.valueOf(current.floatValue()), new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

