/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.repository;

import com.bizunited.empower.business.policy.entity.RebateAccountBrandDetails;
import com.bizunited.empower.business.policy.repository.internal.RebateAccountBrandDetailsRepositoryCustom;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_RebateAccountBrandDetailsRepository")
public interface RebateAccountBrandDetailsRepository
extends RebateAccountBrandDetailsRepositoryCustom,
JpaRepository<RebateAccountBrandDetails, String>,
JpaSpecificationExecutor<RebateAccountBrandDetails> {
    @Query(value="select count(*) from RebateAccountBrandDetails ra where ra.rebateAccount.id = :rebateAccountId AND ra.brandCode = :brandCode")
    public Long countByRebateAccountIdAndBrandCode(@Param(value="rebateAccountId") String var1, @Param(value="brandCode") String var2);

    @Query(value="select target1.rebate_account_id , target1.brand_code , target1.available_amount , target2.used_amount from   (select rab.rebate_account_id , rab.brand_code , rab.available_amount      from rebate_account_brand_details rab      where rab.rebate_account_id = :rebateAccountId and rebate_account_brand_code in        (select max(rebate_account_brand_code)          from rebate_account_brand_details rb          where rb.rebate_account_id = :rebateAccountId          group by rb.brand_code )     ) as target1  left join   (select d.rebate_account_id , d.brand_code , sum(d.detail_amount)  as used_amount     from rebate_account_brand_details d     where d.rebate_account_id = :rebateAccountId and d.detail_type < 0     group by d.rebate_account_id , d.brand_code     ) as target2  on target1.rebate_account_id = target2.rebate_account_id and  target1.brand_code = target2.brand_code  order by target1.brand_code", nativeQuery=true)
    public Object[][] findByGroupRebateAccountId(@Param(value="rebateAccountId") String var1);

    @Query(value="select rebate_account_brand_details.available_amount from rebate_account_brand_details where rebate_account_id = :rebateAccountId AND rebate_account_brand_code = (select max(rebate_account_brand_code) from rebate_account_brand_details where rebate_account_id = :rebateAccountId and brand_code = :brandCode)", nativeQuery=true)
    public BigDecimal findAvailableAmountByRebateAccountId(@Param(value="rebateAccountId") String var1, @Param(value="brandCode") String var2);

    @Query(value="from RebateAccountBrandDetails ra where ra.relevanceCode = :relevanceCode and ra.tenantCode = :tenantCode order by ra.rebateAccountBrandCode ")
    public Set<RebateAccountBrandDetails> findByRelevanceCode(@Param(value="relevanceCode") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="insert into rebate_account_brand_details(id , brand_code , rebate_account_brand_code , available_amount , detail_amount ,detail_type , relevance_code , remark , rebate_account_id , create_account , create_time , modify_account , modify_time , tenant_code)  select :id,:brandCode,:rebateAccountBrandCode, (IFNULL(rebate_account_brand_details.available_amount,0) + :detailAmount) as available_amount , :detailAmount , :detailType, :relevanceCode , :remark, :rebateAccountId , :createAccount , :createTime , :modifyAccount , :modifyTime , :tenantCode  from rebate_account_brand_details WHERE rebate_account_brand_details.rebate_account_id = :rebateAccountId AND rebate_account_brand_details.brand_code = :brandCode AND rebate_account_brand_details.rebate_account_brand_code = (select max(rebate_account_brand_code) from rebate_account_brand_details where rebate_account_brand_details.rebate_account_id = :rebateAccountId AND rebate_account_brand_details.brand_code = :brandCode)", nativeQuery=true)
    public int createForIncrement(@Param(value="id") String var1, @Param(value="brandCode") String var2, @Param(value="rebateAccountBrandCode") String var3, @Param(value="detailAmount") BigDecimal var4, @Param(value="detailType") Integer var5, @Param(value="relevanceCode") String var6, @Param(value="rebateAccountId") String var7, @Param(value="createAccount") String var8, @Param(value="createTime") Date var9, @Param(value="modifyAccount") String var10, @Param(value="modifyTime") Date var11, @Param(value="remark") String var12, @Param(value="tenantCode") String var13);

    @Modifying
    @Query(value="insert into rebate_account_brand_details(id , brand_code , rebate_account_brand_code , available_amount , detail_amount ,detail_type , relevance_code , remark , rebate_account_id , create_account , create_time , modify_account , modify_time , tenant_code)  select :id,:brandCode,:rebateAccountBrandCode, (IFNULL(rebate_account_brand_details.available_amount,0) - :detailAmount) as available_amount , :detailAmount , :detailType, :relevanceCode , :remark, :rebateAccountId , :createAccount , :createTime , :modifyAccount , :modifyTime , :tenantCode  from rebate_account_brand_details WHERE rebate_account_brand_details.rebate_account_id = :rebateAccountId AND rebate_account_brand_details.brand_code = :brandCode AND rebate_account_brand_details.rebate_account_brand_code = (select max(rebate_account_brand_code) from rebate_account_brand_details where rebate_account_brand_details.rebate_account_id = :rebateAccountId AND rebate_account_brand_details.brand_code = :brandCode)", nativeQuery=true)
    public int createForDecrement(@Param(value="id") String var1, @Param(value="brandCode") String var2, @Param(value="rebateAccountBrandCode") String var3, @Param(value="detailAmount") BigDecimal var4, @Param(value="detailType") Integer var5, @Param(value="relevanceCode") String var6, @Param(value="rebateAccountId") String var7, @Param(value="createAccount") String var8, @Param(value="createTime") Date var9, @Param(value="modifyAccount") String var10, @Param(value="modifyTime") Date var11, @Param(value="remark") String var12, @Param(value="tenantCode") String var13);

    @Modifying
    @Query(value="update rebate_account_brand_details set relevance_code = :targetRelevanceCode where relevance_code = :sourceRelevanceCode", nativeQuery=true)
    public void updateRelevanceCode(@Param(value="sourceRelevanceCode") String var1, @Param(value="targetRelevanceCode") String var2);
}

