/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.repository;

import com.bizunited.empower.business.policy.entity.RebateAccountProductDetails;
import com.bizunited.empower.business.policy.repository.internal.RebateAccountProductDetailsRepositoryCustom;
import java.util.Date;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_RebateAccountProductDetailsRepository")
public interface RebateAccountProductDetailsRepository
extends RebateAccountProductDetailsRepositoryCustom,
JpaRepository<RebateAccountProductDetails, String>,
JpaSpecificationExecutor<RebateAccountProductDetails> {
    @Query(value="select count(*) from RebateAccountProductDetails ra where ra.rebateAccount.id = :rebateAccountId AND ra.productSpecificationCode = :productSpecificationCode")
    public Long countByRebateAccountIdAndProductSpecificationCode(@Param(value="rebateAccountId") String var1, @Param(value="productSpecificationCode") String var2);

    @Query(value="select target1.rebate_account_id , target1.product_code , target1.product_specification_code , target1.unit_code , target1.available_number , target2.used_number from   (select rap.rebate_account_id , rap.product_code , rap.product_specification_code , rap.unit_code , rap.available_number       from rebate_account_product_details rap       where rap.rebate_account_id = :rebateAccountId and rap.rebate_account_product_code in         (select max(rebate_account_product_code)           from rebate_account_product_details ra           where ra.rebate_account_id = :rebateAccountId           group by ra.product_specification_code)   ) as target1  left join     (select d.rebate_account_id , d.product_code , d.product_specification_code , d.unit_code , sum(d.detail_number)  as used_number      from rebate_account_product_details d      where d.rebate_account_id = :rebateAccountId and d.detail_type < 0     group by d.rebate_account_id,d.product_code,d.product_specification_code,d.unit_code     ) as target2 on target1.rebate_account_id = target2.rebate_account_id and target1.product_specification_code = target2.product_specification_code order by target1.product_specification_code", nativeQuery=true)
    public Object[][] findByGroupRebateAccountId(@Param(value="rebateAccountId") String var1);

    @Query(value="from RebateAccountProductDetails rap where rap.rebateAccount.id = :rebateAccountId AND rap.rebateAccountProductCode =  (select max(r.rebateAccountProductCode) from RebateAccountProductDetails r where r.rebateAccount.id = :rebateAccountId AND r.productSpecificationCode = :productSpecificationCode) ")
    public RebateAccountProductDetails findByRebateAccountIdAndProductSpecificationCode(@Param(value="rebateAccountId") String var1, @Param(value="productSpecificationCode") String var2);

    @Query(value="select rebate_account_product_details.available_number from rebate_account_product_details where rebate_account_id = :rebateAccountId AND rebate_account_product_code =  (select max(rebate_account_product_code) from rebate_account_product_details where rebate_account_id = :rebateAccountId and product_specification_code = :productSpecificationCode)", nativeQuery=true)
    public Integer findAvailableNumberByRebateAccountId(@Param(value="rebateAccountId") String var1, @Param(value="productSpecificationCode") String var2);

    @Query(value="from RebateAccountProductDetails ra where ra.relevanceCode = :relevanceCode and ra.tenantCode = :tenantCode order by ra.rebateAccountProductCode ")
    public Set<RebateAccountProductDetails> findByRelevanceCode(@Param(value="relevanceCode") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="insert into rebate_account_product_details(id , product_code, product_specification_code , unit_code , rebate_account_product_code , available_number , detail_number ,detail_type , relevance_code , remark , rebate_account_id , create_account , create_time , modify_account , modify_time , tenant_code)  select :id,:productCode,:productSpecificationCode,:unitCode,:rebateAccountProductCode,  (IFNULL(details.available_number,0) + :detailNumber) as available_number , :detailNumber , :detailType , :relevanceCode ,  :remark , :rebateAccountId , :createAccount , :createTime , :modifyAccount , :modifyTime , :tenantCode  from rebate_account_product_details details   where   details.rebate_account_id = :rebateAccountId   and details.product_specification_code = :productSpecificationCode  and details.rebate_account_product_code = (   select max(rebate_account_product_code) from rebate_account_product_details where rebate_account_id = :rebateAccountId and product_specification_code = :productSpecificationCode)", nativeQuery=true)
    public int createForIncrement(@Param(value="id") String var1, @Param(value="productCode") String var2, @Param(value="productSpecificationCode") String var3, @Param(value="unitCode") String var4, @Param(value="rebateAccountProductCode") String var5, @Param(value="detailNumber") Integer var6, @Param(value="detailType") Integer var7, @Param(value="relevanceCode") String var8, @Param(value="rebateAccountId") String var9, @Param(value="createAccount") String var10, @Param(value="createTime") Date var11, @Param(value="modifyAccount") String var12, @Param(value="modifyTime") Date var13, @Param(value="remark") String var14, @Param(value="tenantCode") String var15);

    @Modifying
    @Query(value="insert into rebate_account_product_details(id , product_code, product_specification_code , unit_code , rebate_account_product_code , available_number , detail_number ,detail_type , relevance_code , remark , rebate_account_id , create_account , create_time , modify_account , modify_time , tenant_code)  select :id,:productCode,:productSpecificationCode,:unitCode,:rebateAccountProductCode,  (IFNULL(details.available_number,0) - :detailNumber) as available_number , :detailNumber , :detailType , :relevanceCode ,  :remark , :rebateAccountId , :createAccount , :createTime , :modifyAccount , :modifyTime , :tenantCode  from rebate_account_product_details details   where   details.rebate_account_id = :rebateAccountId   and details.product_specification_code = :productSpecificationCode  and details.rebate_account_product_code = (   select max(rebate_account_product_code) from rebate_account_product_details where rebate_account_id = :rebateAccountId and product_specification_code = :productSpecificationCode)", nativeQuery=true)
    public int createForDecrement(@Param(value="id") String var1, @Param(value="productCode") String var2, @Param(value="productSpecificationCode") String var3, @Param(value="unitCode") String var4, @Param(value="rebateAccountProductCode") String var5, @Param(value="detailNumber") Integer var6, @Param(value="detailType") Integer var7, @Param(value="relevanceCode") String var8, @Param(value="rebateAccountId") String var9, @Param(value="createAccount") String var10, @Param(value="createTime") Date var11, @Param(value="modifyAccount") String var12, @Param(value="modifyTime") Date var13, @Param(value="remark") String var14, @Param(value="tenantCode") String var15);

    @Modifying
    @Query(value="update rebate_account_product_details set relevance_code = :targetRelevanceCode where relevance_code = :sourceRelevanceCode", nativeQuery=true)
    public void updateRelevanceCode(@Param(value="sourceRelevanceCode") String var1, @Param(value="targetRelevanceCode") String var2);
}

