/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.repository.internal;

import com.bizunited.empower.business.policy.dto.RebateAccountBrandDetailsDto;
import com.bizunited.empower.business.policy.entity.RebateAccountBrandDetails;
import com.bizunited.empower.business.policy.repository.internal.RebateAccountBrandDetailsRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class RebateAccountBrandDetailsRepositoryImpl
implements RebateAccountBrandDetailsRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<RebateAccountBrandDetails> findByCondition(Pageable pageable, RebateAccountBrandDetailsDto conditions) {
        StringBuilder hql = new StringBuilder(" from RebateAccountBrandDetails sp left join fetch sp.rebateAccount ra where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(sp) from RebateAccountBrandDetails sp where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            this.buildConditionsAndParameter(conditions, condition, parameters);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u67e5\u8be2\u6761\u4ef6\u4e2d\uff0c\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!!");
        }
        hql.append((CharSequence)condition).append(" order by sp.createTime desc ");
        countHql.append((CharSequence)condition);
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        parameters.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        Number count = (Number)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count == null ? 0L : count.longValue());
    }

    private void buildConditionsAndParameter(RebateAccountBrandDetailsDto conditions, StringBuilder condition, Map<String, Object> parameter) throws ParseException {
        if (conditions == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)conditions.getRebateAccountId())) {
            condition.append(" and sp.rebateAccount.id = :rebateAccountId ");
            parameter.put("rebateAccountId", conditions.getRebateAccountId());
        }
        if (StringUtils.isNotBlank((CharSequence)conditions.getBrandCode())) {
            condition.append(" and sp.brandCode = :brandCode ");
            parameter.put("brandCode", conditions.getBrandCode());
        }
        if (conditions.getCreateTimeStart() != null) {
            condition.append(" and sp.createTime >= :createTimeStart ");
            parameter.put("createTimeStart", conditions.getCreateTimeStart());
        }
        if (conditions.getCreateTimeEnd() != null) {
            condition.append(" and sp.createTime <= :createTimeEnd ");
            parameter.put("createTimeEnd", conditions.getCreateTimeEnd());
        }
    }
}

