/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.entity.PolicyExecutor;
import com.bizunited.empower.business.policy.entity.PolicyExecutorVar;
import com.bizunited.empower.business.policy.repository.PolicyExecutorRepository;
import com.bizunited.empower.business.policy.service.PolicyExecutorService;
import com.bizunited.empower.business.policy.service.PolicyExecutorVarService;
import com.bizunited.platform.script.event.ScriptVo;
import com.bizunited.platform.script.service.ScriptVoService;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="PolicyExecutorServiceImpl")
public class PolicyExecutorServiceImpl
implements PolicyExecutorService {
    @Autowired
    private PolicyExecutorRepository policyExecutorRepository;
    @Autowired
    private PolicyExecutorVarService policyExecutorVarService;
    @Autowired
    private ScriptVoService scriptService;

    @Override
    @Transactional
    public PolicyExecutor create(PolicyExecutor policyExecutor) {
        PolicyExecutor current = this.createForm(policyExecutor);
        return current;
    }

    @Override
    @Transactional
    public PolicyExecutor createForm(PolicyExecutor policyExecutor) {
        String scriptName = "script_" + policyExecutor.getExecutorCode();
        this.createValidation(policyExecutor);
        ScriptVo scriptVo = new ScriptVo();
        scriptVo.setDescription("\u7b56\u7565\u7c7b\u578b\u6267\u884c\u5668\uff1a" + policyExecutor.getExecutorName() + "\u7684\u811a\u672c\u6267\u884c\u6267\u884c\u4fe1\u606f");
        scriptVo.setLanguage("groovy");
        scriptVo.setName(scriptName);
        this.scriptService.create(scriptVo, policyExecutor.getScript());
        policyExecutor.setScript(scriptName);
        this.policyExecutorRepository.save((Object)policyExecutor);
        Set<PolicyExecutorVar> vars = policyExecutor.getPolicyExecutorVars();
        if (!CollectionUtils.isEmpty(vars)) {
            for (PolicyExecutorVar var : vars) {
                var.setPolicyExecutor(policyExecutor);
                this.policyExecutorVarService.create(var);
            }
        }
        return policyExecutor;
    }

    private void createValidation(PolicyExecutor policyExecutor) {
        Validate.notNull((Object)((Object)policyExecutor), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)policyExecutor.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        policyExecutor.setId(null);
        Validate.notBlank((CharSequence)policyExecutor.getExecutorCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6267\u884c\u5668\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutor.getExecutorName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6267\u884c\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutor.getExpression(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutor.getScript(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5bf9\u5e94\u7684\u811a\u672c\u5185\u5bb9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((policyExecutor.getExecutorCode() == null || policyExecutor.getExecutorCode().length() < 255 ? 1 : 0) != 0, (String)"\u6267\u884c\u5668\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((policyExecutor.getExecutorName() == null || policyExecutor.getExecutorName().length() < 255 ? 1 : 0) != 0, (String)"\u6267\u884c\u5668\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((policyExecutor.getExpression() == null || policyExecutor.getExpression().length() < 255 ? 1 : 0) != 0, (String)"\u8868\u8fbe\u5f0f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        PolicyExecutor currentPolicyExecutor = this.findByExecutorCode(policyExecutor.getExecutorCode());
        Validate.isTrue((currentPolicyExecutor == null ? 1 : 0) != 0, (String)"\u6267\u884c\u5668\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public PolicyExecutor update(PolicyExecutor policyExecutor) {
        PolicyExecutor current = this.updateForm(policyExecutor);
        return current;
    }

    @Override
    @Transactional
    public PolicyExecutor updateForm(PolicyExecutor policyExecutor) {
        this.updateValidation(policyExecutor);
        String currentId = policyExecutor.getId();
        Optional op_currentPolicyExecutor = this.policyExecutorRepository.findById(currentId);
        PolicyExecutor currentPolicyExecutor = op_currentPolicyExecutor.orElse(null);
        currentPolicyExecutor = (PolicyExecutor)((Object)Validate.notNull((Object)((Object)currentPolicyExecutor), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        String scriptName = "script_" + policyExecutor.getExecutorCode();
        ScriptVo scriptObject = this.scriptService.findByName(scriptName);
        if (scriptObject != null) {
            ScriptVo currentScript = new ScriptVo();
            currentScript.setDescription("\u7b56\u7565\u7c7b\u578b\u6267\u884c\u5668\uff1a" + policyExecutor.getExecutorName() + "\u7684\u811a\u672c\u6267\u884c\u6267\u884c\u4fe1\u606f");
            currentScript.setLanguage("groovy");
            currentScript.setName(scriptName);
            this.scriptService.create(currentScript, policyExecutor.getScript());
        } else {
            this.scriptService.update(scriptObject, policyExecutor.getScript());
        }
        currentPolicyExecutor.setExecutorCode(policyExecutor.getExecutorCode());
        currentPolicyExecutor.setExecutorName(policyExecutor.getExecutorName());
        currentPolicyExecutor.setExpression(policyExecutor.getExpression());
        currentPolicyExecutor.setScript(policyExecutor.getScript());
        this.policyExecutorRepository.saveAndFlush((Object)currentPolicyExecutor);
        this.policyExecutorVarService.deleteByExecutor(policyExecutor.getId());
        Set<PolicyExecutorVar> vars = policyExecutor.getPolicyExecutorVars();
        if (!CollectionUtils.isEmpty(vars)) {
            for (PolicyExecutorVar var : vars) {
                var.setPolicyExecutor(policyExecutor);
                this.policyExecutorVarService.create(var);
            }
        }
        return currentPolicyExecutor;
    }

    private void updateValidation(PolicyExecutor policyExecutor) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)policyExecutor.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutor.getExecutorCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6267\u884c\u5668\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutor.getExecutorName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6267\u884c\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutor.getExpression(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyExecutor.getScript(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5bf9\u5e94\u7684\u811a\u672c\u5185\u5bb9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        PolicyExecutor currentForExecutorCode = this.findByExecutorCode(policyExecutor.getExecutorCode());
        Validate.isTrue((currentForExecutorCode == null || StringUtils.equals((CharSequence)currentForExecutorCode.getId(), (CharSequence)policyExecutor.getId()) ? 1 : 0) != 0, (String)"\u6267\u884c\u5668\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((policyExecutor.getExecutorCode() == null || policyExecutor.getExecutorCode().length() < 255 ? 1 : 0) != 0, (String)"\u6267\u884c\u5668\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((policyExecutor.getExecutorName() == null || policyExecutor.getExecutorName().length() < 255 ? 1 : 0) != 0, (String)"\u6267\u884c\u5668\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((policyExecutor.getExpression() == null || policyExecutor.getExpression().length() < 255 ? 1 : 0) != 0, (String)"\u8868\u8fbe\u5f0f,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public PolicyExecutor findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.policyExecutorRepository.findDetailsById(id);
    }

    @Override
    public PolicyExecutor findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.policyExecutorRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        PolicyExecutor current = this.findById(id);
        if (current != null) {
            this.policyExecutorRepository.delete((Object)current);
        }
    }

    @Override
    public PolicyExecutor findByExecutorCode(String executorCode) {
        if (StringUtils.isBlank((CharSequence)executorCode)) {
            return null;
        }
        return this.policyExecutorRepository.findByExecutorCode(executorCode);
    }
}

