/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.entity.PolicyType;
import com.bizunited.empower.business.policy.repository.PolicyTypeRepository;
import com.bizunited.empower.business.policy.service.PolicyExecutorService;
import com.bizunited.empower.business.policy.service.PolicyTypeService;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="policyTypeServiceImpl")
public class PolicyTypeServiceImpl
implements PolicyTypeService {
    @Autowired
    private PolicyTypeRepository policyTypeEntityRepository;
    @Autowired
    private PolicyExecutorService policyExecutorService;

    @Override
    @Transactional
    public PolicyType create(PolicyType policyTypeEntity) {
        PolicyType current = this.createForm(policyTypeEntity);
        return current;
    }

    @Override
    @Transactional
    public PolicyType createForm(PolicyType policyTypeEntity) {
        this.createValidation(policyTypeEntity);
        this.policyTypeEntityRepository.save((Object)policyTypeEntity);
        return policyTypeEntity;
    }

    private void createValidation(PolicyType policyTypeEntity) {
        Validate.notNull((Object)((Object)policyTypeEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)policyTypeEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        policyTypeEntity.setId(null);
        Validate.notNull((Object)policyTypeEntity.getSaleType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyTypeEntity.getPolicyTypeCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getPolicyTypeStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyTypeEntity.getPolicyTypeName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getDisplayGifts(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u5c55\u793a\u8d60\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getGiftsMapping(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u672c\u54c1\u548c\u8d60\u54c1\u4e00\u4e00\u5bf9\u5e94\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getExecutorSteps(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u6267\u884c\u5668\u91cd\u590d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)policyTypeEntity.getPolicyExecutor()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9009\u5b9a\u7684\u4fc3\u9500\u6267\u884c\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((policyTypeEntity.getPolicyTypeCode() == null || policyTypeEntity.getPolicyTypeCode().length() < 128 ? 1 : 0) != 0, (String)"\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((policyTypeEntity.getPolicyTypeName() == null || policyTypeEntity.getPolicyTypeName().length() < 128 ? 1 : 0) != 0, (String)"\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        PolicyType currentPolicyType = this.findByPolicyTypeCode(policyTypeEntity.getPolicyTypeCode());
        Validate.isTrue((currentPolicyType == null ? 1 : 0) != 0, (String)"\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u7f16\u53f7\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String policyExecutor = policyTypeEntity.getPolicyExecutor().getId();
        Validate.notNull((Object)((Object)this.policyExecutorService.findById(policyExecutor)), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4fc3\u9500\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public PolicyType update(PolicyType policyTypeEntity) {
        PolicyType current = this.updateForm(policyTypeEntity);
        return current;
    }

    @Override
    @Transactional
    public PolicyType updateForm(PolicyType policyTypeEntity) {
        this.updateValidation(policyTypeEntity);
        String currentId = policyTypeEntity.getId();
        Optional op_currentPolicyType = this.policyTypeEntityRepository.findById(currentId);
        PolicyType currentPolicyType = op_currentPolicyType.orElse(null);
        currentPolicyType = (PolicyType)((Object)Validate.notNull((Object)((Object)currentPolicyType), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentPolicyType.setPolicyTypeStatus(policyTypeEntity.getPolicyTypeStatus());
        currentPolicyType.setPolicyTypeName(policyTypeEntity.getPolicyTypeName());
        currentPolicyType.setDisplayGifts(policyTypeEntity.getDisplayGifts());
        currentPolicyType.setGiftsMapping(policyTypeEntity.getGiftsMapping());
        currentPolicyType.setPolicyExecutor(policyTypeEntity.getPolicyExecutor());
        this.policyTypeEntityRepository.saveAndFlush((Object)currentPolicyType);
        return currentPolicyType;
    }

    private void updateValidation(PolicyType policyTypeEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)policyTypeEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyTypeEntity.getPolicyTypeCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getPolicyTypeStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u5de5\u4f5c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyTypeEntity.getPolicyTypeName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getDisplayGifts(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u5c55\u793a\u8d60\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getGiftsMapping(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u672c\u54c1\u548c\u8d60\u54c1\u4e00\u4e00\u5bf9\u5e94\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)policyTypeEntity.getExecutorSteps(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fc3\u9500\u6267\u884c\u5668\u91cd\u590d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((policyTypeEntity.getPolicyTypeCode() == null || policyTypeEntity.getPolicyTypeCode().length() < 128 ? 1 : 0) != 0, (String)"\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((policyTypeEntity.getPolicyTypeName() == null || policyTypeEntity.getPolicyTypeName().length() < 128 ? 1 : 0) != 0, (String)"\u4fc3\u9500\u89c4\u5219\u7c7b\u578b\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        PolicyType current = this.findById(id);
        if (current != null) {
            this.policyTypeEntityRepository.delete((Object)current);
        }
    }

    @Override
    public Set<PolicyType> findDetailsByPolicyExecutor(String policyExecutor) {
        if (StringUtils.isBlank((CharSequence)policyExecutor)) {
            return Sets.newHashSet();
        }
        return this.policyTypeEntityRepository.findDetailsByPolicyExecutor(policyExecutor);
    }

    @Override
    public PolicyType findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.policyTypeEntityRepository.findDetailsById(id);
    }

    @Override
    public PolicyType findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.policyTypeEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public PolicyType findByPolicyTypeCode(String policyTypeCode) {
        if (StringUtils.isBlank((CharSequence)policyTypeCode)) {
            return null;
        }
        return this.policyTypeEntityRepository.findByPolicyTypeCode(policyTypeCode);
    }

    @Override
    public Set<PolicyType> findByPolicyTypeStatus(Integer policyTypeStatus) {
        if (policyTypeStatus == null) {
            return null;
        }
        return this.policyTypeEntityRepository.findByPolicyTypeStatus(policyTypeStatus);
    }
}

