/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.dto.RebateAccountBrandDetailsDto;
import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountBrandDetails;
import com.bizunited.empower.business.policy.repository.RebateAccountBrandDetailsRepository;
import com.bizunited.empower.business.policy.service.RebateAccountBrandDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountBrandDetailsVoService;
import com.bizunited.empower.business.policy.vo.RebateAccountBrandDetailsVo;
import com.bizunited.empower.business.product.entity.ProductBrand;
import com.bizunited.empower.business.product.service.ProductBrandService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RebateAccountBrandDetailsVoServiceImpl")
public class RebateAccountBrandDetailsVoServiceImpl
implements RebateAccountBrandDetailsVoService {
    @Autowired
    private RebateAccountBrandDetailsService rebateAccountBrandDetailsService;
    @Autowired
    private RebateAccountBrandDetailsRepository rebateAccountBrandDetailsRepository;
    @Autowired
    private ProductBrandService productBrandService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String REBATE_POLICY_BRAND_GEN_PREFIX = "REBATE_POLICY_BRAND_GEN_PREFIX";

    @Override
    public String preCreate() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(REBATE_POLICY_BRAND_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebateAccountBrandDetailsVo create(RebateAccountBrandDetailsVo rebateAccountCommonDetail) {
        block5: {
            Validate.notNull((Object)((Object)rebateAccountCommonDetail), (String)"\u6dfb\u52a0\u8fd4\u5229\u8d26\u6237-\u901a\u7528\u660e\u7ec6\u65f6\uff0c\u6dfb\u52a0\u7684\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            String prefix = rebateAccountCommonDetail.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(REBATE_POLICY_BRAND_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u8fd4\u5229\u8d26\u6237-\u54c1\u724c\u8d44\u91d1\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(REBATE_POLICY_BRAND_GEN_PREFIX, prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u8fd4\u5229\u653f\u7b56\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
        RebateAccountBrandDetails cRebateAccountBrandDetails = (RebateAccountBrandDetails)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rebateAccountCommonDetail, RebateAccountBrandDetails.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        RebateAccount rebateAccount = new RebateAccount();
        rebateAccount.setId(rebateAccountCommonDetail.getRebateAccountId());
        cRebateAccountBrandDetails.setRebateAccount(rebateAccount);
        cRebateAccountBrandDetails = this.rebateAccountBrandDetailsService.create(cRebateAccountBrandDetails);
        rebateAccountCommonDetail.setId(cRebateAccountBrandDetails.getId());
        return rebateAccountCommonDetail;
    }

    @Override
    public Page<RebateAccountBrandDetailsVo> findByConditions(Pageable pageable, RebateAccountBrandDetailsDto conditions) {
        Page<RebateAccountBrandDetails> resutls;
        if (conditions == null || StringUtils.isBlank((CharSequence)conditions.getRebateAccountId())) {
            return null;
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if ((resutls = this.rebateAccountBrandDetailsRepository.findByCondition(pageable, conditions)) == null || resutls.isEmpty()) {
            return null;
        }
        Collection rebateAccountBrandDetails = this.nebulaToolkitService.copyCollectionByWhiteList(resutls, RebateAccountBrandDetails.class, RebateAccountBrandDetailsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List codeList = rebateAccountBrandDetails.stream().map(RebateAccountBrandDetailsVo::getBrandCode).distinct().collect(Collectors.toList());
        List productBrands = this.productBrandService.findByCodeList(codeList);
        if (!CollectionUtils.isEmpty((Collection)productBrands)) {
            Map<String, String> productBrandMapping = productBrands.stream().collect(Collectors.toMap(ProductBrand::getBrandCode, ProductBrand::getBrandName));
            rebateAccountBrandDetails.forEach(item -> item.setBrandName((String)productBrandMapping.get(item.getBrandCode())));
        }
        return new PageImpl((List)Lists.newArrayList((Iterable)rebateAccountBrandDetails), pageable, resutls.getTotalElements());
    }

    @Override
    public Set<RebateAccountBrandDetailsVo> findByRelevanceCode(String relevanceCode) {
        Set<RebateAccountBrandDetails> rebateAccountBrandDetails = this.rebateAccountBrandDetailsRepository.findByRelevanceCode(relevanceCode, TenantUtils.getTenantCode());
        Set rebateAccountBrandDetailsVos = (Set)this.nebulaToolkitService.copyCollectionByWhiteList(rebateAccountBrandDetails, RebateAccountBrandDetails.class, RebateAccountBrandDetailsVo.class, HashSet.class, ArrayList.class, new String[]{""});
        return rebateAccountBrandDetailsVos;
    }
}

