/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountCommonDetails;
import com.bizunited.empower.business.policy.repository.RebateAccountCommonDetailsRepository;
import com.bizunited.empower.business.policy.repository.RebateAccountRepository;
import com.bizunited.empower.business.policy.service.RebateAccountCommonDetailsService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RebateAccountCommonDetailsServiceImpl")
public class RebateAccountCommonDetailsServiceImpl
implements RebateAccountCommonDetailsService {
    @Autowired
    private RebateAccountCommonDetailsRepository rebateAccountCommonDetailsRepository;
    @Autowired
    private RebateAccountRepository rebateAccountRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private CustomerService customerService;
    private static final String REBATE_CODE_PREFIX = "RPC";

    @Override
    @Transactional
    public void init(RebateAccount rebateAccount, String customerCode) {
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u521d\u59cb\u5316\u65f6\uff0c\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\u5fc5\u987b\u9996\u5148\u8fdb\u884c\u521b\u5efa!!", (Object[])new Object[0]);
        String rebateAccountId = rebateAccount.getId();
        Validate.notBlank((CharSequence)rebateAccountId, (String)"\u521d\u59cb\u5316\u65f6\uff0c", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Customer customer = this.customerService.findByTenantCodeAndCustomerCode(tenantCode, customerCode);
        Validate.notNull((Object)customer, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5ba2\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RebateAccountCommonDetails rebateAccountCommonDetail = new RebateAccountCommonDetails();
        Date now = new Date();
        rebateAccountCommonDetail.setCreateAccount(SecurityUtils.getUserAccount());
        rebateAccountCommonDetail.setCreateTime(now);
        rebateAccountCommonDetail.setModifyAccount(SecurityUtils.getUserAccount());
        rebateAccountCommonDetail.setModifyTime(now);
        rebateAccountCommonDetail.setAvailableAmount(BigDecimal.ZERO);
        rebateAccountCommonDetail.setDetailAmount(BigDecimal.ZERO);
        rebateAccountCommonDetail.setDetailType(1);
        rebateAccountCommonDetail.setRebateAccount(rebateAccount);
        rebateAccountCommonDetail.setRelevanceCode(null);
        String remark = "\u8fd4\u5229\u8d26\u6237-\u901a\u7528\u8d26\u6237\u8d44\u91d1\u521d\u59cb\u5316";
        rebateAccountCommonDetail.setRemark(remark);
        rebateAccountCommonDetail.setTenantCode(TenantUtils.getTenantCode());
        rebateAccountCommonDetail.setId(null);
        this.createValidation(rebateAccountCommonDetail, customerCode, now, true);
        this.rebateAccountCommonDetailsRepository.save((Object)rebateAccountCommonDetail);
    }

    @Override
    @Transactional
    public RebateAccountCommonDetails create(RebateAccountCommonDetails rebateAccountCommonDetails) {
        RebateAccountCommonDetails current = this.createForm(rebateAccountCommonDetails);
        return current;
    }

    private RebateAccountCommonDetails createForm(RebateAccountCommonDetails rebateAccountCommonDetail) {
        Validate.notNull((Object)((Object)rebateAccountCommonDetail), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        RebateAccount rebateAccount = rebateAccountCommonDetail.getRebateAccount();
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u672a\u6307\u5b9a\u8fd4\u5229\u660e\u7ec6\u5173\u8054\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String rebateAccountId = rebateAccount.getId();
        RebateAccount existRebateAccount = this.rebateAccountRepository.findById(rebateAccountId).orElse(null);
        Validate.notNull((Object)((Object)existRebateAccount), (String)"\u521b\u5efa\u901a\u7528\u8d26\u6237\u660e\u7ec6\u65f6\uff0c\u672a\u6307\u5b9a\u8fd4\u5229\u660e\u7ec6\u5173\u8054\u7684\u8fd4\u5229\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((existRebateAccount.getRebateAccountStatus() == 1 ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u8fd4\u5229\u8d26\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u4efb\u4f55\u8fd4\u5229\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Date now = new Date();
        rebateAccountCommonDetail.setTenantCode(TenantUtils.getTenantCode());
        rebateAccountCommonDetail.setCreateAccount(SecurityUtils.getUserAccount());
        rebateAccountCommonDetail.setCreateTime(now);
        rebateAccountCommonDetail.setModifyAccount(SecurityUtils.getUserAccount());
        rebateAccountCommonDetail.setModifyTime(now);
        this.createValidation(rebateAccountCommonDetail, existRebateAccount.getCustomerCode(), now, false);
        String id = rebateAccountCommonDetail.getId();
        String rebateAccountCommonCode = rebateAccountCommonDetail.getRebateAccountCommonCode();
        BigDecimal detailAmount = rebateAccountCommonDetail.getDetailAmount();
        Integer detailType = rebateAccountCommonDetail.getDetailType();
        String relevanceCode = rebateAccountCommonDetail.getRelevanceCode();
        String opAccount = SecurityUtils.getUserAccount();
        String remark = rebateAccountCommonDetail.getRemark() == null ? "" : rebateAccountCommonDetail.getRemark();
        String tenantCode = TenantUtils.getTenantCode();
        if (detailType > 0) {
            this.rebateAccountCommonDetailsRepository.createForIncrement(id, rebateAccountCommonCode, detailAmount, detailType, relevanceCode, rebateAccountId, opAccount, now, opAccount, now, remark, tenantCode);
        } else if (rebateAccountCommonDetail.getDetailType() < 0) {
            this.rebateAccountCommonDetailsRepository.createForDecrement(id, rebateAccountCommonCode, detailAmount, detailType, relevanceCode, rebateAccountId, opAccount, now, opAccount, now, remark, tenantCode);
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u8fd4\u5229\u660e\u7ec6\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        rebateAccountCommonDetail.setRebateAccountCommonCode(rebateAccountCommonCode);
        rebateAccountCommonDetail.setId(id);
        return rebateAccountCommonDetail;
    }

    private void createValidation(RebateAccountCommonDetails rebateAccountCommonDetail, String customerCode, Date now, boolean init) {
        Validate.notNull((Object)rebateAccountCommonDetail.getDetailType(), (String)"\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u503c\uff01", (Object[])new Object[0]);
        if (!init) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)rebateAccountCommonDetail.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
            rebateAccountCommonDetail.setId(null);
            Validate.isTrue((rebateAccountCommonDetail.getDetailType() != 0 && rebateAccountCommonDetail.getDetailType() != 1 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u503c\uff01", (Object[])new Object[0]);
        } else {
            Validate.isTrue((rebateAccountCommonDetail.getDetailType() != 0 ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u660e\u7ec6\u53d8\u66f4\u7c7b\u578b\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u503c\uff01", (Object[])new Object[0]);
        }
        Validate.notNull((Object)rebateAccountCommonDetail.getDetailAmount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d8\u66f4\u91d1\u989d\uff0c\u90fd\u4e3a\u56db\u4f4d\uff0c\u65e0\u8bba\u652f\u51fa\u8fd8\u662f\u6536\u5165\uff0c\u90fd\u4e3a\u6b63\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!init) {
            RebateAccount rebateAccount = rebateAccountCommonDetail.getRebateAccount();
            if (rebateAccountCommonDetail.getDetailType() < 0) {
                BigDecimal currentAvailableAmount = this.rebateAccountCommonDetailsRepository.findAvailableAmountByRebateAccountId(rebateAccount.getId());
                Validate.notNull((Object)currentAvailableAmount, (String)"\u6dfb\u52a0\u660e\u7ec6\u65f6\uff0c\u672a\u53d1\u73b0\u5f53\u524d\u8d26\u6237\u7684\u53ef\u7528\u8d44\u91d1\uff0c\u8bf7\u89c1\u67e5\u8fd4\u5229\u8d26\u6237-\u901a\u7528\u8d44\u91d1\u8fd4\u5229", (Object[])new Object[0]);
                Validate.isTrue((currentAvailableAmount.subtract(rebateAccountCommonDetail.getDetailAmount()).floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u5f53\u524d\u8fd4\u5229\u8d26\u6237-\u901a\u7528\u8d44\u91d1\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
        } else {
            Validate.isTrue((rebateAccountCommonDetail.getDetailAmount().floatValue() == 0.0f ? 1 : 0) != 0, (String)"\u521d\u59cb\u5316\u65f6\uff0c\u91d1\u989d\u53d8\u66f4\u660e\u7ec6\u5fc5\u987b\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        }
        Validate.isTrue((rebateAccountCommonDetail.getRelevanceCode() == null || rebateAccountCommonDetail.getRelevanceCode().length() < 64 ? 1 : 0) != 0, (String)"\u5173\u8054\u5355\u636e,\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebateAccountCommonDetail.getRemark() == null || rebateAccountCommonDetail.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String datecode = dateFormat.format(now);
        String codeUnKey = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, "_", tenantCode, "_", customerCode});
        String atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
        String rebateAccountCommonCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, atomicNumberValue});
        rebateAccountCommonDetail.setRebateAccountCommonCode(rebateAccountCommonCode);
        if (!init) {
            String id = StringUtils.join((Object[])new String[]{tenantCode, "_", customerCode, "_", atomicNumberValue});
            while (this.rebateAccountCommonDetailsRepository.findById(id).orElse(null) != null) {
                atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
                rebateAccountCommonCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, atomicNumberValue});
                id = StringUtils.join((Object[])new String[]{tenantCode, "_", customerCode, "_", atomicNumberValue});
            }
            rebateAccountCommonDetail.setId(id);
        }
    }

    @Override
    @Transactional
    public void diffectiveByRelevanceCode(String relevanceCode) {
        if (StringUtils.isBlank((CharSequence)relevanceCode)) {
            return;
        }
        Set<RebateAccountCommonDetails> rebateAccountCommonDetails = this.rebateAccountCommonDetailsRepository.findByRelevanceCode(relevanceCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(rebateAccountCommonDetails)) {
            return;
        }
        for (RebateAccountCommonDetails rebateAccountCommonDetail : rebateAccountCommonDetails) {
            Validate.isTrue((rebateAccountCommonDetail.getDetailType() <= -1 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4e1a\u52a1\u5355\u636e\u8fd4\u5229\u6d41\u6c34\u51b2\u62b5\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u6d41\u6c34\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
            RebateAccountCommonDetails newCommonDetail = new RebateAccountCommonDetails();
            newCommonDetail.setId(null);
            newCommonDetail.setDetailType(3);
            newCommonDetail.setRebateAccount(rebateAccountCommonDetail.getRebateAccount());
            newCommonDetail.setRelevanceCode(relevanceCode);
            newCommonDetail.setAvailableAmount(null);
            newCommonDetail.setDetailAmount(rebateAccountCommonDetail.getDetailAmount());
            newCommonDetail.setRemark("\u4e1a\u52a1\u5355\u636e\u6d88\u8d39\u6d41\u6c34\u51b2\u62b5");
            newCommonDetail.setTenantCode(rebateAccountCommonDetail.getTenantCode());
            this.createForm(newCommonDetail);
        }
    }

    @Override
    @Transactional
    public void updateRelevanceCode(String sourceRelevanceCode, String targetRelevanceCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sourceRelevanceCode, targetRelevanceCode})) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set<RebateAccountCommonDetails> rebateAccountBrandDetails = this.rebateAccountCommonDetailsRepository.findByRelevanceCode(sourceRelevanceCode, tenantCode);
        for (RebateAccountCommonDetails detail : rebateAccountBrandDetails) {
            detail.setRelevanceCode(targetRelevanceCode);
            detail.setRemark(String.format(detail.getRemark(), targetRelevanceCode));
            this.rebateAccountCommonDetailsRepository.save((Object)detail);
        }
    }
}

