/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.dto.RebateAccountProductDetailsDto;
import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountProductDetails;
import com.bizunited.empower.business.policy.repository.RebateAccountProductDetailsRepository;
import com.bizunited.empower.business.policy.service.RebateAccountProductDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountProductDetailsVoService;
import com.bizunited.empower.business.policy.vo.RebateAccountProductDetailsVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import com.bizunited.empower.business.product.vo.ProductUnitVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_RebateAccountProductDetailsVoServiceImpl")
public class RebateAccountProductDetailsVoServiceImpl
implements RebateAccountProductDetailsVoService {
    @Autowired
    private RebateAccountProductDetailsService rebateAccountProductDetailsService;
    @Autowired
    private RebateAccountProductDetailsRepository rebateAccountProductDetailsRepository;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String REBATE_POLICY_PRODUCT_GEN_PREFIX = "REBATE_POLICY_PRODUCT_GEN_PREFIX";

    @Override
    public String preCreate() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(REBATE_POLICY_PRODUCT_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebateAccountProductDetailsVo create(RebateAccountProductDetailsVo rebateAccountProductDetail) {
        block5: {
            Validate.notNull((Object)((Object)rebateAccountProductDetail), (String)"\u6dfb\u52a0\u8fd4\u5229\u8d26\u6237-\u5b9e\u7269\u8fd4\u5229\u65f6\uff0c\u6dfb\u52a0\u7684\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            String prefix = rebateAccountProductDetail.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u8fd4\u5229\u8d26\u6237-\u5b9e\u7269\u8fd4\u5229\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(REBATE_POLICY_PRODUCT_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u8fd4\u5229\u8d26\u6237-\u5b9e\u7269\u8fd4\u5229\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(REBATE_POLICY_PRODUCT_GEN_PREFIX, prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u8fd4\u5229\u8d26\u6237-\u5b9e\u7269\u8fd4\u5229\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
        RebateAccountProductDetails cRebateAccountProductDetails = (RebateAccountProductDetails)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rebateAccountProductDetail, RebateAccountProductDetails.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        RebateAccount rebateAccount = new RebateAccount();
        rebateAccount.setId(rebateAccountProductDetail.getRebateAccountId());
        cRebateAccountProductDetails.setRebateAccount(rebateAccount);
        cRebateAccountProductDetails = this.rebateAccountProductDetailsService.create(cRebateAccountProductDetails);
        rebateAccountProductDetail.setId(cRebateAccountProductDetails.getId());
        return rebateAccountProductDetail;
    }

    @Override
    public Page<RebateAccountProductDetailsVo> findByConditions(Pageable pageable, RebateAccountProductDetailsDto conditions) {
        Page<RebateAccountProductDetails> resutls;
        if (conditions == null || StringUtils.isBlank((CharSequence)conditions.getRebateAccountId())) {
            return null;
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if ((resutls = this.rebateAccountProductDetailsRepository.findByCondition(pageable, conditions)) == null || resutls.isEmpty()) {
            return null;
        }
        Collection rebateAccountProductDetails = this.nebulaToolkitService.copyCollectionByWhiteList(resutls, RebateAccountProductDetails.class, RebateAccountProductDetailsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        PageImpl currentResutls = new PageImpl((List)Lists.newArrayList((Iterable)rebateAccountProductDetails), pageable, resutls.getTotalElements());
        Map<String, List<RebateAccountProductDetailsVo>> rebateAccountProductDetailMapping = currentResutls.stream().collect(Collectors.groupingBy(RebateAccountProductDetailsVo::getProductSpecificationCode));
        if (CollectionUtils.isEmpty(rebateAccountProductDetailMapping)) {
            return null;
        }
        ArrayList specificationCodes = Lists.newArrayList(rebateAccountProductDetailMapping.keySet());
        List productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList((List)specificationCodes);
        if (CollectionUtils.isEmpty((Collection)productSpecifications)) {
            return null;
        }
        for (ProductSpecificationVo productSpecification : productSpecifications) {
            String productSpecificationCode = productSpecification.getProductSpecificationCode();
            List<RebateAccountProductDetailsVo> rebateAccountProductDetailItems = rebateAccountProductDetailMapping.get(productSpecificationCode);
            if (CollectionUtils.isEmpty(rebateAccountProductDetailItems)) continue;
            for (RebateAccountProductDetailsVo rebateAccountProductDetailItem : rebateAccountProductDetailItems) {
                rebateAccountProductDetailItem.setProductName(productSpecification.getProduct().getProductName());
                rebateAccountProductDetailItem.setProductSpecificationName(productSpecification.getProductSpecificationName());
                Set productUnitAndPrices = productSpecification.getProduct().getProductUnitSpecificationAndPrices();
                if (CollectionUtils.isEmpty((Collection)productUnitAndPrices)) continue;
                String unitCode = rebateAccountProductDetailItem.getUnitCode();
                for (ProductUnitSpecificationAndPriceVo productUnitAndPriceVo : productUnitAndPrices) {
                    ProductUnitVo productUnit = productUnitAndPriceVo.getProductUnit();
                    if (productUnit == null || !StringUtils.equals((CharSequence)productUnit.getUnitCode(), (CharSequence)unitCode)) continue;
                    rebateAccountProductDetailItem.setUnitName(productUnit == null ? "" : productUnit.getUnitName());
                }
            }
        }
        return currentResutls;
    }

    @Override
    public Set<RebateAccountProductDetailsVo> findByRelevanceCode(String relevanceCode) {
        Set<RebateAccountProductDetails> rebateAccountProductDetails = this.rebateAccountProductDetailsRepository.findByRelevanceCode(relevanceCode, TenantUtils.getTenantCode());
        Set rebateAccountProductDetailsVos = (Set)this.nebulaToolkitService.copyCollectionByWhiteList(rebateAccountProductDetails, RebateAccountProductDetails.class, RebateAccountProductDetailsVo.class, HashSet.class, ArrayList.class, new String[]{""});
        return rebateAccountProductDetailsVos;
    }
}

