/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.dto.RebateAccountDto;
import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.repository.RebateAccountRepository;
import com.bizunited.empower.business.policy.service.RebateAccountVoService;
import com.bizunited.empower.business.policy.vo.RebateAccountVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="_RebateAccountVoServiceImpl")
public class RebateAccountVoServiceImpl
implements RebateAccountVoService {
    @Autowired
    private RebateAccountRepository rebateAccountRepository;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<RebateAccountVo> findByConditions(Pageable pageable, RebateAccountDto conditions) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if (conditions == null) {
            conditions = new RebateAccountDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        conditions.setTenantCode(tenantCode);
        Page<RebateAccount> results = this.rebateAccountRepository.findByCondition(pageable, conditions);
        if (results == null || results.isEmpty()) {
            return Page.empty((Pageable)pageable);
        }
        Collection rebateAccountVos = this.nebulaToolkitService.copyCollectionByWhiteList(results, RebateAccount.class, RebateAccountVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        PageImpl pageResults = new PageImpl((List)Lists.newArrayList((Iterable)rebateAccountVos), pageable, results.getTotalElements());
        Map<String, RebateAccountVo> customerCodeMapping = rebateAccountVos.stream().collect(Collectors.toMap(RebateAccountVo::getCustomerCode, item -> item));
        List customers = this.customerService.findDetailsByCustomerCodes(new ArrayList<String>(customerCodeMapping.keySet()));
        for (Customer customer : customers) {
            String customerCode = customer.getCustomerCode();
            RebateAccountVo item2 = customerCodeMapping.get(customerCode);
            item2.setCustomerName(customer.getCustomerName());
            if (customer.getCustomerCategory() != null) {
                item2.setCategoryCode(customer.getCustomerCategory().getCode());
                item2.setCategoryName(customer.getCustomerCategory().getName());
            }
            if (customer.getCustomerLevel() != null) {
                item2.setLevelCode(customer.getCustomerLevel().getLevelCode());
                item2.setLevelName(customer.getCustomerLevel().getLevelName());
            }
            if (customer.getSalesArea() == null) continue;
            item2.setSalesAreaCode(customer.getSalesArea().getSalesAreaCode());
            item2.setSalesAreaName(customer.getSalesArea().getSalesAreaName());
        }
        return pageResults;
    }

    @Override
    public RebateAccountVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.rebateAccountRepository.findById(id);
        RebateAccount c = op.orElse(null);
        if (c == null) {
            return null;
        }
        return this.transformRebateAccountVo(c);
    }

    private RebateAccountVo transformRebateAccountVo(RebateAccount c) {
        String tenantCode = TenantUtils.getTenantCode();
        RebateAccountVo rebateAccount = (RebateAccountVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)c, RebateAccountVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        String customerCode = c.getCustomerCode();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return rebateAccount;
        }
        Customer customer = this.customerService.findByTenantCodeAndCustomerCode(tenantCode, customerCode);
        if (customer == null) {
            return rebateAccount;
        }
        rebateAccount.setCustomerName(customer.getCustomerName());
        if (customer.getSalesArea() != null) {
            rebateAccount.setSalesAreaCode(customer.getSalesArea().getSalesAreaCode());
            rebateAccount.setSalesAreaName(customer.getSalesArea().getSalesAreaName());
        }
        if (customer.getCustomerLevel() != null) {
            rebateAccount.setLevelCode(customer.getCustomerLevel().getLevelCode());
            rebateAccount.setLevelName(customer.getCustomerLevel().getLevelName());
        }
        if (customer.getCustomerCategory() != null) {
            rebateAccount.setCategoryCode(customer.getCustomerCategory().getCode());
            rebateAccount.setCategoryName(customer.getCustomerCategory().getName());
        }
        return rebateAccount;
    }

    @Override
    public RebateAccountVo findByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        RebateAccount c = this.rebateAccountRepository.findByTenantCodeAndCustomerCode(tenantCode, customerCode);
        if (c == null) {
            return null;
        }
        return this.transformRebateAccountVo(c);
    }
}

