/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.dto.RebatePolicyDto;
import com.bizunited.empower.business.policy.entity.RebatePolicy;
import com.bizunited.empower.business.policy.entity.RebatePolicyCustomers;
import com.bizunited.empower.business.policy.entity.RebatePolicyProducts;
import com.bizunited.empower.business.policy.repository.RebatePolicyCustomersRepository;
import com.bizunited.empower.business.policy.repository.RebatePolicyProductsRepository;
import com.bizunited.empower.business.policy.repository.RebatePolicyRepository;
import com.bizunited.empower.business.policy.service.RebatePolicyService;
import com.bizunited.empower.business.policy.service.RebatePolicyVoService;
import com.bizunited.empower.business.policy.vo.RebatePolicyCustomersVo;
import com.bizunited.empower.business.policy.vo.RebatePolicyProductsVo;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.empower.business.product.dto.ProductSpecificationAndUnitDto;
import com.bizunited.empower.business.product.service.ProductActionService;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RebatePolicyServiceImpl")
public class RebatePolicyServiceImpl
implements RebatePolicyService {
    @Autowired
    private RebatePolicyProductsRepository rebatePolicyProductsRepository;
    @Autowired
    private RebatePolicyCustomersRepository rebatePolicyCustomersRepository;
    @Autowired
    private RebatePolicyRepository rebatePolicyRepository;
    @Autowired
    private RebatePolicyVoService rebatePolicyVoService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private ProductActionService productActionService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String REBATE_CODE_PREFIX = "RP";
    private static final String REBATE_POLICY_GEN_PREFIX = "REBATE_POLICY_GEN_PREFIX";

    @Override
    public String preCreate() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(REBATE_POLICY_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    @Override
    @Transactional
    public RebatePolicy create(RebatePolicy rebatePolicy) {
        RebatePolicy current = this.createForm(rebatePolicy);
        String tenantCode = TenantUtils.getTenantCode();
        this.rebatePolicyVoService.notifyCacheRefresh(tenantCode);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebatePolicy createForm(RebatePolicy rebatePolicy) {
        block11: {
            String prefix = rebatePolicy.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u8fd4\u5229\u653f\u7b56\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(REBATE_POLICY_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u8fd4\u5229\u653f\u7b56\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(REBATE_POLICY_GEN_PREFIX, prefix, prefix, 1L);
                    break block11;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u8fd4\u5229\u653f\u7b56\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
        Date now = new Date();
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = SecurityUtils.getUserAccount();
        rebatePolicy.setId(null);
        rebatePolicy.setCreateAccount(currentAccount);
        rebatePolicy.setCreateTime(now);
        rebatePolicy.setModifyAccount(currentAccount);
        rebatePolicy.setModifyTime(now);
        rebatePolicy.setTenantCode(tenantCode);
        rebatePolicy.setEffective(true);
        rebatePolicy.setValidStartTime(now);
        rebatePolicy.setValidEndTime(DateUtils.addYears((Date)now, (int)100));
        Validate.notNull((Object)rebatePolicy.getRebatePolicyType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Integer rebatePolicyType = rebatePolicy.getRebatePolicyType();
        if (rebatePolicyType == 1 || rebatePolicyType == 2) {
            rebatePolicy.setMaxTotalNumberRatio(BigDecimal.ZERO);
            rebatePolicy.setThresholdNumber(BigDecimal.ZERO);
            rebatePolicy.setMinNumberRebate(BigDecimal.ZERO);
        } else if (rebatePolicyType == 3) {
            rebatePolicy.setMaxTotalAmountRatio(BigDecimal.ZERO);
            rebatePolicy.setThresholdAmount(BigDecimal.ZERO);
            rebatePolicy.setMinAmountRebate(BigDecimal.ZERO);
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u8fd4\u5229\u653f\u7b56\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        this.saveValidation(rebatePolicy, false);
        rebatePolicy.setRebatePolicyCode(UUID.randomUUID().toString());
        this.rebatePolicyRepository.saveAndFlush((Object)rebatePolicy);
        Set<RebatePolicyCustomers> rebatePolicyCustomers = rebatePolicy.getCustomers();
        this.rebatePolicyCustomersRepository.saveAll(rebatePolicyCustomers);
        if (rebatePolicyType == 3) {
            Set<RebatePolicyProducts> rebatePolicyProducts = rebatePolicy.getProducts();
            this.rebatePolicyProductsRepository.saveAll(rebatePolicyProducts);
        }
        this.rebatePolicyRepository.flush();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String datecode = dateFormat.format(now);
        String codeUnKey = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, "_", tenantCode});
        String atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
        String rebatePolicyCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, atomicNumberValue});
        while (this.rebatePolicyRepository.findByRebatePolicyCodeAndTenantCode(rebatePolicyCode, tenantCode) != null) {
            atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
            rebatePolicyCode = StringUtils.join((Object[])new String[]{REBATE_CODE_PREFIX, datecode, atomicNumberValue});
        }
        rebatePolicy.setRebatePolicyCode(rebatePolicyCode);
        this.rebatePolicyRepository.saveAndFlush((Object)rebatePolicy);
        this.rebatePolicyVoService.notifyCacheRefresh(tenantCode);
        return rebatePolicy;
    }

    private void saveValidation(RebatePolicy rebatePolicy, boolean update) {
        String onTimeValue;
        Date now = new Date();
        String currentAccount = SecurityUtils.getUserAccount();
        if (!update) {
            onTimeValue = "\u6dfb\u52a0\u8fd4\u5229\u653f\u7b56\u65f6";
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)rebatePolicy.getId()), (String)(onTimeValue + "\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01"), (Object[])new Object[0]);
            rebatePolicy.setId(null);
        } else {
            onTimeValue = "\u4fee\u6539\u8fd4\u5229\u653f\u7b56\u65f6";
            rebatePolicy.setModifyAccount(currentAccount);
            rebatePolicy.setModifyTime(now);
            Validate.isTrue((!StringUtils.isBlank((CharSequence)rebatePolicy.getId()) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01"), (Object[])new Object[0]);
        }
        Validate.notNull((Object)((Object)rebatePolicy), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rebatePolicy.getRebatePolicyName(), (String)(onTimeValue + "\uff0c\u8fd4\u5229\u89c4\u5219\u653f\u7b56\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getMaxTotalAmountRatio(), (String)(onTimeValue + "\uff0c\uff08\u6700\u9ad8\uff09\u5355\u6b21\u53ef\u62b5\u6263\u7684\u8ba2\u5355\u5546\u54c1\u91d1\u989d\u4ef7\u503c\u6bd4\u4f8b\uff0c\u6700\u4f4e\u91cf\u4e3a0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getThresholdAmount(), (String)(onTimeValue + "\uff0c\u8ba2\u5355\u5546\u54c1\u4ef7\u503c\u7684\u6700\u4f4e\u95e8\u69db\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getMinAmountRebate(), (String)(onTimeValue + "\uff0c\u6bcf\u6b21\u6700\u5c11\u4f7f\u7528\u7684\u62b5\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getMaxTotalNumberRatio(), (String)(onTimeValue + "\uff0c\uff08\u6700\u9ad8\uff09\u5355\u6b21\u53ef\u62b5\u6263\u7684\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u6bd4\u4f8b\uff0c\u6700\u4f4e\u91cf\u4e3a0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getThresholdNumber(), (String)(onTimeValue + "\uff0c\u8ba2\u5355\u5546\u54c1\u4ef7\u503c\u7684\u6700\u4f4e\u95e8\u69db\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getMinNumberRebate(), (String)(onTimeValue + "\uff0c\u6bcf\u6b21\u6700\u5c11\u4f7f\u7528\u7684\u62b5\u6263\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getCustomerSelectionMethod(), (String)(onTimeValue + "\uff0c\u5ba2\u6237\u7684\u9009\u62e9\u65b9\u5f0f\uff1a1\uff1a\u901a\u8fc7\u8303\u56f4\u9009\u62e9\uff1b2\uff1a\u76f4\u63a5\u6307\u5b9a\u5ba2\u6237\uff1b3\uff1a\u5ba2\u6237\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rebatePolicy.getDescription(), (String)(onTimeValue + "\uff0c\u8fd4\u5229\u89c4\u5219\u653f\u7b56\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u586b\u5199\uff01"), (Object[])new Object[0]);
        Validate.isTrue((rebatePolicy.getRebatePolicyName() == null || rebatePolicy.getRebatePolicyName().length() < 128 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u89c4\u5219\u653f\u7b56\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebatePolicy.getClassifications() == null || rebatePolicy.getClassifications().length() < 255 ? 1 : 0) != 0, (String)"\u5f53\u6309\u7167\u5546\u54c1\u54c1\u724c\u6307\u5b9a\u65f6\uff0c\u5546\u54c1\u54c1\u724c\u7f16\u53f7\u88ab\u653e\u7f6e\u5728\u8fd9\u91cc,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((rebatePolicy.getCustomerSelectionValue() == null || rebatePolicy.getCustomerSelectionValue().length() < 255 ? 1 : 0) != 0, (String)"\u7528\u4e8e\u4e3a\u524d\u7aef\u8bb0\u5f55\u5ba2\u6237\u5728\u786e\u5b9a\u7684\u9009\u62e9\u65b9\u5f0f\u4e0b\uff0c\u4f7f\u7528\u7684\u8bbe\u5b9a\u503c\uff08json\u5b57\u7b26\u4e32\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Date validStartTime = rebatePolicy.getValidStartTime();
        Validate.notNull((Object)validStartTime, (String)(onTimeValue + "\uff0c\u8fd4\u5229\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Date validEndTime = rebatePolicy.getValidEndTime();
        Validate.notNull((Object)validEndTime, (String)(onTimeValue + "\uff0c\u8fd4\u5229\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        long validStartTimeValue = validStartTime.getTime();
        long validEndTimeValue = validEndTime.getTime();
        Validate.isTrue((validStartTimeValue < validEndTimeValue ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u8fd4\u5229\u8d77\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u8fd4\u5229\u622a\u6b62\u65f6\u95f4\uff01"), (Object[])new Object[0]);
        this.saveValidationForProducts(rebatePolicy, onTimeValue);
        this.saveValidationForCustomers(rebatePolicy, onTimeValue);
        this.validationIntersectionProductsAndCustomers(rebatePolicy, onTimeValue);
    }

    private void saveValidationForProducts(RebatePolicy rebatePolicy, String onTimeValue) {
        List productSpecifications;
        LinkedHashSet rebatePolicyProducts = null;
        if (rebatePolicy.getRebatePolicyType() == 1) {
            rebatePolicy.setProducts(null);
        }
        if (rebatePolicy.getRebatePolicyType() == 2) {
            Validate.notBlank((CharSequence)rebatePolicy.getClassifications(), (String)(onTimeValue + "\uff0c\u8bf7\u6307\u5b9a\u6b63\u786e\u7684\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\u5546\u54c1\u54c1\u724c\u7f16\u53f7\u4fe1\u606f!!"), (Object[])new Object[0]);
            ArrayList brandCodeList = Lists.newArrayList((Object[])StringUtils.split((String)rebatePolicy.getClassifications(), (String)","));
            productSpecifications = this.productSpecificationVoService.findByBrandCodeList((List)brandCodeList);
            if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                rebatePolicyProducts = Sets.newLinkedHashSet();
                rebatePolicy.setProducts(rebatePolicyProducts);
                for (ProductSpecificationVo productSpecificationItem : productSpecifications) {
                    ProductUnitVo basicUnit;
                    RebatePolicyProducts rebatePolicyProductItem = new RebatePolicyProducts();
                    rebatePolicyProductItem.setProductSpecificationCode(productSpecificationItem.getProductSpecificationCode());
                    rebatePolicyProductItem.setProductSpecificationName(productSpecificationItem.getProductSpecificationName());
                    ProductVo product = productSpecificationItem.getProduct();
                    if (product != null) {
                        rebatePolicyProductItem.setProductCode(product.getProductCode());
                        rebatePolicyProductItem.setProductName(product.getProductName());
                    }
                    if ((basicUnit = productSpecificationItem.getBasicUnit()) != null) {
                        rebatePolicyProductItem.setUnitCode(basicUnit.getUnitCode());
                        rebatePolicyProductItem.setUnitName(basicUnit.getUnitName());
                    }
                    rebatePolicyProductItem.setRebatePolicy(rebatePolicy);
                    rebatePolicyProductItem.setId(null);
                    rebatePolicyProducts.add(rebatePolicyProductItem);
                }
            }
        }
        if (rebatePolicy.getRebatePolicyType() == 3) {
            String unitCode;
            String productSpecificationCode;
            rebatePolicyProducts = rebatePolicy.getProducts();
            Validate.isTrue((!CollectionUtils.isEmpty(rebatePolicyProducts) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a!!"), (Object[])new Object[0]);
            List productSpecificationCodes = rebatePolicyProducts.stream().map(RebatePolicyProducts::getProductSpecificationCode).distinct().collect(Collectors.toList());
            Validate.isTrue((!CollectionUtils.isEmpty(productSpecificationCodes) && productSpecificationCodes.size() == rebatePolicyProducts.size() ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u6307\u5b9a\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList(productSpecificationCodes);
            Map<String, ProductSpecificationVo> productSpecificationMapping = productSpecifications.stream().collect(Collectors.toMap(ProductSpecificationVo::getProductSpecificationCode, item -> item));
            ArrayList pairList = Lists.newArrayList();
            int index = 1;
            for (RebatePolicyProducts rebatePolicyProductItem : rebatePolicyProducts) {
                String productCode = rebatePolicyProductItem.getProductCode();
                Validate.notBlank((CharSequence)productCode, (String)(onTimeValue + "\uff0c\u7b2c[%s]\u5546\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u672a\u6307\u5b9a\u5546\u54c1\u7f16\u7801!!"), (Object[])new Object[]{index});
                productSpecificationCode = rebatePolicyProductItem.getProductSpecificationCode();
                Validate.notBlank((CharSequence)productSpecificationCode, (String)(onTimeValue + "\uff0c\u7b2c[%s]\u5546\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u672a\u6307\u5b9a\u5546\u54c1\u89c4\u683c\u7f16\u7801!!"), (Object[])new Object[]{index});
                unitCode = rebatePolicyProductItem.getUnitCode();
                Validate.notBlank((CharSequence)unitCode, (String)(onTimeValue + "\uff0c\u7b2c[%s]\u5546\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u672a\u6307\u5b9a\u5546\u54c1\u5355\u4f4d\u7f16\u7801!!"), (Object[])new Object[]{index});
                ProductSpecificationVo productSpecification = productSpecificationMapping.get(productSpecificationCode);
                Validate.notNull((Object)productSpecification, (String)(onTimeValue + "\uff0c\u7b2c[%s]\u5546\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u672a\u88ab\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{index});
                ProductVo product = productSpecification.getProduct();
                Validate.notNull((Object)product, (String)(onTimeValue + "\uff0c\u7b2c[%s]\u5546\u54c1\u4fe1\u606f\uff0c\u672a\u88ab\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{index});
                String productName = product.getProductName();
                rebatePolicyProductItem.setProductName(productName);
                rebatePolicyProductItem.setRebatePolicy(rebatePolicy);
                rebatePolicyProductItem.setId(null);
                Pair pair = Pair.of((Object)productSpecificationCode, (Object)unitCode);
                pairList.add(pair);
                ++index;
            }
            ProductSpecificationAndUnitDto productSpecificationAndUnitMapping = this.productActionService.findSpecNameAndUnitName((List)pairList);
            for (RebatePolicyProducts rebatePolicyProductItem : rebatePolicyProducts) {
                productSpecificationCode = rebatePolicyProductItem.getProductSpecificationCode();
                unitCode = rebatePolicyProductItem.getUnitCode();
                ProductSpecificationAndUnitDto productSpecificationAndUnit = productSpecificationAndUnitMapping.getProductSpecificationAndUnitDto(productSpecificationCode, unitCode);
                Validate.notNull((Object)productSpecificationAndUnit, (String)(onTimeValue + "\uff0c\u4e3a\u627e\u5230\u6307\u5b9a\u7684\u5546\u54c1\u89c4\u683c[%s]-\u5355\u4f4d\u89c4\u683c[%s]\u7ec4\u5408\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{productSpecificationCode, unitCode});
                rebatePolicyProductItem.setProductSpecificationName(productSpecificationAndUnit.getProductSpecificationName());
                rebatePolicyProductItem.setUnitName(productSpecificationAndUnit.getUnitName());
            }
        }
    }

    private void saveValidationForCustomers(RebatePolicy rebatePolicy, String onTimeValue) {
        Integer customerSelectionMethod = rebatePolicy.getCustomerSelectionMethod();
        Validate.notNull((Object)customerSelectionMethod, (String)(onTimeValue + "\uff0c\u9700\u8981\u7ed9\u5b9a\u5f53\u524d\u5ba2\u6237\u7684\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        HashSet rebatePolicyCustomers = null;
        if (customerSelectionMethod == 1) {
            List queryCustomers;
            String customerSelectionValue = rebatePolicy.getCustomerSelectionValue();
            JSONObject customerSelectionJson = null;
            try {
                customerSelectionJson = JSON.parseObject((String)customerSelectionValue);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            HashMap conditions = Maps.newHashMap();
            Boolean enabledState = true;
            conditions.put("enabledState", enabledState);
            ArrayList levelCodes = null;
            String levelCodeValues = customerSelectionJson.getString("levelCodes");
            if (!StringUtils.isBlank((CharSequence)levelCodeValues)) {
                levelCodes = Lists.newArrayList((Object[])StringUtils.split((String)","));
                conditions.put("levelCodes", levelCodes);
            }
            ArrayList categoryCodes = null;
            String categoryCodeValues = customerSelectionJson.getString("categoryCodes");
            if (!StringUtils.isBlank((CharSequence)categoryCodeValues)) {
                categoryCodes = Lists.newArrayList((Object[])StringUtils.split((String)","));
                conditions.put("categoryCodes", categoryCodes);
            }
            ArrayList saleAreaCodes = null;
            String saleAreaCodeValues = customerSelectionJson.getString("saleAreaCodes");
            if (!StringUtils.isBlank((CharSequence)saleAreaCodeValues)) {
                saleAreaCodes = Lists.newArrayList((Object[])StringUtils.split((String)","));
                conditions.put("saleAreaCodes", saleAreaCodes);
            }
            if (!CollectionUtils.isEmpty((Collection)(queryCustomers = this.customerService.findAllByConditions((Map)conditions)))) {
                rebatePolicyCustomers = Sets.newHashSet();
                for (Customer queryCustomer : queryCustomers) {
                    RebatePolicyCustomers rebatePolicyCustomer = new RebatePolicyCustomers();
                    rebatePolicyCustomer.setCustomerCode(queryCustomer.getCustomerCode());
                    rebatePolicyCustomer.setId(null);
                    rebatePolicyCustomer.setRebatePolicy(rebatePolicy);
                    rebatePolicyCustomers.add(rebatePolicyCustomer);
                }
            }
        } else if (customerSelectionMethod == 2) {
            rebatePolicyCustomers = rebatePolicy.getCustomers();
            Validate.isTrue((!CollectionUtils.isEmpty(rebatePolicyCustomers) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u81f3\u5c11\u4fdd\u8bc1\u6709\u4e00\u4e2a\u80fd\u591f\u53c2\u4e0e\u8fd4\u5229\u653f\u7b56\u7684\u5ba2\u6237\u4fe1\u606f(\u6682\u4e0d\u652f\u6301\u5ba2\u6237\u6807\u7b7e\u9009\u62e9\u5ba2\u6237)"), (Object[])new Object[0]);
            for (RebatePolicyCustomers rebatePolicyCustomerItem : rebatePolicyCustomers) {
                Validate.notBlank((CharSequence)rebatePolicyCustomerItem.getCustomerCode(), (String)(onTimeValue + "\uff0c\u81f3\u5c11\u53d1\u73b0\u4e00\u6761\u5ba2\u6237\u4fe1\u606f\u6ca1\u6709\u5ba2\u6237\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u6a21\u5757\u4e2d\u7684\u5ba2\u6237\u4fe1\u606f!!"), (Object[])new Object[0]);
                rebatePolicyCustomerItem.setId(null);
                rebatePolicyCustomerItem.setRebatePolicy(rebatePolicy);
            }
            List customerCodes = rebatePolicyCustomers.stream().map(RebatePolicyCustomers::getCustomerCode).collect(Collectors.toList());
            List customers = this.customerService.findByTenantCodeAndCustomerCodes(tenantCode, customerCodes);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)customers) && customers.size() == customerCodes.size() ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u81f3\u5c11\u53d1\u73b0\u4e00\u6761\u5ba2\u6237\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u6a21\u5757\u4e2d\u7684\u5ba2\u6237\u4fe1\u606f!!"), (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException(onTimeValue + "\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u5ba2\u6237\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!");
        }
        rebatePolicy.setCustomers(rebatePolicyCustomers);
        rebatePolicy.setCustomerNumber(rebatePolicyCustomers.size());
    }

    private void validationIntersectionProductsAndCustomers(RebatePolicy rebatePolicy, String onTimeValue) {
        Integer rebatePolicyType = rebatePolicy.getRebatePolicyType();
        String tenantCode = TenantUtils.getTenantCode();
        Set<RebatePolicyVo> exsitsRebatePolicies = this.rebatePolicyVoService.findDetailsByEffectiveAndRebateType(tenantCode, false, rebatePolicy.getRebatePolicyType());
        if (CollectionUtils.isEmpty(exsitsRebatePolicies)) {
            return;
        }
        HashSet repeatRebatePolicis = Sets.newHashSet();
        if (rebatePolicyType == 1) {
            for (RebatePolicyVo exsitRebatePolicy : exsitsRebatePolicies) {
                if (!StringUtils.isBlank((CharSequence)rebatePolicy.getRebatePolicyCode()) && StringUtils.equals((CharSequence)rebatePolicy.getRebatePolicyCode(), (CharSequence)exsitRebatePolicy.getRebatePolicyCode())) continue;
                repeatRebatePolicis.add(exsitRebatePolicy);
            }
        }
        if (rebatePolicyType == 2) {
            String sourceClassifications = rebatePolicy.getClassifications();
            HashSet sourceBrandCodes = Sets.newHashSet((Object[])StringUtils.split((String)sourceClassifications, (String)","));
            for (RebatePolicyVo exsitRebatePolicy : exsitsRebatePolicies) {
                HashSet exsitBrandCodes;
                String exsitClassifications;
                if (!StringUtils.isBlank((CharSequence)rebatePolicy.getRebatePolicyCode()) && StringUtils.equals((CharSequence)rebatePolicy.getRebatePolicyCode(), (CharSequence)exsitRebatePolicy.getRebatePolicyCode()) || StringUtils.isBlank((CharSequence)(exsitClassifications = exsitRebatePolicy.getClassifications())) || Sets.intersection((Set)sourceBrandCodes, (Set)(exsitBrandCodes = Sets.newHashSet((Object[])exsitClassifications.split(",")))).isEmpty()) continue;
                repeatRebatePolicis.add(exsitRebatePolicy);
            }
        }
        if (rebatePolicyType == 3) {
            Set<RebatePolicyProducts> sourceRebatePolicyProducts = rebatePolicy.getProducts();
            if (CollectionUtils.isEmpty(sourceRebatePolicyProducts)) {
                return;
            }
            Set sourceProductSpecificationCodes = sourceRebatePolicyProducts.stream().map(RebatePolicyProducts::getProductSpecificationCode).collect(Collectors.toSet());
            for (RebatePolicyVo exsitRebatePolicy : exsitsRebatePolicies) {
                Set exsitProductSpecificationCodes;
                Set<RebatePolicyProductsVo> exsitRebatePolicyProducts;
                if (!StringUtils.isBlank((CharSequence)rebatePolicy.getRebatePolicyCode()) && StringUtils.equals((CharSequence)rebatePolicy.getRebatePolicyCode(), (CharSequence)exsitRebatePolicy.getRebatePolicyCode()) || CollectionUtils.isEmpty(exsitRebatePolicyProducts = exsitRebatePolicy.getProducts()) || Sets.intersection(sourceProductSpecificationCodes, exsitProductSpecificationCodes = exsitRebatePolicyProducts.stream().map(RebatePolicyProductsVo::getProductSpecificationCode).collect(Collectors.toSet())).isEmpty()) continue;
                repeatRebatePolicis.add(exsitRebatePolicy);
            }
        }
        if (CollectionUtils.isEmpty((Collection)repeatRebatePolicis)) {
            return;
        }
        HashSet targetRebatePolicyCustomerCodes = Sets.newHashSet();
        Set<RebatePolicyCustomers> exsitsRebatePolicyCustomers = rebatePolicy.getCustomers();
        if (CollectionUtils.isEmpty(exsitsRebatePolicyCustomers)) {
            return;
        }
        Set sourceRebatePolicyCustomerCodes = exsitsRebatePolicyCustomers.stream().map(RebatePolicyCustomers::getCustomerCode).collect(Collectors.toSet());
        for (RebatePolicyVo repeatRebatePolicy : repeatRebatePolicis) {
            Set<RebatePolicyCustomersVo> rebatePolicyCustomerItems = repeatRebatePolicy.getCustomers();
            if (CollectionUtils.isEmpty(rebatePolicyCustomerItems)) continue;
            targetRebatePolicyCustomerCodes.addAll(rebatePolicyCustomerItems.stream().map(RebatePolicyCustomersVo::getCustomerCode).collect(Collectors.toSet()));
            Sets.SetView intersectionResults = Sets.intersection(sourceRebatePolicyCustomerCodes, (Set)targetRebatePolicyCustomerCodes);
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)intersectionResults), (String)(onTimeValue + "\uff0c\u53d1\u73b0\u3010%s\u3011\u8fd4\u5229\u653f\u7b56\u4e2d\uff0c\u5305\u542b\u76f8\u540c\u7684\u5ba2\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{repeatRebatePolicy.getRebatePolicyName()});
        }
    }

    @Override
    @Transactional
    public RebatePolicy update(RebatePolicy rebatePolicy) {
        RebatePolicy current = this.updateForm(rebatePolicy);
        String tenantCode = TenantUtils.getTenantCode();
        this.rebatePolicyVoService.notifyCacheRefresh(tenantCode);
        return current;
    }

    private RebatePolicy updateForm(RebatePolicy rebatePolicy) {
        Date now = new Date();
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = SecurityUtils.getUserAccount();
        Validate.notNull((Object)((Object)rebatePolicy), (String)"\u4fee\u6539\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u4fee\u6539\u7684\u8fd4\u5229\u653f\u7b56\u4fe1\u606f\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09\uff0c\u8bf7\u53c2\u89c1\u6587\u6863!!", (Object[])new Object[0]);
        rebatePolicy.setModifyAccount(currentAccount);
        rebatePolicy.setModifyTime(now);
        rebatePolicy.setTenantCode(tenantCode);
        Integer rebatePolicyType = rebatePolicy.getRebatePolicyType();
        Validate.notNull((Object)rebatePolicyType, (String)"\u8fd4\u5229\u653f\u7b56\u7c7b\u578b\u5fc5\u987b\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String rebatePolicyCode = rebatePolicy.getRebatePolicyCode();
        Validate.notBlank((CharSequence)rebatePolicyCode, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u8fd4\u5229\u653f\u7b56\u6709\u6b63\u786e\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RebatePolicy currentRebatePolicy = this.rebatePolicyRepository.findByRebatePolicyCodeAndTenantCode(rebatePolicyCode, tenantCode);
        Validate.notNull((Object)((Object)currentRebatePolicy), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u8fd4\u5229\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)rebatePolicy.getRebatePolicyType(), (String)"\u4fee\u6539\u65f6\uff0c\u8fd4\u5229\u7c7b\u578b\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((rebatePolicy.getRebatePolicyType().intValue() == currentRebatePolicy.getRebatePolicyType().intValue() ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u8fd4\u5229\u7c7b\u578b\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539!", (Object[])new Object[0]);
        String rebatePolicyId = currentRebatePolicy.getId();
        rebatePolicy.setId(rebatePolicyId);
        this.rebatePolicyCustomersRepository.deleteByRebatePolicy(rebatePolicyId);
        this.rebatePolicyProductsRepository.deleteByRebatePolicy(rebatePolicyId);
        if (rebatePolicyType == 1 || rebatePolicyType == 2) {
            rebatePolicy.setMaxTotalNumberRatio(BigDecimal.ZERO);
            rebatePolicy.setThresholdNumber(BigDecimal.ZERO);
            rebatePolicy.setMinNumberRebate(BigDecimal.ZERO);
            Validate.isTrue((rebatePolicy.getMaxTotalAmountRatio() != null && rebatePolicy.getMaxTotalAmountRatio().floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u5355\u6b21\u53ef\u62b5\u6263\u7684\u8ba2\u5355\u5546\u54c1\u91d1\u989d\u4ef7\u503c\u6bd4\u4f8b\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.isTrue((rebatePolicy.getThresholdAmount() != null && rebatePolicy.getThresholdAmount().floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u4ef7\u503c\u7684\u6700\u4f4e\u91d1\u989d\u95e8\u69db\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.isTrue((rebatePolicy.getMinAmountRebate() != null && rebatePolicy.getMinAmountRebate().floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u6bcf\u6b21\u6700\u5c11\u4f7f\u7528\u7684\u62b5\u6263\u91d1\u989d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        } else if (rebatePolicyType == 3) {
            rebatePolicy.setMaxTotalAmountRatio(BigDecimal.ZERO);
            rebatePolicy.setThresholdAmount(BigDecimal.ZERO);
            rebatePolicy.setMinAmountRebate(BigDecimal.ZERO);
            Validate.isTrue((rebatePolicy.getMaxTotalNumberRatio() != null && rebatePolicy.getMaxTotalNumberRatio().floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u5355\u6b21\u53ef\u62b5\u6263\u7684\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u6bd4\u4f8b\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.isTrue((rebatePolicy.getThresholdNumber() != null && rebatePolicy.getThresholdNumber().floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u7684\u6700\u4f4e\u6570\u91cf\u95e8\u69db\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.isTrue((rebatePolicy.getMinNumberRebate() != null && rebatePolicy.getMinNumberRebate().floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u6bcf\u6b21\u6700\u5c11\u4f7f\u7528\u7684\u62b5\u6263\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u8fd4\u5229\u653f\u7b56\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        rebatePolicy.setValidEndTime(currentRebatePolicy.getValidEndTime());
        rebatePolicy.setValidStartTime(currentRebatePolicy.getValidStartTime());
        rebatePolicy.setEffective(currentRebatePolicy.getEffective());
        this.saveValidation(rebatePolicy, true);
        currentRebatePolicy.setRebatePolicyName(rebatePolicy.getRebatePolicyName());
        currentRebatePolicy.setMaxTotalAmountRatio(rebatePolicy.getMaxTotalAmountRatio());
        currentRebatePolicy.setThresholdAmount(rebatePolicy.getThresholdAmount());
        currentRebatePolicy.setMinAmountRebate(rebatePolicy.getMinAmountRebate());
        currentRebatePolicy.setMaxTotalNumberRatio(rebatePolicy.getMaxTotalNumberRatio());
        currentRebatePolicy.setThresholdNumber(rebatePolicy.getThresholdNumber());
        currentRebatePolicy.setMinNumberRebate(rebatePolicy.getMinNumberRebate());
        currentRebatePolicy.setClassifications(rebatePolicy.getClassifications());
        currentRebatePolicy.setCustomerSelectionMethod(rebatePolicy.getCustomerSelectionMethod());
        currentRebatePolicy.setCustomerSelectionValue(rebatePolicy.getCustomerSelectionValue());
        currentRebatePolicy.setCustomerNumber(rebatePolicy.getCustomerNumber());
        currentRebatePolicy.setDescription(rebatePolicy.getDescription());
        this.rebatePolicyRepository.saveAndFlush((Object)currentRebatePolicy);
        Set<RebatePolicyCustomers> rebatePolicyCustomers = rebatePolicy.getCustomers();
        this.rebatePolicyCustomersRepository.saveAll(rebatePolicyCustomers);
        this.rebatePolicyRepository.flush();
        if (rebatePolicyType == 2 || rebatePolicyType == 3) {
            Set<RebatePolicyProducts> rebatePolicyProducts = rebatePolicy.getProducts();
            this.rebatePolicyProductsRepository.saveAll(rebatePolicyProducts);
        }
        this.rebatePolicyVoService.notifyCacheRefresh(tenantCode);
        return currentRebatePolicy;
    }

    @Override
    @Transactional
    public void invalid(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4e0b\u67b6\u8fd4\u5229\u653f\u7b56\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        RebatePolicy currentRebatePolicy = this.rebatePolicyRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentRebatePolicy), (String)"\u4e0b\u67b6\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u8fd4\u5229\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentRebatePolicy.setEffective(false);
        this.rebatePolicyRepository.save((Object)currentRebatePolicy);
        String tenantCode = TenantUtils.getTenantCode();
        this.rebatePolicyVoService.notifyCacheRefresh(tenantCode);
    }

    @Override
    @Transactional
    public void effective(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u91cd\u65b0\u4e0a\u67b6\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u8fd4\u5229\u653f\u7b56\u6280\u672f\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RebatePolicy currentRebatePolicy = this.rebatePolicyRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentRebatePolicy), (String)"\u91cd\u65b0\u4e0a\u67b6\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u8fd4\u5229\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validationIntersectionProductsAndCustomers(currentRebatePolicy, "\u91cd\u65b0\u4e0a\u67b6\u65f6");
        currentRebatePolicy.setEffective(true);
        this.rebatePolicyRepository.save((Object)currentRebatePolicy);
        String tenantCode = TenantUtils.getTenantCode();
        this.rebatePolicyVoService.notifyCacheRefresh(tenantCode);
    }

    @Override
    public Page<RebatePolicy> findByConditions(Pageable pageable, RebatePolicyDto conditions) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if (conditions == null) {
            conditions = new RebatePolicyDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        conditions.setTenantCode(tenantCode);
        Page<RebatePolicy> results = this.rebatePolicyRepository.findByCondition(pageable, conditions);
        return results;
    }
}

