/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.entity.RebatePolicy;
import com.bizunited.empower.business.policy.entity.RebatePolicyCustomers;
import com.bizunited.empower.business.policy.repository.RebatePolicyRepository;
import com.bizunited.empower.business.policy.service.RebatePolicyVoService;
import com.bizunited.empower.business.policy.vo.RebatePolicyCustomersVo;
import com.bizunited.empower.business.policy.vo.RebatePolicyProductsVo;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.empower.business.product.entity.Product;
import com.bizunited.empower.business.product.entity.ProductBrand;
import com.bizunited.empower.business.product.entity.ProductCategory;
import com.bizunited.empower.business.product.service.ProductBrandService;
import com.bizunited.empower.business.product.service.ProductService;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RebatePolicyVoServiceImpl
implements RebatePolicyVoService {
    @Autowired
    private RebatePolicyRepository rebatePolicyRepository;
    @Autowired
    private ProductBrandService productBrandService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private ProductService productService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private Redisson redisson;
    private static Map<String, Map<String, RebatePolicyVo>> rebatePolicyCacheMapping = Maps.newConcurrentMap();
    private static Map<String, ReentrantReadWriteLock> rebatePolicyLockMapping = Maps.newConcurrentMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(RebatePolicyVoServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.WriteLock getWriteLockByTenantCode(String tenantCode) {
        while (rebatePolicyLockMapping.get(tenantCode) == null) {
            Map<String, ReentrantReadWriteLock> map = rebatePolicyLockMapping;
            synchronized (map) {
                if (rebatePolicyLockMapping.get(tenantCode) == null) {
                    rebatePolicyLockMapping.put(tenantCode, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = rebatePolicyLockMapping.get(tenantCode);
        return lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.ReadLock getReadLockByTenantCode(String tenantCode) {
        while (rebatePolicyLockMapping.get(tenantCode) == null) {
            Map<String, ReentrantReadWriteLock> map = rebatePolicyLockMapping;
            synchronized (map) {
                if (rebatePolicyLockMapping.get(tenantCode) == null) {
                    rebatePolicyLockMapping.put(tenantCode, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = rebatePolicyLockMapping.get(tenantCode);
        return lock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshCache(String tenantCode, boolean hasReadLock) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        Date now = new Date();
        Set<RebatePolicy> rebatePolicies = this.rebatePolicyRepository.findByValidTimeAndPolicyEffective(tenantCode, now);
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByTenantCode(tenantCode);
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        try {
            if (hasReadLock) {
                readLock.unlock();
            }
            writeLock.lockInterruptibly();
            LOGGER.info("rebate policy cache refreshing ..... ");
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        try {
            if (CollectionUtils.isEmpty(rebatePolicies)) {
                rebatePolicyCacheMapping.put(tenantCode, Maps.newConcurrentMap());
                return;
            }
            ConcurrentMap rebatePolicyDetailMapping = rebatePolicyCacheMapping.get(tenantCode);
            if (rebatePolicyDetailMapping == null) {
                rebatePolicyDetailMapping = Maps.newConcurrentMap();
                rebatePolicyCacheMapping.put(tenantCode, rebatePolicyDetailMapping);
            }
            for (RebatePolicy rebatePolicyItem : rebatePolicies) {
                RebatePolicyVo rebatePolicyDetail = this.findDetailsByCodeFromRepository(rebatePolicyItem.getRebatePolicyCode());
                if (rebatePolicyDetail == null) continue;
                rebatePolicyDetailMapping.put(rebatePolicyDetail.getRebatePolicyCode(), rebatePolicyDetail);
            }
        }
        finally {
            writeLock.unlock();
            if (hasReadLock) {
                readLock.lock();
            }
        }
    }

    @Override
    public void clearCache(String tenantCode) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByTenantCode(tenantCode);
        try {
            writeLock.lock();
            if (rebatePolicyCacheMapping != null) {
                rebatePolicyCacheMapping.remove(tenantCode);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void notifyCacheRefresh(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        RTopic topic = this.redisson.getTopic("_REBATE_POLICY_NOTIFY");
        topic.publish((Object)tenantCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebatePolicyVo findDetailsByCode(String rebatePolicCode) {
        if (StringUtils.isBlank((CharSequence)rebatePolicCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        Date now = new Date();
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            Map<String, RebatePolicyVo> rebatePolicyDetailMapping = rebatePolicyCacheMapping.get(tenantCode);
            if (rebatePolicyDetailMapping == null) {
                this.doRefreshCache(tenantCode, true);
                rebatePolicyDetailMapping = rebatePolicyCacheMapping.get(tenantCode);
            }
            if (rebatePolicyDetailMapping.isEmpty()) {
                RebatePolicyVo rebatePolicyVo = null;
                return rebatePolicyVo;
            }
            RebatePolicyVo currentRebatePolicyVo = rebatePolicyDetailMapping.get(rebatePolicCode);
            if (currentRebatePolicyVo != null) {
                RebatePolicyVo rebatePolicyVo = currentRebatePolicyVo;
                return rebatePolicyVo;
            }
            RebatePolicy rRebatePolicy = this.rebatePolicyRepository.findByRebatePolicyCodeAndTenantCode(rebatePolicCode, tenantCode);
            if (rRebatePolicy == null) {
                RebatePolicyVo rebatePolicyVo = null;
                return rebatePolicyVo;
            }
            if (!rRebatePolicy.getEffective().booleanValue() || now.getTime() > rRebatePolicy.getValidEndTime().getTime()) {
                RebatePolicyVo result;
                RebatePolicyVo rebatePolicyVo = result = this.findDetailsByCodeFromRepository(rebatePolicCode);
                return rebatePolicyVo;
            }
        }
        finally {
            readLock.unlock();
        }
        LOGGER.warn("====== \u79df\u6237[" + tenantCode + "]\u7f13\u5b58\u7684\u8fd4\u5229\u653f\u7b56\u4fe1\u606f\uff0c\u548c\u8fd4\u5229\u653f\u7b56\u5b9e\u9645\u4fe1\u606f\u4e0d\u540c\u6b65\uff0c\u8bf7\u68c0\u67e5!![rebatePolicCode = " + rebatePolicCode + "]");
        this.doRefreshCache(tenantCode, false);
        RebatePolicyVo result = this.findDetailsByCode(rebatePolicCode);
        return result;
    }

    private RebatePolicyVo findDetailsByCodeFromRepository(String rebatePolicyCode) {
        ArrayList brandCodes;
        List productBrands;
        String tenantCode = TenantUtils.getTenantCode();
        RebatePolicy rebatePolicy = this.rebatePolicyRepository.findByDetailsRebatePolicyCode(rebatePolicyCode, tenantCode);
        if (rebatePolicy == null) {
            return null;
        }
        RebatePolicyVo rebatePolicyVo = (RebatePolicyVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rebatePolicy, RebatePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products"}));
        Set<RebatePolicyCustomers> rebatePolicyCustomers = rebatePolicy.getCustomers();
        if (!CollectionUtils.isEmpty(rebatePolicyCustomers)) {
            List customerCodes = rebatePolicyCustomers.stream().map(RebatePolicyCustomers::getCustomerCode).collect(Collectors.toList());
            List customers = this.customerService.findDetailsByTenantCodeAndCustomerCodes(tenantCode, customerCodes);
            LinkedHashSet customerVos = Sets.newLinkedHashSet((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)customers, Customer.class, RebatePolicyCustomersVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"customerCategory", "customerLevel", "salesArea"}));
            rebatePolicyVo.setCustomers(customerVos);
        }
        Set<RebatePolicyProductsVo> rebatePolicyProducts = rebatePolicyVo.getProducts();
        if (rebatePolicyVo.getRebatePolicyType() == 3 && !CollectionUtils.isEmpty(rebatePolicyProducts)) {
            Map<String, RebatePolicyProductsVo> rebatePolicyProductMapping = rebatePolicyProducts.stream().collect(Collectors.toMap(RebatePolicyProductsVo::getProductSpecificationCode, item -> item));
            ArrayList<String> productSpecificationCodes = new ArrayList<String>(rebatePolicyProductMapping.keySet());
            List productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList(productSpecificationCodes);
            for (ProductSpecificationVo productSpecificationVoItem : productSpecifications) {
                ProductBrand productBrand;
                RebatePolicyProductsVo rebatePolicyProduct = rebatePolicyProductMapping.get(productSpecificationVoItem.getProductSpecificationCode());
                if (rebatePolicyProduct == null) continue;
                rebatePolicyProduct.setMainImageName(productSpecificationVoItem.getMainImageName());
                rebatePolicyProduct.setMainImagePath(productSpecificationVoItem.getMainImagePath());
                ProductVo productVo = productSpecificationVoItem.getProduct();
                Product product = this.productService.findById(productVo.getId());
                if (product == null) continue;
                ProductCategory productCategory = product.getProductCategory();
                if (productCategory != null) {
                    rebatePolicyProduct.setCategoryCode(productCategory.getCode());
                    rebatePolicyProduct.setCategoryName(productCategory.getName());
                }
                if ((productBrand = product.getProductBrand()) == null) continue;
                rebatePolicyProduct.setProductBrandCode(productBrand.getBrandCode());
                rebatePolicyProduct.setProductBrandName(productBrand.getBrandName());
            }
        }
        String classifications = rebatePolicyVo.getClassifications();
        if (rebatePolicyVo.getRebatePolicyType() == 2 && !StringUtils.isBlank((CharSequence)classifications) && !CollectionUtils.isEmpty((Collection)(productBrands = this.productBrandService.findByCodeList((List)(brandCodes = Lists.newArrayList((Object[])classifications.split(","))))))) {
            rebatePolicyVo.setClassificationNames(StringUtils.join((Iterable)productBrands.stream().map(ProductBrand::getBrandName).collect(Collectors.toList()), (String)","));
        }
        return rebatePolicyVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RebatePolicyVo> findDetailsByEffectiveAndRebateType(String tenantCode, boolean processing, Integer rebateType) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || rebateType == null) {
            return null;
        }
        Date now = new Date();
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            Map<String, RebatePolicyVo> rebatePolicyDetailMapping = rebatePolicyCacheMapping.get(tenantCode);
            if (rebatePolicyDetailMapping == null) {
                this.doRefreshCache(tenantCode, true);
                rebatePolicyDetailMapping = rebatePolicyCacheMapping.get(tenantCode);
            }
            if (rebatePolicyDetailMapping.isEmpty()) {
                Set<RebatePolicyVo> set = null;
                return set;
            }
            List effectiveRebatePolicyVos = !processing ? rebatePolicyDetailMapping.values().stream().filter(item -> item.getEffective() != false && item.getRebatePolicyType().intValue() == rebateType.intValue() && item.getValidEndTime().getTime() > now.getTime()).sorted((source, target) -> (int)(source.getValidStartTime().getTime() - target.getValidStartTime().getTime())).collect(Collectors.toList()) : rebatePolicyDetailMapping.values().stream().filter(item -> item.getEffective() != false && item.getRebatePolicyType().intValue() == rebateType.intValue() && item.getValidEndTime().getTime() > now.getTime() && item.getValidStartTime().getTime() < now.getTime()).sorted((source, target) -> (int)(source.getValidStartTime().getTime() - target.getValidStartTime().getTime())).collect(Collectors.toList());
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(effectiveRebatePolicyVos);
            return linkedHashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RebatePolicyVo> findDetailsByEffectiveAndCustomerCode(String tenantCode, boolean processing, String customerCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        Date now = new Date();
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            Map<String, RebatePolicyVo> rebatePolicyDetailMapping = rebatePolicyCacheMapping.get(tenantCode);
            if (rebatePolicyDetailMapping == null) {
                this.doRefreshCache(tenantCode, true);
                rebatePolicyDetailMapping = rebatePolicyCacheMapping.get(tenantCode);
            }
            if (rebatePolicyDetailMapping.isEmpty()) {
                Set<RebatePolicyVo> set = null;
                return set;
            }
            List effectiveRebatePolicys = !processing ? rebatePolicyDetailMapping.values().stream().filter(item -> item.getEffective() != false && item.getValidEndTime().getTime() > now.getTime()).sorted((source, target) -> (int)(source.getValidStartTime().getTime() - target.getValidStartTime().getTime())).collect(Collectors.toList()) : rebatePolicyDetailMapping.values().stream().filter(item -> item.getEffective() != false && item.getValidEndTime().getTime() > now.getTime() && item.getValidStartTime().getTime() < now.getTime()).sorted((source, target) -> (int)(source.getValidStartTime().getTime() - target.getValidStartTime().getTime())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(effectiveRebatePolicys)) {
                Set<RebatePolicyVo> set = null;
                return set;
            }
            block7: for (int index = 0; index < effectiveRebatePolicys.size(); ++index) {
                RebatePolicyVo effectiveRebatePolicy = (RebatePolicyVo)((Object)effectiveRebatePolicys.get(index));
                Set<RebatePolicyCustomersVo> rebatePolicyCustomers = effectiveRebatePolicy.getCustomers();
                if (CollectionUtils.isEmpty(rebatePolicyCustomers)) {
                    effectiveRebatePolicys.remove(index);
                    --index;
                    continue;
                }
                for (RebatePolicyCustomersVo rebatePolicyCustomer : rebatePolicyCustomers) {
                    if (!StringUtils.equals((CharSequence)rebatePolicyCustomer.getCustomerCode(), (CharSequence)customerCode)) continue;
                    continue block7;
                }
                effectiveRebatePolicys.remove(index);
                --index;
            }
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(effectiveRebatePolicys);
            return linkedHashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Set<RebatePolicyVo> findDetailsByEffectiveAndCustomerCodesAndProductSpecificationCodes(String tenantCode, boolean processing, Integer rebateType, String customerCode, String productSpecificationCode) {
        if (StringUtils.isBlank((CharSequence)productSpecificationCode)) {
            return null;
        }
        Set<RebatePolicyVo> rebatePolicies = this.findDetailsByEffectiveAndRebateType(tenantCode, processing, rebateType);
        if (CollectionUtils.isEmpty(rebatePolicies)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (RebatePolicyVo rebatePolicyItem : rebatePolicies) {
            long matchCount;
            Set<RebatePolicyProductsVo> rebatePolicyProducts = rebatePolicyItem.getProducts();
            if (CollectionUtils.isEmpty(rebatePolicyProducts) || (matchCount = rebatePolicyProducts.stream().filter(item -> StringUtils.equals((CharSequence)item.getProductSpecificationCode(), (CharSequence)productSpecificationCode)).count()) <= 0L) continue;
            result.add(rebatePolicyItem);
        }
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        return Sets.newLinkedHashSet((Iterable)result);
    }
}

