/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.policy.entity.SalePolicyResultProducts;
import com.bizunited.empower.business.policy.repository.SalePolicyResultProductsRepository;
import com.bizunited.empower.business.policy.service.SalePolicyResultProductsService;
import com.bizunited.empower.business.policy.vo.SalePolicyResultProductsVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SalePolicyResultProductsServiceImpl")
public class SalePolicyResultProductsServiceImpl
implements SalePolicyResultProductsService {
    @Autowired
    private SalePolicyResultProductsRepository salePolicyResultProductsRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Set<SalePolicyResultProductsVo> findByRelevanceCode(String relevanceCode) {
        Set<SalePolicyResultProducts> resultProducts = this.salePolicyResultProductsRepository.findByRelevanceCode(relevanceCode, TenantUtils.getTenantCode());
        Set resultProductsVos = (Set)this.nebulaToolkitService.copyCollectionByWhiteList(resultProducts, SalePolicyResultProducts.class, SalePolicyResultProductsVo.class, HashSet.class, ArrayList.class, new String[]{"salePolicyResult"});
        return resultProductsVos;
    }

    @Override
    public Set<SalePolicyResultProductsVo> findByTenantCodeAndSalePolicyCodeAndSpecificationProductCode(String salePolicyCode, String specificationProductCode) {
        String tenantCode = TenantUtils.getTenantCode();
        Set<SalePolicyResultProducts> resultProducts = this.salePolicyResultProductsRepository.findByTenantCodeAndSalePolicyCodeAndSpecificationProductCode(tenantCode, salePolicyCode, specificationProductCode);
        Set resultProductsVos = (Set)this.nebulaToolkitService.copyCollectionByWhiteList(resultProducts, SalePolicyResultProducts.class, SalePolicyResultProductsVo.class, HashSet.class, ArrayList.class, new String[]{"salePolicyResult"});
        return resultProductsVos;
    }

    @Override
    public Set<SalePolicyResultProductsVo> findByTenantCodeAndSalePolicyCodeAndSpecificationProductCodeAndCustomerCode(String salePolicyCode, String specificationProductCode, String customerCode) {
        String tenantCode = TenantUtils.getTenantCode();
        Set<SalePolicyResultProducts> resultProducts = this.salePolicyResultProductsRepository.findByTenantCodeAndSalePolicyCodeAndSpecificationProductCodeAndCustomerCode(tenantCode, salePolicyCode, specificationProductCode, customerCode);
        Set resultProductsVos = (Set)this.nebulaToolkitService.copyCollectionByWhiteList(resultProducts, SalePolicyResultProducts.class, SalePolicyResultProductsVo.class, HashSet.class, ArrayList.class, new String[]{"salePolicyResult"});
        return resultProductsVos;
    }
}

