/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.dto.SalePolicyDto;
import com.bizunited.empower.business.policy.entity.PolicyExecutorVar;
import com.bizunited.empower.business.policy.entity.PolicyType;
import com.bizunited.empower.business.policy.entity.SalePolicy;
import com.bizunited.empower.business.policy.entity.SalePolicyCustomers;
import com.bizunited.empower.business.policy.entity.SalePolicyExcludeProducts;
import com.bizunited.empower.business.policy.entity.SalePolicyExecutorLadder;
import com.bizunited.empower.business.policy.entity.SalePolicyExecutorVars;
import com.bizunited.empower.business.policy.entity.SalePolicyGifts;
import com.bizunited.empower.business.policy.entity.SalePolicyProducts;
import com.bizunited.empower.business.policy.repository.SalePolicyCustomersRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyExcludeProductsRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyExecutorLadderRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyExecutorVarsRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyGiftsRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyProductsRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyRepository;
import com.bizunited.empower.business.policy.service.PolicyTypeService;
import com.bizunited.empower.business.policy.service.SalePolicyService;
import com.bizunited.empower.business.policy.service.SalePolicyVoService;
import com.bizunited.empower.business.policy.service.internal.AbstractSalePolicyService;
import com.bizunited.empower.business.policy.vo.SalePolicyVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="SalePolicyServiceImpl")
public class SalePolicyServiceImpl
extends AbstractSalePolicyService
implements SalePolicyService {
    @Autowired
    private SalePolicyRepository salePolicyRepository;
    @Autowired
    private SalePolicyVoService salePolicyVoService;
    @Autowired
    private PolicyTypeService policyTypeService;
    @Autowired
    private SalePolicyProductsRepository salePolicyProductsRepository;
    @Autowired
    private SalePolicyCustomersRepository salePolicyCustomersRepository;
    @Autowired
    private SalePolicyGiftsRepository salePolicyGiftsRepository;
    @Autowired
    private SalePolicyExecutorLadderRepository salePolicyExecutorLadderRepository;
    @Autowired
    private SalePolicyExcludeProductsRepository salePolicyExcludeProductsRepository;
    @Autowired
    private SalePolicyExecutorVarsRepository salePolicyExecutorVarsRepository;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String POLICY_CODE_PREFIX = "SP";
    private static final String SALE_POLICY_GEN_PREFIX = "SALE_POLICY_GEN_PREFIX";

    @Override
    public String preCreate() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(SALE_POLICY_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    private void saveValidation(SalePolicy salePolicy, PolicyType policyType, boolean update) {
        String onTimeValue;
        Date now = new Date();
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = SecurityUtils.getUserAccount();
        if (!update) {
            onTimeValue = "\u6dfb\u52a0\u8425\u9500\u653f\u7b56\u65f6";
            salePolicy.setId(null);
            salePolicy.setCreateAccount(currentAccount);
            salePolicy.setCreateTime(now);
            salePolicy.setModifyAccount(currentAccount);
            salePolicy.setModifyTime(now);
            salePolicy.setTenantCode(tenantCode);
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)salePolicy.getId()), (String)(onTimeValue + "\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01"), (Object[])new Object[0]);
        } else {
            onTimeValue = "\u4fee\u6539\u8425\u9500\u653f\u7b56\u65f6";
            salePolicy.setModifyAccount(currentAccount);
            salePolicy.setModifyTime(now);
            Validate.isTrue((!StringUtils.isBlank((CharSequence)salePolicy.getId()) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01"), (Object[])new Object[0]);
        }
        Validate.notNull((Object)((Object)salePolicy), (String)(onTimeValue + "\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)salePolicy.getSalePolicyName(), (String)(onTimeValue + "\uff0c\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)salePolicy.getDescription(), (String)(onTimeValue + "\uff0c\u4e2d\u6587\u63cf\u8ff0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Date validStartTime = salePolicy.getValidStartTime();
        Validate.notNull((Object)validStartTime, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Date validEndTime = salePolicy.getValidEndTime();
        Validate.notNull((Object)validEndTime, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        long validStartTimeValue = validStartTime.getTime();
        long validEndTimeValue = validEndTime.getTime();
        Validate.isTrue((validStartTimeValue < validEndTimeValue ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u8d77\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u4f18\u60e0\u622a\u6b62\u65f6\u95f4\uff01"), (Object[])new Object[0]);
        Validate.isTrue((now.getTime() < validStartTimeValue ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"), (Object[])new Object[0]);
        Validate.notNull((Object)salePolicy.getDescription(), (String)(onTimeValue + "\uff0c\u4f18\u60e0\u653f\u7b56\u4e2d\u6587\u63cf\u8ff0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        salePolicy.setEffective(true);
        Validate.notNull((Object)salePolicy.getOverlap(), (String)(onTimeValue + "\uff0c\u662f\u5426\u5141\u8bb8\u653f\u7b56\u53e0\u52a0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.notNull((Object)salePolicy.getLadder(), (String)(onTimeValue + "\uff0c\u662f\u5426\u5141\u8bb8\u9636\u68af\u53e0\u52a0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Set<SalePolicyExecutorLadder> salePolicyExecutorLadders = salePolicy.getSalePolicyExecutorLadders();
        if (!salePolicy.getLadder().booleanValue()) {
            Validate.isTrue((salePolicyExecutorLadders.size() == 1 ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u7531\u4e8e\u4e0d\u5141\u8bb8\u8bbe\u5b9a\u653f\u7b56\u9636\u68af\uff0c\u6240\u4ee5\u53ea\u80fd\u8bbe\u5b9a\u4e00\u7ec4\u8425\u9500\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        }
        boolean composeOfType = policyType.getCompose() == null ? false : policyType.getCompose();
        Validate.isTrue((composeOfType == salePolicy.getCompose() ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u672c\u54c1\u7ec4\u5408\u9009\u62e9\u65b9\u5f0f\u4e0e\u5bf9\u5e94\u7684\u7b56\u7565\u7c7b\u578b\u7ec4\u5408\u9009\u62e9\u65b9\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getDescription() == null || salePolicy.getDescription().length() < 400 ? 1 : 0) != 0, (String)(onTimeValue + "\u4f18\u60e0\u653f\u7b56\u4e2d\u6587\u63cf\u8ff0\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(200\u4e2a\u5b57\u7b26)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getSalePolicyCode() == null || salePolicy.getSalePolicyCode().length() < 128 ? 1 : 0) != 0, (String)(onTimeValue + "\u4fc3\u9500\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getSalePolicyName() == null || salePolicy.getSalePolicyName().length() < 128 ? 1 : 0) != 0, (String)(onTimeValue + "\u4fc3\u9500\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getDescription() == null || salePolicy.getDescription().length() < 512 ? 1 : 0) != 0, (String)(onTimeValue + "\u4e2d\u6587\u63cf\u8ff0\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
        this.saveValidationForCustomers(salePolicy, policyType, tenantCode, onTimeValue);
        this.saveValidationForProducts(salePolicy, policyType, tenantCode, onTimeValue, update, now);
        Set<PolicyExecutorVar> policyExecutorVars = policyType.getPolicyExecutor().getPolicyExecutorVars();
        if (!CollectionUtils.isEmpty(policyExecutorVars)) {
            Set policyExecutorVarNames = policyExecutorVars.stream().map(PolicyExecutorVar::getVariableName).collect(Collectors.toSet());
            int index = 0;
            for (SalePolicyExecutorLadder salePolicyExecutorLadderItem : salePolicyExecutorLadders) {
                Set<SalePolicyExecutorVars> salePolicyExecutorVars = salePolicyExecutorLadderItem.getSalePolicyExecutorVars();
                Validate.isTrue((!CollectionUtils.isEmpty(salePolicyExecutorVars) ? 1 : 0) != 0, (String)(onTimeValue + "\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\uff0c\u5fc5\u987b\u8bbe\u5b9a\u76f8\u5e94\u7684\u5173\u952e\u503c!"), (long)(++index));
                HashMap policyExecutorVarsMapping = Maps.newHashMap();
                for (SalePolicyExecutorVars salePolicyExecutorVarItem : salePolicyExecutorVars) {
                    salePolicyExecutorVarItem.setId(null);
                    String variableName = salePolicyExecutorVarItem.getVariableName();
                    Validate.notBlank((CharSequence)variableName, (String)(onTimeValue + "\uff0c\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u53d8\u91cf\u8bbe\u5b9a\u7f3a\u5c11\u53d8\u91cf\u540d"), (Object[])new Object[]{index});
                    Integer variableType = salePolicyExecutorVarItem.getVariableType();
                    Validate.inclusiveBetween((Object)1, (Object)4, (Comparable)variableType, (String)(onTimeValue + "\uff0c\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u53d8\u91cf\u8bbe\u5b9a\u7f3a\u5c11\u6b63\u786e\u7684\u53d8\u91cf\u7c7b\u578b"), (Object[])new Object[]{index});
                    String variableValue = salePolicyExecutorVarItem.getVariableValue();
                    Validate.notNull((Object)variableValue, (String)(onTimeValue + "\uff0c\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u53d8\u91cf\u8bbe\u5b9a\u7f3a\u5c11\u8bbe\u5b9a\u503c"), (Object[])new Object[]{index});
                    Validate.isTrue((policyExecutorVarsMapping.get(variableName) == null ? 1 : 0) != 0, (String)(onTimeValue + "\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u8bbe\u5b9a\u4e86\u91cd\u590d\u7684\u53d8\u91cf\u540d\uff0c\u8bf7\u68c0\u67e5!!"), (long)index);
                    Integer indexs = salePolicyExecutorVarItem.getIndexs();
                    Validate.notNull((Object)indexs, (String)(onTimeValue + "\uff0c\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u53d8\u91cf\u8bbe\u5b9a\u7f3a\u5c11\u6392\u5e8f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5"), (Object[])new Object[]{index});
                    if (variableType == 1) {
                        try {
                            Boolean.parseBoolean(variableValue);
                        }
                        catch (RuntimeException e) {
                            throw new IllegalArgumentException(String.format(onTimeValue + "\uff0c\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u53ea\u80fd\u8bbe\u5b9aboolean\u7c7b\u578b\uff0c\u4f46\u6ca1\u6709\u4f20\u5165\u6b63\u786e\u7684\u503c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", index));
                        }
                    }
                    if (variableType == 3) {
                        try {
                            Integer.parseInt(variableValue);
                        }
                        catch (RuntimeException e) {
                            throw new IllegalArgumentException(String.format(onTimeValue + "\uff0c\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u53ea\u80fd\u8bbe\u5b9a\u6574\u6570\uff0c\u4f46\u6ca1\u6709\u4f20\u5165\u6b63\u786e\u7684\u503c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", index));
                        }
                    }
                    if (variableType == 4) {
                        try {
                            Float.parseFloat(variableValue);
                        }
                        catch (RuntimeException e) {
                            throw new IllegalArgumentException(String.format(onTimeValue + "\uff0c\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u53ea\u80fd\u8bbe\u5b9a\u5c0f\u6570\uff0c\u4f46\u6ca1\u6709\u4f20\u5165\u6b63\u786e\u7684\u503c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", index));
                        }
                    }
                    policyExecutorVarsMapping.put(variableName, salePolicyExecutorVarItem);
                }
                Set salePolicyExecutorVarNames = salePolicyExecutorVars.stream().map(SalePolicyExecutorVars::getVariableName).collect(Collectors.toSet());
                Validate.isTrue((boolean)Sets.difference(salePolicyExecutorVarNames, policyExecutorVarNames).isEmpty(), (String)(onTimeValue + "\u7b2c%d\u7ec4\u653f\u7b56\u660e\u7ec6\u4e2d\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u9700\u8981\u8bbe\u5b9a\u7684\u653f\u7b56\u53c2\u6570\u6ca1\u6709\u8bbe\u5b9a[%s]\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{index, StringUtils.join((Object[])new Set[]{policyExecutorVarNames})});
            }
        }
    }

    private void saveValidationForProducts(SalePolicy salePolicy, PolicyType policyType, String tenantCode, String onTimeValue, boolean update, Date now) {
        Object salePolicyProductCodes;
        Set salePolicyExcludeProductCodes;
        Sets.SetView intersectionCodes;
        ProductUnitVo productUnitVo;
        SalePolicyProducts salePolicyProductItem;
        ProductVo product;
        List productSpecifications;
        Integer productSelectionMethod;
        long validStartTimeValue = salePolicy.getValidStartTime().getTime();
        long validEndTimeValue = salePolicy.getValidEndTime().getTime();
        if (salePolicy.getCompose() != null && salePolicy.getCompose().booleanValue()) {
            Validate.notNull((Object)salePolicy.getComposeType(), (String)(onTimeValue + "\uff0c,\u5982\u5df2\u786e\u8ba4\u9700\u8981\u6307\u5b9a\u5408\u8ba2\u91cf\uff0c\u5219\u5408\u8ba2\u91cf\u7c7b\u578b\u5fc5\u987b\u6307\u5b9a!!"), (Object[])new Object[0]);
            Validate.notNull((Object)salePolicy.getComposeNumber(), (String)(onTimeValue + "\uff0c\u5982\u5df2\u786e\u8ba4\u9700\u8981\u6307\u5b9a\u5408\u8ba2\u91cf\uff0c\u5219\u5408\u8ba2\u91cf\u6570\u91cf\u5fc5\u987b\u6307\u5b9a!!"), (Object[])new Object[0]);
            Validate.isTrue((salePolicy.getComposeNumber().floatValue() > 0.0f ? 1 : 0) != 0, (String)(onTimeValue + "\u5982\u5df2\u786e\u8ba4\u9700\u8981\u6307\u5b9a\u5408\u8ba2\u91cf\uff0c\u5219\u5408\u8ba2\u91cf\u91cf\u9650\u5b9a\u503c\u5fc5\u987b\u5927\u4e8e0!!"), (Object[])new Object[0]);
        }
        Validate.inclusiveBetween((long)1L, (long)3L, (long)((productSelectionMethod = salePolicy.getProductSelectionMethod()) == null ? -1L : (long)productSelectionMethod.intValue()), (String)(onTimeValue + "\uff0c\u8bf7\u6307\u5b9a\u6b63\u786e\u7684\u5546\u54c1\u9009\u62e9\u65b9\u5f0f[\u6307\u5b9a\u5206\u7c7b|\u6307\u5b9a\u54c1\u724c|\u6307\u5b9a\u5546\u54c1]"));
        if (productSelectionMethod == 1 || productSelectionMethod == 2) {
            Validate.notBlank((CharSequence)salePolicy.getClassifications(), (String)(onTimeValue + "\uff0c\u8bf7\u6307\u5b9a\u6b63\u786e\u7684\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\u5546\u54c1\u5206\u7c7b\u6216\u5546\u54c1\u54c1\u724c\u7f16\u53f7\u4fe1\u606f!!"), (Object[])new Object[0]);
        }
        if (productSelectionMethod == 1 || productSelectionMethod == 2) {
            Validate.isTrue((policyType.getGiftsMapping() == false ? 1 : 0) != 0, (String)"\u5f53\u8d60\u54c1\u548c\u5546\u54c1\u9700\u8981\u4e00\u5bf9\u4e00\u9009\u62e9\u65f6\uff0c\u4e0d\u80fd\u4f7f\u7528\u5546\u54c1\u67e5\u8be2\u6761\u4ef6\u7684\u65b9\u5f0f\u6307\u5b9a\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
        }
        Set<SalePolicyProducts> allreadySalePolicyProducts = null;
        allreadySalePolicyProducts = update ? this.salePolicyProductsRepository.findByValidTimeAndPolicyTypeAndPolicyEffectiveAndExcludePolicy(tenantCode, now, policyType.getSaleType(), salePolicy.getId()) : this.salePolicyProductsRepository.findByValidTimeAndPolicyTypeAndPolicyEffective(tenantCode, now, policyType.getSaleType());
        Set<Object> allreadySalePolicyProductCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(allreadySalePolicyProducts)) {
            allreadySalePolicyProductCodes = allreadySalePolicyProducts.stream().map(SalePolicyProducts::getProductSpecificationCode).distinct().collect(Collectors.toSet());
        }
        LinkedHashSet salePolicyProducts = null;
        if (productSelectionMethod == 1) {
            ArrayList categoryCodeList = Lists.newArrayList((Object[])StringUtils.split((String)salePolicy.getClassifications(), (String)","));
            productSpecifications = this.productSpecificationVoService.findByCategoryCodeList((List)categoryCodeList);
            if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                salePolicyProducts = Sets.newLinkedHashSet();
                salePolicy.setProducts(salePolicyProducts);
                for (ProductSpecificationVo productSpecificationItem : productSpecifications) {
                    product = productSpecificationItem.getProduct();
                    salePolicyProductItem = new SalePolicyProducts();
                    salePolicyProductItem.setProductCode(product.getProductCode());
                    salePolicyProductItem.setProductName(product.getProductName());
                    salePolicyProductItem.setProductSpecificationCode(productSpecificationItem.getProductSpecificationCode());
                    salePolicyProductItem.setProductSpecificationName(productSpecificationItem.getProductSpecificationName());
                    salePolicyProductItem.setThresholdType(3);
                    salePolicyProductItem.setThreshold(BigDecimal.ZERO);
                    productUnitVo = productSpecificationItem.getBasicUnit();
                    Validate.notNull((Object)productUnitVo, (String)"\u5546\u54c1\u3010%s\u3011\u672a\u8bbe\u5b9a\u89c4\u683c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{product.getProductName()});
                    salePolicyProductItem.setUnitCode(productUnitVo.getUnitCode());
                    salePolicyProductItem.setUnitName(productUnitVo.getUnitCode());
                    salePolicyProducts.add(salePolicyProductItem);
                }
            }
        } else if (productSelectionMethod == 2) {
            ArrayList brandCodeList = Lists.newArrayList((Object[])StringUtils.split((String)salePolicy.getClassifications(), (String)","));
            productSpecifications = this.productSpecificationVoService.findByBrandCodeList((List)brandCodeList);
            if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                salePolicyProducts = Sets.newLinkedHashSet();
                salePolicy.setProducts(salePolicyProducts);
                for (ProductSpecificationVo productSpecificationItem : productSpecifications) {
                    product = productSpecificationItem.getProduct();
                    salePolicyProductItem = new SalePolicyProducts();
                    salePolicyProductItem.setProductCode(product.getProductCode());
                    salePolicyProductItem.setProductName(product.getProductName());
                    salePolicyProductItem.setProductSpecificationCode(productSpecificationItem.getProductSpecificationCode());
                    salePolicyProductItem.setProductSpecificationName(productSpecificationItem.getProductSpecificationName());
                    salePolicyProductItem.setThresholdType(3);
                    salePolicyProductItem.setThreshold(BigDecimal.ZERO);
                    productUnitVo = productSpecificationItem.getBasicUnit();
                    Validate.notNull((Object)productUnitVo, (String)"\u5546\u54c1\u3010%s\u3011\u672a\u8bbe\u5b9a\u89c4\u683c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{product.getProductName()});
                    salePolicyProductItem.setUnitCode(productUnitVo.getUnitCode());
                    salePolicyProductItem.setUnitName(productUnitVo.getUnitCode());
                    salePolicyProducts.add(salePolicyProductItem);
                    salePolicyProducts.add(salePolicyProductItem);
                }
            }
        } else if (productSelectionMethod == 3) {
            salePolicyProducts = salePolicy.getProducts();
            List salePolicyCodes = salePolicyProducts.stream().map(SalePolicyProducts::getProductSpecificationCode).distinct().collect(Collectors.toList());
            productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList(salePolicyCodes);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)productSpecifications) && salePolicyCodes.size() == productSpecifications.size() ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u6307\u5b9a\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        }
        Validate.isTrue((!CollectionUtils.isEmpty(salePolicyProducts) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u5fc5\u987b\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u5546\u54c1\u89c4\u683c\u53c2\u52a0\u8425\u9500\u6d3b\u52a8\uff08\u4e5f\u53ef\u80fd\u56e0\u4e3a\u4f7f\u7528\u5546\u54c1\u5206\u7c7b\u6216\u8005\u54c1\u724c\u9009\u5b9a\u5546\u54c1\u89c4\u683c\u65f6\uff0c\u5176\u4e0b\u5e76\u6ca1\u6709\u5546\u54c1\u89c4\u683c\u4fe1\u606f!\uff09"), (Object[])new Object[0]);
        Set<SalePolicyExcludeProducts> salePolicyExcludeProducts = salePolicy.getExcludeProducts();
        if (!CollectionUtils.isEmpty(salePolicyExcludeProducts) && !CollectionUtils.isEmpty((Collection)(intersectionCodes = Sets.intersection(salePolicyExcludeProductCodes = salePolicyExcludeProducts.stream().map(SalePolicyExcludeProducts::getProductSpecificationCode).collect(Collectors.toSet()), (Set)(salePolicyProductCodes = salePolicyProducts.stream().map(SalePolicyProducts::getProductSpecificationCode).collect(Collectors.toSet())))))) {
            CharSequence[] intersectionCodeArrays = intersectionCodes.toArray(new String[0]);
            Iterator it = salePolicyProducts.iterator();
            for (int i = 0; i < salePolicyProducts.size(); ++i) {
                SalePolicyProducts salePolicyProductItem2 = (SalePolicyProducts)((Object)it.next());
                if (!StringUtils.equalsAny((CharSequence)salePolicyProductItem2.getProductSpecificationCode(), (CharSequence[])intersectionCodeArrays)) continue;
                it.remove();
                --i;
            }
        }
        LinkedHashSet salePolicyProductCodes2 = Sets.newLinkedHashSet();
        for (SalePolicyProducts salePolicyProductItem3 : salePolicyProducts) {
            BigDecimal threshold;
            String productCode = salePolicyProductItem3.getProductCode();
            Validate.notBlank((CharSequence)productCode, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u7684\u7f16\u53f7\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            String productName = salePolicyProductItem3.getProductName();
            Validate.notBlank((CharSequence)productName, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u7684\u540d\u79f0\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            String productSpecificationCode = salePolicyProductItem3.getProductSpecificationCode();
            Validate.notBlank((CharSequence)productSpecificationCode, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u89c4\u683c\u7684\u7f16\u53f7\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            String productSpecificationName = salePolicyProductItem3.getProductSpecificationName();
            Validate.notBlank((CharSequence)productSpecificationName, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u540d\u79f0\u4fe1\u606f\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            String unitCode = salePolicyProductItem3.getUnitCode();
            Validate.notBlank((CharSequence)unitCode, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u89c4\u683c\u7684\u5355\u4f4d\u7f16\u53f7\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            String unitName = salePolicyProductItem3.getUnitName();
            Validate.notBlank((CharSequence)unitName, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u89c4\u683c\u7684\u5355\u4f4d\u540d\u79f0\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            if (salePolicyProductItem3.getThresholdType() == null) {
                salePolicyProductItem3.setThresholdType(3);
            }
            if ((threshold = salePolicyProductItem3.getThreshold()) == null) {
                salePolicyProductItem3.setThreshold(BigDecimal.ZERO);
            }
            Validate.isTrue((threshold.floatValue() >= 0.0f ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u89c4\u683c\u7684\u8d77\u8ba2\u6570\u91cf\u6ca1\u6709\u5927\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            if (policyType.getSaleType() == 1) {
                BigDecimal specificPrice = salePolicyProductItem3.getSpecificPrice();
                Validate.notNull((Object)specificPrice, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u672c\u6b21\u7279\u4ef7\u6d3b\u52a8\u8bbe\u5b9a\u4e2d\uff0c\u81f3\u5c11\u4e00\u4ef6\u5546\u54c1\u5e76\u6ca1\u6709\u8bbe\u5b9a\u7279\u4ef7\u4f18\u60e0\u4ef7\u683c\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            }
            if (salePolicyProductItem3.getLimitedPerCustomer() != null && salePolicyProductItem3.getLimitedTotal() != null) {
                Validate.isTrue((salePolicyProductItem3.getLimitedTotal().compareTo(salePolicyProductItem3.getLimitedPerCustomer()) >= 0 ? 1 : 0) != 0, (String)"\u5546\u54c1%s\u7684\u89c4\u683c%s\u7684\u603b\u9650\u5b9a\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u5355\u5ba2\u9650\u5b9a\u91cf", (Object[])new Object[]{salePolicyProductItem3.getProductName(), salePolicyProductItem3.getProductSpecificationName()});
            }
            salePolicyProductCodes2.add(productSpecificationCode);
        }
        Sets.SetView allreadyIntersectionSalePolicyProductCodes = Sets.intersection((Set)allreadySalePolicyProductCodes, (Set)salePolicyProductCodes2);
        HashSet exsitedIntersectionSalePolicyProductCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)allreadyIntersectionSalePolicyProductCodes)) {
            for (String allreadyIntersectionSalePolicyProductCodeItem : allreadyIntersectionSalePolicyProductCodes) {
                Set intersectionSalePolicyProducts = allreadySalePolicyProducts.stream().filter(item -> StringUtils.equals((CharSequence)item.getProductSpecificationCode(), (CharSequence)allreadyIntersectionSalePolicyProductCodeItem)).collect(Collectors.toSet());
                for (SalePolicyProducts salePolicyProductItem4 : intersectionSalePolicyProducts) {
                    SalePolicy intersectionSalePolicy = salePolicyProductItem4.getSalePolicy();
                    Date intersectionValidEndTime = intersectionSalePolicy.getValidEndTime();
                    long intersectionValidEndTimeValue = intersectionValidEndTime.getTime();
                    Date intersectionValidStartTime = intersectionSalePolicy.getValidStartTime();
                    long intersectionValidStartTimeValue = intersectionValidStartTime.getTime();
                    if (validStartTimeValue > intersectionValidEndTimeValue || validEndTimeValue < intersectionValidStartTimeValue) continue;
                    exsitedIntersectionSalePolicyProductCodes.add(salePolicyProductItem4.getProductSpecificationCode());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)exsitedIntersectionSalePolicyProductCodes)) {
                Set<SalePolicyCustomers> salePolicyCustomers = salePolicy.getCustomers();
                for (String exsitedIntersectionSalePolicyProductCode : exsitedIntersectionSalePolicyProductCodes) {
                    for (SalePolicyCustomers salePolicyCustomer : salePolicyCustomers) {
                        String salePolicyCustomerCode = salePolicyCustomer.getCustomerCode();
                        Set<SalePolicyVo> exsitedIntersectionSalePolicies = null;
                        exsitedIntersectionSalePolicies = update ? this.salePolicyVoService.findDetailsByEffectiveAndCustomerCodesAndProductSpecificationCodesAndExcludePolicy(tenantCode, false, policyType.getSaleType(), salePolicyCustomerCode, exsitedIntersectionSalePolicyProductCode, salePolicy.getId()) : this.salePolicyVoService.findDetailsByEffectiveAndCustomerCodesAndProductSpecificationCodes(tenantCode, false, policyType.getSaleType(), salePolicyCustomerCode, exsitedIntersectionSalePolicyProductCode);
                        if (CollectionUtils.isEmpty(exsitedIntersectionSalePolicies)) continue;
                        for (SalePolicyVo exsitedIntersectionSalePolicy : exsitedIntersectionSalePolicies) {
                            Date exsitedIntersectionValidEndTime = exsitedIntersectionSalePolicy.getValidEndTime();
                            long exsitedIntersectionValidEndTimeValue = exsitedIntersectionValidEndTime.getTime();
                            Date exsitedIntersectionValidStartTime = exsitedIntersectionSalePolicy.getValidStartTime();
                            long exsitedIntersectionValidStartTimeValue = exsitedIntersectionValidStartTime.getTime();
                            String salePolicyName = exsitedIntersectionSalePolicy.getSalePolicyName();
                            if (exsitedIntersectionValidStartTimeValue > validEndTimeValue || exsitedIntersectionValidEndTimeValue < validStartTimeValue) continue;
                            throw new IllegalArgumentException(String.format(onTimeValue + "\uff0c\u53d1\u73b0\u5546\u54c1\u89c4\u683c\u3010%s\u3011-\u5ba2\u6237\u7f16\u53f7[%s]\uff0c\u5df2\u7ecf\u540c\u65f6\u53c2\u4e0e\u4e86\u201c%s\u201d\u6d3b\u52a8\uff0c\u4e0d\u80fd\u540c\u65f6\u53c2\u4e0e\u540c\u4e00\u7c7b\u578b\u7684\u8425\u9500\u6d3b\u52a8\uff0c\u8bf7\u68c0\u67e5!!", exsitedIntersectionSalePolicyProductCode, salePolicyCustomerCode, salePolicyName));
                        }
                    }
                }
            }
        }
        this.saveValidationForGifts(salePolicy, policyType, onTimeValue, salePolicyProducts);
    }

    private void saveValidationForGifts(SalePolicy salePolicy, PolicyType policyType, String onTimeValue, Set<SalePolicyProducts> salePolicyProducts) {
        if (policyType.getDisplayGifts().booleanValue() && !policyType.getGiftsMapping().booleanValue()) {
            Set<SalePolicyGifts> salePolicyGifts = salePolicy.getGifts();
            Validate.isTrue((!CollectionUtils.isEmpty(salePolicy.getGifts()) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u5fc5\u987b\u6307\u5b9a\u4e00\u4ef6\u7684\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            Iterator<SalePolicyGifts> iterator = salePolicyGifts.iterator();
            while (iterator.hasNext()) {
                SalePolicyGifts salePolicyGiftItem = iterator.next();
                String giftCode = salePolicyGiftItem.getGiftCode();
                Validate.notBlank((CharSequence)giftCode, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\u540d\u79f0\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String giftName = salePolicyGiftItem.getGiftName();
                Validate.notBlank((CharSequence)giftName, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                Integer n = salePolicyGiftItem.getGiftQuantity();
                Validate.notNull((Object)n, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\uff0c\u5fc5\u987b\u8bbe\u5b9a\u8d60\u54c1\u6570\u91cf!"), (Object[])new Object[0]);
                Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String giftSpecificationCode = salePolicyGiftItem.getGiftSpecificationCode();
                Validate.notBlank((CharSequence)giftSpecificationCode, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\uff0c\u5fc5\u987b\u6307\u5b9a\u8d60\u54c1\u89c4\u683c\u7f16\u53f7!!"), (Object[])new Object[0]);
                String giftSpecificationName = salePolicyGiftItem.getGiftSpecificationName();
                Validate.notBlank((CharSequence)giftSpecificationName, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\uff0c\u5fc5\u987b\u6307\u5b9a\u8d60\u54c1\u89c4\u683c\u540d\u79f0!!"), (Object[])new Object[0]);
                String giftUnitCode = salePolicyGiftItem.getGiftUnitCode();
                Validate.notBlank((CharSequence)giftUnitCode, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\u5fc5\u987b\u8bbe\u5b9a\u5355\u4f4d\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String giftUnitName = salePolicyGiftItem.getGiftUnitName();
                Validate.notBlank((CharSequence)giftUnitName, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\u5fc5\u987b\u8bbe\u5b9a\u5355\u4f4d\u540d\u79f0\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            }
            List salePolicyGiftCodes = salePolicyGifts.stream().map(SalePolicyGifts::getGiftSpecificationCode).distinct().collect(Collectors.toList());
            List productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList(salePolicyGiftCodes);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)productSpecifications) && salePolicyGiftCodes.size() == productSpecifications.size() ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            Map<String, List<SalePolicyGifts>> salePolicyGiftCodeMapping = salePolicyGifts.stream().collect(Collectors.groupingBy(SalePolicyGifts::getGiftSpecificationCode));
            for (Map.Entry entry : salePolicyGiftCodeMapping.entrySet()) {
                List salePolicyProductsForGifts = (List)entry.getValue();
                if (salePolicyProductsForGifts.size() <= 1) continue;
                SalePolicyGifts salePolicyGift = (SalePolicyGifts)((Object)salePolicyProductsForGifts.get(0));
                String targetGiftUnitCode = salePolicyGift.getGiftUnitCode();
                for (SalePolicyGifts salePolicyGiftItem : salePolicyProductsForGifts) {
                    String sourceGiftUnitCode = salePolicyGiftItem.getGiftUnitCode();
                    Validate.isTrue((boolean)StringUtils.equals((CharSequence)targetGiftUnitCode, (CharSequence)sourceGiftUnitCode), (String)"\u9009\u62e9\u7684\u72ec\u7acb\u8d60\u54c1\u4e2d\uff0c\u76f8\u540c\u8d60\u54c1\u89c4\u683c\u4e0d\u5141\u8bb8\u6307\u5b9a\u4e0d\u540c\u7684\u5355\u4f4d\u89c4\u683c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                }
            }
        }
        if (policyType.getDisplayGifts().booleanValue() && policyType.getGiftsMapping().booleanValue()) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty(salePolicy.getGifts()), (String)(onTimeValue + "\uff0c\u4e0d\u80fd\u6307\u5b9a\u72ec\u7acb\u8d60\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            for (SalePolicyProducts salePolicyProductItem : salePolicyProducts) {
                String giftCode = salePolicyProductItem.getGiftCode();
                Validate.notBlank((CharSequence)giftCode, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u8d60\u54c1\u7684\u7f16\u53f7\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String giftName = salePolicyProductItem.getGiftName();
                Validate.notBlank((CharSequence)giftName, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u8d60\u54c1\u7684\u540d\u79f0\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                Integer giftQuantity = salePolicyProductItem.getGiftQuantity();
                Validate.isTrue((giftQuantity != null && giftQuantity > 0 ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u8d60\u54c1\u7684\u6570\u91cf\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String string = salePolicyProductItem.getGiftSpecificationCode();
                Validate.notBlank((CharSequence)string, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u8d60\u54c1\u89c4\u683c\u7684\u7f16\u53f7\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String giftSpecificationName = salePolicyProductItem.getGiftSpecificationName();
                Validate.notBlank((CharSequence)giftSpecificationName, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u8d60\u54c1\u89c4\u683c\u7684\u540d\u79f0\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String giftUnitCode = salePolicyProductItem.getGiftUnitCode();
                Validate.notBlank((CharSequence)giftUnitCode, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u8d60\u54c1\u5355\u4f4d\u7f16\u53f7\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String giftUnitName = salePolicyProductItem.getGiftUnitName();
                Validate.notBlank((CharSequence)giftUnitName, (String)(onTimeValue + "\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4ef6\u8d60\u54c1\u5355\u4f4d\u540d\u79f0\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            }
            List salePolicyGiftCodes = salePolicyProducts.stream().map(SalePolicyProducts::getGiftSpecificationCode).distinct().collect(Collectors.toList());
            List productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList(salePolicyGiftCodes);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)productSpecifications) && salePolicyGiftCodes.size() == productSpecifications.size() ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u4e00\u5bf9\u4e00\u8d60\u54c1\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            if (policyType.getCompose().booleanValue()) {
                Map<String, List<SalePolicyProducts>> salePolicyProductsGiftCodeMapping = salePolicyProducts.stream().collect(Collectors.groupingBy(SalePolicyProducts::getGiftSpecificationCode));
                for (Map.Entry<String, List<SalePolicyProducts>> salePolicyProductsGiftCodeMappingItem : salePolicyProductsGiftCodeMapping.entrySet()) {
                    List<SalePolicyProducts> list = salePolicyProductsGiftCodeMappingItem.getValue();
                    if (list.size() <= 1) continue;
                    SalePolicyProducts salePolicyProductsForGift = list.get(0);
                    String targetGiftUnitCode = salePolicyProductsForGift.getGiftUnitCode();
                    for (SalePolicyProducts salePolicyProductsForGiftItem : list) {
                        String sourceGiftUnitCode = salePolicyProductsForGiftItem.getUnitCode();
                        Validate.isTrue((boolean)StringUtils.equals((CharSequence)targetGiftUnitCode, (CharSequence)sourceGiftUnitCode), (String)"\u5728\u8d60\u54c1-\u5546\u54c1 \u4e00\u5bf9\u4e00\u9009\u62e9\uff0c\u4e14\u9700\u8981\u8fdb\u884c\u5546\u54c1\u7ec4\u5408\u4f18\u60e0\u7684\u8425\u9500\u6d3b\u52a8\u573a\u666f\u4e0b\uff0c\u76f8\u540c\u8d60\u54c1\u89c4\u683c\u4e0d\u5141\u8bb8\u6307\u5b9a\u4e0d\u540c\u7684\u5355\u4f4d\u89c4\u683c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    private void saveValidationForCustomers(SalePolicy salePolicy, PolicyType policyType, String tenantCode, String onTimeValue) {
        Integer customerSelectionMethod = salePolicy.getCustomerSelectionMethod();
        Validate.notNull((Object)customerSelectionMethod, (String)(onTimeValue + "\uff0c\u9700\u8981\u7ed9\u5b9a\u5f53\u524d\u5ba2\u6237\u7684\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        HashSet salePolicyCustomers = null;
        if (customerSelectionMethod == 1) {
            List queryCustomers;
            String customerSelectionValue = salePolicy.getCustomerSelectionValue();
            JSONObject customerSelectionJson = null;
            try {
                customerSelectionJson = JSON.parseObject((String)customerSelectionValue);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            HashMap conditions = Maps.newHashMap();
            Boolean enabledState = true;
            conditions.put("enabledState", enabledState);
            ArrayList levelCodes = null;
            String levelCodeValues = customerSelectionJson.getString("levelCodes");
            if (!StringUtils.isBlank((CharSequence)levelCodeValues)) {
                levelCodes = Lists.newArrayList((Object[])StringUtils.split((String)levelCodeValues, (String)","));
                conditions.put("levelCodes", levelCodes);
            }
            ArrayList categoryCodes = null;
            String categoryCodeValues = customerSelectionJson.getString("categoryCodes");
            if (!StringUtils.isBlank((CharSequence)categoryCodeValues)) {
                categoryCodes = Lists.newArrayList((Object[])StringUtils.split((String)categoryCodeValues, (String)","));
                conditions.put("categoryCodes", categoryCodes);
            }
            ArrayList saleAreaCodes = null;
            String saleAreaCodeValues = customerSelectionJson.getString("saleAreaCodes");
            if (!StringUtils.isBlank((CharSequence)saleAreaCodeValues)) {
                saleAreaCodes = Lists.newArrayList((Object[])StringUtils.split((String)saleAreaCodeValues, (String)","));
                conditions.put("saleAreaCodes", saleAreaCodes);
            }
            if (!CollectionUtils.isEmpty((Collection)(queryCustomers = this.customerService.findAllByConditions((Map)conditions)))) {
                salePolicyCustomers = Sets.newHashSet();
                for (Customer queryCustomer : queryCustomers) {
                    SalePolicyCustomers salePolicyCustomer = new SalePolicyCustomers();
                    salePolicyCustomer.setCustomerCode(queryCustomer.getCustomerCode());
                    salePolicyCustomers.add(salePolicyCustomer);
                }
            }
        } else if (customerSelectionMethod == 2) {
            salePolicyCustomers = salePolicy.getCustomers();
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5ba2\u6237\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!");
        }
        Validate.isTrue((!CollectionUtils.isEmpty(salePolicyCustomers) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u81f3\u5c11\u4fdd\u8bc1\u6709\u4e00\u4e2a\u80fd\u591f\u53c2\u4e0e\u8425\u9500\u653f\u7b56\u7684\u5ba2\u6237\u4fe1\u606f(\u6682\u4e0d\u652f\u6301\u5ba2\u6237\u6807\u7b7e\u9009\u62e9\u5ba2\u6237)"), (Object[])new Object[0]);
        for (SalePolicyCustomers salePolicyCustomerItem : salePolicyCustomers) {
            Validate.notBlank((CharSequence)salePolicyCustomerItem.getCustomerCode(), (String)(onTimeValue + "\uff0c\u81f3\u5c11\u53d1\u73b0\u4e00\u6761\u5ba2\u6237\u4fe1\u606f\u6ca1\u6709\u5ba2\u6237\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u6a21\u5757\u4e2d\u7684\u5ba2\u6237\u4fe1\u606f!!"), (Object[])new Object[0]);
        }
        salePolicy.setCustomers(salePolicyCustomers);
        salePolicy.setCustomerNumber(salePolicyCustomers.size());
    }

    @Override
    @Transactional
    public SalePolicy create(SalePolicy salePolicy) {
        SalePolicy current = this.createForm(salePolicy);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public SalePolicy createForm(SalePolicy salePolicy) {
        block7: {
            String prefix = salePolicy.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u8425\u9500\u6d3b\u52a8\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(SALE_POLICY_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u8425\u9500\u6d3b\u52a8\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(SALE_POLICY_GEN_PREFIX, prefix, prefix, 1L);
                    break block7;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u8425\u9500\u6d3b\u52a8\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
        Validate.notNull((Object)((Object)salePolicy), (String)"\u6dfb\u52a0\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u6dfb\u52a0\u7684\u8425\u9500\u653f\u7b56\u4fe1\u606f\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09\uff0c\u8bf7\u53c2\u89c1\u6587\u6863!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        PolicyType policyType = salePolicy.getPolicyType();
        Validate.notNull((Object)((Object)policyType), (String)"\u4f18\u60e0\u7b56\u7565\u7c7b\u578b\u5fc5\u987b\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        PolicyType currentPolicyType = this.policyTypeService.findById(policyType.getId());
        Validate.notNull((Object)((Object)currentPolicyType), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u4f18\u60e0\u7c7b\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<SalePolicyExecutorLadder> salePolicyExecutorLadders = salePolicy.getSalePolicyExecutorLadders();
        Validate.isTrue((!CollectionUtils.isEmpty(salePolicyExecutorLadders) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u653f\u7b56\u660e\u7ec6\u8bbe\u7f6e\u5fc5\u987b\u4f20\u5165(\u89c6\u662f\u5426\u5141\u8bb8\u9636\u68af\uff0c\u53ef\u4ee5\u8bbe\u7f6e\u4e00\u7ec4\u6216\u8005\u591a\u7ec4\u653f\u7b56\u660e\u7ec6)!!", (Object[])new Object[0]);
        this.saveValidation(salePolicy, currentPolicyType, false);
        salePolicy.setSalePolicyCode(UUID.randomUUID().toString());
        this.salePolicyRepository.save((Object)salePolicy);
        this.saveProducts(salePolicy, currentPolicyType);
        this.savePolicyExecutor(salePolicy, currentPolicyType);
        Set<SalePolicyCustomers> salePolicyCustomers = salePolicy.getCustomers();
        for (SalePolicyCustomers salePolicyCustomerItem : salePolicyCustomers) {
            salePolicyCustomerItem.setId(null);
            salePolicyCustomerItem.setSalePolicy(salePolicy);
        }
        this.salePolicyCustomersRepository.saveAll(salePolicyCustomers);
        this.salePolicyRepository.flush();
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String datecode = dateFormat.format(now);
        String codeUnKey = StringUtils.join((Object[])new String[]{POLICY_CODE_PREFIX, "_", tenantCode});
        String atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
        String salePolicyCode = StringUtils.join((Object[])new String[]{POLICY_CODE_PREFIX, datecode, atomicNumberValue});
        while (this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode) != null) {
            atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
            salePolicyCode = StringUtils.join((Object[])new String[]{POLICY_CODE_PREFIX, datecode, atomicNumberValue});
        }
        salePolicy.setSalePolicyCode(salePolicyCode);
        this.salePolicyRepository.save((Object)salePolicy);
        this.salePolicyVoService.notifyCacheRefresh(tenantCode);
        return salePolicy;
    }

    private void saveProducts(SalePolicy salePolicy, PolicyType policyType) {
        Set<SalePolicyExcludeProducts> salePolicyExcludeProducts;
        Set<SalePolicyProducts> salePolicyProducts = salePolicy.getProducts();
        for (SalePolicyProducts salePolicyProductItem : salePolicyProducts) {
            salePolicyProductItem.setId(null);
            salePolicyProductItem.setSalePolicy(salePolicy);
        }
        this.salePolicyProductsRepository.saveAll(salePolicyProducts);
        if (policyType.getDisplayGifts().booleanValue() && !policyType.getGiftsMapping().booleanValue()) {
            Set<SalePolicyGifts> salePolicyGifts = salePolicy.getGifts();
            for (SalePolicyGifts giftItem : salePolicyGifts) {
                giftItem.setId(null);
                giftItem.setSalePolicy(salePolicy);
            }
            this.salePolicyGiftsRepository.saveAll(salePolicyGifts);
        }
        if (!CollectionUtils.isEmpty(salePolicyExcludeProducts = salePolicy.getExcludeProducts())) {
            for (SalePolicyExcludeProducts salePolicyExcludeProductItem : salePolicyExcludeProducts) {
                salePolicyExcludeProductItem.setId(null);
                salePolicyExcludeProductItem.setSalePolicy(salePolicy);
            }
            this.salePolicyExcludeProductsRepository.saveAll(salePolicyExcludeProducts);
        }
    }

    private void savePolicyExecutor(SalePolicy salePolicy, PolicyType policyType) {
        Set<SalePolicyExecutorLadder> salePolicyExecutorLadders = salePolicy.getSalePolicyExecutorLadders();
        if (!CollectionUtils.isEmpty(salePolicyExecutorLadders)) {
            List sortedSalePolicyExecutorLadders = salePolicyExecutorLadders.stream().sorted((source, target) -> source.getIndexs() - target.getIndexs()).collect(Collectors.toList());
            sortedSalePolicyExecutorLadders.stream().forEach(item -> {
                item.setSalePolicy(salePolicy);
                item.setId(null);
            });
            this.salePolicyExecutorLadderRepository.saveAll(sortedSalePolicyExecutorLadders);
            for (SalePolicyExecutorLadder executorLadderItem : sortedSalePolicyExecutorLadders) {
                Set<SalePolicyExecutorVars> salePolicyExecutorVars = executorLadderItem.getSalePolicyExecutorVars();
                if (CollectionUtils.isEmpty(salePolicyExecutorVars)) continue;
                for (SalePolicyExecutorVars salePolicyExecutorVarItem : salePolicyExecutorVars) {
                    salePolicyExecutorVarItem.setExecutorLadder(executorLadderItem);
                }
                this.salePolicyExecutorVarsRepository.saveAll(salePolicyExecutorVars);
            }
        }
    }

    @Override
    @Transactional
    public SalePolicy update(SalePolicy salePolicy) {
        SalePolicy current = this.updateForm(salePolicy);
        return current;
    }

    @Override
    @Transactional
    public SalePolicy updateForm(SalePolicy salePolicy) {
        String tenantCode = TenantUtils.getTenantCode();
        Date now = new Date();
        Validate.notNull((Object)((Object)salePolicy), (String)"\u4fee\u6539\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u4fee\u6539\u7684\u8425\u9500\u653f\u7b56\u4fe1\u606f\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09\uff0c\u8bf7\u53c2\u89c1\u6587\u6863!!", (Object[])new Object[0]);
        PolicyType policyType = salePolicy.getPolicyType();
        Validate.notNull((Object)((Object)policyType), (String)"\u4f18\u60e0\u7b56\u7565\u7c7b\u578b\u5fc5\u987b\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        PolicyType currentPolicyType = this.policyTypeService.findById(policyType.getId());
        Validate.notNull((Object)((Object)currentPolicyType), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u653f\u7b56\u7c7b\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String salePolicyCode = salePolicy.getSalePolicyCode();
        Validate.notBlank((CharSequence)salePolicyCode, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u8425\u9500\u653f\u7b56\u6709\u6b63\u786e\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicy currentSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        Validate.notNull((Object)((Object)currentSalePolicy), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u8425\u9500\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        boolean effective = currentSalePolicy.getEffective();
        Date validStartTime = currentSalePolicy.getValidStartTime();
        if (!effective || now.getTime() > validStartTime.getTime()) {
            throw new IllegalArgumentException("\u4fee\u6539\u65f6\uff0c\u5df2\u88ab\u4e0b\u67b6\u7684\u8425\u9500\u653f\u7b56\uff0c\u6216\u8005\u5df2\u7ed3\u675f\u3001\u5df2\u5f00\u59cb\u7684\u8425\u9500\u653f\u7b56\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5!!");
        }
        String salePolicyId = currentSalePolicy.getId();
        salePolicy.setId(salePolicyId);
        this.salePolicyProductsRepository.deleteBySalePolicy(salePolicyId);
        this.salePolicyGiftsRepository.deleteBySalePolicy(salePolicyId);
        this.salePolicyExcludeProductsRepository.deleteBySalePolicy(salePolicyId);
        Set<SalePolicyExecutorLadder> salePolicyExecutorLadders = currentSalePolicy.getSalePolicyExecutorLadders();
        if (!CollectionUtils.isEmpty(salePolicyExecutorLadders)) {
            for (SalePolicyExecutorLadder salePolicyExecutorLadderItem : salePolicyExecutorLadders) {
                this.salePolicyExecutorVarsRepository.deleteByExecutorLadder(salePolicyExecutorLadderItem.getId());
            }
            this.salePolicyExecutorVarsRepository.flush();
            this.salePolicyExecutorLadderRepository.deleteBySalePolicy(salePolicyId);
        }
        this.salePolicyCustomersRepository.deleteBySalePolicy(salePolicyId);
        this.salePolicyRepository.flush();
        this.saveValidation(salePolicy, currentPolicyType, true);
        currentSalePolicy.setClassifications(salePolicy.getClassifications());
        currentSalePolicy.setCompose(salePolicy.getCompose());
        currentSalePolicy.setComposeNumber(salePolicy.getComposeNumber());
        currentSalePolicy.setComposeType(salePolicy.getComposeType());
        currentSalePolicy.setCustomerSelectionMethod(salePolicy.getCustomerSelectionMethod());
        currentSalePolicy.setCustomerSelectionValue(salePolicy.getCustomerSelectionValue());
        currentSalePolicy.setDescription(salePolicy.getDescription());
        currentSalePolicy.setLadder(salePolicy.getLadder());
        currentSalePolicy.setOverlap(salePolicy.getOverlap());
        currentSalePolicy.setProductSelectionMethod(salePolicy.getProductSelectionMethod());
        currentSalePolicy.setSalePolicyName(salePolicy.getSalePolicyName());
        currentSalePolicy.setValidEndTime(salePolicy.getValidEndTime());
        currentSalePolicy.setValidStartTime(salePolicy.getValidStartTime());
        this.salePolicyRepository.save((Object)currentSalePolicy);
        this.saveProducts(salePolicy, currentPolicyType);
        this.savePolicyExecutor(salePolicy, currentPolicyType);
        Set<SalePolicyCustomers> salePolicyCustomers = salePolicy.getCustomers();
        for (SalePolicyCustomers salePolicyCustomerItem : salePolicyCustomers) {
            salePolicyCustomerItem.setId(null);
            salePolicyCustomerItem.setSalePolicy(salePolicy);
        }
        this.salePolicyCustomersRepository.saveAll(salePolicyCustomers);
        this.salePolicyVoService.notifyCacheRefresh(tenantCode);
        return salePolicy;
    }

    @Override
    @Transactional
    public void invalid(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4e0b\u67b6\u8425\u9500\u6d3b\u52a8\u65f6\uff0c\u8425\u9500\u6d3b\u52a8\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        SalePolicy currentSalePolicy = this.findById(id);
        Validate.notNull((Object)((Object)currentSalePolicy), (String)"\u4e0b\u67b6\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u8425\u9500\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentSalePolicy.setEffective(false);
        this.salePolicyRepository.save((Object)currentSalePolicy);
        String tenantCode = TenantUtils.getTenantCode();
        this.salePolicyVoService.notifyCacheRefresh(tenantCode);
    }

    @Override
    public Set<SalePolicy> findDetailsByPolicyType(String policyType) {
        if (StringUtils.isBlank((CharSequence)policyType)) {
            return Sets.newHashSet();
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set<SalePolicy> resutls = this.salePolicyRepository.findDetailsByPolicyType(policyType, tenantCode);
        if (!CollectionUtils.isEmpty(resutls)) {
            this.fetchValidType(resutls);
        }
        return resutls;
    }

    @Override
    public SalePolicy findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.salePolicyRepository.findById(id);
        SalePolicy result = op.orElse(null);
        if (result != null) {
            this.fetchValidType(result);
        }
        return result;
    }

    @Override
    public SalePolicy findBySalePolicyCode(String salePolicyCode) {
        if (StringUtils.isBlank((CharSequence)salePolicyCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        SalePolicy result = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        if (result != null) {
            this.fetchValidType(result);
        }
        return result;
    }

    @Override
    public SalePolicy findBySalePolicyCodeAndProductCode(String salePolicyCode, String productCode) {
        if (StringUtils.isBlank((CharSequence)salePolicyCode) || StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        SalePolicy result = this.salePolicyRepository.findBySalePolicyCodeAndProductCode(salePolicyCode, productCode, tenantCode);
        if (result != null) {
            this.fetchValidType(result);
        }
        return result;
    }

    @Override
    public List<SalePolicy> findBySalePolicyCodesAndProductCode(String[] salePolicyCodes, String productCode) {
        if (salePolicyCodes == null || salePolicyCodes.length == 0) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List<SalePolicy> results = this.salePolicyRepository.findBySalePolicyCodesAndProductCode(salePolicyCodes, productCode, tenantCode);
        if (!CollectionUtils.isEmpty(results)) {
            this.fetchValidType(results);
        }
        return results;
    }

    @Override
    public Page<SalePolicy> findByCondition(Pageable pageable, SalePolicyDto conditions) {
        Page results;
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if (conditions == null) {
            conditions = new SalePolicyDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        conditions.setTenantCode(tenantCode);
        Integer validType = conditions.getValidType();
        if (validType != null) {
            Date now = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (validType == 1) {
                conditions.setEffective(true);
                conditions.setValidEndTime(simpleDateFormat.format(now));
            } else if (validType == 2) {
                conditions.setEffective(false);
            } else if (validType == 3) {
                conditions.setEffective(true);
                conditions.setValidBetweenTime(simpleDateFormat.format(now));
            } else if (validType == 4) {
                conditions.setEffective(true);
                conditions.setValidStartTime(simpleDateFormat.format(now));
            }
        }
        if ((results = this.salePolicyRepository.findByCondition(pageable, conditions)) != null) {
            this.fetchValidType((Iterable<SalePolicy>)results);
        }
        return results;
    }

    private void fetchValidType(Iterable<SalePolicy> iters) {
        if (iters == null) {
            return;
        }
        for (SalePolicy salePolicyItem : iters) {
            this.fetchValidType(salePolicyItem);
        }
    }

    private void fetchValidType(SalePolicy salePolicyItem) {
        Date validEndTime = salePolicyItem.getValidEndTime();
        Date validStartTime = salePolicyItem.getValidStartTime();
        boolean effective = salePolicyItem.getEffective();
        salePolicyItem.setValidType(super.fetchValidTypeForSalePolicy(effective, validEndTime, validStartTime));
    }
}

