/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.internal;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.entity.PolicyGlobalLimit;
import com.bizunited.empower.business.policy.entity.PolicyTypeGlobalLimitMapping;
import com.bizunited.empower.business.policy.entity.SalePolicy;
import com.bizunited.empower.business.policy.entity.SalePolicyGlobalLimitMapping;
import com.bizunited.empower.business.policy.entity.SalePolicyGlobalLimitMappingVars;
import com.bizunited.empower.business.policy.repository.PolicyGlobalLimitRepository;
import com.bizunited.empower.business.policy.repository.SalePolicyRepository;
import com.bizunited.empower.business.policy.service.SalePolicyVoService;
import com.bizunited.empower.business.policy.service.internal.AbstractSalePolicyService;
import com.bizunited.empower.business.policy.vo.PolicyGlobalLimitVo;
import com.bizunited.empower.business.policy.vo.PolicyTypeVo;
import com.bizunited.empower.business.policy.vo.SalePolicyCustomersVo;
import com.bizunited.empower.business.policy.vo.SalePolicyExcludeProductsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyExecutorLadderVo;
import com.bizunited.empower.business.policy.vo.SalePolicyGlobalLimitVarsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyGlobalLimitVo;
import com.bizunited.empower.business.policy.vo.SalePolicyProductsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyVo;
import com.bizunited.empower.business.product.entity.ProductBrand;
import com.bizunited.empower.business.product.entity.ProductCategory;
import com.bizunited.empower.business.product.service.ProductBrandService;
import com.bizunited.empower.business.product.service.ProductCategoryService;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.service.notifier.ProductBrandEventListener;
import com.bizunited.empower.business.product.service.notifier.ProductCategoryEventListener;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyVoServiceImpl
extends AbstractSalePolicyService
implements SalePolicyVoService,
ProductCategoryEventListener,
ProductBrandEventListener {
    @Autowired
    private SalePolicyRepository salePolicyRepository;
    @Autowired
    private ProductBrandService productBrandService;
    @Autowired
    private ProductCategoryService productCategoryService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private PolicyGlobalLimitRepository policyGlobalLimitRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private Redisson redisson;
    private static Map<String, Map<String, SalePolicyVo>> salePolicyCacheMapping = Maps.newConcurrentMap();
    private static Map<String, ReentrantReadWriteLock> salePolicyLockMapping = Maps.newConcurrentMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyVoServiceImpl.class);

    @Override
    public void clearCache(String tenantCode) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByTenantCode(tenantCode);
        try {
            writeLock.lock();
            if (salePolicyCacheMapping != null) {
                salePolicyCacheMapping.remove(tenantCode);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshCache(String tenantCode, boolean hasReadLock) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        Date now = new Date();
        Set<SalePolicy> salePolicies = this.salePolicyRepository.findByValidTimeAndPolicyEffective(tenantCode, now);
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByTenantCode(tenantCode);
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        try {
            if (hasReadLock) {
                readLock.unlock();
            }
            writeLock.lockInterruptibly();
            LOGGER.info("sale policy cache refreshing ..... ");
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        try {
            if (CollectionUtils.isEmpty(salePolicies)) {
                salePolicyCacheMapping.put(tenantCode, Maps.newConcurrentMap());
                return;
            }
            ConcurrentMap salePolicyDetailMapping = salePolicyCacheMapping.get(tenantCode);
            if (salePolicyDetailMapping == null) {
                salePolicyDetailMapping = Maps.newConcurrentMap();
                salePolicyCacheMapping.put(tenantCode, salePolicyDetailMapping);
            }
            for (SalePolicy salePolicyItem : salePolicies) {
                SalePolicyVo salePolicyDetail = this.findDetailsByCodeFromRepository(salePolicyItem.getSalePolicyCode());
                if (salePolicyDetail == null) continue;
                salePolicyDetailMapping.put(salePolicyDetail.getSalePolicyCode(), salePolicyDetail);
            }
        }
        finally {
            writeLock.unlock();
            if (hasReadLock) {
                readLock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.WriteLock getWriteLockByTenantCode(String tenantCode) {
        while (salePolicyLockMapping.get(tenantCode) == null) {
            Map<String, ReentrantReadWriteLock> map = salePolicyLockMapping;
            synchronized (map) {
                if (salePolicyLockMapping.get(tenantCode) == null) {
                    salePolicyLockMapping.put(tenantCode, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = salePolicyLockMapping.get(tenantCode);
        return lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.ReadLock getReadLockByTenantCode(String tenantCode) {
        while (salePolicyLockMapping.get(tenantCode) == null) {
            Map<String, ReentrantReadWriteLock> map = salePolicyLockMapping;
            synchronized (map) {
                if (salePolicyLockMapping.get(tenantCode) == null) {
                    salePolicyLockMapping.put(tenantCode, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = salePolicyLockMapping.get(tenantCode);
        return lock.readLock();
    }

    @Override
    public void notifyCacheRefresh(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        RTopic topic = this.redisson.getTopic("_SALE_POLICY_NOTIFY");
        topic.publish((Object)tenantCode);
    }

    public String onDelete(ProductBrand productBrand) {
        String brandCode = productBrand.getBrandCode();
        String tenantCode = productBrand.getTenantCode();
        Set<SalePolicyVo> salePolicies = this.findDetailsByEffective(tenantCode, false);
        if (CollectionUtils.isEmpty(salePolicies)) {
            return null;
        }
        long matchCount = salePolicies.stream().filter(item -> item.getProductSelectionMethod() == 2 && StringUtils.equalsAny((CharSequence)brandCode, (CharSequence[])StringUtils.split((String)item.getClassifications(), (String)","))).count();
        Validate.isTrue((matchCount == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5546\u54c1\u54c1\u724c\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u5f53\u524d\u5546\u54c1\u54c1\u724c\u5df2\u7ecf\u5728\u8425\u9500\u6d3b\u52a8[%s]\u4e2d\u88ab\u6307\u5b9a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u3002", (Object[])new Object[0]);
        return null;
    }

    public String onRelationshipChange(ProductBrand productBrand) {
        return null;
    }

    public String onDelete(ProductCategory productCategory) {
        String productCategoryCode = productCategory.getCode();
        String tenantCode = productCategory.getTenantCode();
        Set<SalePolicyVo> salePolicies = this.findDetailsByEffective(tenantCode, false);
        if (CollectionUtils.isEmpty(salePolicies)) {
            return null;
        }
        long matchCount = salePolicies.stream().filter(item -> item.getProductSelectionMethod() == 1 && StringUtils.equalsAny((CharSequence)productCategoryCode, (CharSequence[])StringUtils.split((String)item.getClassifications(), (String)","))).count();
        Validate.isTrue((matchCount == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5546\u54c1\u5206\u7c7b\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u5f53\u524d\u5546\u54c1\u5206\u7c7b\u5df2\u7ecf\u5728\u8425\u9500\u6d3b\u52a8[%s]\u4e2d\u88ab\u6307\u5b9a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u3002", (Object[])new Object[0]);
        return null;
    }

    public String onRelationshipChange(ProductCategory productCategory) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SalePolicyVo findDetailsByCode(String salePolicyCode) {
        if (StringUtils.isBlank((CharSequence)salePolicyCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        Date now = new Date();
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            Map<String, SalePolicyVo> salePolicyDetailMapping = salePolicyCacheMapping.get(tenantCode);
            if (salePolicyDetailMapping == null) {
                this.doRefreshCache(tenantCode, true);
                salePolicyDetailMapping = salePolicyCacheMapping.get(tenantCode);
            }
            if (salePolicyDetailMapping.isEmpty()) {
                SalePolicyVo salePolicyVo = null;
                return salePolicyVo;
            }
            SalePolicyVo currentSalePolicyVo = salePolicyDetailMapping.get(salePolicyCode);
            if (currentSalePolicyVo != null) {
                this.fetchValidType(currentSalePolicyVo);
                SalePolicyVo salePolicyVo = currentSalePolicyVo;
                return salePolicyVo;
            }
            SalePolicy rSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
            if (rSalePolicy == null) {
                SalePolicyVo salePolicyVo = null;
                return salePolicyVo;
            }
            if (!rSalePolicy.getEffective().booleanValue() || now.getTime() > rSalePolicy.getValidEndTime().getTime()) {
                SalePolicyVo result = this.findDetailsByCodeFromRepository(salePolicyCode);
                this.fetchValidType(result);
                SalePolicyVo salePolicyVo = result;
                return salePolicyVo;
            }
        }
        finally {
            readLock.unlock();
        }
        LOGGER.warn("====== \u79df\u6237[" + tenantCode + "]\u7f13\u5b58\u7684\u8425\u9500\u6d3b\u52a8\u4fe1\u606f\uff0c\u548c\u8425\u9500\u6d3b\u52a8\u5b9e\u9645\u4fe1\u606f\u4e0d\u540c\u6b65\uff0c\u8bf7\u68c0\u67e5!![salePolicyCode = " + salePolicyCode + "]");
        this.doRefreshCache(tenantCode, false);
        SalePolicyVo result = this.findDetailsByCode(salePolicyCode);
        this.fetchValidType(result);
        return result;
    }

    private SalePolicyVo findDetailsByCodeFromRepository(String salePolicyCode) {
        Set<SalePolicyCustomersVo> salePolicyCustomers;
        Set<SalePolicyGlobalLimitMapping> salePolicyGlobalLimitMappings;
        String policyTypeCode;
        List<PolicyGlobalLimit> policyGlobalLimits;
        Set<SalePolicyExcludeProductsVo> salePolicyExcludeProducts;
        Object classificationNames;
        Object[] classificationArray;
        String tenantCode = TenantUtils.getTenantCode();
        SalePolicy currentSalePolicy = this.salePolicyRepository.findDetailsBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        if (currentSalePolicy == null) {
            return null;
        }
        SalePolicyVo salePolicy = (SalePolicyVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentSalePolicy, SalePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "gifts", "excludeProducts", "policyType", "policyType.policyExecutor", "policyType.policyExecutor.policyExecutorVars", "salePolicyExecutorLadders", "salePolicyExecutorLadders.salePolicyExecutorVars", "customers"}));
        LinkedHashSet sourceSalePolicyExecutorLadders = salePolicy.getSalePolicyExecutorLadders();
        if (!CollectionUtils.isEmpty(sourceSalePolicyExecutorLadders) && sourceSalePolicyExecutorLadders.size() > 1) {
            sourceSalePolicyExecutorLadders = Sets.newLinkedHashSet((Iterable)sourceSalePolicyExecutorLadders.stream().sorted((source, target) -> source.getIndexs() - target.getIndexs()).collect(Collectors.toList()));
            salePolicy.setSalePolicyExecutorLadders(sourceSalePolicyExecutorLadders);
            for (SalePolicyExecutorLadderVo salePolicyExecutorLadder : sourceSalePolicyExecutorLadders) {
                LinkedHashSet sourceSalePolicyExecutorVars = salePolicyExecutorLadder.getSalePolicyExecutorVars();
                if (CollectionUtils.isEmpty(sourceSalePolicyExecutorVars)) continue;
                sourceSalePolicyExecutorVars = Sets.newLinkedHashSet((Iterable)sourceSalePolicyExecutorVars.stream().sorted((source, target) -> source.getIndexs() - target.getIndexs()).collect(Collectors.toList()));
                salePolicyExecutorLadder.setSalePolicyExecutorVars(sourceSalePolicyExecutorVars);
            }
        }
        Integer productSelectionMethod = salePolicy.getProductSelectionMethod();
        PolicyTypeVo policyType = salePolicy.getPolicyType();
        if (policyType == null) {
            LOGGER.warn("\u9519\u8bef\u7684\u8425\u9500\u7b56\u7565\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff1a\u9519\u8bef\u7684\u8425\u9500\u6d3b\u52a8\u7c7b\u578b\u4fe1\u606f\u3010" + salePolicyCode + "\u3011!!");
            return salePolicy;
        }
        String classifications = salePolicy.getClassifications();
        if (productSelectionMethod == 1) {
            if (!StringUtils.isBlank((CharSequence)classifications)) {
                classificationArray = StringUtils.split((String)classifications, (String)",");
                ArrayList categoryCodes = Lists.newArrayList((Iterable)Sets.newHashSet((Object[])classificationArray));
                List productCategoryresults = this.productCategoryService.findByCodeList((List)categoryCodes);
                classificationNames = null;
                if (!CollectionUtils.isEmpty((Collection)productCategoryresults)) {
                    ArrayList arrayList = Lists.newArrayList((Iterable)productCategoryresults.stream().map(ProductCategory::getName).collect(Collectors.toList()));
                    classificationNames = StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)",");
                }
                salePolicy.setClassificationNames((String)classificationNames);
            }
        } else if (productSelectionMethod == 2) {
            if (!StringUtils.isBlank((CharSequence)classifications)) {
                classificationArray = StringUtils.split((String)classifications, (String)",");
                ArrayList brandCodes = Lists.newArrayList((Iterable)Sets.newHashSet((Object[])classificationArray));
                List productBrands = this.productBrandService.findByCodeList((List)brandCodes);
                classificationNames = null;
                if (!CollectionUtils.isEmpty((Collection)productBrands)) {
                    List<String> list = productBrands.stream().map(ProductBrand::getBrandName).collect(Collectors.toList());
                    classificationNames = StringUtils.join((Object[])list.toArray(new String[0]), (String)",");
                }
                salePolicy.setClassificationNames((String)classificationNames);
            }
        } else if (productSelectionMethod > 3 || productSelectionMethod <= 0) {
            LOGGER.warn("\u9519\u8bef\u7684\u8425\u9500\u7b56\u7565\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff1a\u9519\u8bef\u7684\u5546\u54c1\u9009\u62e9\u5f62\u5f0f\u3010" + salePolicyCode + "\u3011!!");
            return salePolicy;
        }
        if (!(productSelectionMethod != 1 && productSelectionMethod != 2 || CollectionUtils.isEmpty(salePolicyExcludeProducts = salePolicy.getExcludeProducts()))) {
            List productSpecificationCodes = salePolicyExcludeProducts.stream().map(SalePolicyExcludeProductsVo::getProductSpecificationCode).distinct().collect(Collectors.toList());
            List productSpecificationVos = this.productSpecificationVoService.findBySpecificationCodeList(productSpecificationCodes);
            for (ProductSpecificationVo productSpecificationVo : productSpecificationVos) {
                SalePolicyExcludeProductsVo salePolicyExcludeProductItem = salePolicyExcludeProducts.stream().filter(item -> StringUtils.equals((CharSequence)item.getProductSpecificationCode(), (CharSequence)productSpecificationItem.getProductSpecificationCode())).findFirst().orElse(null);
                String productSpecificationCode = salePolicyExcludeProductItem.getProductSpecificationCode();
                ProductSpecificationVo productSpecificationVo2 = productSpecificationVos.stream().filter(item -> StringUtils.equals((CharSequence)productSpecificationCode, (CharSequence)item.getProductSpecificationCode())).findFirst().orElse(null);
                if (productSpecificationVo2 == null) continue;
                salePolicyExcludeProductItem.setMainImageName(productSpecificationVo2.getMainImageName());
                salePolicyExcludeProductItem.setMainImagePath(productSpecificationVo2.getMainImagePath());
                salePolicyExcludeProductItem.setProductSpecificationCode(productSpecificationVo2.getProductSpecificationCode());
                salePolicyExcludeProductItem.setProductSpecificationName(productSpecificationVo2.getProductSpecificationName());
            }
        }
        if (!CollectionUtils.isEmpty(policyGlobalLimits = this.policyGlobalLimitRepository.findByPolicyTypeCode(policyTypeCode = policyType.getPolicyTypeCode()))) {
            LinkedHashSet policyGlobalLimitVos = Sets.newLinkedHashSet();
            for (PolicyGlobalLimit policyGlobalLimit : policyGlobalLimits) {
                PolicyGlobalLimitVo policyGlobalLimitVo = (PolicyGlobalLimitVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)policyGlobalLimit, PolicyGlobalLimitVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                policyGlobalLimitVos.add(policyGlobalLimitVo);
            }
            salePolicy.setPolicyGlobalLimits(policyGlobalLimitVos);
        }
        if (!CollectionUtils.isEmpty(salePolicyGlobalLimitMappings = currentSalePolicy.getSalePolicyGlobalLimitMappings())) {
            LinkedHashSet salePolicyGlobalLimits = Sets.newLinkedHashSet();
            for (SalePolicyGlobalLimitMapping salePolicyGlobalLimitMappingItem : salePolicyGlobalLimitMappings) {
                PolicyTypeGlobalLimitMapping policyTypeGlobalLimitMapping = salePolicyGlobalLimitMappingItem.getPolicyTypeGlobalLimitMapping();
                PolicyGlobalLimit policyGlobalLimit = policyTypeGlobalLimitMapping.getPolicyGlobalLimit();
                String policyGlobalLimitId = policyGlobalLimit.getId();
                salePolicyGlobalLimitMappingItem.getSalePolicyGlobalLimitMappingVars();
                SalePolicyGlobalLimitVo salePolicyGlobalLimitVo = new SalePolicyGlobalLimitVo();
                salePolicyGlobalLimitVo.setPolicyGlobalLimitId(policyGlobalLimitId);
                Set<SalePolicyGlobalLimitMappingVars> salePolicyGlobalLimitMappingVars = salePolicyGlobalLimitMappingItem.getSalePolicyGlobalLimitMappingVars();
                if (!CollectionUtils.isEmpty(salePolicyGlobalLimitMappingVars)) {
                    LinkedHashSet salePolicyGlobalLimitVars = Sets.newLinkedHashSet();
                    for (SalePolicyGlobalLimitMappingVars salePolicyGlobalLimitMappingVarItem : salePolicyGlobalLimitMappingVars) {
                        SalePolicyGlobalLimitVarsVo salePolicyGlobalLimitVarsVo = new SalePolicyGlobalLimitVarsVo();
                        salePolicyGlobalLimitVarsVo.setVariableName(salePolicyGlobalLimitMappingVarItem.getVariableName());
                        salePolicyGlobalLimitVarsVo.setVariableType(salePolicyGlobalLimitMappingVarItem.getVariableType());
                        salePolicyGlobalLimitVarsVo.setVariableValue(salePolicyGlobalLimitMappingVarItem.getVariableValue());
                        salePolicyGlobalLimitVars.add(salePolicyGlobalLimitVarsVo);
                    }
                    salePolicyGlobalLimitVo.setSalePolicyGlobalLimitVars(salePolicyGlobalLimitVars);
                }
                salePolicyGlobalLimits.add(salePolicyGlobalLimitVo);
            }
            salePolicy.setSalePolicyGlobalLimits(salePolicyGlobalLimits);
        }
        if (!CollectionUtils.isEmpty(salePolicyCustomers = salePolicy.getCustomers())) {
            List list = salePolicyCustomers.stream().map(SalePolicyCustomersVo::getCustomerCode).collect(Collectors.toList());
            List customers = this.customerService.findDetailsByTenantCodeAndCustomerCodes(tenantCode, list);
            LinkedHashSet customerVos = Sets.newLinkedHashSet((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)customers, Customer.class, SalePolicyCustomersVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"customerCategory", "customerLevel", "salesArea"}));
            salePolicy.setCustomers(customerVos);
        }
        return salePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SalePolicyVo> findDetailsByEffective(String tenantCode, boolean processing) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        Date now = new Date();
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByTenantCode(tenantCode);
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            Map<String, SalePolicyVo> salePolicyDetailMapping = salePolicyCacheMapping.get(tenantCode);
            if (salePolicyDetailMapping == null) {
                this.doRefreshCache(tenantCode, true);
                salePolicyDetailMapping = salePolicyCacheMapping.get(tenantCode);
            }
            if (salePolicyDetailMapping.isEmpty()) {
                Set<SalePolicyVo> set = null;
                return set;
            }
            List<SalePolicyVo> effectiveSalePolicyVos = !processing ? salePolicyDetailMapping.values().stream().filter(item -> item.getEffective() != false && item.getValidEndTime().getTime() > now.getTime()).sorted((source, target) -> (int)(source.getValidStartTime().getTime() - target.getValidStartTime().getTime())).collect(Collectors.toList()) : salePolicyDetailMapping.values().stream().filter(item -> item.getEffective() != false && item.getValidEndTime().getTime() > now.getTime() && item.getValidStartTime().getTime() < now.getTime()).sorted((source, target) -> (int)(source.getValidStartTime().getTime() - target.getValidStartTime().getTime())).collect(Collectors.toList());
            this.fetchValidType(effectiveSalePolicyVos);
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(effectiveSalePolicyVos);
            return linkedHashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Set<SalePolicyVo> findDetailsByEffectiveAndCustomerCode(String tenantCode, boolean processing, String customerCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        Set<SalePolicyVo> salePolicies = this.findDetailsByEffective(tenantCode, processing);
        if (CollectionUtils.isEmpty(salePolicies)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (SalePolicyVo salePolicyItem : salePolicies) {
            long matchCount;
            Set<SalePolicyCustomersVo> salePolicyCustomers = salePolicyItem.getCustomers();
            if (CollectionUtils.isEmpty(salePolicyCustomers) || (matchCount = salePolicyCustomers.stream().filter(item -> StringUtils.equals((CharSequence)item.getCustomerCode(), (CharSequence)customerCode)).count()) <= 0L) continue;
            result.add(salePolicyItem);
        }
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        this.fetchValidType(result);
        return Sets.newLinkedHashSet((Iterable)result);
    }

    private void fetchValidType(Iterable<SalePolicyVo> iters) {
        if (iters == null) {
            return;
        }
        for (SalePolicyVo salePolicyItem : iters) {
            this.fetchValidType(salePolicyItem);
        }
    }

    private void fetchValidType(SalePolicyVo salePolicyItem) {
        Date validEndTime = salePolicyItem.getValidEndTime();
        Date validStartTime = salePolicyItem.getValidStartTime();
        boolean effective = salePolicyItem.getEffective();
        salePolicyItem.setValidType(super.fetchValidTypeForSalePolicy(effective, validEndTime, validStartTime));
    }

    @Override
    public Set<SalePolicyVo> findDetailsByEffectiveAndCustomerCodesAndProductSpecificationCodes(String tenantCode, boolean processing, Integer saleType, String customerCode, String productSpecificationCode) {
        return this.findDetailsByEffectiveAndCustomerCodesAndProductSpecificationCodesAndExcludePolicy(tenantCode, processing, saleType, customerCode, productSpecificationCode, null);
    }

    @Override
    public Set<SalePolicyVo> findDetailsByEffectiveAndCustomerCodesAndProductSpecificationCodesAndExcludePolicy(String tenantCode, boolean processing, Integer saleType, String customerCode, String productSpecificationCode, String excludeSalePolicyId) {
        if (saleType == null || StringUtils.isBlank((CharSequence)productSpecificationCode) || StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        Set<SalePolicyVo> currentSalePolicy = this.findDetailsByEffective(tenantCode, processing);
        if (CollectionUtils.isEmpty(currentSalePolicy)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)excludeSalePolicyId)) {
            currentSalePolicy = currentSalePolicy.stream().filter(item -> !StringUtils.equals((CharSequence)item.getId(), (CharSequence)excludeSalePolicyId)).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(currentSalePolicy = currentSalePolicy.stream().filter(item -> item.getPolicyType().getSaleType() == saleType).collect(Collectors.toSet()))) {
            return null;
        }
        if (CollectionUtils.isEmpty(currentSalePolicy = currentSalePolicy.stream().filter(item -> {
            Set<SalePolicyProductsVo> salePolicyProducts = item.getProducts();
            for (SalePolicyProductsVo salePolicyProductItem : salePolicyProducts) {
                if (!StringUtils.equals((CharSequence)salePolicyProductItem.getProductSpecificationCode(), (CharSequence)productSpecificationCode)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toSet()))) {
            return null;
        }
        currentSalePolicy = currentSalePolicy.stream().filter(item -> {
            Set<SalePolicyCustomersVo> salePolicyCustomers = item.getCustomers();
            for (SalePolicyCustomersVo salePolicyCustomerItem : salePolicyCustomers) {
                if (!StringUtils.equals((CharSequence)salePolicyCustomerItem.getCustomerCode(), (CharSequence)customerCode)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        return currentSalePolicy;
    }
}

