/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.rebatepolicy;

import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillCon;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProduct;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProductResult;
import com.bizunited.empower.business.policy.vo.RebatePolicyNotMatchedVo;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class RebatePolicyExecuteContext {
    private Set<RebatePolicyVo> initRebatePolicys;
    private BillCon initBillCon;
    private final String tenantCode;
    private final String customerCode;
    private List<BillConProduct> excludedPolicyProducts;
    private Map<String, RebatePolicyNotMatchedVo> excludedPolicyMapping;
    private Map<String, RebatePolicyVo> matchedPolicyMapping;
    private Map<String, List<BillConProduct>> matchedPolicyProducts;
    private BigDecimal resultDiscountAmount;
    private Set<BillConProductResult> resultProducts;
    private NebulaToolkitService nebulaToolkitService;

    public RebatePolicyExecuteContext(Set<RebatePolicyVo> initRebatePolicys, BillCon initBill, String tenantCode, String customerCode, NebulaToolkitService nebulaToolkitService) {
        this.initRebatePolicys = initRebatePolicys;
        this.initBillCon = initBill;
        this.tenantCode = tenantCode;
        this.customerCode = customerCode;
        this.nebulaToolkitService = nebulaToolkitService;
        Validate.isTrue((!CollectionUtils.isEmpty(initRebatePolicys) ? 1 : 0) != 0, (String)"initRebatePolicys not be empty !", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"tenantCode not blank !", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"customerCode not blank !", (Object[])new Object[0]);
        List<BillConProduct> billConProducts = initBill.getProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(billConProducts) ? 1 : 0) != 0, (String)"billConProducts not be empty !", (Object[])new Object[0]);
        this.excludedPolicyProducts = Lists.newArrayList();
        this.excludedPolicyMapping = Maps.newHashMap();
        this.matchedPolicyMapping = Maps.newLinkedHashMap();
        this.matchedPolicyProducts = Maps.newLinkedHashMap();
    }

    public void addExcludedPolicy(RebatePolicyVo rebatePolicy, RebatePolicyNotMatchedVo notMatched) {
        Validate.notNull((Object)((Object)rebatePolicy), (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u653f\u7b56\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.notNull((Object)notMatched, (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u6392\u9664\u539f\u56e0\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.initRebatePolicys.contains((Object)rebatePolicy), (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u653f\u7b56\u4fe1\u606f\u5fc5\u987b\u5df2\u5b58\u5728\u4e8einitRebatePolicys\u6e05\u5355\u4e2d", (Object[])new Object[0]);
        this.excludedPolicyMapping.put(rebatePolicy.getRebatePolicyCode(), notMatched);
    }

    public void addMatchedPolicyProducts(String rebatePolicyCode, List<BillConProduct> policyProducts) {
        this.matchedPolicyProducts.put(rebatePolicyCode, policyProducts);
    }

    public void setExcludedPolicyProducts(List<BillConProduct> excludedPolicyProducts) {
        this.excludedPolicyProducts = excludedPolicyProducts;
    }

    public void streamlining() {
        LinkedHashSet initRebatePolicys;
        this.initRebatePolicys = initRebatePolicys = Sets.newLinkedHashSet((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(this.initRebatePolicys, RebatePolicyVo.class, RebatePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        if (!CollectionUtils.isEmpty(this.matchedPolicyMapping)) {
            Set<String> rebatePolicyCodes = this.matchedPolicyMapping.keySet();
            for (String rebatePolicyCode : rebatePolicyCodes) {
                RebatePolicyVo rebatePolicy = this.matchedPolicyMapping.get(rebatePolicyCode);
                rebatePolicy = (RebatePolicyVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rebatePolicy, RebatePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                this.matchedPolicyMapping.put(rebatePolicyCode, rebatePolicy);
            }
        }
    }

    public void setMatchedPolicyMapping(Map<String, RebatePolicyVo> matchedPolicyMapping) {
        this.matchedPolicyMapping = matchedPolicyMapping;
    }

    public void setResultDiscountAmount(BigDecimal resultDiscountAmount) {
        this.resultDiscountAmount = resultDiscountAmount;
    }

    public void setResultProducts(Set<BillConProductResult> resultProducts) {
        this.resultProducts = resultProducts;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public Map<String, RebatePolicyVo> getMatchedPolicyMapping() {
        return this.matchedPolicyMapping;
    }

    public Map<String, List<BillConProduct>> getMatchedPolicyProducts() {
        return this.matchedPolicyProducts;
    }

    public BillCon getInitBillCon() {
        return this.initBillCon;
    }

    public Map<String, RebatePolicyNotMatchedVo> getExcludedPolicyMapping() {
        return this.excludedPolicyMapping;
    }

    public List<BillConProduct> getExcludedPolicyProducts() {
        return this.excludedPolicyProducts;
    }

    public BigDecimal getResultDiscountAmount() {
        return this.resultDiscountAmount;
    }

    public Set<BillConProductResult> getResultProducts() {
        return this.resultProducts;
    }
}

