/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.rebatepolicy.strategy;

import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountCommonDetails;
import com.bizunited.empower.business.policy.service.RebateAccountCommonDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountService;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyExecuteContext;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyStrategy;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillCon;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProduct;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConResult;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CommonRebatePolicyStrategy")
public class CommonRebatePolicyStrategy
implements RebatePolicyStrategy {
    @Autowired
    private RebateAccountService rebateAccountService;
    @Autowired
    private RebateAccountCommonDetailsService rebateAccountCommonDetailsService;

    @Override
    public boolean policyMatched(RebatePolicyVo rebatePolicy) {
        return rebatePolicy.getRebatePolicyType() == 1;
    }

    @Override
    public List<BillConProduct> preExecute(BillCon bill, RebatePolicyVo rebatePolicy) {
        BigDecimal totalAmount = bill.getTotalAmount();
        BigDecimal thresholdAmount = rebatePolicy.getThresholdAmount();
        Validate.notNull((Object)totalAmount, (String)"\u8ba2\u5355\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)thresholdAmount, (String)"\u8ba2\u5355\u5546\u54c1\u4ef7\u503c\u7684\u6700\u4f4e\u95e8\u69db\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((totalAmount.floatValue() >= thresholdAmount.floatValue() ? 1 : 0) != 0, (String)"\u5355\u636e\u91d1\u989d\u672a\u5230\u8fbe\u8fd4\u5229\u653f\u7b56\u8981\u6c42", (Object[])new Object[0]);
        return bill.getProducts();
    }

    @Override
    public void execute(RebatePolicyExecuteContext executeContext, BillCon bill, BillConResult billConResult, RebatePolicyVo rebatePolicy) {
        String billCode = bill.getCode();
        String customerCode = bill.getCustomerCode();
        RebateAccount rebateAccount = this.rebateAccountService.findByTenantCodeAndCustomerCode(customerCode);
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u672a\u627e\u5230\u6307\u5b9a\u5ba2\u6237\u7684\u8fd4\u5229\u8d26\u6237\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String rebatePolicyName = rebatePolicy.getRebatePolicyName();
        BigDecimal totalAmount = bill.getTotalAmount();
        BigDecimal discountAmount = billConResult.getDiscountAmount();
        Validate.isTrue((discountAmount != null && discountAmount.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u5355\u636e\u672a\u6b63\u786e\u8bbe\u5b9a\u901a\u7528\u8fd4\u5229\u7684\u62b5\u6263\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        discountAmount = discountAmount.setScale(4, RoundingMode.UP);
        billConResult.setDiscountAmount(discountAmount);
        BigDecimal thresholdAmount = rebatePolicy.getThresholdAmount();
        Validate.isTrue((totalAmount.floatValue() >= thresholdAmount.floatValue() ? 1 : 0) != 0, (String)"\u5355\u636e\u603b\u91d1\u989d[%s]\u4e0d\u6ee1\u8db3\u8fd4\u5229\u653f\u7b56[%s]\u89c4\u5b9a\u7684\u6700\u5c0f\u603b\u91d1\u989d\u8981\u6c42\uff0c\u4e0d\u80fd\u8fdb\u884c\u8fd4\u5229\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{Float.valueOf(totalAmount.floatValue()), rebatePolicyName});
        BigDecimal maxTotalAmountRatio = rebatePolicy.getMaxTotalAmountRatio();
        BigDecimal maxAmount = totalAmount.multiply(maxTotalAmountRatio).setScale(4, RoundingMode.UP);
        BigDecimal minAmount = rebatePolicy.getMinAmountRebate();
        Validate.isTrue((discountAmount.floatValue() <= maxAmount.floatValue() ? 1 : 0) != 0, (String)"\u5355\u636e\u62b5\u6263\u91d1\u989d[%s]\uff0c\u5df2\u7ecf\u8d85\u51fa\u8fd4\u5229\u653f\u7b56[%s]\u89c4\u5b9a\u7684\u5355\u7b14\u5355\u636e\u6700\u5927\u53ef\u62b5\u6263\u7684\u91d1\u989d[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{Float.valueOf(discountAmount.floatValue()), rebatePolicyName, Float.valueOf(maxTotalAmountRatio.floatValue())});
        Validate.isTrue((discountAmount.floatValue() >= minAmount.floatValue() ? 1 : 0) != 0, (String)"\u5355\u636e\u62b5\u6263\u91d1\u989d[%s]\uff0c\u5df2\u7ecf\u4f4e\u4e8e\u8fd4\u5229\u653f\u7b56[%s]\u89c4\u5b9a\u7684\u5355\u7b14\u5355\u636e\u6700\u5c0f\u53ef\u62b5\u6263\u7684\u91d1\u989d[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{Float.valueOf(discountAmount.floatValue()), rebatePolicyName, Float.valueOf(minAmount.floatValue())});
        RebateAccountCommonDetails rebateAccountCommonDetail = new RebateAccountCommonDetails();
        rebateAccountCommonDetail.setDetailAmount(discountAmount);
        rebateAccountCommonDetail.setDetailType(-1);
        rebateAccountCommonDetail.setRebateAccount(rebateAccount);
        rebateAccountCommonDetail.setRelevanceCode(billCode);
        rebateAccountCommonDetail.setRemark(String.format("\u5355\u636e[%s]\u901a\u7528\u8fd4\u5229\u8d44\u91d1\u62b5\u6263[%s]", "%s", Float.valueOf(discountAmount.floatValue())));
        rebateAccountCommonDetail.setTenantCode(TenantUtils.getTenantCode());
        this.rebateAccountCommonDetailsService.create(rebateAccountCommonDetail);
    }
}

