/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.rebatepolicy.strategy;

import com.bizunited.empower.business.policy.entity.RebateAccount;
import com.bizunited.empower.business.policy.entity.RebateAccountProductDetails;
import com.bizunited.empower.business.policy.service.RebateAccountProductDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountService;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyExecuteContext;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyStrategy;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillCon;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProduct;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProductResult;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConResult;
import com.bizunited.empower.business.policy.service.rebatepolicy.exception.RebatePolicyNotMatchedException;
import com.bizunited.empower.business.policy.vo.RebatePolicyNotMatchedVo;
import com.bizunited.empower.business.policy.vo.RebatePolicyProductsVo;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ProductRebatePolicyStrategy")
public class ProductRebatePolicyStrategy
implements RebatePolicyStrategy {
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private RebateAccountService rebateAccountService;
    @Autowired
    private RebateAccountProductDetailsService rebateAccountProductDetailsService;

    @Override
    public boolean policyMatched(RebatePolicyVo rebatePolicy) {
        return rebatePolicy.getRebatePolicyType() == 3;
    }

    @Override
    public List<BillConProduct> preExecute(BillCon bill, RebatePolicyVo rebatePolicy) {
        Set<RebatePolicyProductsVo> rebatePolicyProducts = rebatePolicy.getProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(rebatePolicyProducts) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u914d\u7f6e\u51fa\u73b0\u95ee\u9898", (Object[])new Object[0]);
        Map<String, RebatePolicyProductsVo> rebatePolicyProductMapping = rebatePolicyProducts.stream().collect(Collectors.toMap(RebatePolicyProductsVo::getProductSpecificationCode, item -> item));
        BigDecimal totalNumbers = BigDecimal.ZERO;
        List<BillConProduct> billProducts = bill.getProducts();
        ArrayList resultProducts = Lists.newArrayList();
        Validate.isTrue((!CollectionUtils.isEmpty(billProducts) ? 1 : 0) != 0, (String)"\u5355\u636e\u4e3a\u4f20\u5165\u672c\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        for (BillConProduct billConProductItem : billProducts) {
            String unitCode;
            String productSpecificationCode;
            float unitRate;
            String billProductSpecificationCode = billConProductItem.getProductSpecificationCode();
            String billUnitCode = billConProductItem.getUnitCode();
            BigDecimal billQuantity = billConProductItem.getQuantity();
            Validate.isTrue((billQuantity != null && billQuantity.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u5355\u636e\u672c\u54c1\u6570\u91cf\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            RebatePolicyProductsVo rebatePolicyProduct = rebatePolicyProductMapping.get(billProductSpecificationCode);
            if (rebatePolicyProduct == null || (unitRate = this.productSpecificationVoService.transformationUnitRate(productSpecificationCode = rebatePolicyProduct.getProductSpecificationCode(), billUnitCode, unitCode = rebatePolicyProduct.getUnitCode())) <= 0.0f) continue;
            billConProductItem.setUnitRate(Float.valueOf(unitRate));
            billConProductItem.setUnitCode(unitCode);
            resultProducts.add(billConProductItem);
            BigDecimal realNumber = billQuantity.multiply(new BigDecimal(unitRate).setScale(2, RoundingMode.HALF_UP));
            billConProductItem.setQuantity(realNumber);
            totalNumbers = totalNumbers.add(realNumber);
        }
        if ((float)rebatePolicy.getThresholdNumber().intValue() <= totalNumbers.floatValue()) {
            return resultProducts;
        }
        RebatePolicyNotMatchedVo rebatePolicyNotMatched = new RebatePolicyNotMatchedVo();
        rebatePolicyNotMatched.setMessage("\u54c1\u724c\u5546\u54c1\u603b\u6570\u91cf\u672a\u8fbe\u5230\u8fd4\u5229\u95e8\u69db");
        rebatePolicyNotMatched.setRebatePolicy(rebatePolicy);
        throw new RebatePolicyNotMatchedException(rebatePolicyNotMatched);
    }

    @Override
    public void execute(RebatePolicyExecuteContext executeContext, BillCon bill, BillConResult billConResult, RebatePolicyVo rebatePolicy) {
        String billCode = bill.getCode();
        String customerCode = bill.getCustomerCode();
        RebateAccount rebateAccount = this.rebateAccountService.findByTenantCodeAndCustomerCode(customerCode);
        Validate.notNull((Object)((Object)rebateAccount), (String)"\u672a\u627e\u5230\u6307\u5b9a\u5ba2\u6237\u7684\u8fd4\u5229\u8d26\u6237\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<BillConProduct> billProducts = bill.getProducts();
        BigDecimal totalNumber = BigDecimal.ZERO;
        for (BillConProduct billConProduct : billProducts) {
            totalNumber = totalNumber.add(billConProduct.getQuantity());
        }
        List<BillConProductResult> billConProductResults = billConResult.getProductResutls();
        Validate.isTrue((!CollectionUtils.isEmpty(billConProductResults) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8fd4\u5229\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (BillConProductResult billConProductResult : billConProductResults) {
            String productCode = billConProductResult.getProductCode();
            String productSpecificationCode = billConProductResult.getProductSpecificationCode();
            String unitCode = billConProductResult.getUnitCode();
            BigDecimal quantity = billConProductResult.getQuantity();
            RebateAccountProductDetails rebateAccountProductDetail = new RebateAccountProductDetails();
            rebateAccountProductDetail.setDetailNumber(quantity.intValue());
            rebateAccountProductDetail.setDetailType(-1);
            rebateAccountProductDetail.setProductCode(productCode);
            rebateAccountProductDetail.setProductSpecificationCode(productSpecificationCode);
            rebateAccountProductDetail.setUnitCode(unitCode);
            rebateAccountProductDetail.setRebateAccount(rebateAccount);
            rebateAccountProductDetail.setRelevanceCode(billCode);
            rebateAccountProductDetail.setRemark(String.format("\u5355\u636e[%s]\u5b9e\u7269\u8fd4\u5229\u62b5\u6263", "%s"));
            rebateAccountProductDetail.setTenantCode(TenantUtils.getTenantCode());
            this.rebateAccountProductDetailsService.create(rebateAccountProductDetail);
        }
    }
}

