/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.service.salepolicy;

import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConMatched;
import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConProduct;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.GiftInfo;
import com.bizunited.empower.business.policy.vo.SalePolicyVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class PolicyExecuteContext {
    private Set<SalePolicyVo> initSalePolicys;
    private final String tenantCode;
    private final String customerCode;
    private BigDecimal totalDiscountAmount = BigDecimal.ZERO;
    private List<GiftInfo> totalGiftInfos = Lists.newArrayList();
    private List<PolicyConProduct> excludedPolicyProducts;
    private Map<String, String> excludedPolicyMapping;
    private Map<String, PolicyConMatched> matchedPolicyMapping;
    private NebulaToolkitService nebulaToolkitService;

    public PolicyExecuteContext(Set<SalePolicyVo> initSalePolicys, String tenantCode, String customerCode, NebulaToolkitService nebulaToolkitService) {
        this.initSalePolicys = initSalePolicys;
        this.tenantCode = tenantCode;
        this.customerCode = customerCode;
        this.nebulaToolkitService = nebulaToolkitService;
        Validate.isTrue((!CollectionUtils.isEmpty(initSalePolicys) ? 1 : 0) != 0, (String)"salePolicys not be empty \uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"tenantCode not blank !", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"customerCode not blank !", (Object[])new Object[0]);
        this.excludedPolicyProducts = Lists.newArrayList();
        this.excludedPolicyMapping = Maps.newHashMap();
        this.matchedPolicyMapping = Maps.newLinkedHashMap();
    }

    public void addExcludedPolicy(SalePolicyVo excludedPolicy, String message) {
        Validate.notNull((Object)((Object)excludedPolicy), (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u653f\u7b56\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)message, (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u6392\u9664\u539f\u56e0\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.initSalePolicys.contains((Object)excludedPolicy), (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u653f\u7b56\u4fe1\u606f\u5fc5\u987b\u5df2\u5b58\u5728\u4e8einitSalePolicys\u6e05\u5355\u4e2d", (Object[])new Object[0]);
        this.excludedPolicyMapping.put(excludedPolicy.getSalePolicyCode(), message);
    }

    public Integer sizeOfExcludedPolices() {
        return this.excludedPolicyMapping.size();
    }

    public void addMatchedPolicy(String policyCode, PolicyConMatched policyConMatched) {
        Validate.notBlank((CharSequence)policyCode, (String)"policyCode not be blank!!", (Object[])new Object[0]);
        Validate.notNull((Object)policyConMatched, (String)"policyConMatched not be empty!!", (Object[])new Object[0]);
        this.matchedPolicyMapping.put(policyCode, policyConMatched);
    }

    public void setExcludedPolicyProducts(List<PolicyConProduct> excludedPolicyProducts) {
        this.excludedPolicyProducts = excludedPolicyProducts;
    }

    public void setTotalDiscountAmount(BigDecimal totalDiscountAmount) {
        this.totalDiscountAmount = totalDiscountAmount;
    }

    public void setTotalGiftInfos(List<GiftInfo> totalGiftInfos) {
        this.totalGiftInfos = totalGiftInfos;
    }

    public void streamlining() {
        if (!CollectionUtils.isEmpty(this.matchedPolicyMapping)) {
            for (PolicyConMatched policyConMatched : this.matchedPolicyMapping.values()) {
                SalePolicyVo salePolicy = policyConMatched.getSalePolicy();
                SalePolicyVo targetSalePolicy = (SalePolicyVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicy, SalePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"policyType"}));
                policyConMatched.setSalePolicy(targetSalePolicy);
            }
        }
    }

    public BigDecimal getTotalDiscountAmount() {
        return this.totalDiscountAmount;
    }

    public List<GiftInfo> getTotalGiftInfos() {
        return this.totalGiftInfos;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public List<PolicyConProduct> getExcludedPolicyProducts() {
        return this.excludedPolicyProducts;
    }

    public Map<String, String> getExcludedPolicyMapping() {
        return this.excludedPolicyMapping;
    }

    public Map<String, PolicyConMatched> getMatchedPolicyMapping() {
        return this.matchedPolicyMapping;
    }
}

