package com.bizunited.empower.business.product.common.enumerate;

/**
 * 价格调整类型
 * @author lihuan
 */
public enum AdjustType {
  MONEY_ADD(1,"按金额上调"),
  SCALE_ADD(2,"按比例上调"),
  MONEY_REDUCE(3,"按金额下调"),
  SCALE_REDUCE(4,"按比例下调")
  ;

  private Integer type;
  private String desc;

  AdjustType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }


  public static AdjustType getValue(Integer type) {
    AdjustType[] adjustTypes = values();
    for (AdjustType adjustType : adjustTypes) {
      if (adjustType.getType().equals(type)) {
        return adjustType;
      }
    }
    return null;
  }

}
