package com.bizunited.empower.business.product.controller;

import com.bizunited.empower.business.product.dto.DiscountResultDto;
import com.bizunited.empower.business.product.service.ProductActionService;
import com.bizunited.empower.business.product.vo.ProductPriceVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 商品模块的扩展Controller层，基于HTTP Restful风格
 *
 * @author saturn
 */
@RestController
@RequestMapping("/v1/productAction")
public class ProductActionController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ProductActionController.class);

  @Autowired
  ProductActionService productActionService;

  @ApiOperation(value = "该部分商品原始价值计算")
  @GetMapping(value = "findProductSellingPrice")
  public ResponseModel findProductSellingPrice(@RequestParam("productCodeList") @ApiParam("商品编码集合") List<String> productCodeList) {
    try {
      List<ProductPriceVo> result = this.productActionService.findProductSellingPrice(productCodeList);
      return this.buildHttpResultW(result, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "该部分商品最终交易价计算")
  @PostMapping(value = "findProductFinalPrice")
  public ResponseModel findProductFinalPrice(@RequestBody @ApiParam("商品编码-客户集合") List<DiscountResultDto> discountResultDtoList) {
    try {
      List<DiscountResultDto> result = this.productActionService.findProductFinalPrice(discountResultDtoList);
      return this.buildHttpResultW(result, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  @ApiOperation(value = "调用商品模块，检验单位编码的有效性")
  @GetMapping(value = "validityUnitCode")
  public ResponseModel validityUnitCode(@RequestParam("productCode") @ApiParam("商品编码") String productCode,
                                        @RequestParam("unitCode") @ApiParam("单位编码") String unitCode) {
    try {
      Boolean result = this.productActionService.validityUnitCode(productCode, unitCode);
      return this.buildHttpResultW(result, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
