package com.bizunited.empower.business.product.controller;

import com.bizunited.empower.business.product.service.ProductBrandVoService;
import com.bizunited.empower.business.product.vo.ProductBrandVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * productBrandVo业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author saturn
 */
@RestController
@RequestMapping("/v1/productBrandVo")
public class ProductBrandVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ProductBrandVoController.class);

  @Autowired
  ProductBrandVoService productBrandVoService;


  @ApiOperation(value = "分页查询")
  @GetMapping(value = "/findByConditions")
  public ResponseModel findByConditions(@RequestParam(name = "brandName", required = false) @ApiParam("名称") String brandName,
                                        @ApiParam(value = "分页查询，分页参数为page和size，page从0开始，size默认50") @PageableDefault(value = 50) Pageable pageable) {
    try {
      Page<ProductBrandVo> result = this.productBrandVoService.findByConditions(pageable, brandName);
      return this.buildHttpResult(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


}
