package com.bizunited.empower.business.product.controller;

import com.bizunited.empower.business.product.service.ProductCategoryVoService;
import com.bizunited.empower.business.product.vo.ProductCategoryVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * ProductCategoryVo 业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author saturn
 */
@RestController
@RequestMapping("/v1/productCategoryVo")
public class ProductCategoryVoController  extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ProductCategoryVoController.class);

  @Autowired
  ProductCategoryVoService productCategoryVoService;

  @ApiOperation(value = "查询所有数据，并以父子数展示")
  @RequestMapping(value="/findStructureTree" , method={RequestMethod.GET})
  public ResponseModel findStructureTree() {
    try {
      List<ProductCategoryVo> result = this.productCategoryVoService.findStructureTree();
      return this.buildHttpResult(result);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

}
