package com.bizunited.empower.business.product.controller;

import com.bizunited.empower.business.product.dto.ProductDto;
import com.bizunited.empower.business.product.entity.Product;
import com.bizunited.empower.business.product.service.ProductService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * Product业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/product")
public class ProductController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ProductController.class);
  
  @Autowired
  private ProductService productService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建product中的基本信息以外，还可以对product中属于OneToMany关联的明细信息一同进行创建注意：基于（Product）模型的创建操作传入的productJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建product中的基本信息以外，还可以对product中属于OneToMany关联的明细信息一同进行创建注意：基于（Product）模型的创建操作传入的productJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="ProductDto" , value="") ProductDto productDto) {
    try {
      Product current = this.productService.create(productDto);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Product）的修改操作传入的productJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Product）的修改操作传入的productJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="ProductDto" , value="") ProductDto productDto) {
    try {
      Product current = this.productService.update(productDto);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Product）的修改操作传入的productJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Product）的修改操作传入的productJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PutMapping(value="")
  public ResponseModel updateProduct(@RequestBody @ApiParam(name="ProductDto" , value="") ProductDto productDto) {
    try {
      Product current = this.productService.update(productDto);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      Product current = this.productService.findById(id);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      this.productService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照Product实体中的（productCategory）关联的 商品分类进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param productCategory 关联的 商品分类
   */
  @ApiOperation(value = "按照Product实体中的（productCategory）关联的 商品分类进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByProductCategory" , method={RequestMethod.GET})
  public ResponseModel findDetailsByProductCategory(@RequestParam("productCategory") @ApiParam("关联的 商品分类") String productCategory) {
    try { 
      Set<Product> result = this.productService.findDetailsByProductCategory(productCategory); 
      return this.buildHttpResultW(result, new String[]{"tags","productCategory","productBrand"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照Product实体中的（productBrand）关联的 品牌进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param productBrand 关联的 品牌
   */
  @ApiOperation(value = "按照Product实体中的（productBrand）关联的 品牌进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByProductBrand" , method={RequestMethod.GET})
  public ResponseModel findDetailsByProductBrand(@RequestParam("productBrand") @ApiParam("关联的 品牌") String productBrand) {
    try { 
      Set<Product> result = this.productService.findDetailsByProductBrand(productBrand); 
      return this.buildHttpResultW(result, new String[]{"tags","productCategory","productBrand"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照Product实体中的（tags）关联的 商品标签进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param tags 关联的 商品标签
   */
  @ApiOperation(value = "按照Product实体中的（tags）关联的 商品标签进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByTags" , method={RequestMethod.GET})
  public ResponseModel findDetailsByTags(@RequestParam("tags") @ApiParam("关联的 商品标签") String tags) {
    try { 
      Set<Product> result = this.productService.findDetailsByTags(tags); 
      return this.buildHttpResultW(result, new String[]{"tags","productCategory","productBrand"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照Product实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照Product实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      Product result = this.productService.findDetailsById(id); 
      return this.buildHttpResult(result);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照Product实体中的（productCode）商品编码进行查询
   * @param productCode 商品编码
   */
  @ApiOperation(value = "按照Product实体中的（productCode）商品编码进行查询")
  @RequestMapping(value="/findByProductCode" , method={RequestMethod.GET})
  public ResponseModel findByProductCode(@RequestParam("productCode") @ApiParam("商品编码") String productCode) {
    try { 
      Product result = this.productService.findByProductCode(productCode); 
      return this.buildHttpResultW(result, new String[]{}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 上架下架（修改上架状态 1，立即上架；2，暂不上架）
   * @param shelfStatus
   * @return
   */
  @ApiOperation(value = "上架下架（修改上架状态 1，立即上架；2，暂不上架）")
  @PatchMapping(value="/updateShelfStatus")
  public ResponseModel updateShelfStatus(@RequestParam("shelfStatus") @ApiParam("上架状态") Integer shelfStatus,
                                         @RequestParam("productCode") @ApiParam("商品编号") String productCode){
    try {
      this.productService.updateShelfStatus(shelfStatus, productCode);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 小程序没有patch  提供为put
   * 上架下架（修改上架状态 1，立即上架；2，暂不上架）
   * @param shelfStatus
   * @return
   */
  @ApiOperation(value = "上架下架（修改上架状态 1，立即上架；2，暂不上架）")
  @PutMapping(value="/updateShelfStatus")
  public ResponseModel updateProductShelfStatus(@RequestParam("shelfStatus") @ApiParam("上架状态") Integer shelfStatus,
                                         @RequestParam("productCode") @ApiParam("商品编号") String productCode){
    try {
      this.productService.updateShelfStatus(shelfStatus, productCode);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

} 
