package com.bizunited.empower.business.product.controller;
import com.bizunited.empower.business.product.entity.ProductShowCategory;
import com.bizunited.empower.business.product.service.ProductShowCategoryService;
import com.bizunited.empower.business.product.vo.ProductShowCategoryVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.String;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * ProductShowCategory业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/productShowCategory")
public class ProductShowCategoryController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ProductShowCategoryController.class);
  
  @Autowired
  private ProductShowCategoryService productShowCategoryService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建productShowCategory中的基本信息以外，还可以对productShowCategory中属于OneToMany关联的明细信息一同进行创建注意：基于（ProductShowCategory）模型的创建操作传入的productShowCategoryJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建productShowCategory中的基本信息以外，还可以对productShowCategory中属于OneToMany关联的明细信息一同进行创建注意：基于（ProductShowCategory）模型的创建操作传入的productShowCategoryJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="productShowCategory" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建productShowCategory中的基本信息以外，还可以对productShowCategory中属于OneToMany关联的明细信息一同进行创建注意：基于（ProductShowCategory）模型的创建操作传入的productShowCategoryJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") ProductShowCategory productShowCategory) {
    try {
      ProductShowCategory current = this.productShowCategoryService.create(productShowCategory);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（ProductShowCategory）的修改操作传入的productShowCategoryJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（ProductShowCategory）的修改操作传入的productShowCategoryJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="productShowCategory" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（ProductShowCategory）的修改操作传入的productShowCategoryJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") ProductShowCategory productShowCategory) {
    try {
      ProductShowCategory current = this.productShowCategoryService.update(productShowCategory);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      ProductShowCategory current = this.productShowCategoryService.findById(id);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      this.productShowCategoryService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照ProductShowCategory实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照ProductShowCategory实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      ProductShowCategory result = this.productShowCategoryService.findDetailsById(id); 
      return this.buildHttpResultW(result, new String[]{}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 按照ProductCategory实体中的（code）分类编码进行查询
   *
   * @param code 分类编码
   */
  @ApiOperation(value = "按照ProductCategory实体中的（code）分类编码进行查询")
  @RequestMapping(value = "/findByCode", method = {RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("分类编码") String code) {
    try {
      ProductShowCategory result = this.productShowCategoryService.findByCode(code);
      return this.buildHttpResultW(result, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "分页查询")
  @GetMapping(value = "/findByConditions")
  public ResponseModel findByConditions( @ApiParam(value = "分页查询，分页参数为page和size，page从0开始，size默认50") @PageableDefault(value = 50) Pageable pageable) {
    try {
      Page<ProductShowCategory> categories = this.productShowCategoryService.findByConditions(pageable);
      return this.buildHttpResultW(categories, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据上级code查询下一级所有信息")
  @GetMapping(value = "/findByPCode")
  public ResponseModel findByPCode(@RequestParam("pCode") @ApiParam("分类编码") String pCode){
    try {
      List<ProductShowCategory> result = this.productShowCategoryService.findByPCode(pCode);
      return this.buildHttpResultW(result, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * 根据一批分类编码code查询，并且要保证顺序一致
   *
   * @param codeList 分类编码
   */
  @ApiOperation(value = "根据一批分类编码code查询，并且要保证返回结果与入参顺序一致")
  @RequestMapping(value = "/findByCodeList", method = {RequestMethod.GET})
  public ResponseModel findByCodeList(@RequestParam("codeList") @ApiParam("分类编码") List<String> codeList) {
    try {
      List<ProductShowCategory> result = this.productShowCategoryService.findByCodeList(codeList);
      return this.buildHttpResultW(result, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "查询所有数据，并以父子数展示")
  @RequestMapping(value="/findStructureTree" , method={RequestMethod.GET})
  public ResponseModel findStructureTree() {
    try {
      List<ProductShowCategoryVo> result = this.productShowCategoryService.findStructureTree();
      return this.buildHttpResult(result);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

} 
