package com.bizunited.empower.business.product.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * BrandAndUnitMapBarCodeDto 商品品牌和单位 映射 条码 的dto
 *
 * @Author: hefan
 * @Date: 2021/5/17 14:10
 */
@ApiModel(value = "BrandAndUnitMapBarCodeDto", description = "商品品牌和单位 映射 条码 的dto")
public class BrandAndUnitMapBarCodeDto implements Serializable {
  
  private static final long serialVersionUID = 6472741669714528987L;

  /** 品牌编码 */
  @ApiModelProperty("品牌编码")
  private String brandCode;

  /** 品牌名称 */
  @ApiModelProperty("品牌名称")
  private String brandName;

  /** 条形码 */
  @ApiModelProperty("条形码")
  private String barCode;

  /** 规格编号 */
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /** 规格名称 */
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 单位编号 */
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** true:map里有信息，false：map里没有信息 */
  private Boolean hasContent = false;

  /** key:品牌code+单位code   */
  private Map<String, BrandAndUnitMapBarCodeDto> map;

  public BrandAndUnitMapBarCodeDto getBrandAndUnitMapBarCodeDto(String specificationCode, String unitCode) {
    if (Objects.isNull(map)) {
      return null;
    }
    String specificationUnitCodeKey = StringUtils.join(specificationCode, unitCode);
    return map.get(specificationUnitCodeKey);
  }

  public void setBrandAndUnitMapBarCodeDto(BrandAndUnitMapBarCodeDto brandAndUnitMapBarCodeDto){
    if (Objects.isNull(brandAndUnitMapBarCodeDto)) {
      return;
    }
    if (Objects.isNull(map)) {
      map = new HashMap<>();
      this.setHasContent(true);
    }
    String specificationUnitCodeKey = StringUtils.join(brandAndUnitMapBarCodeDto.getProductSpecificationCode(), brandAndUnitMapBarCodeDto.getUnitCode());
    map.put(specificationUnitCodeKey, brandAndUnitMapBarCodeDto);
  }


  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public Boolean getHasContent() {
    return hasContent;
  }

  public void setHasContent(Boolean hasContent) {
    this.hasContent = hasContent;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public String getBrandName() {
    return brandName;
  }

  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }
}
