package com.bizunited.empower.business.product.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "DiscountResultDto", description = "打折结果DTO")
public class DiscountResultDto implements Serializable {
  /**
   *
   */
  private static final long serialVersionUID = 7363399861222819465L;
  //商品编码
  @ApiModelProperty("商品编码")
  private String productCode;
  //客户编码
  @ApiModelProperty("客户编号")
  private String customerCode;
  //折后金额
  @ApiModelProperty("订货价格")
  private BigDecimal afterDiscountPrice;

  /** 单位编号 */
  @ApiModelProperty("单位编号")
  private String unitCode;

  /**
   * 规格编号
   */
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;


  public DiscountResultDto() {
  }

  public DiscountResultDto(String customerCode, String productCode) {
    this(customerCode, productCode, BigDecimal.ZERO);
  }

  public DiscountResultDto(String customerCode, String productCode, BigDecimal afterDiscountPrice) {
    this.productCode = productCode;
    this.customerCode = customerCode;
    this.afterDiscountPrice = afterDiscountPrice;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getAfterDiscountPrice() {
    return afterDiscountPrice;
  }

  public void setAfterDiscountPrice(BigDecimal afterDiscountPrice) {
    this.afterDiscountPrice = afterDiscountPrice;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }
}
