package com.bizunited.empower.business.product.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * ProductSpecificationAndUnitDto 一对规格和单位编码，想获得名称/销售价格
 *
 * @Author: hefan
 * @Date: 2021/4/10 13:28
 */
@ApiModel(value = "ProductSpecificationAndUnitPriceDto", description = "规格和单位的名称和编号、销售价格")
public class ProductSpecificationAndUnitPriceDto {
  /** 规格编号 */
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /** 规格名称 */
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 单位编号 */
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位名称 */
  @ApiModelProperty("单位名称")
  private String unitName;

  /** 销售价 */
  @ApiModelProperty("销售价")
  private BigDecimal sellingPrice;

  /** true:规格不存在该单位，false：规格和单位是正确关系 */
  @ApiModelProperty("错误配对")
  private Boolean errorPair;

  /** true:map里有信息，false：map里没有信息 */
  private Boolean hasContent = false;

  /** key:规格code+单位code   */
  private Map<String, ProductSpecificationAndUnitPriceDto> map;

  public ProductSpecificationAndUnitPriceDto getProductSpecificationAndUnitPriceDto(String specificationCode, String unitCode) {
    if (Objects.isNull(map)) {
      return null;
    }
    String specificationUnitCodeKey = StringUtils.join(specificationCode, unitCode);
    return map.get(specificationUnitCodeKey);
  }

  public void setProductSpecificationAndUnitPriceDto(ProductSpecificationAndUnitPriceDto productSpecificationAndUnitDto){
    if (Objects.isNull(productSpecificationAndUnitDto)) {
      return;
    }
    if (Objects.isNull(map)) {
      map = new HashMap<>();
      setHasContent(true);
    }
    String specificationUnitCodeKey = StringUtils.join(productSpecificationAndUnitDto.getProductSpecificationCode(), productSpecificationAndUnitDto.getUnitCode());
    map.put(specificationUnitCodeKey, productSpecificationAndUnitDto);
  }

  public Boolean getErrorPair() {
    return errorPair;
  }

  public void setErrorPair(Boolean errorPair) {
    this.errorPair = errorPair;
  }

  public Boolean getHasContent() {
    return hasContent;
  }

  private void setHasContent(Boolean hasContent) {
    this.hasContent = hasContent;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }

  public BigDecimal getSellingPrice() {
    return sellingPrice;
  }

  public void setSellingPrice(BigDecimal sellingPrice) {
    this.sellingPrice = sellingPrice;
  }
}
