package com.bizunited.empower.business.product.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 该DTO专门用于提供给上层模块，进行指定商品规格最小出库数量和最大出库数量的验证</br>
 * 另请参见 #ProductSpecificationVoService#validateOrderQuantity
 * @author hefan
 */
public class ProductSpecificationOrderDto implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = -7873222631387031283L;

  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  @ApiModelProperty(" 订货数量：默认为0，千位数代表.000 ")
  private BigDecimal orderQuantity;

  @ApiModelProperty("单位")
  private String unitCode;

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public BigDecimal getOrderQuantity() {
    return orderQuantity;
  }

  public void setOrderQuantity(BigDecimal orderQuantity) {
    this.orderQuantity = orderQuantity;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }
}
