package com.bizunited.empower.business.product.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 规格价格修改DTO
 * @author lihuan
 */
@ApiModel("规格价格批量修改DTO")
public class SpecificationPriceDto {

  /**
   * 规格ID 集合
   */
  @ApiModelProperty("规格ID 集合")
  private List<String> spcificationId;

  /**
   * 价格类型 1.销售价 2.进货价
   */
  @ApiModelProperty("销售价格类型 1.销售价 2.进货价")
  private Integer priceType;

  /**
   * 调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调
   */
  @ApiModelProperty("调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调")
  private Integer adjustType;

  /**
   * 调整金额
   */
  @ApiModelProperty("调整金额")
  private BigDecimal adjustMoney;

  /**
   * 同步修改客户价格
   */
  @ApiModelProperty("同步修改客户价格")
  private Boolean updateCustomerPrice;


  public List<String> getSpcificationId() {
    return spcificationId;
  }

  public void setSpcificationId(List<String> spcificationId) {
    this.spcificationId = spcificationId;
  }

  public Integer getPriceType() {
    return priceType;
  }

  public void setPriceType(Integer priceType) {
    this.priceType = priceType;
  }

  public Integer getAdjustType() {
    return adjustType;
  }

  public void setAdjustType(Integer adjustType) {
    this.adjustType = adjustType;
  }

  public BigDecimal getAdjustMoney() {
    return adjustMoney;
  }

  public void setAdjustMoney(BigDecimal adjustMoney) {
    this.adjustMoney = adjustMoney;
  }

  public Boolean getUpdateCustomerPrice() {
    return updateCustomerPrice;
  }

  public void setUpdateCustomerPrice(Boolean updateCustomerPrice) {
    this.updateCustomerPrice = updateCustomerPrice;
  }
}
