package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

@ApiModel(value = "Product", description = "商品信息")
@Entity
@Table(name = "`product`" , indexes = @Index(columnList = "tenant_code , product_code", unique = true))
@org.hibernate.annotations.Table(appliesTo = "`product`", comment = "商品信息")
@BuildCustomRepository
public class Product extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 6055811765450669506L;

  /**
   * 商品编码
   */
  @Column(name = "product_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  @SaturnColumn(description = "商品编码")
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @Column(name = "product_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品名称 '")
  @SaturnColumn(description = "商品名称")
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品分类
   */
  @SaturnColumn(description = "商品分类")
  @ApiModelProperty("商品分类")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "category_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品分类 '")
  private ProductCategory productCategory;

  /**
   * 商品前端展示分类
   */
  @SaturnColumn(description = "商品前端展示分类")
  @ApiModelProperty("商品前端展示分类")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "category_show_id", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 商品前端展示分类 '")
  @NotFound(action = NotFoundAction.IGNORE)
  private ProductShowCategory productShowCategory;

  /**
   * 品牌
   */
  @SaturnColumn(description = "品牌")
  @ApiModelProperty("品牌")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "brand_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 品牌 '")
  private ProductBrand productBrand;

  /**
   * 上架状态
   */
  @Column(name = "shelf_status", nullable = false, columnDefinition = "VARCHAR(32) COMMENT ' 上架状态 '")
  @SaturnColumn(description = "上架状态")
  @ApiModelProperty("上架状态：1，立即上架；2，暂不上架")
  private Integer shelfStatus;

  /**
   * 默认仓库
   */
  @Column(name = "default_warehouse_code", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 默认仓库 '")
  @SaturnColumn(description = "默认仓库")
  @ApiModelProperty("默认仓库")
  private String defaultWarehouseCode;

  /**
   * 仓库名称
   */
  @Column(name = "warehouse_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 仓库名称 '")
  @SaturnColumn(description = "仓库名称")
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 搜索关键字
   */
  @Column(name = "search_keyword", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 搜索关键字 '")
  @SaturnColumn(description = "搜索关键字")
  @ApiModelProperty("搜索关键字")
  private String searchKeyword;

  /**
   * 备注信息
   */
  @Column(name = "remark", nullable = true, columnDefinition = "VARCHAR(512) COMMENT ' 备注信息 '")
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  private String remark;

  /**
   * 商品配图状态
   */
  @Column(name = "product_image_status", nullable = false, columnDefinition = "VARCHAR(32) COMMENT ' 商品配图状态 '")
  @SaturnColumn(description = "商品配图状态")
  @ApiModelProperty("商品配图状态：1，未完善；2，已完善")
  private Integer productImageStatus;

  /**
   * 规格配图状态
   */
  @Column(name = "specification_image_status", nullable = false, columnDefinition = "VARCHAR(32) COMMENT ' 规格配图状态 '")
  @SaturnColumn(description = "商品配图状态")
  @ApiModelProperty("规格配图状态：1，待配图；2，完成配图")
  private Integer specificationImageStatus;

  /**
   * 商品文件
   */
  @SaturnColumn(description = "商品文件")
  @ApiModelProperty("商品文件")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "product")
  private Set<ProductFile> productFiles;

  /**
   * 商品规格
   */
  @SaturnColumn(description = "商品规格")
  @ApiModelProperty("商品规格")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "product")
  private Set<ProductSpecification> productSpecifications;

  /**
   * 商品多规格参数
   */
  @SaturnColumn(description = "商品多规格参数")
  @ApiModelProperty("商品多规格参数")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "product")
  private Set<ProductMultipleSpecification> productMultipleSpecifications;

  /**
   * 商品标签
   */
  @SaturnColumn(description = "商品标签")
  @ApiModelProperty("商品标签")
  @ManyToMany(fetch = FetchType.LAZY,targetEntity = ProductTag.class)
  @JoinTable(
      name = "product_product_tag",
      joinColumns = {@JoinColumn(name = "product_id")},
      inverseJoinColumns = {@JoinColumn(name = "tags_id")})
  private Set<ProductTag> tags;

  /**
   * 商品价格
   */
  @SaturnColumn(description = "商品价格")
  @ApiModelProperty("商品价格")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "product")
  private Set<ProductPricing> productPricings;

  /** 单位与价格  */
  @SaturnColumn(description = "单位与价格")
  @ApiModelProperty("单位与价格")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "product")
  private Set<ProductUnitAndPrice> productUnitAndPrices;

  /** 单位规格与价格  */
  @SaturnColumn(description = "单位规格与价格")
  @ApiModelProperty("单位规格与价格")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "product")
  @NotFound(action = NotFoundAction.IGNORE)
  private Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices;

  /**
   * 商品图片资源库
   */
  @SaturnColumn(description = "商品图片资源库")
  @ApiModelProperty("商品图片资源库")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "product")
  private Set<ProductImageResource> productImageResources;

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public ProductCategory getProductCategory() {
    return productCategory;
  }

  public void setProductCategory(ProductCategory productCategory) {
    this.productCategory = productCategory;
  }

  public ProductBrand getProductBrand() {
    return productBrand;
  }

  public void setProductBrand(ProductBrand productBrand) {
    this.productBrand = productBrand;
  }

  public Integer getShelfStatus() {
    return shelfStatus;
  }

  public void setShelfStatus(Integer shelfStatus) {
    this.shelfStatus = shelfStatus;
  }

  public String getDefaultWarehouseCode() {
    return defaultWarehouseCode;
  }

  public String getWarehouseName() {
    return warehouseName;
  }

  public void setWarehouseName(String warehouseName) {
    this.warehouseName = warehouseName;
  }

  public void setDefaultWarehouseCode(String defaultWarehouseCode) {
    this.defaultWarehouseCode = defaultWarehouseCode;
  }

  public String getSearchKeyword() {
    return searchKeyword;
  }

  public void setSearchKeyword(String searchKeyword) {
    this.searchKeyword = searchKeyword;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<ProductSpecification> getProductSpecifications() {
    return productSpecifications;
  }

  public void setProductSpecifications(Set<ProductSpecification> productSpecifications) {
    this.productSpecifications = productSpecifications;
  }

  public Set<ProductTag> getTags() {
    return tags;
  }

  public void setTags(Set<ProductTag> tags) {
    this.tags = tags;
  }

  public Set<ProductMultipleSpecification> getProductMultipleSpecifications() {
    return productMultipleSpecifications;
  }

  public void setProductMultipleSpecifications(Set<ProductMultipleSpecification> productMultipleSpecifications) {
    this.productMultipleSpecifications = productMultipleSpecifications;
  }

  public Set<ProductPricing> getProductPricings() {
    return productPricings;
  }

  public void setProductPricings(Set<ProductPricing> productPricings) {
    this.productPricings = productPricings;
  }

  public Set<ProductFile> getProductFiles() {
    return productFiles;
  }

  public void setProductFiles(Set<ProductFile> productFiles) {
    this.productFiles = productFiles;
  }

  public Set<ProductUnitSpecificationAndPrice> getProductUnitSpecificationAndPrices() {
    return productUnitSpecificationAndPrices;
  }

  public void setProductUnitSpecificationAndPrices(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices) {
    this.productUnitSpecificationAndPrices = productUnitSpecificationAndPrices;
  }

  public ProductShowCategory getProductShowCategory() {
    return productShowCategory;
  }

  public void setProductShowCategory(ProductShowCategory productShowCategory) {
    this.productShowCategory = productShowCategory;
  }

  public Set<ProductUnitAndPrice> getProductUnitAndPrices() {
    return productUnitAndPrices;
  }

  public void setProductUnitAndPrices(Set<ProductUnitAndPrice> productUnitAndPrices) {
    this.productUnitAndPrices = productUnitAndPrices;
  }

  public Integer getProductImageStatus() {
    return productImageStatus;
  }

  public void setProductImageStatus(Integer productImageStatus) {
    this.productImageStatus = productImageStatus;
  }

  public Integer getSpecificationImageStatus() {
    return specificationImageStatus;
  }

  public void setSpecificationImageStatus(Integer specificationImageStatus) {
    this.specificationImageStatus = specificationImageStatus;
  }

  public Set<ProductImageResource> getProductImageResources() {
    return productImageResources;
  }

  public void setProductImageResources(Set<ProductImageResource> productImageResources) {
    this.productImageResources = productImageResources;
  }
}