package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@ApiModel(value = "ProductBarCodeInfo", description = "条形码")
@Entity
@Table(name="`product_bar_code_info`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_bar_code_info`", comment = "条形码")
public class ProductBarCodeInfo extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 5805358095427823857L;

  /** 规格编号 */
  @SaturnColumn(description = "规格编号")
  @ApiModelProperty("规格编号")
  @ManyToOne(fetch = FetchType.LAZY,targetEntity = ProductSpecification.class)
  @JoinColumn(name = "product_specification_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 规格编号 '")
  private ProductSpecification productSpecification;

  /** 单位编号 */
  @Column(name = "unit_code", nullable = false, length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 单位编号 '")
  @SaturnColumn(description = "单位编号")
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 条形码 */
  @Column(name = "bar_code", nullable = false,length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 条形码 '")
  @SaturnColumn(description = "条形码")
  @ApiModelProperty("条形码")
  private String barCode;

  public ProductSpecification getProductSpecification() {
    return productSpecification;
  }

  public void setProductSpecification(ProductSpecification productSpecification) {
    this.productSpecification = productSpecification;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }
}