package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

@ApiModel(value = "ProductBrand", description = "商品品牌")
@Entity
@Table(name = "`product_brand`" , indexes = {@Index(columnList = "tenant_code , brand_code" ,unique = true) ,
                                             @Index(columnList = "create_time")})
@org.hibernate.annotations.Table(appliesTo = "`product_brand`", comment = "商品品牌")
public class ProductBrand extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 3365879134208203795L;

  /**
   * 品牌名称
   */
  @Column(name = "brand_name", nullable = true, length = 1024, columnDefinition = "VARCHAR(1024) COMMENT ' 品牌名称 '")
  @SaturnColumn(description = "品牌名称")
  @ApiModelProperty("品牌名称")
  private String brandName;

  /**
   * logo相对路径
   */
  @Column(name = "logo_relative_path", nullable = true, length = 1024, columnDefinition = "VARCHAR(1024) COMMENT ' logo相对路径 '")
  @SaturnColumn(description = "logo相对路径")
  @ApiModelProperty("logo相对路径")
  private String logoRelativePath;

  /**
   * logo文件名
   */
  @Column(name = "logo_file_name", nullable = true, length = 1024, columnDefinition = "VARCHAR(1024) COMMENT ' logo文件名 '")
  @SaturnColumn(description = "logo文件名")
  @ApiModelProperty("logo文件名")
  private String logoFileName;

  /**
   * 品牌编码
   */
  @Column(name = "brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 品牌编码 '")
  @SaturnColumn(description = "品牌编码")
  @ApiModelProperty("品牌编码")
  private String brandCode;

  /**
   * 商品信息
   */
  @SaturnColumn(description = "商品信息")
  @ApiModelProperty("商品信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "productBrand")
  private Set<Product> products;

  public String getBrandName() {
    return brandName;
  }

  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }

  public String getLogoRelativePath() {
    return logoRelativePath;
  }

  public void setLogoRelativePath(String logoRelativePath) {
    this.logoRelativePath = logoRelativePath;
  }

  public String getLogoFileName() {
    return logoFileName;
  }

  public void setLogoFileName(String logoFileName) {
    this.logoFileName = logoFileName;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public Set<Product> getProducts() {
    return products;
  }

  public void setProducts(Set<Product> products) {
    this.products = products;
  }
}