package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@ApiModel(value = "ProductDescription", description = "商品描述")
@Entity
@Table(name = "`product_description`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_description`", comment = "商品描述")
public class ProductDescription extends TenantEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -2483246415672817576L;

  /**
   * 商品编号
   */
  @JoinColumn(name = "product_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编号 '")
  @SaturnColumn(description = "商品编号")
  @ApiModelProperty("商品编号")
  @OneToOne(fetch = FetchType.LAZY)
  private Product product;

  /**
   * 商品描述
   */
  @Column(name = "description", nullable = false, columnDefinition = "TEXT COMMENT ' 商品描述 '")
  @SaturnColumn(description = "商品描述")
  @ApiModelProperty("商品描述")
  private String description;

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public String getDescription() {
    return this.description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

}